/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Objects;
import kd.ai.ids.core.query.data.FilterItemQuery;
import kd.ai.ids.core.query.data.FilterItemValuesDTO;
import kd.ai.ids.core.query.data.HomeOverviewQuery;
import kd.ai.ids.core.query.data.PredictDetailExportProgressQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IAnaResultService;
import kd.ai.ids.core.service.IAuthService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.util.StringUtils;

public class AnaResultServiceImpl
implements IAnaResultService {
    @Override
    public JSONArray getAllSchemeList(Long orgId, String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/modscheme/list", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONArray();
        }
        return null;
    }

    @Override
    public JSONArray getOnlineSchemeList(Long orgId, String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/mod/scheme/select/list", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONArray();
        }
        return null;
    }

    @Override
    public JSONObject getFilterItem(Long orgId, String subServiceId, String fmodeltypeid, boolean needFilterItem) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fmodeltypeid", (Object)fmodeltypeid);
        paramsJo.put("needFilterItem", (Object)needFilterItem);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/filter/item", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getFilterItemValueLevel(Long orgId, String subServiceId, String fmodeltypeid, int page, int pageSize, String labelId, String search, List<FilterItemValuesDTO> filterItemValuesDTOList, boolean fisOutler) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fmodeltypeid", (Object)fmodeltypeid);
        paramsJo.put("fisOutlier", (Object)fisOutler);
        paramsJo.put("current", (Object)page);
        paramsJo.put("size", (Object)pageSize);
        paramsJo.put("labelId", (Object)labelId);
        if (StringUtils.isNotEmpty((String)search)) {
            paramsJo.put("search", (Object)search);
        }
        if (filterItemValuesDTOList != null && !filterItemValuesDTOList.isEmpty()) {
            paramsJo.put("filterItemValuesDTOList", filterItemValuesDTOList);
        }
        paramsJo.put("nameAssemblyNumber", (Object)Boolean.FALSE);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/filter/item/value/level", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getYearTrend(Long orgId, FilterItemQuery filterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/year/trend", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getLastTrend(Long orgId, FilterItemQuery filterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/last/trend", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getLastTrendDetail(Long orgId, FilterItemQuery filterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/last/trend/detail", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getInfluenceFactor(Long orgId, FilterItemQuery filterItemQuery, String parentId) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        paramsJo.put("parentId", (Object)parentId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/sf/influence/factor", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONArray getAlgorithmError(Long orgId, FilterItemQuery filterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/sf/algorithm/error", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONArray();
        }
        return null;
    }

    @Override
    public BaseResult getHomeOverview(Long orgId, HomeOverviewQuery homeOverviewQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)homeOverviewQuery));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/sf/home/overview/detail", paramsJo);
    }

    @Override
    public BaseResult getLastDetailList(Long orgId, FilterItemQuery filterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/last/detail/list", paramsJo);
    }

    @Override
    public JSONObject getLastDetailListExport(Long orgId, FilterItemQuery filterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/last/detail/list/export", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getLastDetailListExportProgress(PredictDetailExportProgressQuery predictDetailExportProgressQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)predictDetailExportProgressQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/anaresults/last/detail/list/export/progress", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public String getLastDetailListExportFileUrl(Long orgId, String subServiceId, String requestId) {
        IdsParameter idsParameter = Services.get(IIdsParameterService.class).getIdsParameter(orgId);
        String token = Services.get(IAuthService.class).getAccessToken(idsParameter);
        try {
            token = URLEncoder.encode(token, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            CommonUtil.getStackTrace(e);
        }
        String url = idsParameter.getIdsServerUrl() + "/ids/data/anaresults/last/detail/list/export/file";
        return String.format("%s?subServiceId=%s&requestId=%s&auth_type=token&token=%s", url, subServiceId, requestId, token);
    }

    @Override
    public BaseResult getLastDetailListSummary(Long orgId, FilterItemQuery filterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/anaresults/last/detail/list/summary", paramsJo);
    }
}

