/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import kd.ai.ids.core.cache.AppCache;
import kd.ai.ids.core.query.auth.CheckAccessTokenRequest;
import kd.ai.ids.core.query.auth.CheckAppTokenRequest;
import kd.ai.ids.core.query.auth.GetAccessTokenRequest;
import kd.ai.ids.core.query.auth.GetAppTokenRequest;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.auth.GetAccessTokenResult;
import kd.ai.ids.core.response.auth.GetAppTokenResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IAuthService;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.HttpUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class AuthServiceImpl
implements IAuthService {
    private static final Log log = LogFactory.getLog(AuthServiceImpl.class);
    public static final String KEY_ACCESS_TOKEN = "AccessToken";
    private static final String KEY_ERROR = "error";
    public static final String KEY_APP_TOKEN = "AppToken";
    private static final int TIME_OUT = 1500;

    @Override
    public String getAccessToken(IdsParameter idsParameter) {
        String accessToken = AppCache.get().get(KEY_ACCESS_TOKEN);
        if (StringUtils.isNotEmpty((CharSequence)accessToken) && this.checkAccessToken(idsParameter, accessToken)) {
            if (KEY_ERROR.equals(accessToken)) {
                return "";
            }
            return accessToken;
        }
        accessToken = "";
        GetAppTokenRequest getAppTokenRequest = new GetAppTokenRequest();
        getAppTokenRequest.setAppId(idsParameter.getAuthorityAppId());
        getAppTokenRequest.setAppSecret(idsParameter.getAuthorityAppSecret());
        String appToken = this.getAppToken(idsParameter, getAppTokenRequest);
        if (StringUtils.isNotEmpty((CharSequence)appToken) && this.checkAppToken(idsParameter, appToken)) {
            try {
                GetAccessTokenResult getAccessTokenResult;
                GetAccessTokenRequest getAccessTokenRequest = new GetAccessTokenRequest();
                getAccessTokenRequest.setAppToken(appToken);
                String result = HttpUtils.doPostJson(idsParameter.getIdsServerUrl() + "/ids/auth/common/authority/getAccessToken", JSONObject.toJSONString((Object)getAccessTokenRequest), null, 1500, 1500);
                JSONObject resultJo = JSON.parseObject((String)result);
                GetAccessTokenResult getAccessTokenResult2 = getAccessTokenResult = resultJo.get((Object)"data") == null ? null : (GetAccessTokenResult)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultJo.get((Object)"data")), GetAccessTokenResult.class);
                if (getAccessTokenResult != null) {
                    accessToken = getAccessTokenResult.getAccessToken();
                    if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                        AppCache.get().put(KEY_ACCESS_TOKEN, accessToken, 3600);
                    } else {
                        AppCache.get().put(KEY_ACCESS_TOKEN, KEY_ERROR, 10);
                    }
                }
            }
            catch (Exception e) {
                CommonUtil.getStackTrace(e);
                AppCache.get().put(KEY_ACCESS_TOKEN, KEY_ERROR, 10);
            }
        }
        return accessToken;
    }

    private String getAppToken(IdsParameter idsParameter, GetAppTokenRequest getAppTokenRequest) {
        String appToken = AppCache.get().get(KEY_APP_TOKEN);
        if (StringUtils.isNotEmpty((CharSequence)appToken) && this.checkAppToken(idsParameter, appToken)) {
            if (KEY_ERROR.equals(appToken)) {
                return "";
            }
            return appToken;
        }
        appToken = "";
        try {
            GetAppTokenResult getAppTokenResult;
            String result = HttpUtils.doPostJson(idsParameter.getIdsServerUrl() + "/ids/auth/common/authority/getAppToken", JSON.toJSONString((Object)getAppTokenRequest), null, 1500, 1500);
            JSONObject resultJo = JSON.parseObject((String)result);
            GetAppTokenResult getAppTokenResult2 = getAppTokenResult = resultJo.get((Object)"data") == null ? null : (GetAppTokenResult)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultJo.get((Object)"data")), GetAppTokenResult.class);
            if (getAppTokenResult != null) {
                appToken = getAppTokenResult.getAppToken();
            }
        }
        catch (Exception e) {
            CommonUtil.getStackTrace(e);
        }
        if (StringUtils.isEmpty((CharSequence)appToken)) {
            AppCache.get().put(KEY_APP_TOKEN, KEY_ERROR, 10);
        } else {
            AppCache.get().put(KEY_APP_TOKEN, appToken, 3600);
        }
        return appToken;
    }

    public boolean checkAppToken(IdsParameter idsParameter, String appToken) {
        try {
            CheckAppTokenRequest checkAppTokenRequest = new CheckAppTokenRequest();
            checkAppTokenRequest.setAppToken(appToken);
            String result = HttpUtils.doPostJson(idsParameter.getIdsServerUrl() + "/ids/auth/common/authority/checkAppToken", JSONObject.toJSONString((Object)checkAppTokenRequest), null, 1500, 1500);
            JSONObject resultJo = JSON.parseObject((String)result);
            if (Objects.equals(resultJo.getInteger("errcode"), BaseResult.SUCCESS)) {
                JSONObject dataJo = resultJo.getJSONObject("data");
                String expect = "success";
                if (dataJo != null && StringUtils.equalsIgnoreCase((CharSequence)dataJo.getString("state"), (CharSequence)expect)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            CommonUtil.getStackTrace(e);
        }
        return false;
    }

    @Override
    public boolean checkAccessToken(IdsParameter idsParameter, String accessToken) {
        try {
            CheckAccessTokenRequest checkAccessTokenRequest = new CheckAccessTokenRequest();
            checkAccessTokenRequest.setAccessToken(accessToken);
            String result = HttpUtils.doPostJson(idsParameter.getIdsServerUrl() + "/ids/auth/common/authority/checkAccessToken", JSONObject.toJSONString((Object)checkAccessTokenRequest), null, 1500, 1500);
            JSONObject resultJo = JSON.parseObject((String)result);
            if (Objects.equals(resultJo.getInteger("errcode"), BaseResult.SUCCESS)) {
                JSONObject dataJo = resultJo.getJSONObject("data");
                String expect = "success";
                if (dataJo != null) {
                    int remainingSeconds = dataJo.getIntValue("remainingSeconds");
                    if (StringUtils.equalsIgnoreCase((CharSequence)dataJo.getString("state"), (CharSequence)expect) && remainingSeconds > 600) {
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            CommonUtil.getStackTrace(e);
        }
        return false;
    }
}

