/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.ids.core.query.data.DataMarkFilterItemQuery;
import kd.ai.ids.core.query.data.DeleteDataMarkQuery;
import kd.ai.ids.core.query.data.SaveDataMarkQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.service.IDataMarkService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.Services;

public class DataMarkServiceImpl
implements IDataMarkService {
    @Override
    public BaseResult getDataMarkDetailList(Long orgId, DataMarkFilterItemQuery filterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)filterItemQuery));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/predict/item/detail/list", paramsJo);
    }

    @Override
    public Map<String, Integer> getCodeMarkCountMap(Long orgId, String subServiceId, List<String> fpredimentypeCodeList) {
        JSONArray markCountJa;
        HashMap<String, Integer> codeMarkCountMap = new HashMap<String, Integer>();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fpredimentypeCodeList", fpredimentypeCodeList);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/predict/item/markcount", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null && (markCountJa = baseResult.getDataAsJSONArray()) != null && markCountJa.size() > 0) {
            for (Object obj : markCountJa) {
                JSONObject jo = (JSONObject)obj;
                codeMarkCountMap.put(jo.getString("fpredimentypeCode"), jo.getIntValue("count"));
            }
        }
        return codeMarkCountMap;
    }

    @Override
    public BaseResult saveDataMark(Long orgId, SaveDataMarkQuery saveDataMarkQuery) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSON.toJSONString((Object)saveDataMarkQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/save", paramsJo);
        return baseResult;
    }

    @Override
    public BaseResult deleteBatchMark(Long orgId, DeleteDataMarkQuery deleteDataMarkQuery) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSON.toJSONString((Object)deleteDataMarkQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/delete", paramsJo);
        return baseResult;
    }

    @Override
    public JSONObject getMarkList(Long orgId, String subServiceId, String fpredimentypeCode, String fmarktype, long current, long size) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fpredimentypeCode", (Object)fpredimentypeCode);
        paramsJo.put("fmarktype", (Object)fmarktype);
        paramsJo.put("current", (Object)current);
        paramsJo.put("size", (Object)size);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/list", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public BaseResult getDataMarkSummary(Long orgId, String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/summary", paramsJo);
        return baseResult;
    }

    @Override
    public BaseResult getDataMarkAnalysis(Long orgId, String subServiceId, String fpredimentypeCode, String fpretimetype) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fpredimentypeCode", (Object)fpredimentypeCode);
        paramsJo.put("fpretimetype", (Object)fpretimetype);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/analysis", paramsJo);
        return baseResult;
    }

    @Override
    public BaseResult getDataMarkTagInfluenceAnalysis(Long orgId, String subServiceId, String fpredimentypeCode, String fpretimetype) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fpredimentypeCode", (Object)fpredimentypeCode);
        paramsJo.put("fpretimetype", (Object)fpretimetype);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/tag/influence/analysis", paramsJo);
        return baseResult;
    }
}

