/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.service.IDataModelService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.Services;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataModelServiceImpl
implements IDataModelService {
    private static final Log logger = LogFactory.getLog(DataModelServiceImpl.class);

    private long getOrgId() {
        RequestContext rc = RequestContext.get();
        return rc.getOrgId();
    }

    @Override
    public JSONArray getLineageGraph(String subserviceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subserviceId);
        logger.info("get lineage graph request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/clientproxy/lineage/graph", paramsJo);
        logger.info("get lineage graph response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            JSONArray data = baseResult.getDataAsJSONArray();
            return data;
        }
        return new JSONArray();
    }

    @Override
    public JSONObject getLineageTable(String subserviceId, String fschemeid, String tblName) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subserviceId);
        paramsJo.put("fschemeid", (Object)fschemeid);
        paramsJo.put("tblName", (Object)tblName);
        logger.info("get lineage table request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/clientproxy/lineage/table", paramsJo);
        logger.info("get lineage table response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            JSONObject data = baseResult.getDataAsJSONObject();
            return data;
        }
        return new JSONObject();
    }
}

