/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.ids.core.query.data.CheckOutlierTagQuery;
import kd.ai.ids.core.query.data.SaveDataMarkQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.service.IDataOutlierAnaService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.Services;
import kd.bos.context.RequestContext;
import org.apache.commons.lang3.StringUtils;

public class DataOutlierAnaServiceImpl
implements IDataOutlierAnaService {
    @Override
    public JSONObject getMaterialSaleTrendNomodeltype(Long orgId, String subServiceId, String modeltypeId, String fpredimentypeCode) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fpredimentypeCode", (Object)fpredimentypeCode);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/material/sale/trend/nomodeltype", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getOutlierBillEntry(Long orgId, String subServiceId, String fpredimentypeCode, String fbiztime, int current, int size, String listType, String fstartDate, String fendDate) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fpredimentypeCode", (Object)fpredimentypeCode);
        paramsJo.put("current", (Object)current);
        paramsJo.put("size", (Object)size);
        paramsJo.put("listType", (Object)listType);
        paramsJo.put("fstartDate", (Object)fstartDate);
        paramsJo.put("fendDate", (Object)fendDate);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/bill/entry/list", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getBillEntryNoModeltype(Long orgId, String subServiceId, String fpredimentypeCode, String fbiztime, int current, int size, String listType, String fstartDate, String fendDate) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fpredimentypeCode", (Object)fpredimentypeCode);
        paramsJo.put("current", (Object)current);
        paramsJo.put("size", (Object)size);
        paramsJo.put("listType", (Object)listType);
        paramsJo.put("fstartDate", (Object)fstartDate);
        paramsJo.put("fendDate", (Object)fendDate);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/bill/entry/list", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public BaseResult saveMark(Long orgId, SaveDataMarkQuery saveDataMarkQuery) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSON.toJSONString((Object)saveDataMarkQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/save", paramsJo);
        return baseResult;
    }

    @Override
    public BaseResult outlierTagCheck(Long orgId, CheckOutlierTagQuery checkOutlierTagQuery) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSON.toJSONString((Object)checkOutlierTagQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/data/mark/tag/check", paramsJo);
        return baseResult;
    }

    @Override
    public List<String> checkTagUseDetail(RequestContext rc, List<String> fnumberList, String subServiceId) {
        JSONArray dataJa;
        List<String> usedNumberList = new ArrayList<String>();
        CheckOutlierTagQuery checkOutlierTagQuery = new CheckOutlierTagQuery();
        checkOutlierTagQuery.setSubServiceId(subServiceId);
        checkOutlierTagQuery.setFnumbers(StringUtils.join((Object[])fnumberList.toArray(), (String)","));
        BaseResult baseResult = this.outlierTagCheck(rc.getOrgId(), checkOutlierTagQuery);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && (dataJa = baseResult.getDataAsJSONArray()) != null && dataJa.size() > 0) {
            for (Object obj : dataJa) {
                JSONObject jo = (JSONObject)obj;
                if (jo.getIntValue("count") <= 0) continue;
                usedNumberList.add(jo.getString("fnumber"));
            }
            usedNumberList = usedNumberList.stream().distinct().collect(Collectors.toList());
        }
        return usedNumberList;
    }
}

