/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.ai.ids.core.entity.model.DataScore;
import kd.ai.ids.core.service.IDataQualityService;
import kd.ai.ids.core.utils.ConfigFileUtil;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.RandomUtils;

public class DataQualityServiceImpl
implements IDataQualityService {
    private static final String CONFIG_FILE_NAME = "META-INF/kd/ai/ids/config/kd.ai.ids.config.Entity";
    private static final JSONObject entityConfig = new JSONObject();

    @Override
    public int count(String entityNumber) {
        JSONObject config = entityConfig.getJSONObject(entityNumber);
        if (config == null) {
            return 0;
        }
        QFilter filter = null;
        JSONArray filterConfig = config.getJSONArray("filter");
        if (filterConfig != null) {
            for (int i = 0; i < filterConfig.size(); ++i) {
                JSONObject filterItem = filterConfig.getJSONObject(i);
                QFilter subFilter = new QFilter(filterItem.getString("prop"), filterItem.getString("cp"), filterItem.get((Object)"value"));
                filter = filter == null ? subFilter : filter.and(subFilter);
            }
        }
        if (filter != null) {
            return ORM.create().count("kd.ai.ids.DataCount." + entityNumber, entityNumber, new QFilter[]{filter});
        }
        return ORM.create().count("kd.ai.ids.DataCount." + entityNumber, entityNumber, new QFilter[0]);
    }

    private double rand() {
        return RandomUtils.nextDouble((double)0.0, (double)1.0);
    }

    private int round(double a) {
        long rtn = Math.round(a);
        return (int)rtn;
    }

    private int dispersionScore(List<Integer> billDailyCount) {
        double sum = 0.0;
        double standardDeviation = 0.0;
        int length = billDailyCount.size();
        for (Integer num : billDailyCount) {
            sum += (double)num.intValue();
        }
        double mean = sum / (double)length;
        for (Integer num : billDailyCount) {
            standardDeviation += Math.pow((double)num.intValue() - mean, 2.0);
        }
        double fcv = Math.sqrt(standardDeviation / (double)length) / (mean + 1.0);
        if (fcv <= 0.05) {
            return this.round(100.0 * (0.85 + 0.05 * this.rand()));
        }
        if (fcv > 0.05 && fcv <= 0.15) {
            return this.round(100.0 * (0.85 - 0.1 * this.rand()));
        }
        return this.round(100.0 * (0.75 - 0.05 * this.rand()));
    }

    private int missingScore(List<Integer> billDailyCount) {
        int length = billDailyCount.size();
        double missingRatio = (double)(90 - length) / 90.0;
        if (missingRatio <= 0.1) {
            return this.round(100.0 * (0.85 + 0.05 * this.rand()));
        }
        if (missingRatio <= 0.2) {
            return this.round(100.0 * (0.85 - 0.05 * this.rand()));
        }
        if (missingRatio <= 0.4) {
            return this.round(100.0 * (0.8 - 0.1 * this.rand()));
        }
        return this.round(100.0 * (0.7 - 0.05 * this.rand()));
    }

    private int sizeScore(long allBillCount) {
        if (allBillCount >= 1095L) {
            return this.round(100.0 * (0.85 + 0.05 * this.rand()));
        }
        if (allBillCount >= 365L) {
            return this.round(100.0 * (0.85 - 0.05 * this.rand()));
        }
        if (allBillCount >= 180L) {
            return this.round(100.0 * (0.75 + 0.05 * this.rand()));
        }
        if (allBillCount >= 60L) {
            return this.round(100.0 * (0.75 - 0.05 * this.rand()));
        }
        return this.round(100.0 * (0.7 - 0.05 * this.rand()));
    }

    private int outlierScore(List<Integer> billDailyCount) {
        int i;
        int length = billDailyCount.size();
        int size = length / 4;
        int mod = length % 4;
        int[] subSize = new int[4];
        for (i = 0; i < 4; ++i) {
            subSize[i] = size;
        }
        i = 0;
        while (i < mod) {
            int n = i++;
            subSize[n] = subSize[n] + 1;
        }
        Collections.sort(billDailyCount);
        int fql = 0;
        if (subSize[0] > 0) {
            int fqlIndex = subSize[0] - 1;
            fql = billDailyCount.get(fqlIndex);
        }
        int fqu = 0;
        if (subSize[2] > 0) {
            int fquIndex = subSize[0] + subSize[1] + subSize[2] - 1;
            fqu = billDailyCount.get(fquIndex);
        }
        int fiqr = fqu - fql;
        long sum = 0L;
        for (Integer num : billDailyCount) {
            if (!((double)num.intValue() < (double)fql - 1.5 * (double)fiqr) && !((double)num.intValue() > (double)fqu + 1.5 * (double)fiqr)) continue;
            ++sum;
        }
        double score = (double)this.round(1.0 * (double)sum / (double)length * 100.0) / 100.0;
        if (score <= 0.1) {
            return this.round(100.0 * (0.85 + 0.05 * this.rand()));
        }
        if (score <= 0.2) {
            return this.round(100.0 * (0.85 - 0.05 * this.rand()));
        }
        if (score <= 0.4) {
            return this.round(100.0 * (0.8 - 0.1 * this.rand()));
        }
        return this.round(100.0 * (0.7 - 0.05 * this.rand()));
    }

    private BillStat queryBillStat(String entityNumber, final Date startDay, final Date endDay) {
        JSONObject config = entityConfig.getJSONObject(entityNumber);
        if (config == null) {
            return null;
        }
        final String bizDateProp = config.getString("bizDateProp");
        if (StringUtils.isEmpty((String)bizDateProp)) {
            return null;
        }
        String algoKey = "kd.ai.ids.DispersionScore." + entityNumber;
        try (DataSet dataSet = Algo.create((String)algoKey).createDataSet(new Input[]{new OrmInput(algoKey, entityNumber, "id," + bizDateProp, new QFilter[0])});){
            final RowMeta rowMeta = new RowMeta(new Field[]{new Field("billcnt", (DataType)DataType.IntegerType), new Field("flag", (DataType)DataType.IntegerType), new Field("bizdate", (DataType)DataType.StringType)});
            DataSet dataSet2 = dataSet.map(new MapFunction(){

                public Object[] map(Row row) {
                    Date bizDate = row.getDate(bizDateProp);
                    int flag = 0;
                    if (bizDate != null && startDay.before(bizDate) && endDay.after(bizDate)) {
                        flag = 1;
                    }
                    String dateStr = "";
                    if (bizDate != null) {
                        dateStr = new SimpleDateFormat("yyyy-MM-dd").format(bizDate);
                    }
                    return new Object[]{1, flag, dateStr};
                }

                public RowMeta getResultRowMeta() {
                    return rowMeta;
                }
            });
            dataSet2 = dataSet2.groupBy(new String[]{"bizdate"}).count("billcnt").max("flag").finish();
            LinkedList<Integer> billDailyCount = new LinkedList<Integer>();
            long allBillDayCount = 0L;
            while (dataSet2.hasNext()) {
                Row row = dataSet2.next();
                Integer billcnt = row.getInteger("billcnt");
                Integer flag = row.getInteger("flag");
                ++allBillDayCount;
                if (flag != 1) continue;
                billDailyCount.add(billcnt);
            }
            BillStat billStat = new BillStat(allBillDayCount, billDailyCount);
            return billStat;
        }
    }

    @Override
    public DataScore calcScore(String entityNumber) {
        Date endDay;
        Date today = KDDateUtils.today();
        Date startDay = KDDateUtils.addDays((Date)today, (int)-90);
        BillStat billStat = this.queryBillStat(entityNumber, startDay, endDay = KDDateUtils.addDays((Date)today, (int)1));
        if (billStat == null) {
            return new DataScore();
        }
        return this.calcScore(billStat);
    }

    public DataScore calcScore(BillStat billStat) {
        int dispersionScore = this.dispersionScore(billStat.getBillDailyCount());
        int missingScore = this.missingScore(billStat.getBillDailyCount());
        int outlierScore = this.outlierScore(billStat.getBillDailyCount());
        int sizeScore = this.sizeScore(billStat.getAllBillDayCount());
        DataScore rtn = new DataScore();
        rtn.setDispersionScore(dispersionScore).setMissingScore(missingScore).setOutlierScore(outlierScore).setSizeScore(sizeScore).setScore((dispersionScore + missingScore + outlierScore + sizeScore) / 4);
        return rtn;
    }

    static {
        List<String> fileDataList = ConfigFileUtil.loadFile(CONFIG_FILE_NAME);
        for (String fileData : fileDataList) {
            try {
                JSONObject json = JSON.parseObject((String)fileData);
                if (json == null || json.isEmpty()) continue;
                entityConfig.putAll((Map)json);
            }
            catch (Exception exception) {}
        }
    }

    public static class BillStat {
        private final List<Integer> billDailyCount;
        private long allBillDayCount = 0L;

        public BillStat(long allBillDayCount, List<Integer> billDailyCount) {
            this.allBillDayCount = allBillDayCount;
            this.billDailyCount = billDailyCount;
        }

        public long getAllBillDayCount() {
            return this.allBillDayCount;
        }

        public List<Integer> getBillDailyCount() {
            return this.billDailyCount;
        }
    }
}

