/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.ai.ids.core.cache.AppCache;
import kd.ai.ids.core.entity.model.EntityCatalog;
import kd.ai.ids.core.enumtype.AppIdentifierEnum;
import kd.ai.ids.core.enumtype.AppStatusEnum;
import kd.ai.ids.core.enumtype.DataappPvaEnum;
import kd.ai.ids.core.enumtype.DataappRfmEnum;
import kd.ai.ids.core.enumtype.DataappSalesForecastEnum;
import kd.ai.ids.core.query.server.SubAddQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.SubserviceDTO;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.ILabelService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ksql.util.StringUtil;
import kd.bos.license.api.ILicenseService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;

public class DataappServiceImpl
implements IDataappService {
    @Override
    public List<String> getVisibleAppIdList(Long orgId, String tenantId) {
        List<String> appIdList = new ArrayList<String>();
        JSONArray labelTypeKeysArray = Services.get(ILabelService.class).getLabelTypeKeysJa(orgId, tenantId);
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("labelKeys", (Object)labelTypeKeysArray);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/dataapp/app/selector", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject dataJObj = baseResult.getDataAsJSONObject();
            JSONArray appIdArray = CommonUtil.emptyIfNull(dataJObj.getJSONArray("apps"));
            appIdList = appIdArray.toJavaList(String.class);
            appIdList = this.sortPvaAndRfm(appIdList);
        }
        return appIdList;
    }

    private List<String> sortPvaAndRfm(List<String> appIdList) {
        List<String> newAppIdList = appIdList;
        if (CollectionUtils.isNotEmpty(appIdList)) {
            newAppIdList = new ArrayList<String>(appIdList.size());
            int rfmIndex = 0;
            int pvaIndex = 0;
            String rfmAppId = "";
            String pvaAppId = "";
            for (int i = 0; i < appIdList.size(); ++i) {
                String appId = appIdList.get(i);
                if (this.appIsRfm(appId)) {
                    rfmIndex = i;
                    rfmAppId = appId;
                    continue;
                }
                if (this.appIsPva(appId)) {
                    pvaIndex = i;
                    pvaAppId = appId;
                    continue;
                }
                newAppIdList.add(appId);
            }
            if (rfmIndex >= 0 && pvaIndex >= 0 && rfmIndex < pvaIndex) {
                newAppIdList.add(rfmIndex, pvaAppId);
                newAppIdList.add(pvaIndex, rfmAppId);
            }
        }
        return newAppIdList;
    }

    @Override
    public String getSalesForecastAppIdByPlatformCode() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        String appId = modelType == 1 ? DataappSalesForecastEnum.IDS_APP_COSMIC.getId() : (modelType == 4 ? DataappSalesForecastEnum.IDS_APP_K3CLOUDULTIMATE.getId() : DataappSalesForecastEnum.IDS_APP_CONSTELLATION.getId());
        return appId;
    }

    @Override
    public String getAppIdByPlatformCode(String appIdentifier) {
        String appId = null;
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        if (StringUtils.equalsIgnoreCase((CharSequence)appIdentifier, (CharSequence)AppIdentifierEnum.SSF.getKey())) {
            appId = modelType == 1 ? DataappSalesForecastEnum.IDS_APP_COSMIC.getId() : (modelType == 4 ? DataappSalesForecastEnum.IDS_APP_K3CLOUDULTIMATE.getId() : DataappSalesForecastEnum.IDS_APP_CONSTELLATION.getId());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)appIdentifier, (CharSequence)AppIdentifierEnum.RFM.getKey())) {
            appId = modelType == 1 ? DataappRfmEnum.IDS_APP_COSMIC.getId() : (modelType == 4 ? DataappRfmEnum.IDS_APP_K3CLOUDULTIMATE.getId() : DataappRfmEnum.IDS_APP_CONSTELLATION.getId());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)appIdentifier, (CharSequence)AppIdentifierEnum.PVA.getKey())) {
            appId = modelType == 1 ? DataappPvaEnum.IDS_APP_COSMIC.getId() : (modelType == 4 ? DataappPvaEnum.IDS_APP_K3CLOUDULTIMATE.getId() : DataappPvaEnum.IDS_APP_CONSTELLATION.getId());
        }
        return appId;
    }

    @Override
    public boolean appIsSalesForecast(String appId) {
        DataappSalesForecastEnum dataappSalesForecastEnum = DataappSalesForecastEnum.getIdAppById(appId);
        return dataappSalesForecastEnum != null;
    }

    @Override
    public boolean appIsRfm(String appId) {
        DataappRfmEnum dataappRfmEnum = DataappRfmEnum.getIdAppById(appId);
        return dataappRfmEnum != null;
    }

    @Override
    public boolean appIsPva(String appId) {
        DataappPvaEnum dataappPvaEnum = DataappPvaEnum.getIdAppById(appId);
        return dataappPvaEnum != null;
    }

    @Override
    public boolean appIsGpe(String appId) {
        return StringUtils.equalsIgnoreCase((CharSequence)appId, (CharSequence)"1000");
    }

    @Override
    public EntityCatalog getModelData(Long orgId, String tenantId, String appId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("tenantId", (Object)tenantId);
        paramsJo.put("appId", (Object)appId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/app/customer/model/cloud/get", paramsJo);
        EntityCatalog entityCatalog = null;
        if (baseResult.getErrcode() == 0) {
            String modelData = baseResult.getDataAsJSONObject().getString("model");
            entityCatalog = (EntityCatalog)JSON.parseObject((String)modelData, EntityCatalog.class);
        }
        return entityCatalog;
    }

    @Override
    public JSONObject getSubService(Long orgId, String tenantId, String appId) {
        String cacheKey = "/ids/clientproxy/subservice/get/" + orgId + "/" + tenantId + "/" + appId;
        String cacheData = AppCache.get().get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)cacheData)) {
            return JSON.parseObject((String)cacheData);
        }
        JSONObject rtn = null;
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("appId", (Object)appId);
        paramsJo.put("tenantId", (Object)tenantId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/subservice/get", paramsJo);
        if (baseResult != null && baseResult.getErrcode() == 0 && baseResult.getData() != null) {
            rtn = baseResult.getDataAsJSONObject();
            AppCache.get().put(cacheKey, rtn.toJSONString(), 5);
        }
        return rtn;
    }

    @Override
    public JSONObject getSubService(String subServiceId) {
        String cacheKey = "/ids/clientproxy/subservice/detail/" + subServiceId;
        String cacheData = AppCache.get().get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)cacheData)) {
            return JSON.parseObject((String)cacheData);
        }
        JSONObject rtn = null;
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/subservice/detail", paramsJo);
        if (baseResult != null && baseResult.getErrcode() == 0 && baseResult.getData() != null) {
            rtn = baseResult.getDataAsJSONObject();
            AppCache.get().put(cacheKey, rtn.toJSONString(), 5);
        }
        return rtn;
    }

    @Override
    public SubserviceDTO subAdd(SubAddQuery subAddQuery) {
        SubserviceDTO subserviceDTO = null;
        JSONObject paramsJo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)subAddQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/ids/app/customer/sub/add", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject dataJo = baseResult.getDataAsJSONObject();
            subserviceDTO = (SubserviceDTO)JSONObject.toJavaObject((JSON)dataJo, SubserviceDTO.class);
        }
        return subserviceDTO;
    }

    @Override
    public BaseResult getConfigStatus(Long orgId, String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/subservice/config/status", paramsJo);
        return baseResult;
    }

    @Override
    public void removeSubserviceCache(Long orgId, String tenantId, String appId) {
        String subServiceCacheKey = "/ids/clientproxy/subservice/get/" + orgId + "/" + tenantId;
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            subServiceCacheKey = subServiceCacheKey + "/" + appId;
        }
        String subListCacheKey = "/ids/ids/app/customer/sub/list/" + orgId + "/" + tenantId;
        AppCache.get().removeWithKeyPrefix(subServiceCacheKey);
        AppCache.get().remove(subServiceCacheKey);
        AppCache.get().remove(subListCacheKey);
    }

    @Override
    public boolean appIsOnline(Long orgId, String tenantId, String appId) {
        Integer status;
        boolean isOnline = false;
        JSONObject resultJo = this.getSubService(orgId, tenantId, appId);
        if (resultJo != null && (status = resultJo.getInteger("status")) != null && status.intValue() == AppStatusEnum.ONLINE.getKey()) {
            isOnline = true;
        }
        return isOnline;
    }

    @Override
    public String getSubServiceId(Long orgId, String tenantId, String appId) {
        String subServiceId = "";
        JSONObject resultJo = this.getSubService(orgId, tenantId, appId);
        if (resultJo != null) {
            subServiceId = resultJo.getString("subServiceId");
        }
        return subServiceId;
    }

    @Override
    public JSONObject getSubAppList(Long orgId, String customerId, String tenantId) {
        String cacheKey = "/ids/ids/app/customer/sub/list/" + orgId + "/" + tenantId;
        String cacheData = AppCache.get().get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)cacheData)) {
            return JSON.parseObject((String)cacheData);
        }
        JSONObject dataJo = null;
        List<String> visibleAppIdList = this.getVisibleAppIdList(orgId, tenantId);
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("customerId", (Object)customerId);
        paramsJo.put("tenantId", (Object)tenantId);
        paramsJo.put("appIds", (Object)StringUtil.arrayToString((Object[])visibleAppIdList.toArray(), (String)","));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/app/customer/sub/list", paramsJo);
        if (baseResult != null && baseResult.getErrcode() == 0) {
            dataJo = baseResult.getDataAsJSONObject();
            AppCache.get().put(cacheKey, dataJo.toJSONString(), 5);
        }
        return dataJo;
    }
}

