/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kd.ai.ids.core.query.clientproxy.gpt.ChatContentListQuery;
import kd.ai.ids.core.query.clientproxy.gpt.CreateDashboardQuery;
import kd.ai.ids.core.query.clientproxy.gpt.CreatePPTQuery;
import kd.ai.ids.core.query.clientproxy.gpt.GetPPTStatusQuery;
import kd.ai.ids.core.query.clientproxy.gpt.GptInsightDataQuery;
import kd.ai.ids.core.query.clientproxy.gpt.TaskResponseQuery;
import kd.ai.ids.core.query.clientproxy.gpt.UserMessageQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IAuthService;
import kd.ai.ids.core.service.IGPTService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GPTServiceImpl
implements IGPTService {
    private static final Log logger = LogFactory.getLog(GPTServiceImpl.class);

    @Override
    public BaseResult userMessage(Long orgId, UserMessageQuery query) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)query));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/gpt/usermessage", paramsJo);
    }

    @Override
    public BaseResult taskResponse(Long orgId, TaskResponseQuery query) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)query));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/gpt/taskresponse", paramsJo);
    }

    @Override
    public BaseResult gptInsightData(Long orgId, GptInsightDataQuery query) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)query));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/gpt/gptinsightdata", paramsJo);
    }

    @Override
    public BaseResult chatContentList(Long orgId, ChatContentListQuery query) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)query));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/gpt/chatcontentlist", paramsJo);
    }

    @Override
    public BaseResult createDashboard(Long orgId, CreateDashboardQuery query) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)query));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/gpt/createdashboard", paramsJo);
    }

    @Override
    public BaseResult createPPT(Long orgId, CreatePPTQuery query) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)query));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/gpt/createppt", paramsJo);
    }

    @Override
    public BaseResult getPPTStatus(Long orgId, GetPPTStatusQuery query) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)query));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/gpt/getpptstatus", paramsJo);
    }

    @Override
    public String getPPTDownloadUrl(Long orgId, String subServiceId, String requestId) {
        IdsParameter idsParameter = Services.get(IIdsParameterService.class).getIdsParameter(orgId);
        String token = Services.get(IAuthService.class).getAccessToken(idsParameter);
        try {
            token = URLEncoder.encode(token, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            CommonUtil.getStackTrace(e);
        }
        String url = idsParameter.getIdsServerUrl() + "/ids/clientproxy/gpt/downloadppt";
        return String.format("%s?subServiceId=%s&requestId=%s&auth_type=token&token=%s", url, subServiceId, requestId, token);
    }
}

