/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.enumtype.gpe.ErrorCodeEnum;
import kd.ai.ids.core.query.gpe.GpeRequestContext;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IGpeServerService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.IOpenAPIService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.HttpUtils;
import kd.ai.ids.core.utils.JsonUtils;
import kd.bos.isv.EncryptUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GpeServerServiceImpl
implements IGpeServerService {
    private static final Log log = LogFactory.getLog(IIdsServerService.class);

    private IIdsParameterService idsParameterService() {
        return Services.get(IIdsParameterService.class);
    }

    private IOpenAPIService openAPIService() {
        return Services.get(IOpenAPIService.class);
    }

    @Override
    public CustomApiResult getCustomApiResult(GpeRequestContext gpeRequestContext, String apiPath, JSONObject paramJo) {
        CustomApiResult customApiResult = CustomApiResult.fail((String)ErrorCodeEnum.FAIL.getId(), (String)"\u8bf7\u6c42\u670d\u52a1\u7aef\u63a5\u53e3\u5931\u8d25");
        try {
            String clientSecret;
            long orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
            IdsParameter idsParameter = this.idsParameterService().getIdsParameter(orgId);
            if (StringUtils.isEmpty((CharSequence)idsParameter.getPublicKey())) {
                return CustomApiResult.fail((String)ErrorCodeEnum.PUBLIC_KEY_EMPTY.getId(), (String)ErrorCodeEnum.PUBLIC_KEY_EMPTY.getName());
            }
            boolean reInit = this.openAPIService().initOpenAPIThirdApp(idsParameter);
            if (reInit) {
                idsParameter = this.idsParameterService().getIdsParameter(orgId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(clientSecret = idsParameter.getThirdAppSecret()))) {
                try {
                    clientSecret = EncryptUtils.publicEncrypt((String)clientSecret, (String)idsParameter.getPublicKey());
                }
                catch (Exception e) {
                    log.error("publicEncrypt error:" + e.getMessage(), (Throwable)e);
                }
            } else {
                return CustomApiResult.fail((String)ErrorCodeEnum.APP_SECRET_EMPTY.getId(), (String)ErrorCodeEnum.APP_SECRET_EMPTY.getName());
            }
            gpeRequestContext.setClientSecret(clientSecret);
            gpeRequestContext.setClientId(idsParameter.getThirdAppId());
            gpeRequestContext.setClientProxyUser(idsParameter.getThirdProxyUsername());
            long startTs = System.currentTimeMillis();
            if (paramJo == null) {
                paramJo = new JSONObject();
            }
            paramJo.put("gpeRequestContext", (Object)gpeRequestContext);
            String requestId = paramJo.getString("requestId");
            String paramStr = JsonUtils.toJSONString(paramJo);
            String gpeServerUrl = idsParameter.getGpeServerUrl();
            if (StringUtils.isEmpty((CharSequence)gpeServerUrl)) {
                return CustomApiResult.fail((String)ErrorCodeEnum.GPE_SERVER_URL_EMPTY.getId(), (String)ErrorCodeEnum.GPE_SERVER_URL_EMPTY.getName());
            }
            String url = String.format("%s%s", gpeServerUrl, apiPath);
            log.info("[GPE api]start requestId: {} url: {}\nparamJo:{}", new Object[]{requestId, url, paramStr});
            String result = null;
            String printResult = result = HttpUtils.doPostJson(url, paramStr, null, AppConstants.DEFAULT_CONNECTION_TIMEOUT, idsParameter.getReadTimeout());
            printResult = StringUtils.isNotEmpty((CharSequence)printResult) && printResult.length() > 2000 ? printResult.substring(0, 2000) : printResult;
            long cost = System.currentTimeMillis() - startTs;
            log.info("#####[GPE api cost:{}ms]end requestId: {} url:{} \nresult:{} ", new Object[]{cost, requestId, url, printResult});
            customApiResult = (CustomApiResult)JSONObject.parseObject((String)result, CustomApiResult.class);
        }
        catch (Exception e) {
            log.error("error:" + e.getMessage(), (Throwable)e);
        }
        return customApiResult;
    }
}

