/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.entity.model.BizTransSchemeMsg;
import kd.ai.ids.core.entity.model.gpe.PlainField;
import kd.ai.ids.core.enumtype.ExecStatusEnum;
import kd.ai.ids.core.enumtype.RowDataTypeEnum;
import kd.ai.ids.core.enumtype.gpe.FieldTypeEnum;
import kd.ai.ids.core.service.IGpeTaskExecuteService;
import kd.ai.ids.core.utils.AlgoUtils;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import org.apache.commons.lang3.time.DateFormatUtils;

public class GpeTaskExecuteServiceImpl
implements IGpeTaskExecuteService {
    private static final Log log = LogFactory.getLog(GpeTaskExecuteServiceImpl.class);
    private static final String KEY_BILL_HEAD_KEY = "billHeadKey";
    private static final String KEY_BILL_DATA = "billData";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBizTransSchemeTask(DynamicObject bizTransSchemeDo, String originCacheId, List<PlainField> plainFieldList, String algoKey) {
        Algo algo = Algo.create((String)algoKey);
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)originCacheId);
        HashMap<String, List<EntityType>> idEntryTypeListMap = new HashMap<String, List<EntityType>>();
        HashMap<String, List<EntityType>> idSubEntryTypeListMap = new HashMap<String, List<EntityType>>();
        Map<String, Integer> fieldNameFieldTypeMap = new HashMap<String, Integer>();
        HashMap<String, String> quotefieldBizobjfieldMap = new HashMap<String, String>();
        HashMap<String, DynamicObjectCollection> entityIdFieldMappingCollectionMap = new HashMap<String, DynamicObjectCollection>(15);
        Date createTime = KDDateUtils.now();
        long startTime = KDDateUtils.now().getTime();
        idEntryTypeListMap.clear();
        idSubEntryTypeListMap.clear();
        fieldNameFieldTypeMap.clear();
        quotefieldBizobjfieldMap.clear();
        entityIdFieldMappingCollectionMap.clear();
        Long bizTransSchemePkId = (Long)bizTransSchemeDo.getPkValue();
        String schemeNumber = bizTransSchemeDo.getString("number");
        String name = bizTransSchemeDo.getString("name");
        String bizobj = bizTransSchemeDo.getDynamicObject("bizobj").getString("number");
        DynamicObjectCollection fieldMappingCollection = bizTransSchemeDo.getDynamicObjectCollection("field_mapping_entry");
        if (fieldMappingCollection != null && !fieldMappingCollection.isEmpty()) {
            for (DynamicObject fieldMappingDynamicObject : fieldMappingCollection) {
                DynamicObjectCollection tempFieldMappingCollection;
                String quoteField = fieldMappingDynamicObject.getString("quotefield");
                String bizobjField = fieldMappingDynamicObject.getString("bizobjfield");
                quotefieldBizobjfieldMap.put(quoteField, bizobjField);
                if (StringUtils.isEmpty((CharSequence)quoteField) || StringUtils.isEmpty((CharSequence)bizobjField)) continue;
                String entityId = bizobj;
                if (bizobjField.contains(".")) {
                    entityId = bizobjField.split("\\.")[0];
                }
                if ((tempFieldMappingCollection = (DynamicObjectCollection)entityIdFieldMappingCollectionMap.get(entityId)) == null) {
                    tempFieldMappingCollection = new DynamicObjectCollection();
                }
                tempFieldMappingCollection.add((Object)fieldMappingDynamicObject);
                entityIdFieldMappingCollectionMap.put(entityId, tempFieldMappingCollection);
            }
        }
        if (entityIdFieldMappingCollectionMap.isEmpty()) {
            log.info("executeSchemeTask failed with entityIdFieldMappingCollectionMap is empty. schemeNumber:{}", (Object)schemeNumber);
            return;
        }
        List<String> fields = plainFieldList.stream().map(PlainField::getFieldKey).collect(Collectors.toList());
        DynamicObjectCollection headEntityFieldMappingCollection = (DynamicObjectCollection)entityIdFieldMappingCollectionMap.get(bizobj);
        if (headEntityFieldMappingCollection == null || headEntityFieldMappingCollection.isEmpty()) {
            log.info("executeSchemeTask failed with billHead field is not configured. schemeNumber:{}", (Object)schemeNumber);
            return;
        }
        String[] headQuoteFieldArray = new String[headEntityFieldMappingCollection.size()];
        for (int i = 0; i < headEntityFieldMappingCollection.size(); ++i) {
            String quoteField;
            DynamicObject fieldMappingDynamicObject = (DynamicObject)headEntityFieldMappingCollection.get(i);
            headQuoteFieldArray[i] = quoteField = fieldMappingDynamicObject.getString("quotefield");
        }
        DataSet modeltypeResultTypeDataSet = null;
        DataSet dataDataSet = null;
        DataSet filterDataSet = null;
        DataSet groupConcatDataSet = null;
        try {
            fieldNameFieldTypeMap = this.getFieldNameFieldTypeMap(fieldNameFieldTypeMap, bizobj);
            RowMeta rowMeta = this.assemblyRowMeta(plainFieldList);
            modeltypeResultTypeDataSet = cacheDataSet.toDataSet(algo, false);
            dataDataSet = this.extractDataToDataSet(rowMeta, modeltypeResultTypeDataSet, headQuoteFieldArray, fields, fieldNameFieldTypeMap, quotefieldBizobjfieldMap, plainFieldList);
            GroupbyDataSet groupbyDataSet = null;
            String filterCondition = bizTransSchemeDo.getString("filtercondition");
            if (StringUtils.isNotEmpty((CharSequence)filterCondition)) {
                filterDataSet = dataDataSet.filter(filterCondition);
                groupbyDataSet = filterDataSet.groupBy(new String[]{KEY_BILL_HEAD_KEY});
            } else {
                groupbyDataSet = dataDataSet.groupBy(new String[]{KEY_BILL_HEAD_KEY});
            }
            groupConcatDataSet = groupbyDataSet.groupConcat(KEY_BILL_DATA, KEY_BILL_DATA).finish();
            while (groupConcatDataSet.hasNext()) {
                Row row = groupConcatDataSet.next();
                DynamicObject bizobjDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)bizobj);
                HashMap<String, DynamicObject> billHeadKeyDynamicObjectMap = new HashMap<String, DynamicObject>(10);
                HashMap<String, DynamicObjectCollection> entryEntityKeyDynamicObjectCollectionMap = new HashMap<String, DynamicObjectCollection>(10);
                HashMap<String, DynamicObjectCollection> entryEntityKeySubDynamicObjectCollectionMap = new HashMap<String, DynamicObjectCollection>(10);
                String rowData = row.getString(1);
                String billDataArrStr = String.format("[%s]", rowData);
                JSONArray rowJa = JSONArray.parseArray((String)billDataArrStr);
                for (Object rowObj : rowJa) {
                    JSONObject rowJo = (JSONObject)rowObj;
                    this.assemblySingleBill(idEntryTypeListMap, idSubEntryTypeListMap, fieldNameFieldTypeMap, entityIdFieldMappingCollectionMap, bizobj, headEntityFieldMappingCollection, bizobjDynamicObject, billHeadKeyDynamicObjectMap, entryEntityKeyDynamicObjectCollectionMap, entryEntityKeySubDynamicObjectCollectionMap, RowDataTypeEnum.JSONOBJECT, rowJo);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizobjDynamicObject});
            }
        }
        catch (Exception e) {
            CommonUtil.getStackTrace(e);
        }
        finally {
            if (groupConcatDataSet != null) {
                groupConcatDataSet.close();
            }
            if (dataDataSet != null) {
                dataDataSet.close();
            }
            if (modeltypeResultTypeDataSet != null) {
                modeltypeResultTypeDataSet.close();
            }
        }
        this.asyncGpeSendMsg(bizTransSchemePkId, schemeNumber, name, bizobj, bizTransSchemeDo);
        long endTime = KDDateUtils.now().getTime();
        long cost = endTime - startTime;
        log.info("executeSchemeTask success with schemeNumber:{}, cost:{}ms", (Object)schemeNumber, (Object)cost);
    }

    private void setBizObjFieldValue(DynamicObject bizobjDynamicObject, String bizobjField, String quoteFieldValue, int fieldType) {
        if (AppConstants.INT_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? Integer.valueOf(new BigDecimal(quoteFieldValue).intValue()) : null);
        } else if (AppConstants.LONG_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? Long.valueOf(new BigDecimal(quoteFieldValue).longValue()) : null);
        } else if (AppConstants.FLOAT_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, (Object)(StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? new BigDecimal(quoteFieldValue) : null));
        } else if (AppConstants.CHAR_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, (Object)quoteFieldValue);
        } else if (AppConstants.DATE_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? DateUtils.parseDate(quoteFieldValue, "yyyy-MM-dd") : null);
        } else if (AppConstants.DATETIME_LIST.contains(fieldType)) {
            Pattern pattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})");
            Matcher matcher = pattern.matcher(quoteFieldValue);
            if (matcher.matches()) {
                quoteFieldValue = String.format("%s 00:00:00", quoteFieldValue);
            }
            bizobjDynamicObject.set(bizobjField, StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? DateUtils.parseDate(quoteFieldValue, "yyyy-MM-dd HH:mm:ss") : null);
        }
    }

    private Object getBizObjFieldValue(String quoteFieldValue, int fieldType) {
        Object value = quoteFieldValue;
        if (AppConstants.INT_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? Integer.valueOf(new BigDecimal(quoteFieldValue).intValue()) : null;
        } else if (AppConstants.LONG_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? Long.valueOf(new BigDecimal(quoteFieldValue).longValue()) : null;
        } else if (AppConstants.FLOAT_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? new BigDecimal(quoteFieldValue) : null;
        } else if (AppConstants.CHAR_LIST.contains(fieldType)) {
            value = quoteFieldValue;
        } else if (AppConstants.DATE_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? DateUtils.parseDate(quoteFieldValue, "yyyy-MM-dd") : null;
        } else if (AppConstants.DATETIME_LIST.contains(fieldType)) {
            Pattern pattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})");
            Matcher matcher = pattern.matcher(quoteFieldValue);
            if (matcher.matches()) {
                quoteFieldValue = String.format("%s 00:00:00", quoteFieldValue);
            }
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? DateUtils.parseDate(quoteFieldValue, "yyyy-MM-dd HH:mm:ss") : null;
        }
        return value;
    }

    private DataType getAlgoDataType(int fieldType) {
        StringType dataType = DataType.StringType;
        if (AppConstants.INT_LIST.contains(fieldType)) {
            dataType = DataType.IntegerType;
        } else if (AppConstants.LONG_LIST.contains(fieldType)) {
            dataType = DataType.LongType;
        } else if (AppConstants.FLOAT_LIST.contains(fieldType)) {
            dataType = DataType.DoubleType;
        } else if (AppConstants.CHAR_LIST.contains(fieldType)) {
            dataType = DataType.StringType;
        } else if (AppConstants.DATE_LIST.contains(fieldType)) {
            dataType = DataType.DateType;
        } else if (AppConstants.DATETIME_LIST.contains(fieldType)) {
            dataType = DataType.DateType;
        }
        return dataType;
    }

    private void assemblySingleBill(Map<String, List<EntityType>> idEntryTypeListMap, Map<String, List<EntityType>> idSubEntryTypeListMap, Map<String, Integer> fieldNameFieldTypeMap, Map<String, DynamicObjectCollection> entityIdFieldMappingCollectionMap, String bizobj, DynamicObjectCollection headEntityFieldMappingCollection, DynamicObject bizobjDynamicObject, Map<String, DynamicObject> billHeadKeyDynamicObjectMap, Map<String, DynamicObjectCollection> entryEntityKeyDynamicObjectCollectionMap, Map<String, DynamicObjectCollection> entryEntityKeySubDynamicObjectCollectionMap, RowDataTypeEnum rowDataTypeEnum, Object rowData) {
        List<EntityType> entryTypeList;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizobj);
        idEntryTypeListMap.clear();
        idSubEntryTypeListMap.clear();
        fieldNameFieldTypeMap.clear();
        if (mainEntityType != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getAlias())) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entry : allEntities.entrySet()) {
                List entityTypeList;
                String parentName;
                Map fieldMap;
                EntityType entityType = (EntityType)entry.getValue();
                String entityName = entityType.getName();
                ISimpleProperty primaryKey = entityType.getPrimaryKey();
                if (primaryKey != null) {
                    String pkFieldName = primaryKey.getName();
                    if (!(entityType instanceof BillEntityType)) {
                        pkFieldName = String.format("%s.%s", entityName, pkFieldName);
                    }
                    fieldNameFieldTypeMap.put(pkFieldName, primaryKey.getDbType());
                }
                if ((fieldMap = entityType.getFields()) != null && !fieldMap.isEmpty()) {
                    Iterator iterator = fieldMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        String fieldName = (String)iterator.next().getKey();
                        IDataEntityProperty dp = (IDataEntityProperty)fieldMap.get(fieldName);
                        if (StringUtils.isEmpty((CharSequence)dp.getAlias())) continue;
                        if (!(entityType instanceof BillEntityType)) {
                            fieldName = String.format("%s.%s", entityName, fieldName);
                        }
                        if (dp instanceof FieldProp) {
                            FieldProp fieldProp = (FieldProp)dp;
                            fieldNameFieldTypeMap.put(fieldName, fieldProp.getDbType());
                            continue;
                        }
                        if (!(dp instanceof BasedataProp)) continue;
                        BasedataProp basedataProp = (BasedataProp)dp;
                        fieldNameFieldTypeMap.put(fieldName, basedataProp.getDbType());
                    }
                }
                if (entityType instanceof SubEntryType) {
                    parentName = entityType.getParent().getName();
                    entityTypeList = idSubEntryTypeListMap.getOrDefault(parentName, new ArrayList());
                    entityTypeList.add(entityType);
                    idSubEntryTypeListMap.put(parentName, entityTypeList);
                    continue;
                }
                if (entityType instanceof EntryType) {
                    parentName = entityType.getParent().getName();
                    entityTypeList = idEntryTypeListMap.getOrDefault(parentName, new ArrayList());
                    entityTypeList.add(entityType);
                    idEntryTypeListMap.put(parentName, entityTypeList);
                    continue;
                }
                if (!(entityType instanceof BillEntityType)) continue;
            }
        }
        StringBuffer billHeadKey = new StringBuffer();
        if (headEntityFieldMappingCollection != null && !headEntityFieldMappingCollection.isEmpty()) {
            String quoteField;
            Set<String> billHeadKeySet = billHeadKeyDynamicObjectMap.keySet();
            for (DynamicObject fieldMappingDynamicObject : headEntityFieldMappingCollection) {
                quoteField = fieldMappingDynamicObject.getString("quotefield");
                String quoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, quoteField);
                billHeadKey = StringUtils.isEmpty((CharSequence)billHeadKey) ? billHeadKey.append(quoteFieldValue) : billHeadKey.append("->").append(quoteFieldValue);
            }
            for (DynamicObject fieldMappingDynamicObject : headEntityFieldMappingCollection) {
                quoteField = fieldMappingDynamicObject.getString("quotefield");
                String bizobjField = fieldMappingDynamicObject.getString("bizobjfield");
                String quoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, quoteField);
                int fieldType = fieldNameFieldTypeMap.get(bizobjField);
                this.setBizObjFieldValue(bizobjDynamicObject, bizobjField, quoteFieldValue, fieldType);
            }
            if (!billHeadKeySet.contains(billHeadKey.toString())) {
                billHeadKeyDynamicObjectMap.put(billHeadKey.toString(), bizobjDynamicObject);
            }
        }
        if ((entryTypeList = idEntryTypeListMap.get(bizobj)) != null && !entryTypeList.isEmpty()) {
            for (EntityType entityType : entryTypeList) {
                List<EntityType> subEntryTypeList;
                Object entryFieldMappingDynamicObject2;
                String entryEntityId = entityType.getName();
                DynamicObjectCollection tempFieldMappingCollection = entityIdFieldMappingCollectionMap.get(entryEntityId);
                DynamicObjectCollection entryentityCollection = bizobjDynamicObject.getDynamicObjectCollection(entryEntityId);
                StringBuffer entryEntityKey = new StringBuffer(String.format("%s%s%s", entryEntityId, "->", billHeadKey));
                if (tempFieldMappingCollection == null || tempFieldMappingCollection.isEmpty()) continue;
                Set<String> entryEntityKeySet = entryEntityKeyDynamicObjectCollectionMap.keySet();
                for (Object entryFieldMappingDynamicObject2 : tempFieldMappingCollection) {
                    String entryQuoteField = entryFieldMappingDynamicObject2.getString("quotefield");
                    String entryQuoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, entryQuoteField);
                    entryEntityKey = entryEntityKey.append(entryEntityKey).append("->").append(entryQuoteFieldValue);
                }
                DynamicObject entryDynamicObject = new DynamicObject(entryentityCollection.getDynamicObjectType());
                entryFieldMappingDynamicObject2 = tempFieldMappingCollection.iterator();
                while (entryFieldMappingDynamicObject2.hasNext()) {
                    DynamicObject entryFieldMappingDynamicObject3 = (DynamicObject)entryFieldMappingDynamicObject2.next();
                    String entryQuoteField = entryFieldMappingDynamicObject3.getString("quotefield");
                    String entryBizobjField = entryFieldMappingDynamicObject3.getString("bizobjfield");
                    String entryQuoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, entryQuoteField);
                    String entryField = entryBizobjField.split("\\.")[1];
                    int fieldType = fieldNameFieldTypeMap.get(entryBizobjField);
                    this.setBizObjFieldValue(entryDynamicObject, entryField, entryQuoteFieldValue, fieldType);
                }
                if (!entryEntityKeySet.contains(entryEntityKey.toString())) {
                    boolean hasSeqColumn;
                    DynamicProperty seqProperty = entityType.getProperty("seq");
                    boolean bl = hasSeqColumn = seqProperty != null;
                    if (hasSeqColumn) {
                        entryDynamicObject.set("seq", (Object)(entryentityCollection.size() + 1));
                    }
                    entryentityCollection.add((Object)entryDynamicObject);
                    entryEntityKeyDynamicObjectCollectionMap.put(entryEntityKey.toString(), entryentityCollection);
                }
                if ((subEntryTypeList = idSubEntryTypeListMap.get(entryEntityId)) == null || subEntryTypeList.isEmpty()) continue;
                for (EntityType subEntityType : subEntryTypeList) {
                    boolean hasSubSeqColumn;
                    String subEentryEntityId = subEntityType.getName();
                    DynamicObjectCollection subTempFieldMappingCollection = entityIdFieldMappingCollectionMap.get(subEentryEntityId);
                    Set<String> entryEntityKeySubSet = entryEntityKeySubDynamicObjectCollectionMap.keySet();
                    DynamicObjectCollection subEntryentityCollection = null;
                    String subEntryEntityKey = String.format("%s%s%s", subEentryEntityId, "->", entryEntityKey);
                    subEntryentityCollection = entryEntityKeySubSet.contains(subEntryEntityKey) ? entryEntityKeySubDynamicObjectCollectionMap.get(subEntryEntityKey) : entryDynamicObject.getDynamicObjectCollection(subEentryEntityId);
                    if (subTempFieldMappingCollection == null || subTempFieldMappingCollection.isEmpty()) continue;
                    DynamicObject subEntryDynamicObject = new DynamicObject(subEntryentityCollection.getDynamicObjectType());
                    for (DynamicObject entryFieldMappingDynamicObject4 : subTempFieldMappingCollection) {
                        String entryQuoteField = entryFieldMappingDynamicObject4.getString("quotefield");
                        String entryBizobjField = entryFieldMappingDynamicObject4.getString("bizobjfield");
                        String entryQuoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, entryQuoteField);
                        String entryField = entryBizobjField.split("\\.")[1];
                        int fieldType = fieldNameFieldTypeMap.get(entryBizobjField);
                        this.setBizObjFieldValue(subEntryDynamicObject, entryField, entryQuoteFieldValue, fieldType);
                    }
                    DynamicProperty subSeqProperty = subEntityType.getProperty("seq");
                    boolean bl = hasSubSeqColumn = subSeqProperty != null;
                    if (hasSubSeqColumn) {
                        subEntryDynamicObject.set("seq", (Object)(subEntryentityCollection.size() + 1));
                    }
                    subEntryentityCollection.add((Object)subEntryDynamicObject);
                    entryEntityKeySubDynamicObjectCollectionMap.put(subEntryEntityKey, subEntryentityCollection);
                }
            }
        }
    }

    private String getQuoteFieldValue(RowDataTypeEnum rowDataTypeEnum, Object rowData, String quoteField) {
        String quoteFieldValue;
        if (StringUtils.equalsIgnoreCase((CharSequence)rowDataTypeEnum.getKey(), (CharSequence)RowDataTypeEnum.ROW.getKey())) {
            Row row = (Row)rowData;
            quoteFieldValue = row.getString(quoteField);
        } else {
            JSONObject row = (JSONObject)rowData;
            quoteFieldValue = row.getString(quoteField);
        }
        return quoteFieldValue;
    }

    private String getBillHeadKeyValue(String[] headQuoteFieldArray, RowDataTypeEnum rowDataTypeEnum, Object rowData) {
        StringBuilder billHeadKeyValueSb = new StringBuilder();
        for (String headQuoteFieldName : headQuoteFieldArray) {
            Row row;
            String value = "";
            if (StringUtils.equalsIgnoreCase((CharSequence)rowDataTypeEnum.getKey(), (CharSequence)RowDataTypeEnum.ROW.getKey())) {
                row = (Row)rowData;
                value = row.getString(headQuoteFieldName);
            } else {
                row = (JSONObject)rowData;
                value = row.getString(headQuoteFieldName);
            }
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            billHeadKeyValueSb.append(value);
        }
        return billHeadKeyValueSb.toString();
    }

    private DataSet extractDataToDataSet(final RowMeta rowMeta, DataSet modeltypeResultTypeDataSet, final String[] headQuoteFieldArray, final List<String> fields, final Map<String, Integer> fieldNameFieldTypeMap, final Map<String, String> quotefieldBizobjfieldMap, final List<PlainField> plainFieldList) {
        log.info("start extractDataToDataSet...");
        long st = KDDateUtils.now().getTime();
        DataSet dataDataSet = modeltypeResultTypeDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] objects = null;
                JSONObject dataJo = GpeTaskExecuteServiceImpl.this.getDataAsJsonObject(plainFieldList, row);
                if (dataJo != null) {
                    objects = new Object[fields.size() + 2];
                    String billHeadKeyValue = GpeTaskExecuteServiceImpl.this.getBillHeadKeyValue(headQuoteFieldArray, RowDataTypeEnum.JSONOBJECT, dataJo);
                    objects[0] = billHeadKeyValue;
                    objects[1] = dataJo.toJSONString();
                    for (int i = 0; i < fields.size(); ++i) {
                        Object value;
                        String field = (String)fields.get(i);
                        String bizobjField = quotefieldBizobjfieldMap.getOrDefault(field, field);
                        Integer type = (Integer)fieldNameFieldTypeMap.get(bizobjField);
                        if (type == null) {
                            type = 12;
                        }
                        int fieldType = type;
                        Object fieldValue = dataJo.get((Object)field);
                        String fieldValueStr = fieldValue == null ? "" : fieldValue.toString();
                        objects[i + 2] = value = GpeTaskExecuteServiceImpl.this.getBizObjFieldValue(fieldValueStr, fieldType);
                    }
                }
                return objects;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        long et = KDDateUtils.now().getTime();
        long cost = et - st;
        log.info("end extractDataToDataSet cost : {}ms", (Object)cost);
        return dataDataSet;
    }

    private RowMeta assemblyRowMeta(List<PlainField> plainFieldList) {
        Field[] fieldArr = new Field[plainFieldList.size() + 2];
        fieldArr[0] = new Field(KEY_BILL_HEAD_KEY, (DataType)DataType.StringType);
        fieldArr[1] = new Field(KEY_BILL_DATA, (DataType)DataType.StringType);
        for (int i = 0; i < plainFieldList.size(); ++i) {
            PlainField plainField = plainFieldList.get(i);
            DataType dataType = AlgoUtils.getAlgoDataType(plainField.getFieldType());
            fieldArr[i + 2] = new Field(plainField.getFieldKey(), dataType);
        }
        RowMeta rowMeta = new RowMeta(fieldArr);
        return rowMeta;
    }

    private JSONObject getDataAsJsonObject(List<PlainField> plainFieldList, Row row) {
        JSONObject dataJo = new JSONObject();
        for (PlainField plainField : plainFieldList) {
            String fieldValueStr;
            String fieldKey = plainField.getFieldKey();
            Object fieldValue = row.get(fieldKey);
            String string = fieldValueStr = fieldValue != null ? fieldValue.toString() : "";
            if (StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATE.getId())) {
                fieldValueStr = KDDateFormatUtils.getDateFormat().format(fieldValue);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATETIME.getId())) {
                fieldValueStr = KDDateFormatUtils.getDateTimeFormat().format(fieldValue);
            }
            dataJo.put(fieldKey, (Object)fieldValueStr);
        }
        return dataJo;
    }

    private void asyncGpeSendMsg(Long bizTransSchemePkId, String number, String name, String bizobj, DynamicObject schemeDynamicObject) {
        String eventnumber = schemeDynamicObject.getString("eventnumber");
        String customparams = schemeDynamicObject.getString("customparams");
        boolean receiveNotice = schemeDynamicObject.getBoolean("receivenotice");
        BizTransSchemeMsg msg = new BizTransSchemeMsg();
        msg.setId(bizTransSchemePkId);
        msg.setNumber(number);
        msg.setName(name);
        msg.setBizobj(bizobj);
        msg.setExecstatus(ExecStatusEnum.SUCCESS.getKey());
        msg.setCustomparams(customparams);
        msg.setMsgctime(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("params", (Object)JSON.toJSONString((Object)msg));
        String msgBody = paramsJo.toJSONString();
        if (receiveNotice && StringUtils.isNotEmpty((CharSequence)eventnumber)) {
            ThreadUtils.execute(() -> {
                log.info("send biz event msg with body: {}", (Object)msgBody);
                EventServiceHelper.triggerEventSubscribe((String)eventnumber, (String)msgBody);
            });
        }
    }

    private Map<String, Integer> getFieldNameFieldTypeMap(Map<String, Integer> fieldNameFieldTypeMap, String bizobj) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizobj);
        fieldNameFieldTypeMap.clear();
        if (mainEntityType != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getAlias())) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entry : allEntities.entrySet()) {
                Map fieldMap;
                EntityType entityType = (EntityType)entry.getValue();
                String entityName = entityType.getName();
                ISimpleProperty primaryKey = entityType.getPrimaryKey();
                if (primaryKey != null) {
                    String pkFieldName = primaryKey.getName();
                    if (!(entityType instanceof BillEntityType)) {
                        pkFieldName = String.format("%s.%s", entityName, pkFieldName);
                    }
                    fieldNameFieldTypeMap.put(pkFieldName, primaryKey.getDbType());
                }
                if ((fieldMap = entityType.getFields()) == null || fieldMap.isEmpty()) continue;
                Iterator iterator = fieldMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String fieldName = (String)iterator.next().getKey();
                    IDataEntityProperty dp = (IDataEntityProperty)fieldMap.get(fieldName);
                    if (StringUtils.isEmpty((CharSequence)dp.getAlias())) continue;
                    if (!(entityType instanceof BillEntityType)) {
                        fieldName = String.format("%s.%s", entityName, fieldName);
                    }
                    if (dp instanceof FieldProp) {
                        FieldProp fieldProp = (FieldProp)dp;
                        fieldNameFieldTypeMap.put(fieldName, fieldProp.getDbType());
                        continue;
                    }
                    if (!(dp instanceof BasedataProp)) continue;
                    BasedataProp basedataProp = (BasedataProp)dp;
                    fieldNameFieldTypeMap.put(fieldName, basedataProp.getDbType());
                }
            }
        }
        return fieldNameFieldTypeMap;
    }
}

