/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.bos.context.RequestContext;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class IdsParameterServiceImpl
implements IIdsParameterService {
    private static final Log log = LogFactory.getLog(IdsParameterServiceImpl.class);

    @Override
    public IdsParameter getIdsParameter(Long orgId) {
        String appId = "1ZY6U=RCHA6Y";
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        apm.setOrgId(orgId);
        Map paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm);
        String idsServerUrl = paramsMap.getOrDefault("idsserverurl", "");
        String authorityAppId = paramsMap.getOrDefault("authorityappid", "");
        String authorityAppSecret = paramsMap.getOrDefault("authorityappsecret", "");
        int readTimeout = paramsMap.getOrDefault("readtimeout", 15000);
        Boolean mqConfig = paramsMap.getOrDefault("mqconfig", false);
        String gpeServerUrl = paramsMap.getOrDefault("gpeserverurl", "");
        int maxRowCount = paramsMap.getOrDefault("maxrowcount", 1000000);
        String thirdAppId = paramsMap.getOrDefault("thirdappid", "");
        String thirdAppSecret = paramsMap.getOrDefault("thirdappsecret", "");
        String publicKey = paramsMap.getOrDefault("publickey", "");
        String cosmicProxyIp = paramsMap.getOrDefault("cosmicproxyip", "");
        String thirdProxyUsername = paramsMap.getOrDefault("thirdproxyusername", "");
        if (StringUtils.isEmpty((CharSequence)gpeServerUrl)) {
            RequestContext rc = RequestContext.get();
            String tenantId = rc.getTenantId();
            gpeServerUrl = System.getProperty(String.format("%s_%s", tenantId, "ai.ids.gpe.server.url"));
            if (StringUtils.isEmpty((CharSequence)gpeServerUrl)) {
                gpeServerUrl = System.getProperty("ai.ids.gpe.server.url");
            }
        }
        IdsParameter idsParameter = new IdsParameter(idsServerUrl, authorityAppId, authorityAppSecret, readTimeout, mqConfig, gpeServerUrl, maxRowCount, thirdAppId, thirdAppSecret, publicKey, cosmicProxyIp, thirdProxyUsername);
        log.info("getIdsParameter : {}", (Object)JSONObject.toJSONString((Object)idsParameter));
        return idsParameter;
    }
}

