/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.ai.ids.core.cache.AppCache;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IAuthService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.HttpUtils;
import kd.bos.api.client.HttpMethod;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class IdsServerServiceImpl
implements IIdsServerService {
    private static final Log log = LogFactory.getLog(IIdsServerService.class);

    @Override
    public BaseResult getBaseResultByPost(Long orgId, String apiPath, JSONObject paramJo) {
        orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
        return this.getBaseResult(orgId, apiPath, paramJo, HttpMethod.POST, -1);
    }

    @Override
    public BaseResult getBaseResultByPost(Long orgId, String apiPath, JSONObject paramJo, int timeout) {
        orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
        return this.getBaseResult(orgId, apiPath, paramJo, HttpMethod.POST, timeout);
    }

    @Override
    public BaseResult getBaseResultByPost(String apiPath, JSONObject paramJo) {
        long orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
        return this.getBaseResult(orgId, apiPath, paramJo, HttpMethod.POST, -1);
    }

    private BaseResult getBaseResult(Long orgId, String apiPath, JSONObject paramJo, HttpMethod httpMethod, int timeout) {
        String result;
        String token;
        long startTs = System.currentTimeMillis();
        String paramStr = JSONObject.toJSONString((Object)paramJo);
        log.info("#####[{}] orgId:{}, apiPath:{}, paramJo:{}", new Object[]{httpMethod.name(), orgId, apiPath, paramStr});
        IdsParameter idsParameter = Services.get(IIdsParameterService.class).getIdsParameter(orgId);
        if (timeout <= 0) {
            timeout = idsParameter.getReadTimeout();
        }
        if (StringUtils.isNotEmpty((CharSequence)(token = Services.get(IAuthService.class).getAccessToken(idsParameter)))) {
            String url = idsParameter.getIdsServerUrl() + apiPath;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("auth-type", "token");
            headerMap.put("token", token);
            String paramsStr = paramJo != null ? paramJo.toJSONString() : null;
            try {
                result = StringUtils.equalsIgnoreCase((CharSequence)httpMethod.name(), (CharSequence)HttpMethod.GET.name()) ? HttpUtils.doGet(url, headerMap, (Map<String, Object>)JSON.parseObject((String)paramsStr), AppConstants.DEFAULT_CONNECTION_TIMEOUT, timeout) : HttpUtils.doPostJson(url, paramsStr, headerMap, AppConstants.DEFAULT_CONNECTION_TIMEOUT, timeout);
                String printResult = result;
                if (url.contains("/ids/clientproxy/data/analysis/report/detail")) {
                    printResult = StringUtils.isNotEmpty((CharSequence)printResult) && printResult.length() > 2000 ? printResult.substring(0, 2000) : printResult;
                }
                long cost = System.currentTimeMillis() - startTs;
                log.info("#####[{}-cost:{}ms] apiFullUrl:{} paramJo:{} result:{} ", new Object[]{httpMethod.name(), cost, url, paramStr, printResult});
            }
            catch (Exception e) {
                CommonUtil.getStackTrace(e);
                return new BaseResult(BaseResult.SERVICE_UNAVAILABLE);
            }
        } else {
            return new BaseResult(BaseResult.SERVICE_UNAVAILABLE);
        }
        JSONObject resultJo = JSONObject.parseObject((String)result);
        BaseResult baseResult = new BaseResult();
        if (resultJo != null) {
            baseResult.setData(resultJo.get((Object)"data"));
            baseResult.setDescription(resultJo.getString("description"));
            baseResult.setDescriptionCn(resultJo.getString("descriptionCn"));
            baseResult.setErrcode(resultJo.getInteger("errcode"));
            if (Objects.equals(baseResult.getErrcode(), BaseResult.INVALID_ACCESS_TOKEN)) {
                AppCache.get().remove("AccessToken");
            }
        } else {
            baseResult.setErrcode(BaseResult.FAIL);
        }
        return baseResult;
    }
}

