/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.ids.core.enumtype.BizTypeEnum;
import kd.ai.ids.core.enumtype.CosmicEditionEnum;
import kd.ai.ids.core.query.label.LabelQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.label.LabelDTO;
import kd.ai.ids.core.response.label.LabelTypeDTO;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.ILabelService;
import kd.ai.ids.core.service.Services;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;

public class LabelServiceImpl
implements ILabelService {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public List<LabelTypeDTO> getTenantTagList(Long orgId, String tenantId) {
        List<LabelTypeDTO> labelTypeDTOList = new ArrayList<LabelTypeDTO>();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("bizId", (Object)tenantId);
        paramsJo.put("bizType", (Object)BizTypeEnum.TENANT.getKey());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/label/relation/list/biz/tag", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONArray dataArray = baseResult.getDataAsJSONArray();
            labelTypeDTOList = dataArray.toJavaList(LabelTypeDTO.class);
        }
        return labelTypeDTOList;
    }

    @Override
    public JSONArray getLabelTypeKeysJa(Long orgId, String tenantId) {
        List<LabelTypeDTO> labelTypeDTOList = this.getTenantTagList(orgId, tenantId);
        HashMap map = new HashMap();
        if (labelTypeDTOList != null && !labelTypeDTOList.isEmpty()) {
            for (LabelTypeDTO labelTypeDTO : labelTypeDTOList) {
                List<LabelDTO> labelDTOList = labelTypeDTO.getLabelDTOList();
                List<Object> tagList = new ArrayList();
                if (labelDTOList != null && !labelDTOList.isEmpty()) {
                    tagList = labelDTOList.stream().map(LabelDTO::getLabelKey).collect(Collectors.toList());
                }
                map.put(labelTypeDTO.getLabelType(), tagList);
            }
        }
        JSONArray labelTypeKeysArray = new JSONArray();
        for (Map.Entry entry : map.entrySet()) {
            String labelType = (String)entry.getKey();
            List labelDTOList = (List)entry.getValue();
            if (labelDTOList == null || labelDTOList.isEmpty()) continue;
            JSONObject itemObj = new JSONObject();
            itemObj.put(labelType, map.get(labelType));
            labelTypeKeysArray.add((Object)itemObj);
        }
        return labelTypeKeysArray;
    }

    @Override
    public BaseResult save(Long orgId, LabelQuery labelQuery) {
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/label/save", JSONObject.parseObject((String)JSONObject.toJSONString((Object)labelQuery)));
    }

    @Override
    public String getPlatformCode() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        String platformCode = modelType == 1 ? CosmicEditionEnum.COSMIC.getId() : (modelType == 4 ? CosmicEditionEnum.K3CLOUDULTIMATE.getId() : CosmicEditionEnum.CONSTELLATION.getId());
        this.log.info("modelType:{}, platformCode:{}", (Object)modelType, (Object)platformCode);
        return platformCode;
    }
}

