/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.gpe.ErrorCodeEnum;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IOpenAPIService;
import kd.ai.ids.core.utils.PermUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.openapi.thirdapp.ThirdAppDto;
import kd.bos.openapi.thirdapp.ThirdAppService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.UserParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OpenAPIServiceImpl
implements IOpenAPIService {
    private static final Log log = LogFactory.getLog(OpenAPIServiceImpl.class);

    @Override
    public long createProxyUser(String userName, String name) {
        HashMap<String, Object> userdata = new HashMap<String, Object>();
        userdata.put("name", userName);
        userdata.put("number", ID.genStringId());
        userdata.put("usertype", 1);
        userdata.put("phone", "");
        userdata.put("fuid", 0);
        ArrayList entryentity = new ArrayList();
        LinkedHashMap<String, Object> entryentitydata = new LinkedHashMap<String, Object>();
        entryentitydata.put("dpt", OrgUnitServiceHelper.getRootOrgId());
        entryentitydata.put("position", "\u4ee3\u7406\u7528\u6237");
        entryentity.add(entryentitydata);
        userdata.put("entryentity", entryentity);
        ArrayList<UserParam> userList = new ArrayList<UserParam>();
        UserParam uParam = new UserParam();
        uParam.setDataMap(userdata);
        userList.add(uParam);
        UserServiceHelper.addOrUpdate(userList);
        UserServiceHelper.enable(userList);
        DynamicObject gpeUser = BusinessDataServiceHelper.loadSingle((String)"bos_user", (QFilter[])new QFilter("username", "=", (Object)userName).toArray());
        long userId = (Long)gpeUser.getPkValue();
        return userId;
    }

    @Override
    public Boolean createThirdApp(String appId, String appSecret, String name, long proxyUserId, boolean createNew) {
        RequestContext rc = RequestContext.get();
        ThirdAppDto thirdAppDto = new ThirdAppDto();
        thirdAppDto.setAccountId(rc.getAccountId());
        thirdAppDto.setSense(createNew ? 1 : 2);
        thirdAppDto.setAgentUserId(Long.valueOf(proxyUserId));
        thirdAppDto.setCreateAgentUser(true);
        thirdAppDto.setEnableAgency(true);
        thirdAppDto.setAgentUserIdList(Collections.singletonList(proxyUserId));
        thirdAppDto.setNumber(appId);
        thirdAppDto.setName(name);
        thirdAppDto.setStatus(BillStatusEnum.AUDITED.getId());
        thirdAppDto.setEnable(true);
        thirdAppDto.setAllowallapi(true);
        thirdAppDto.setAccessToken(appSecret);
        thirdAppDto.setAllowip(true);
        Object result = DispatchApiServiceHelper.invokeApiService((String)ThirdAppService.class.getSimpleName(), (String)"saveThirdApp", (Object[])new Object[]{thirdAppDto});
        if (result instanceof Boolean && ((Boolean)result).booleanValue() || !(result instanceof Boolean)) {
            return true;
        }
        return false;
    }

    @Override
    public void saveAppSecret(String appSecret) {
        String idsAppId = "1ZY6U=RCHA6Y";
        long orgId = OrgUnitServiceHelper.getRootOrgId();
        AppParam appParam = new AppParam();
        appParam.setAppId(idsAppId);
        appParam.setOrgId(Long.valueOf(orgId));
        appParam.setViewType(OrgViewTypeEnum.IS_ORGUNIT.getViewType());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("thirdappsecret", appSecret);
        SystemParamServiceHelper.saveAppParameter((AppParam)appParam, params);
    }

    @Override
    public Long findThirdApp(String appId) {
        DynamicObject[] thirdApps = BusinessDataServiceHelper.load((String)"third_app", (String)"id,number,name,status,enable,isbasicauth,syspwd,is_digest,publickey,jwtasymmetic,jwt_type,securitypublickey,is_signature,sign_type,signature_key,allowallapi,allowip,apiencryption,encryptallapi,creator,createtime,modifier,modifytime,lastenabletime,laststoptime,entryentity_basicauth.basesigncode,entryentity_basicauth.agentuserid,srctype,isagencyuser,authpluginenable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appId)});
        if (thirdApps != null && thirdApps.length != 0) {
            return (Long)thirdApps[0].getPkValue();
        }
        return 0L;
    }

    @Override
    public Boolean initOpenAPIThirdApp(IdsParameter idsParameter) {
        boolean flag = false;
        String appId = idsParameter.getThirdAppId();
        long existedThirdAppId = this.findThirdApp(appId);
        boolean hasPermission = PermUtils.hasPermission(RequestContext.get().getCurrUserId(), "open", "third_app", "QXX0009");
        if (existedThirdAppId <= 0L && !hasPermission) {
            log.info("error:{}", (Object)ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getName());
            throw new KDBizException(new ErrorCode(ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getId(), ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getName()), new Object[0]);
        }
        String proxyUserName = idsParameter.getThirdProxyUsername();
        if (StringUtils.isNotEmpty((CharSequence)proxyUserName)) {
            long proxyUserId = 0L;
            DynamicObject proxyUserDo = BusinessDataServiceHelper.loadSingle((String)"bos_user", (QFilter[])new QFilter("username", "=", (Object)proxyUserName).toArray());
            boolean proxyUserIsNew = false;
            if (proxyUserDo == null) {
                log.info("\u4ee3\u7406\u7528\u6237{}\u4e0d\u5b58\u5728", (Object)proxyUserName);
                if (!StringUtils.equalsIgnoreCase((CharSequence)proxyUserName, (CharSequence)"administrator")) {
                    log.info("\u5f00\u59cb\u521b\u5efa\u4ee3\u7406\u7528\u6237{}", (Object)proxyUserName);
                    proxyUserId = this.createProxyUser(proxyUserName, "GPT\u9884\u6d4b\u5f15\u64ce");
                    proxyUserIsNew = true;
                    log.info("\u521b\u5efa\u4ee3\u7406\u7528\u6237{}\u6210\u529f\uff0cproxyUserId:{}", (Object)proxyUserName, (Object)proxyUserId);
                } else {
                    log.info("\u4ee3\u7406\u7528\u6237\u540d\u4e3a\u7ba1\u7406\u5458({}),\u4e0d\u6267\u884c\u521b\u5efa", (Object)"administrator");
                }
            } else {
                proxyUserId = (Long)proxyUserDo.getPkValue();
                log.info("\u4ee3\u7406\u7528\u6237{}\u5df2\u5b58\u5728\uff0cproxyUserId\uff1a{}", (Object)proxyUserName, (Object)proxyUserId);
            }
            if (proxyUserId > 0L) {
                if (existedThirdAppId <= 0L) {
                    log.info("\u7b2c\u4e09\u65b9\u5e94\u7528{}\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u521b\u5efa", (Object)appId);
                    String[] strIdArr = ID.genStringIds((int)2);
                    String appSecret = String.format("Gpe$0%s%s", strIdArr[0], strIdArr[1]);
                    boolean createFlag = this.createThirdApp(appId, appSecret, "GPT\u9884\u6d4b\u5f15\u64ce", proxyUserId, true);
                    if (createFlag) {
                        log.info("\u521b\u5efa\u7b2c\u4e09\u65b9\u5e94\u7528{}\u6210\u529f", (Object)appId);
                        this.saveAppSecret(appSecret);
                        flag = true;
                    } else {
                        log.error("\u521b\u5efa\u7b2c\u4e09\u65b9\u5e94\u7528{}\u5931\u8d25", (Object)appId);
                    }
                } else if (proxyUserIsNew) {
                    boolean updateFlag = this.createThirdApp(appId, null, null, proxyUserId, false);
                    if (updateFlag) {
                        log.info("\u66f4\u65b0\u7b2c\u4e09\u65b9\u5e94\u7528{}\u6210\u529f", (Object)appId);
                        flag = true;
                    } else {
                        log.error("\u66f4\u65b0\u7b2c\u4e09\u65b9\u5e94\u7528{}\u5931\u8d25", (Object)appId);
                    }
                }
            }
        }
        return flag;
    }
}

