/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.IRealtimePredictService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.StrUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;

public class RealtimePredictServiceImpl
implements IRealtimePredictService {
    private static final Log logger = LogFactory.getLog(RealtimePredictServiceImpl.class);

    @Override
    public Map<String, String> getLevelStandardIdMap() {
        JSONObject object = this.appConfigParameter();
        HashMap<String, String> result = new HashMap<String, String>();
        if (object != null) {
            result.put("fbrandlevel_standardfid", object.getJSONObject("fbrandlevel_standardfid").getString("value"));
            result.put("fbaselevel_standardfid", object.getJSONObject("fbaselevel_standardfid").getString("value"));
        } else {
            result.put("fbrandlevel_standardfid", "");
            result.put("fbaselevel_standardfid", "");
        }
        return result;
    }

    @Override
    public JSONObject getPricePosition(String orgNumber, String warehouseNumber, Long materialMasterId, String firstdistributiondate, BigDecimal price) {
        Map<String, String> baseGroups = this.getMaterialBaseGroups(materialMasterId);
        String subServiceId = this.getSubserviceId();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("forgid", (Object)orgNumber);
        paramsJo.put("fwarehouseid", (Object)warehouseNumber);
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fbase1level", (Object)baseGroups.get("fbase1level"));
        paramsJo.put("fbase2level", (Object)baseGroups.get("fbase2level"));
        paramsJo.put("fbase3level", (Object)baseGroups.get("fbase3level"));
        paramsJo.put("ffirstdistributiondate", (Object)firstdistributiondate);
        paramsJo.put("fprice", (Object)price);
        logger.info("get price position request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/data/new/product/price/position", paramsJo);
        logger.info("get price position response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            JSONObject data = baseResult.getDataAsJSONObject();
            return data;
        }
        return new JSONObject();
    }

    @Override
    public Map<String, String> getMaterialBrandGroups(Long materialMasterId) {
        Map<String, String> levelStandardMap = this.getLevelStandardIdMap();
        String fbrandlevelStandardfid = levelStandardMap.get("fbrandlevel_standardfid");
        DynamicObject brandMaterialGroupDetail = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroupdetail", (String)"group", (QFilter[])new QFilter[]{new QFilter("standard", "=", (Object)Long.parseLong(fbrandlevelStandardfid)), new QFilter("material", "=", (Object)materialMasterId)});
        if (brandMaterialGroupDetail != null) {
            DynamicObject group = brandMaterialGroupDetail.getDynamicObject("group");
            Long brandGroupId = group.getLong("id");
            DynamicObject lastGroup = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroup", (String)"id,name,number,longnumber,parent,level,isleaf,enable,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)brandGroupId), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")});
            HashMap<String, String> result = new HashMap<String, String>();
            this.handleMutilGroups(result, lastGroup, "brand");
            return result;
        }
        return new HashMap<String, String>();
    }

    private Long queryMaterialMasterId(Long materialId) {
        DynamicObject materialinvinfo = BusinessDataServiceHelper.loadSingle((Object)materialId, (String)"bd_materialinvinfo");
        Long masterId = materialinvinfo.getLong("masterid");
        return masterId;
    }

    @Override
    public Map<String, String> getMaterialBaseGroups(Long materialMasterId) {
        Map<String, String> levelStandardMap = this.getLevelStandardIdMap();
        String fbaselevelStandardfid = levelStandardMap.get("fbaselevel_standardfid");
        DynamicObject baseMaterialGroupDetail = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroupdetail", (String)"group", (QFilter[])new QFilter[]{new QFilter("standard", "=", (Object)Long.parseLong(fbaselevelStandardfid)), new QFilter("material", "=", (Object)materialMasterId)});
        if (baseMaterialGroupDetail != null) {
            DynamicObject group = baseMaterialGroupDetail.getDynamicObject("group");
            Long baseGroupId = group.getLong("id");
            DynamicObject lastGroup = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroup", (String)"id,name,number,longnumber,parent,level,isleaf,enable,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)baseGroupId), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")});
            HashMap<String, String> result = new HashMap<String, String>();
            this.handleMutilGroups(result, lastGroup, "base");
            return result;
        }
        return new HashMap<String, String>();
    }

    private void handleMutilGroups(Map<String, String> groups, DynamicObject lastGroup, String groupType) {
        DynamicObject parent = lastGroup.getDynamicObject("parent");
        if (parent != null) {
            this.setLevelGroup(groups, lastGroup, groupType);
            long parentId = parent.getLong("id");
            DynamicObject parentGroup = this.queryMaterialGroup(parentId);
            this.handleMutilGroups(groups, parentGroup, groupType);
        } else {
            this.setLevelGroup(groups, lastGroup, groupType);
        }
    }

    private void setLevelGroup(Map<String, String> groups, DynamicObject lastGroup, String groupType) {
        int level = lastGroup.getInt("level");
        String number = lastGroup.getString("number");
        String name = lastGroup.getString("name");
        if (StringUtils.equalsIgnoreCase((CharSequence)groupType, (CharSequence)"base")) {
            groups.put(String.format("fbase%slevel", level), number);
            groups.put(String.format("fbase%slevel_name", level), name);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)groupType, (CharSequence)"brand")) {
            groups.put(String.format("fbrand%slevel", level), number);
            groups.put(String.format("fbrand%slevel_name", level), name);
        }
    }

    private DynamicObject queryMaterialGroup(Long groupId) {
        DynamicObject lastGroup = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroup", (String)"id,name,number,longnumber,parent,level,isleaf,enable,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupId), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")});
        return lastGroup;
    }

    @Override
    public Map<String, String> getMaterialBaseGroupsName(Long materialMasterId) {
        Map<String, String> levelStandardMap = this.getLevelStandardIdMap();
        String fbaselevelStandardfid = levelStandardMap.get("fbaselevel_standardfid");
        DynamicObject baseMaterialGroupDetail = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroupdetail", (String)"group", (QFilter[])new QFilter[]{new QFilter("standard", "=", (Object)Long.parseLong(fbaselevelStandardfid)), new QFilter("material", "=", (Object)materialMasterId)});
        if (baseMaterialGroupDetail != null) {
            DynamicObject group = baseMaterialGroupDetail.getDynamicObject("group");
            Long baseGroupId = group.getLong("id");
            DynamicObject lastGroup = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroup", (String)"id,name,number,longnumber,parent,level,isleaf,enable,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)baseGroupId), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")});
            HashMap<String, String> result = new HashMap<String, String>();
            this.handleMutilGroups(result, lastGroup, "base");
            return result;
        }
        return new HashMap<String, String>();
    }

    @Override
    public String getSeasonProductFlag(String orgNumber, String warehouseNumber, Long materialMasterId, String ffirstdistributiondate) {
        JSONArray array = this.getDynamicFeature(orgNumber, warehouseNumber, materialMasterId, ffirstdistributiondate);
        String flag = "";
        if (array != null && !array.isEmpty()) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject item = array.getJSONObject(i);
                String id = item.getString("id");
                int enable = item.getIntValue("enable");
                logger.info("dynamic feature key :{},value :{}", (Object)id, (Object)enable);
                if (!id.equals("fseasonalproducts") || enable != 1) continue;
                logger.info("season product flag enable :{}", (Object)enable);
                flag = this.getSeasonProductFlag(materialMasterId);
            }
        }
        if (StringUtils.isEmpty((CharSequence)flag)) {
            flag = "0";
        }
        return flag;
    }

    private String getSeasonProductFlag(Long materialMasterId) {
        String flag = "0";
        try {
            DynamicObject material = BusinessDataServiceHelper.loadSingle((Object)materialMasterId, (String)"bd_material");
            if (material != null) {
                flag = material.getString("axnz_seasonalproducts");
            }
        }
        catch (Exception e) {
            logger.error("can't find field axnz_seasonalproducts");
        }
        return flag;
    }

    @Override
    public Date getFirstDistributiondate(Long org, final Long materialId, final Long warehouseId) {
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)"biztime,billentry.id,billentry.baseqty,billentry.material,billentry.warehouse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org), new QFilter("billstatus", "=", (Object)"C"), new QFilter("supplytrans", "=", (Object)"0")}, (String)"biztime asc");
        if (collection != null && collection.length != 0) {
            final ArrayList<Date> dates = new ArrayList<Date>();
            Arrays.stream(collection).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(final DynamicObject object) {
                    DynamicObjectCollection subCollection = object.getDynamicObjectCollection("billentry");
                    subCollection.stream().forEach(new Consumer<DynamicObject>(){

                        @Override
                        public void accept(DynamicObject subObject) {
                            DynamicObject material = subObject.getDynamicObject("material");
                            DynamicObject warehouse = subObject.getDynamicObject("warehouse");
                            if (material != null && warehouse != null) {
                                long mId = material.getLong("id");
                                long whId = warehouse.getLong("id");
                                if (mId == materialId && whId == warehouseId) {
                                    Date biztime = object.getDate("biztime");
                                    dates.add(biztime);
                                }
                            }
                        }
                    });
                }
            });
            logger.info("format dates : {}", (Object)JSONObject.toJSONString(dates));
            dates.sort(new Comparator<Date>(){

                @Override
                public int compare(Date o1, Date o2) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    return Integer.parseInt(sdf.format(o1)) - Integer.parseInt(sdf.format(o2));
                }
            });
            if (!dates.isEmpty()) {
                return (Date)dates.get(0);
            }
        }
        return null;
    }

    @Override
    public BigDecimal getFirstweekdistributionqty(Date firstDistributiondate, Long orgId, final Long materialId, final Long warehouseId) {
        if (firstDistributiondate == null) {
            return null;
        }
        List<Date> weeks = DateUtils.dateToWeek(firstDistributiondate);
        Date startDate = weeks.get(0);
        Date endDate = weeks.get(weeks.size() - 1);
        QFilter start = new QFilter("biztime", ">=", (Object)startDate);
        QFilter end = new QFilter("biztime", "<=", (Object)endDate);
        QFilter org = new QFilter("org", "=", (Object)orgId);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)"id,biztime,billentry.id,billentry.baseqty,billentry.material,billentry.warehouse", (QFilter[])new QFilter[]{org, start, end});
        final BigDecimal[] totalQty = new BigDecimal[]{new BigDecimal(0)};
        if (collection != null && collection.length != 0) {
            Arrays.stream(collection).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject dynamicObject) {
                    DynamicObjectCollection subCollection = dynamicObject.getDynamicObjectCollection("billentry");
                    subCollection.stream().forEach(new Consumer<DynamicObject>(){

                        @Override
                        public void accept(DynamicObject subObject) {
                            DynamicObject material = subObject.getDynamicObject("material");
                            DynamicObject warehouse = subObject.getDynamicObject("warehouse");
                            if (material != null && warehouse != null) {
                                long mId = material.getLong("id");
                                long whId = warehouse.getLong("id");
                                if (mId == materialId && whId == warehouseId) {
                                    BigDecimal qty = subObject.getBigDecimal("baseqty");
                                    totalQty[0] = totalQty[0].add(qty);
                                }
                            }
                        }
                    });
                }
            });
        }
        return totalQty[0];
    }

    @Override
    public BigDecimal getPrice(Long org, final Long materialId, final Long warehouseId) {
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)"biztime,billentry.id,billentry.material,billentry.price,billentry.warehouse,billentry.actualprice", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org), new QFilter("billstatus", "=", (Object)"C"), new QFilter("supplytrans", "=", (Object)"0")}, (String)"biztime asc");
        if (collection != null && collection.length != 0) {
            final HashMap datePrice = new HashMap();
            final ArrayList<String> dates = new ArrayList<String>();
            Arrays.stream(collection).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(final DynamicObject dynamicObject) {
                    DynamicObjectCollection subCollection = dynamicObject.getDynamicObjectCollection("billentry");
                    subCollection.stream().forEach(new Consumer<DynamicObject>(){

                        @Override
                        public void accept(DynamicObject subObject) {
                            DynamicObject material = subObject.getDynamicObject("material");
                            DynamicObject warehouse = subObject.getDynamicObject("warehouse");
                            if (material != null && warehouse != null) {
                                long mId = material.getLong("id");
                                long whId = warehouse.getLong("id");
                                if (mId == materialId && whId == warehouseId) {
                                    BigDecimal price = subObject.getBigDecimal("price");
                                    Date biztime = dynamicObject.getDate("biztime");
                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                                    datePrice.put(sdf.format(biztime), price);
                                    dates.add(sdf.format(biztime));
                                }
                            }
                        }
                    });
                }
            });
            dates.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.parseInt(o2) - Integer.parseInt(o1);
                }
            });
            if (!dates.isEmpty()) {
                String lastDate = (String)dates.get(0);
                BigDecimal newPrice = (BigDecimal)datePrice.get(lastDate);
                if (newPrice == null || newPrice.longValue() == 0L) {
                    for (int i = 0; i < dates.size(); ++i) {
                        String date = (String)dates.get(i);
                        BigDecimal price = (BigDecimal)datePrice.get(date);
                        if (price == null || price.longValue() == 0L) continue;
                        logger.info("last bill price:{}, date :{}", (Object)price, (Object)date);
                        return price;
                    }
                }
                return newPrice;
            }
        }
        return null;
    }

    @Override
    public JSONArray getDynamicFeature(String orgNumber, String warehouseNumber, Long materialMasterId, String ffirstdistributiondate) {
        String subServiceId = this.getSubserviceId();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("forgid", (Object)orgNumber);
        paramsJo.put("fwarehouseid", (Object)warehouseNumber);
        paramsJo.put("subServiceId", (Object)subServiceId);
        Map<String, String> baseGroups = this.getMaterialBaseGroups(materialMasterId);
        paramsJo.put("fbase1level", (Object)baseGroups.get("fbase1level"));
        paramsJo.put("fbase2level", (Object)baseGroups.get("fbase2level"));
        paramsJo.put("fbase3level", (Object)baseGroups.get("fbase3level"));
        Map<String, String> brandGroups = this.getMaterialBrandGroups(materialMasterId);
        paramsJo.put("fbrand1level", (Object)brandGroups.get("fbrand1level"));
        paramsJo.put("fbrand2level", (Object)brandGroups.get("fbrand2level"));
        paramsJo.put("fbrand3level", (Object)brandGroups.get("fbrand3level"));
        paramsJo.put("ffirstdistributiondate", (Object)ffirstdistributiondate);
        logger.info("get dynamic feature request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/data/new/product/dynamic/feature", paramsJo);
        logger.info("get dynamic feature response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            JSONArray data = baseResult.getDataAsJSONArray();
            return data;
        }
        return new JSONArray();
    }

    @Override
    public JSONObject submitPredict(String orgNumber, String warehouseNumber, String materialNumber, Long materialMasterId, String firstdistributiondate, BigDecimal price, String fpriceposition, BigDecimal ffirstweekdistributionqty, String fseasonalproducts) {
        String subServiceId = this.getSubserviceId();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("forgid", (Object)orgNumber);
        paramsJo.put("fwarehouseid", (Object)warehouseNumber);
        paramsJo.put("fmaterialid", (Object)materialNumber);
        paramsJo.put("ffirstdistributiondate", (Object)firstdistributiondate);
        paramsJo.put("fprice", (Object)price);
        paramsJo.put("fpriceposition", (Object)fpriceposition);
        paramsJo.put("ffirstweekdistributionqty", (Object)ffirstweekdistributionqty);
        paramsJo.put("fseasonalproducts", (Object)fseasonalproducts);
        Map<String, String> baseGroups = this.getMaterialBaseGroups(materialMasterId);
        paramsJo.put("fbase1level", (Object)baseGroups.get("fbase1level"));
        paramsJo.put("fbase2level", (Object)baseGroups.get("fbase2level"));
        paramsJo.put("fbase3level", (Object)baseGroups.get("fbase3level"));
        Map<String, String> brandGroups = this.getMaterialBrandGroups(materialMasterId);
        paramsJo.put("fbrand1level", (Object)brandGroups.get("fbrand1level"));
        paramsJo.put("fbrand2level", (Object)brandGroups.get("fbrand2level"));
        paramsJo.put("fbrand3level", (Object)brandGroups.get("fbrand3level"));
        logger.info("submit single predict request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/data/new/product/predict/data", paramsJo);
        logger.info("submit single predict response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return new JSONObject();
    }

    @Override
    public JSONObject singlePredictData(String requestId) {
        String subServiceId = this.getSubserviceId();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("requestId", (Object)requestId);
        logger.info("single predict data request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/data/new/product/predict/data/get", paramsJo);
        logger.info("single predict data response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return new JSONObject();
    }

    @Override
    public JSONObject priceSkuAnalysis(String orgNumber, String warehouseNumber, Long materialMasterId) {
        String subServiceId = this.getSubserviceId();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("forgid", (Object)orgNumber);
        paramsJo.put("fwarehouseid", (Object)warehouseNumber);
        paramsJo.put("subServiceId", (Object)subServiceId);
        Map<String, String> baseGroups = this.getMaterialBaseGroups(materialMasterId);
        paramsJo.put("fbase1level", (Object)baseGroups.get("fbase1level"));
        paramsJo.put("fbase2level", (Object)baseGroups.get("fbase2level"));
        paramsJo.put("fbase3level", (Object)baseGroups.get("fbase3level"));
        logger.info("price sku analyst request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/data/new/product/price/sku/analysis", paramsJo);
        logger.info("price sku analyst response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            JSONObject data = baseResult.getDataAsJSONObject();
            return data;
        }
        return new JSONObject();
    }

    @Override
    public JSONObject materialSalesAnalysis(String orgNumber, String warehouseNumber, Long materialMasterId) {
        String subServiceId = this.getSubserviceId();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("forgid", (Object)orgNumber);
        paramsJo.put("fwarehouseid", (Object)warehouseNumber);
        paramsJo.put("subServiceId", (Object)subServiceId);
        Map<String, String> baseGroups = this.getMaterialBaseGroups(materialMasterId);
        paramsJo.put("fbase1level", (Object)baseGroups.get("fbase1level"));
        paramsJo.put("fbase2level", (Object)baseGroups.get("fbase2level"));
        paramsJo.put("fbase3level", (Object)baseGroups.get("fbase3level"));
        logger.info("material sales analyst request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/data/new/product/material/sales/analysis", paramsJo);
        logger.info("material sales analyst response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            JSONObject data = baseResult.getDataAsJSONObject();
            return data;
        }
        return new JSONObject();
    }

    @Override
    public JSONObject priceQtyAnalysis(String orgNumber, String warehouseNumber, Long materialMasterId) {
        String subServiceId = this.getSubserviceId();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("forgid", (Object)orgNumber);
        paramsJo.put("fwarehouseid", (Object)warehouseNumber);
        paramsJo.put("subServiceId", (Object)subServiceId);
        Map<String, String> baseGroups = this.getMaterialBaseGroups(materialMasterId);
        paramsJo.put("fbase1level", (Object)baseGroups.get("fbase1level"));
        paramsJo.put("fbase2level", (Object)baseGroups.get("fbase2level"));
        paramsJo.put("fbase3level", (Object)baseGroups.get("fbase3level"));
        logger.info("price qty analyst request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/data/new/product/price/qty/analysis", paramsJo);
        logger.info("price qty analyst response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            JSONObject data = baseResult.getDataAsJSONObject();
            return data;
        }
        return new JSONObject();
    }

    @Override
    public JSONObject appConfigParameter() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = Services.get(ITenantService.class).getTenantDTO(rc.getOrgId(), rc.getTenantId(), rc.getAccountId());
        IDataappService dataappService = Services.get(IDataappService.class);
        String salesForecastAppId = dataappService.getSalesForecastAppIdByPlatformCode();
        String subServiceId = dataappService.getSubServiceId(rc.getOrgId(), tenantDTO.getTenantId(), salesForecastAppId);
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("scope", (Object)"modelResultParameter");
        paramsJo.put("parameterKeys", (Object)"fbrandlevel_standardfid,fbaselevel_standardfid");
        paramsJo.put("subServiceId", (Object)subServiceId);
        logger.info("app config parameter request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(rc.getOrgId(), "/ids/clientproxy/app/config/parameter", paramsJo);
        logger.info("app config parameter response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return new JSONObject();
    }

    @Override
    public String genPredictNumber(Long materialId, final String materialNumber) {
        QFilter materialFilter = new QFilter("materialid", "=", (Object)materialId);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"ids_ns_predict_scheme", (String)"id,materialid,number", (QFilter[])new QFilter[]{materialFilter});
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        final ArrayList numberList = new ArrayList();
        String genNumber = "";
        logger.info("find material predict size:{}", (Object)(collection != null ? collection.length : 0));
        if (collection != null && collection.length > 0) {
            Arrays.stream(collection).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject object) {
                    String number = object.getString("number");
                    if (!StringUtils.isEmpty((CharSequence)number)) {
                        numberList.add(number);
                    }
                }
            });
            final String currentDate = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            if (numberList != null && !numberList.isEmpty()) {
                List filters = numberList.stream().filter(new Predicate<String>(){

                    @Override
                    public boolean test(String s) {
                        String dateStr = s.substring(materialNumber.length() + 1);
                        String date = dateStr.substring(0, 8);
                        boolean flag = s.indexOf(materialNumber) != -1 && StringUtils.equalsIgnoreCase((CharSequence)date, (CharSequence)currentDate);
                        return flag;
                    }
                }).collect(Collectors.toList());
                if (filters == null || filters.isEmpty()) {
                    genNumber = materialNumber + "-" + currentDate + "-" + StrUtils.leftAddChar("0", 1, 3);
                } else {
                    OptionalInt optionalInt = filters.stream().mapToInt(s -> {
                        int needLength = materialNumber.length() + 1 + currentDate.length();
                        if (s.length() <= needLength) {
                            return 0;
                        }
                        String seq = s.substring(materialNumber.length() + 1 + currentDate.length() + 1);
                        return Integer.parseInt(seq);
                    }).max();
                    if (optionalInt.isPresent()) {
                        int seq = optionalInt.getAsInt() + 1;
                        if (seq > 999) {
                            int length = String.valueOf(seq).length();
                            genNumber = materialNumber + "-" + currentDate + "-" + StrUtils.leftAddChar("0", seq, length);
                        } else {
                            genNumber = materialNumber + "-" + currentDate + "-" + StrUtils.leftAddChar("0", seq, 3);
                        }
                    }
                }
            }
        } else {
            genNumber = materialNumber + "-" + date + "-001";
        }
        return this.predictNumberPlus(genNumber);
    }

    private String predictNumberPlus(String genNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)genNumber);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"ids_ns_predict_scheme", (String)"id,materialid,number", (QFilter[])new QFilter[]{numberFilter});
        if (collection != null && collection.length > 0) {
            String numberPrefix = genNumber.substring(0, genNumber.lastIndexOf("-"));
            OptionalInt optionalInt = Arrays.stream(collection).map(s -> s.getString("number")).collect(Collectors.toList()).stream().mapToInt(new ToIntFunction<String>(){

                @Override
                public int applyAsInt(String value) {
                    int index = value.lastIndexOf("-");
                    String seqStr = value.substring(index + 1);
                    return Integer.parseInt(seqStr);
                }
            }).max();
            if (optionalInt.isPresent()) {
                int seq = optionalInt.getAsInt() + 1;
                if (seq > 999) {
                    int length = String.valueOf(seq).length();
                    return numberPrefix + "-" + StrUtils.leftAddChar("0", seq, length);
                }
                return numberPrefix + "-" + StrUtils.leftAddChar("0", seq, 3);
            }
            return genNumber;
        }
        return genNumber;
    }

    @Override
    public boolean materialIsNewProduct(Long orgId, final Long warehouseId, final Long materialId) {
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)"biztime,billentry.id,billentry.material,billentry.price,billentry.warehouse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("supplytrans", "=", (Object)"0")});
        if (collection != null && collection.length != 0) {
            final Boolean[] flags = new Boolean[]{false};
            final ArrayList<Date> dates = new ArrayList<Date>();
            Arrays.stream(collection).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(final DynamicObject dynamicObject) {
                    DynamicObjectCollection subCollection = dynamicObject.getDynamicObjectCollection("billentry");
                    subCollection.stream().forEach(new Consumer<DynamicObject>(){

                        @Override
                        public void accept(DynamicObject subObject) {
                            DynamicObject material = subObject.getDynamicObject("material");
                            DynamicObject warehouse = subObject.getDynamicObject("warehouse");
                            if (material != null && warehouse != null) {
                                long mId = material.getLong("id");
                                long whId = warehouse.getLong("id");
                                if (mId == materialId && whId == warehouseId) {
                                    flags[0] = true;
                                    Date biztime = dynamicObject.getDate("biztime");
                                    dates.add(biztime);
                                }
                            }
                        }
                    });
                }
            });
            if (!flags[0].booleanValue()) {
                return true;
            }
            logger.info("format dates : {}", (Object)JSONObject.toJSONString(dates));
            dates.sort(new Comparator<Date>(){

                @Override
                public int compare(Date o1, Date o2) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    return Integer.parseInt(sdf.format(o1)) - Integer.parseInt(sdf.format(o2));
                }
            });
            if (!dates.isEmpty()) {
                Date firstDate = (Date)dates.get(0);
                Date nowDate = new Date();
                try {
                    long day = DateUtils.getDistanceDays(firstDate, nowDate);
                    return day <= 30L;
                }
                catch (Exception e) {
                    CommonUtil.getStackTrace(e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean materialHasSale(Long orgId, final Long warehouseId, final Long materialId) {
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)"biztime,billentry.id,billentry.material,billentry.price,billentry.warehouse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("supplytrans", "=", (Object)"0")});
        if (collection != null && collection.length != 0) {
            final Boolean[] flags = new Boolean[]{false};
            Arrays.stream(collection).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject dynamicObject) {
                    DynamicObjectCollection subCollection = dynamicObject.getDynamicObjectCollection("billentry");
                    subCollection.stream().forEach(new Consumer<DynamicObject>(){

                        @Override
                        public void accept(DynamicObject subObject) {
                            DynamicObject material = subObject.getDynamicObject("material");
                            DynamicObject warehouse = subObject.getDynamicObject("warehouse");
                            if (material != null && warehouse != null) {
                                long mId = material.getLong("id");
                                long whId = warehouse.getLong("id");
                                if (mId == materialId && whId == warehouseId) {
                                    flags[0] = true;
                                }
                            }
                        }
                    });
                }
            });
            return flags[0];
        }
        return false;
    }

    private String getSubserviceId() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = Services.get(ITenantService.class).getTenantDTO(rc.getOrgId(), rc.getTenantId(), rc.getAccountId());
        IDataappService dataappService = Services.get(IDataappService.class);
        String salesForecastAppId = dataappService.getSalesForecastAppIdByPlatformCode();
        String subServiceId = dataappService.getSubServiceId(rc.getOrgId(), tenantDTO.getTenantId(), salesForecastAppId);
        return subServiceId;
    }

    private long getOrgId() {
        RequestContext rc = RequestContext.get();
        return rc.getOrgId();
    }
}

