/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.ai.ids.core.constants.RequirePlanConstants;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.IRequirePlanService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class RequirePlanServiceImpl
implements IRequirePlanService {
    private static final Log logger = LogFactory.getLog(RequirePlanServiceImpl.class);

    private String getSubserviceId() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = Services.get(ITenantService.class).getTenantDTO(rc.getOrgId(), rc.getTenantId(), rc.getAccountId());
        IDataappService dataappService = Services.get(IDataappService.class);
        String salesForecastAppId = dataappService.getSalesForecastAppIdByPlatformCode();
        String subServiceId = dataappService.getSubServiceId(rc.getOrgId(), tenantDTO.getTenantId(), salesForecastAppId);
        return subServiceId;
    }

    private long getOrgId() {
        RequestContext rc = RequestContext.get();
        return rc.getOrgId();
    }

    @Override
    public JSONObject loadingRequireData(long requirePlanId, final List<String> preDimLists, final Map<String, Object> condition) {
        JSONObject data = new JSONObject();
        JSONObject dic = new JSONObject();
        data.put("dic", (Object)dic);
        dic.put("finvorgid", (Object)new JSONObject());
        dic.put("fwarehouseid", (Object)new JSONObject());
        dic.put("fcustid", (Object)new JSONObject());
        dic.put("fmaterialid", (Object)new JSONObject());
        final JSONObject preDataJo = new JSONObject();
        data.put("data", (Object)preDataJo);
        QFilter requireidFilter = new QFilter("requireplanid", "=", (Object)requirePlanId);
        final ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(requireidFilter);
        if (condition != null && !condition.isEmpty()) {
            condition.keySet().stream().forEach(new Consumer<String>(){

                @Override
                public void accept(String field) {
                    QFilter filter = new QFilter(field, "=", condition.get(field));
                    filters.add(filter);
                }
            });
        }
        QFilter[] queryFilters = new QFilter[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            queryFilters[i] = (QFilter)filters.get(i);
        }
        DynamicObject[] entries = BusinessDataServiceHelper.load((String)"ids_requireplan_entry", (String)("orgid,warehouseid,custid,materialid," + RequirePlanConstants.REQUIRE_PLAN_ENTRY_ENTITY_QUERY_FIELDS), (QFilter[])queryFilters);
        if (entries != null && entries.length > 0) {
            final JSONObject orgJo = dic.getJSONObject("finvorgid");
            final JSONObject warehouseJo = dic.getJSONObject("fwarehouseid");
            final JSONObject customJo = dic.getJSONObject("fcustid");
            final JSONObject materialJo = dic.getJSONObject("fmaterialid");
            Arrays.stream(entries).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject object) {
                    DynamicObjectCollection subs;
                    DynamicObject materialidObj;
                    DynamicObject custidObj;
                    DynamicObject warehouseidObj;
                    LinkedList<String> preDimTypeCodes = new LinkedList<String>();
                    LinkedList<String> preDimTypeCodeNames = new LinkedList<String>();
                    LinkedList<String> orgDimTypeIds = new LinkedList<String>();
                    LinkedList<String> warehousePreDimTypeIds = new LinkedList<String>();
                    LinkedList<String> customerPreDimTypeIds = new LinkedList<String>();
                    LinkedList<String> materialPreDimTypeIds = new LinkedList<String>();
                    Object pk = object.getPkValue();
                    DynamicObject orgObj = object.getDynamicObject("orgid");
                    if (orgObj != null) {
                        String name = orgObj.getString("name");
                        String number = orgObj.getString("number");
                        long id = (Long)orgObj.getPkValue();
                        JSONObject item = new JSONObject();
                        item.put("name", (Object)name);
                        item.put("number", (Object)number);
                        item.put("id", (Object)id);
                        preDimTypeCodes.add(number);
                        preDimTypeCodeNames.add(name);
                        orgDimTypeIds.add(String.valueOf(id));
                        orgJo.put(String.valueOf(id), (Object)item);
                    }
                    if ((warehouseidObj = object.getDynamicObject("warehouseid")) != null) {
                        String name = warehouseidObj.getString("name");
                        String number = warehouseidObj.getString("number");
                        long id = (Long)warehouseidObj.getPkValue();
                        JSONObject item = new JSONObject();
                        item.put("name", (Object)name);
                        item.put("number", (Object)number);
                        item.put("id", (Object)String.valueOf(id));
                        item.put("parent_org", (Object)StringUtils.join(orgDimTypeIds, (String)"_"));
                        preDimTypeCodes.add(number);
                        preDimTypeCodeNames.add(name);
                        warehousePreDimTypeIds.add(StringUtils.join(orgDimTypeIds, (String)"_"));
                        warehousePreDimTypeIds.add(String.valueOf(id));
                        warehouseJo.put(StringUtils.join(warehousePreDimTypeIds, (String)"_"), (Object)item);
                    }
                    if ((custidObj = object.getDynamicObject("custid")) != null) {
                        String name = custidObj.getString("name");
                        String number = custidObj.getString("number");
                        long id = (Long)custidObj.getPkValue();
                        JSONObject item = new JSONObject();
                        item.put("name", (Object)name);
                        item.put("number", (Object)number);
                        item.put("id", (Object)String.valueOf(id));
                        item.put("parent_org", (Object)StringUtils.join(orgDimTypeIds, (String)"_"));
                        item.put("parent_warehouse", (Object)StringUtils.join(warehousePreDimTypeIds, (String)"_"));
                        preDimTypeCodes.add(number);
                        preDimTypeCodeNames.add(name);
                        customerPreDimTypeIds.add(StringUtils.join(warehousePreDimTypeIds, (String)"_"));
                        customerPreDimTypeIds.add(String.valueOf(id));
                        customJo.put(StringUtils.join(customerPreDimTypeIds, (String)"_"), (Object)item);
                    }
                    if ((materialidObj = object.getDynamicObject("materialid")) != null) {
                        String name = materialidObj.getString("name");
                        String number = materialidObj.getString("number");
                        long id = (Long)materialidObj.getPkValue();
                        JSONObject item = new JSONObject();
                        item.put("name", (Object)name);
                        item.put("number", (Object)number);
                        item.put("id", (Object)id);
                        item.put("parent_org", (Object)StringUtils.join(orgDimTypeIds, (String)"_"));
                        item.put("parent_warehouse", (Object)StringUtils.join(warehousePreDimTypeIds, (String)"_"));
                        item.put("parent_customer", (Object)StringUtils.join(customerPreDimTypeIds, (String)"_"));
                        preDimTypeCodes.add(number);
                        preDimTypeCodeNames.add(name);
                        if (customerPreDimTypeIds.isEmpty()) {
                            materialPreDimTypeIds.add(StringUtils.join(warehousePreDimTypeIds, (String)"_"));
                            materialPreDimTypeIds.add(String.valueOf(id));
                            materialJo.put(StringUtils.join(materialPreDimTypeIds, (String)"_"), (Object)item);
                        } else {
                            materialPreDimTypeIds.add(StringUtils.join(customerPreDimTypeIds, (String)"_"));
                            materialPreDimTypeIds.add(String.valueOf(id));
                            materialJo.put(StringUtils.join(materialPreDimTypeIds, (String)"_"), (Object)item);
                        }
                    }
                    if ((subs = object.getDynamicObjectCollection("ids_req_indicator_entry")) != null && !subs.isEmpty()) {
                        final JSONObject indicatorData = new JSONObject();
                        final JSONObject entryIdData = new JSONObject();
                        subs.stream().forEach(new Consumer<DynamicObject>(){

                            @Override
                            public void accept(DynamicObject entity) {
                                BigDecimal bd;
                                int i;
                                String indicator = entity.getString("indicator");
                                JSONObject predata = new JSONObject();
                                for (i = 0; i < 12; ++i) {
                                    bd = entity.getBigDecimal(String.format("%s%s", "value_", i + 1));
                                    predata.put(String.format("%s%s", "value_", i + 1), (Object)bd);
                                }
                                for (i = 0; i < 12; ++i) {
                                    bd = entity.getBigDecimal(String.format("%s%s", "value", i + 1));
                                    predata.put(String.format("%s%s", "value", i + 1), (Object)bd);
                                }
                                indicatorData.put(indicator, (Object)predata);
                                entryIdData.put(indicator, entity.getPkValue());
                            }
                        });
                        JSONObject dimData = new JSONObject();
                        JSONObject materialProp = new JSONObject();
                        JSONObject materialData = new JSONObject();
                        if (materialidObj != null) {
                            long id = (Long)materialidObj.getPkValue();
                            materialData.put("id", (Object)String.valueOf(id));
                            materialData.put("name", (Object)materialidObj.getString("name"));
                            materialData.put("number", (Object)materialidObj.getString("number"));
                        }
                        materialData.put("indicator", (Object)indicatorData);
                        materialData.put("dim", (Object)dimData);
                        materialData.put("materialProp", (Object)materialProp);
                        materialData.put("fid", pk);
                        materialData.put("entryids", (Object)entryIdData);
                        materialData.put("orgName", (Object)(orgObj != null ? orgObj.getString("name") : ""));
                        materialData.put("warehouseName", (Object)(warehouseidObj != null ? warehouseidObj.getString("name") : ""));
                        materialData.put("customerName", (Object)(custidObj != null ? custidObj.getString("name") : ""));
                        materialData.put("orgNumber", (Object)(orgObj != null ? orgObj.getString("number") : ""));
                        materialData.put("warehouseNumber", (Object)(warehouseidObj != null ? warehouseidObj.getString("number") : ""));
                        materialData.put("customerNumber", (Object)(custidObj != null ? custidObj.getString("number") : ""));
                        materialData.put("fpredimentypeCode", (Object)StringUtils.join(preDimTypeCodes, (String)"->"));
                        materialData.put("fpredimentypeCodeName", (Object)StringUtils.join(preDimTypeCodeNames, (String)"->"));
                        if (preDimLists.contains("finvorgid")) {
                            dimData.put("finvorgid", (Object)StringUtils.join(orgDimTypeIds, (String)"_"));
                            if (orgObj != null) {
                                materialProp.put("finvorgid", orgObj.getPkValue());
                            }
                        }
                        if (preDimLists.contains("fwarehouseid")) {
                            dimData.put("fwarehouseid", (Object)StringUtils.join(warehousePreDimTypeIds, (String)"_"));
                            materialProp.put("fwarehouseid", warehouseidObj != null ? warehouseidObj.getPkValue() : null);
                        }
                        if (preDimLists.contains("fcustid")) {
                            dimData.put("fcustid", (Object)StringUtils.join(customerPreDimTypeIds, (String)"_"));
                            materialProp.put("fcustid", custidObj != null ? custidObj.getPkValue() : null);
                        }
                        preDataJo.put(StringUtils.join(materialPreDimTypeIds, (String)"_"), (Object)materialData);
                    }
                }
            });
        }
        return data;
    }

    @Override
    public JSONObject loadMarkAnaData(String fpredimentypeCode, String fpretimetype, String fstartDate, String fendDate) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("fpredimentypeCode", (Object)fpredimentypeCode);
        paramsJo.put("fpretimetype", (Object)fpretimetype);
        paramsJo.put("subServiceId", (Object)this.getSubserviceId());
        paramsJo.put("fstartDate", (Object)fstartDate);
        paramsJo.put("fendDate", (Object)fendDate);
        logger.info("load mark ana data request:{}", (Object)paramsJo.toJSONString());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(this.getOrgId(), "/ids/data/data/mark/analysis/range", paramsJo);
        logger.info("load mark ana data response:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null) {
            JSONObject data = baseResult.getDataAsJSONObject();
            return data;
        }
        return new JSONObject();
    }
}

