/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.sf.std.AppExecuteLogDTO;
import kd.ai.ids.core.entity.model.sf.std.AppExecuteNodeLogDTO;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.sf.std.AppExecuteLogNodeEnum;
import kd.ai.ids.core.query.clientproxy.sf.std.AppExecuteLogSaveQuery;
import kd.ai.ids.core.query.clientproxy.sf.std.AppExecuteNodeLogSaveQuery;
import kd.ai.ids.core.query.data.HomeOverviewQuery;
import kd.ai.ids.core.query.sf.std.PreObjCheckQuery;
import kd.ai.ids.core.query.sf.std.PreObjConfigQuery;
import kd.ai.ids.core.query.sf.std.PreObjListQuery;
import kd.ai.ids.core.query.sf.std.StandardFilterItemQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IAuthService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.ISfStandardService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class SfStandardServiceImpl
implements ISfStandardService {
    private static final Log log = LogFactory.getLog(SfStandardServiceImpl.class);

    @Override
    public Integer newSchemeid(String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/standard/sub/schemeid/new", paramsJo);
        return baseResult.getDataAsJSONObject().getIntValue("fschemeid");
    }

    @Override
    public JSONObject appConfigGet(String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/standard/sf/app/config/get", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONArray getOnlineSchemeList(String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/online/scheme/list", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONArray();
        }
        return null;
    }

    @Override
    public JSONObject appModelGet(String subServiceId, String tenantId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("tenantId", (Object)tenantId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/ids/app/customer/model/autocreate/get", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public BaseResult subServiceInit(String subServiceId, String tenantId, String fdatasource) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("tenantId", (Object)tenantId);
        paramsJo.put("fdatasource", (Object)fdatasource);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/standard/subservice/init", paramsJo);
        return baseResult;
    }

    @Override
    public JSONArray getSubsericeInitNodeList(String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/standard/subservice/init/list", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONArray();
        }
        return null;
    }

    @Override
    public JSONObject appEexecuteLogSave(AppExecuteLogSaveQuery query) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)query));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/standard/app/execute/log/save", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject appEexecuteLogNodeSave(AppExecuteNodeLogSaveQuery query) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)query));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/standard/app/execute/node/log/save", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public AppExecuteLogDTO appEexecuteLogLast(String subServiceId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/standard/app/execute/log/last", paramsJo);
        if (baseResult.getData() != null) {
            JSONObject appExecuteLogJo = baseResult.getDataAsJSONObject();
            AppExecuteLogDTO appExecuteLogDTO = (AppExecuteLogDTO)appExecuteLogJo.toJavaObject(AppExecuteLogDTO.class);
            return appExecuteLogDTO;
        }
        return null;
    }

    @Override
    public int getAppExecuteLogStatus(String subServiceId) {
        int executeStatus = ExecuteStatusEnum.EXECUTING.getKey();
        AppExecuteLogDTO appExecuteLogDTO = this.appEexecuteLogLast(subServiceId);
        if (appExecuteLogDTO != null) {
            executeStatus = appExecuteLogDTO.getExecuteStatus();
        }
        return executeStatus;
    }

    @Override
    public Boolean canExecuteQueryTask(String subServiceId) {
        List<AppExecuteNodeLogDTO> nodeLogList;
        Boolean flag = Boolean.FALSE;
        AppExecuteLogDTO appExecuteLogDTO = this.appEexecuteLogLast(subServiceId);
        if (appExecuteLogDTO != null && CollectionUtils.isNotEmpty(nodeLogList = appExecuteLogDTO.getNodeLogList())) {
            int modelCalculateStatus;
            Map<String, AppExecuteNodeLogDTO> map = nodeLogList.stream().collect(Collectors.toMap(AppExecuteNodeLogDTO::getNode, a -> a, (k1, k2) -> k1));
            AppExecuteNodeLogDTO dataPreparationNodeLog = map.get(AppExecuteLogNodeEnum.DATA_PREPARATION.getKey());
            AppExecuteNodeLogDTO modelCalculateNodeLog = map.get(AppExecuteLogNodeEnum.MODEL_CALCULATE.getKey());
            int dataPreparationStatus = dataPreparationNodeLog != null ? dataPreparationNodeLog.getExecuteStatus().intValue() : ExecuteStatusEnum.INIT.getKey();
            int n = modelCalculateStatus = modelCalculateNodeLog != null ? modelCalculateNodeLog.getExecuteStatus().intValue() : ExecuteStatusEnum.INIT.getKey();
            if (dataPreparationStatus == ExecuteStatusEnum.SUCCESS.getKey() && modelCalculateStatus == ExecuteStatusEnum.SUCCESS.getKey()) {
                flag = Boolean.TRUE;
            }
        }
        return flag;
    }

    @Override
    public Map<String, Integer> getAppExecuteLogNodeStatusMap(String subServiceId) {
        List<AppExecuteNodeLogDTO> nodeLogList;
        AppExecuteLogNodeEnum[] appExecuteLogNodeEnums = AppExecuteLogNodeEnum.values();
        HashMap<String, Integer> executeIdStatusMap = new HashMap<String, Integer>(appExecuteLogNodeEnums.length);
        AppExecuteLogDTO appExecuteLogDTO = this.appEexecuteLogLast(subServiceId);
        Map<Object, Object> map = new HashMap();
        if (appExecuteLogDTO != null && CollectionUtils.isNotEmpty(nodeLogList = appExecuteLogDTO.getNodeLogList())) {
            map = nodeLogList.stream().collect(Collectors.toMap(AppExecuteNodeLogDTO::getNode, a -> a, (k1, k2) -> k1));
        }
        for (AppExecuteLogNodeEnum appExecuteLogNodeEnum : appExecuteLogNodeEnums) {
            String node = appExecuteLogNodeEnum.getKey();
            AppExecuteNodeLogDTO appExecuteNodeLogDTO = (AppExecuteNodeLogDTO)map.get(node);
            int status = ExecuteStatusEnum.INIT.getKey();
            if (appExecuteNodeLogDTO != null) {
                status = appExecuteNodeLogDTO.getExecuteStatus();
            }
            executeIdStatusMap.put(node, status);
        }
        return executeIdStatusMap;
    }

    @Override
    public BaseResult getHomeOverview(Long orgId, HomeOverviewQuery homeOverviewQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)homeOverviewQuery));
        return Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/data/sf/standard/home/overview", paramsJo);
    }

    @Override
    public JSONArray getAlgorithmError(String subServiceId, int fschemeid) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("fschemeid", (Object)fschemeid);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/anaresults/algorithm/error", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONArray();
        }
        return null;
    }

    @Override
    public JSONObject getLastTrend(StandardFilterItemQuery standardFilterItemQuery) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)standardFilterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/anaresults/last/trend", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getYearTrend(StandardFilterItemQuery standardFilterItemQuery) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)standardFilterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/anaresults/year/trend", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getLastTrendDetail(StandardFilterItemQuery standardFilterItemQuery) {
        JSONObject paramsJo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)standardFilterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/anaresults/last/trend/detail", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getLastDetailList(StandardFilterItemQuery standardFilterItemQuery) {
        String filters = this.getDataPermFilters();
        standardFilterItemQuery.setFilters(filters);
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)standardFilterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/anaresults/last/detail", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getLastDetailSummary(StandardFilterItemQuery standardFilterItemQuery) {
        String filters = this.getDataPermFilters();
        standardFilterItemQuery.setFilters(filters);
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)standardFilterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/anaresults/last/detail/summary", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getLastDetailListExport(StandardFilterItemQuery standardFilterItemQuery) {
        String filters = this.getDataPermFilters();
        standardFilterItemQuery.setFilters(filters);
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)standardFilterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/anaresults/last/detail/list/export", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public String getLastDetailListExportFileUrl(String subServiceId, String requestId) {
        long orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
        IdsParameter idsParameter = Services.get(IIdsParameterService.class).getIdsParameter(orgId);
        String token = Services.get(IAuthService.class).getAccessToken(idsParameter);
        try {
            token = URLEncoder.encode(token, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            CommonUtil.getStackTrace(e);
        }
        String url = idsParameter.getIdsServerUrl() + "/ids/data/sf/standard/anaresults/last/detail/list/export/file";
        return String.format("%s?subServiceId=%s&requestId=%s&auth_type=token&token=%s", url, subServiceId, requestId, token);
    }

    @Override
    public String getDataPermFilters() {
        StringBuffer filters = new StringBuffer();
        RequestContext rc = RequestContext.get();
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)rc.getCurrUserId());
        if (!isSuperUser) {
            QFilter dataQFilter = PermissionServiceHelper.getOperationRuleFilter((String)"ids", (String)IdsFormIdEnum.IDS_PREDICT_DETAIL_L_PERM.getId(), (String)"view", (StringBuilder)new StringBuilder("\u65e0\u6743\u9650\u8bbf\u95ee"));
            if (dataQFilter != null && StringUtils.equalsIgnoreCase((CharSequence)dataQFilter.getProperty(), (CharSequence)"org")) {
                log.info("dataQFilter:{}", (Object)dataQFilter.toString());
                List orgidList = (List)dataQFilter.getValue();
                if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)orgidList)) {
                    String dataQFilterStr = String.format(" %s ", dataQFilter);
                    filters = StringUtils.isEmpty((CharSequence)filters.toString()) ? filters.append(dataQFilterStr) : filters.append(" AND ").append(dataQFilterStr);
                }
            }
        } else {
            log.info("{}({}) is superUser", (Object)rc.getUserName(), (Object)rc.getCurrUserId());
        }
        log.info("filters : {}", (Object)filters);
        return filters.toString();
    }

    @Override
    public JSONObject getCurrPredictObjList(PreObjListQuery preObjListQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)preObjListQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/predict/obj/list", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONObject getPredictObjConfigList(PreObjListQuery preObjListQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)preObjListQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/predict/obj/config/list", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }

    @Override
    public JSONArray predictObjCheck(PreObjCheckQuery preObjCheckQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSONObject.toJSONString((Object)preObjCheckQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/predict/obj/check", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONArray();
        }
        return null;
    }

    @Override
    public BaseResult predictObjConfig(PreObjConfigQuery preObjConfigQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)preObjConfigQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/predict/obj/config", paramsJo);
        return baseResult;
    }

    @Override
    public JSONObject getAnaExtraInfo(StandardFilterItemQuery standardFilterItemQuery) {
        JSONObject paramsJo = JSON.parseObject((String)JSON.toJSONString((Object)standardFilterItemQuery));
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/data/sf/standard/anaresults/extra/info", paramsJo);
        if (baseResult.getData() != null) {
            return baseResult.getDataAsJSONObject();
        }
        return null;
    }
}

