/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.ai.ids.core.constants.AppConstants;
import kd.ai.ids.core.entity.model.BizAssociateSchemeMsg;
import kd.ai.ids.core.entity.model.ColumnDetail;
import kd.ai.ids.core.entity.model.EntityCatalog;
import kd.ai.ids.core.entity.model.EntityTable;
import kd.ai.ids.core.entity.model.IncrementCondition;
import kd.ai.ids.core.entity.model.ModelType;
import kd.ai.ids.core.entity.model.RequirePlanPushDownParams;
import kd.ai.ids.core.entity.model.ResultExportLog;
import kd.ai.ids.core.entity.model.ResultExportMetadata;
import kd.ai.ids.core.entity.model.ResultType;
import kd.ai.ids.core.entity.model.TableCount;
import kd.ai.ids.core.entity.model.TableField;
import kd.ai.ids.core.enumtype.BillEnableEnum;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.ClientPatternEnum;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.ExecStatusEnum;
import kd.ai.ids.core.enumtype.ExecuteIntervalUnitEnum;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.ExecuteTypeEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.ModelConfigItemEnum;
import kd.ai.ids.core.enumtype.RetentionPeriodEnum;
import kd.ai.ids.core.enumtype.RetryTypeEnum;
import kd.ai.ids.core.enumtype.RowDataTypeEnum;
import kd.ai.ids.core.enumtype.SalesplanIndicatorEnum;
import kd.ai.ids.core.enumtype.TaskStatusEnum;
import kd.ai.ids.core.enumtype.TaskTypeEnum;
import kd.ai.ids.core.enumtype.UploadLocationEnum;
import kd.ai.ids.core.enumtype.UploadTypeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.sf.std.AppExecuteLogNodeEnum;
import kd.ai.ids.core.query.clientproxy.ExecuteDetailLog;
import kd.ai.ids.core.query.clientproxy.ExecuteLog;
import kd.ai.ids.core.query.clientproxy.InitExecuteDetailLogQuery;
import kd.ai.ids.core.query.clientproxy.InitExecuteLogQuery;
import kd.ai.ids.core.query.clientproxy.sf.std.AppExecuteLogSaveQuery;
import kd.ai.ids.core.query.clientproxy.sf.std.AppExecuteNodeLogSaveQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.S3UploadTableInfo;
import kd.ai.ids.core.response.server.TaskQueryResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.response.server.UploadDbInfo;
import kd.ai.ids.core.response.server.UploadFieldInfo;
import kd.ai.ids.core.response.server.UploadInfo;
import kd.ai.ids.core.response.server.UploadTableInfo;
import kd.ai.ids.core.service.ICommonService;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.IModelResultService;
import kd.ai.ids.core.service.IResultExportLogService;
import kd.ai.ids.core.service.ISalesPlanPeriodService;
import kd.ai.ids.core.service.ISfStandardService;
import kd.ai.ids.core.service.ITaskExecuteService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.AwsS3Utils;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.EntityUtils;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.TaskUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.input.OrmInput;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class TaskExecuteServiceImpl
implements ITaskExecuteService {
    private static final Log log = LogFactory.getLog(TaskExecuteServiceImpl.class);
    private static final int PAGE_SIZE = 100000;
    private static final int MAX_THREAD_COUNT = 1;
    private static final ExecutorService executorService = ThreadPools.newExecutorService((String)"ids_threadpools", (int)1);
    private static final String KEY_APPID = "appid";
    private static final String KEY_MODELID = "modelid";
    private static final String KEY_FMODELTYPEID_AS_FSTOREID = "fstoreid";
    private static final String KEY_CREATETIME = "createtime";
    private static final String KEY_BILL_HEAD_KEY = "billHeadKey";
    private static final String KEY_BILL_DATA = "billData";

    private ICommonService commonService() {
        return Services.get(ICommonService.class);
    }

    private ISalesPlanPeriodService salesPlanPeriodService() {
        return Services.get(ISalesPlanPeriodService.class);
    }

    private IIdsServerService idsServerService() {
        return Services.get(IIdsServerService.class);
    }

    private ISfStandardService sfStandardService() {
        return Services.get(ISfStandardService.class);
    }

    private ITaskExecuteService taskExecuteService() {
        return Services.get(ITaskExecuteService.class);
    }

    private IDataappService dataappService() {
        return Services.get(IDataappService.class);
    }

    @Override
    public void uploadData(Long orgId, String modelVersionId, TenantDTO tenantResult, String appId, String taskName, int executeType, long runByUserId, String subServiceId, String executeId) {
        if (executeType == ExecuteTypeEnum.MANUAL.getKey()) {
            this.saveAppExecuteLog(runByUserId, executeType, executeId, subServiceId);
            this.saveAppExecuteNodeLog(executeId, subServiceId, ExecuteStatusEnum.EXECUTING.getKey(), AppExecuteLogNodeEnum.DATA_PREPARATION.getKey(), modelVersionId, null);
        }
        this.onlineAvailScheme();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("customerId", (Object)tenantResult.getCustomerId());
        paramsJo.put("tenantId", (Object)tenantResult.getTenantId());
        paramsJo.put("modelVersionId", (Object)modelVersionId);
        log.info("#####start uploadData paramGet");
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/app/customer/task/param/get", paramsJo);
        log.info("#####end uploadData paramGet : {}", (Object)JSONObject.toJSONString((Object)baseResult));
        String baseResultData = JSONObject.toJSONString((Object)baseResult.getData());
        JSONObject baseResultDataJo = JSON.parseObject((String)baseResultData);
        JSONObject baseResultDataDataJo = JSON.parseObject((String)baseResultDataJo.getString("data"));
        baseResultDataJo.put("data", (Object)baseResultDataDataJo);
        UploadInfo uploadInfo = (UploadInfo)baseResultDataJo.toJavaObject(UploadInfo.class);
        log.info("#####start uploadData initExecuteLog");
        ExecuteLog executeLog = this.initExecuteLog(orgId, null, modelVersionId, TaskTypeEnum.UPLOAD.getKey(), tenantResult.getTenantName(), uploadInfo.getModelName(), appId, taskName, executeType, RetryTypeEnum.NORMAL.getKey(), null);
        log.info("#####end uploadData initExecuteLog");
        List<EntityTable> entityTableList = EntityUtils.getEntityTableList((EntityCatalog)uploadInfo.getData().toJavaObject(EntityCatalog.class));
        if (!CollectionUtils.isEmpty(entityTableList)) {
            UploadDbInfo uploadDbInfo = new UploadDbInfo();
            uploadDbInfo.setExecuteId(executeId);
            uploadDbInfo.setTenantId(tenantResult.getTenantId());
            uploadDbInfo.setConnect("R/lqTMM9UjwMo2OcUe/Lk+xswU5U9fCBlEGEdTHQrUX1Rn7ZeasD71/nPu7JdGMz+eNDiX5KB2R5JoFA+/HjXJyM/82ea/jRIwCOJPZTaIhEIEI+CTHqXHpLbvYpZFzZqPwxkfiET4GS7PA5jMXXu5VVd8t6RjvIQUs2d4dL+rh5vuD97iyKtg==");
            uploadDbInfo.setDbName(uploadInfo.getDbName());
            uploadDbInfo.setExecuteType(ExecuteTypeEnum.CRONTAB.getKey());
            uploadDbInfo.setModelVersionId(modelVersionId);
            Map<String, S3UploadTableInfo> tableNameS3PathMap = this.getTableNameS3PathMap(uploadInfo);
            this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.EXECUTING.getKey(), null);
            log.info("start uploadData...");
            Date st = new Date();
            this.uploadDataByCondition(orgId, executeLog, uploadInfo, entityTableList, uploadDbInfo, tableNameS3PathMap);
            Date et = new Date();
            log.info("end uploadData spendTime:{}s", (Object)((et.getTime() - st.getTime()) / 1000L));
            this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.SUCCESS.getKey(), null);
            log.info("#####uploadDbInfo : {}", (Object)JSONObject.toJSONString((Object)uploadDbInfo));
            this.runWork(orgId, uploadDbInfo, tenantResult, runByUserId, executeType, subServiceId, appId);
        } else {
            log.info("#####entityTableList is empty.");
        }
    }

    private void onlineAvailScheme() {
        ThreadUtils.execute(() -> {
            DynamicObject[] schemeDoArr = BusinessDataServiceHelper.load((String)IdsFormIdEnum.IDS_SF_SCHEME.getId(), (String)"name,number,status,enable,bizstatus", (QFilter[])new QFilter("enable", "=", (Object)BillEnableEnum.ENABLE.getId()).and("bizstatus", "!=", (Object)YesNoEnum.YES.getKeyStr()).toArray());
            if (schemeDoArr != null && schemeDoArr.length > 0) {
                for (DynamicObject schemeDo : schemeDoArr) {
                    schemeDo.set("bizstatus", (Object)YesNoEnum.YES.getKeyStr());
                }
                Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])schemeDoArr);
                if (saveObjs != null && saveObjs.length > 0) {
                    log.info("online scheme count : {}", (Object)saveObjs.length);
                }
            }
        });
    }

    private void saveAppExecuteLog(long runByUserId, int executeType, String executeId, String subServiceId) {
        if (StringUtils.isNotEmpty((CharSequence)subServiceId)) {
            Map userInfoByID;
            AppExecuteLogSaveQuery appExecuteLogSaveQuery = new AppExecuteLogSaveQuery();
            appExecuteLogSaveQuery.setExecuteId(executeId);
            appExecuteLogSaveQuery.setExecuteType(executeType);
            appExecuteLogSaveQuery.setSubServiceId(subServiceId);
            appExecuteLogSaveQuery.setUserId(String.valueOf(runByUserId));
            if (runByUserId > 0L && !CollectionUtils.isEmpty((Map)(userInfoByID = UserServiceHelper.getUserInfoByID((long)runByUserId)))) {
                appExecuteLogSaveQuery.setUserName(userInfoByID.getOrDefault("name", "administrator").toString());
            }
            this.sfStandardService().appEexecuteLogSave(appExecuteLogSaveQuery);
        }
    }

    private void saveAppExecuteNodeLog(String executeId, String subServiceId, int executeStatus, String node, String bizIds, String failMsg) {
        if (StringUtils.isNotEmpty((CharSequence)subServiceId)) {
            AppExecuteNodeLogSaveQuery appExecuteNodeLogSaveQuery = new AppExecuteNodeLogSaveQuery();
            appExecuteNodeLogSaveQuery.setExecuteId(executeId);
            appExecuteNodeLogSaveQuery.setExecuteStatus(executeStatus);
            appExecuteNodeLogSaveQuery.setNode(node);
            appExecuteNodeLogSaveQuery.setBizIds(bizIds);
            appExecuteNodeLogSaveQuery.setSubServiceId(subServiceId);
            appExecuteNodeLogSaveQuery.setFailMsg(failMsg);
            this.sfStandardService().appEexecuteLogNodeSave(appExecuteNodeLogSaveQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadDataByCondition(Long orgId, ExecuteLog executeLog, UploadInfo uploadInfo, List<EntityTable> entityTableList, UploadDbInfo uploadDbInfo, Map<String, S3UploadTableInfo> tableNameS3PathMap) {
        HashMap<String, String> startPkEndPkMap = new HashMap<String, String>();
        String billHeadMinPk = "";
        String billHeadMaxPk = "";
        String billHeadPk = "id";
        String billHeadPkType = "LONG";
        QFilter incrementQFilter = null;
        ORM orm = ORM.create();
        for (EntityTable entityTable : entityTableList) {
            Date startTime;
            boolean isBillHead;
            String entityName = entityTable.getEntityId();
            if (StringUtils.isEmpty((CharSequence)entityTable.getEntityId()) || StringUtils.isEmpty((CharSequence)entityTable.getTableName())) {
                log.info("{} entity has no tableName");
                continue;
            }
            boolean bl = isBillHead = !StringUtils.containsIgnoreCase((CharSequence)entityTable.getPkFiledName(), (CharSequence)".");
            if (isBillHead) {
                startPkEndPkMap = new HashMap();
                billHeadMinPk = "";
                billHeadMaxPk = "";
                if (StringUtils.isNotEmpty((CharSequence)entityTable.getPkFiledName())) {
                    billHeadPk = entityTable.getPkFiledName();
                    billHeadPkType = entityTable.getPkFieldType();
                } else {
                    billHeadPk = "id";
                    billHeadPkType = "LONG";
                }
                incrementQFilter = null;
            }
            List<TableField> tableFieldList = entityTable.getFields();
            ArrayList<UploadFieldInfo> fields = new ArrayList<UploadFieldInfo>(tableFieldList.size());
            TableField tableField = null;
            UploadFieldInfo uploadFieldInfo = null;
            for (int i = 0; i < tableFieldList.size(); ++i) {
                tableField = tableFieldList.get(i);
                uploadFieldInfo = new UploadFieldInfo();
                uploadFieldInfo.setComment(tableField.getComment());
                uploadFieldInfo.setFieldName(tableField.getFieldName());
                uploadFieldInfo.setFieldType(tableField.getFieldType());
                uploadFieldInfo.setTempFieldName("f" + i);
                fields.add(uploadFieldInfo);
                uploadFieldInfo = null;
                tableField = null;
            }
            UploadTableInfo uploadTableInfo = new UploadTableInfo();
            uploadTableInfo.setTableName(entityTable.getTableName());
            uploadTableInfo.setTableNameCn(entityTable.getName());
            uploadTableInfo.setTempTableName("t_cosmic_test");
            uploadTableInfo.setFields(fields);
            uploadDbInfo.getTableList().add(uploadTableInfo);
            List fieldKeyList = tableFieldList.stream().map(TableField::getTableFieldName).collect(Collectors.toList());
            String selectFields = String.join((CharSequence)",", fieldKeyList);
            int totalCount = 0;
            if (isBillHead) {
                startTime = new Date();
                IncrementCondition incrementCondition = this.getIncrementCondition(orgId, executeLog, entityTable);
                if (incrementCondition != null && StringUtils.isNotEmpty((CharSequence)incrementCondition.getFieldValue())) {
                    Date incrementDateValue = kd.ai.ids.core.utils.DateUtils.parseDate(incrementCondition.getFieldValue(), "yyyy-MM-dd HH:mm:ss.SSS");
                    incrementQFilter = new QFilter(incrementCondition.getFieldKey(), ">", (Object)incrementDateValue);
                }
                QFilter[] incrementQFilters = incrementQFilter != null ? incrementQFilter.toArray() : null;
                String minPk = "";
                List minPkList = QueryServiceHelper.queryPrimaryKeys((String)this.getClass().getName(), (String)entityName, (QFilter[])incrementQFilters, (String)(billHeadPk + " asc"), (int)1);
                if (minPkList.size() > 0 && minPkList.get(0) != null) {
                    minPk = minPkList.get(0).toString();
                }
                billHeadMinPk = minPk;
                String maxPk = "";
                List maxPkList = QueryServiceHelper.queryPrimaryKeys((String)this.getClass().getName(), (String)entityName, (QFilter[])incrementQFilters, (String)(billHeadPk + " desc"), (int)1);
                if (maxPkList.size() > 0 && maxPkList.get(0) != null) {
                    maxPk = maxPkList.get(0).toString();
                }
                billHeadMaxPk = maxPk;
                QFilter totalCountQFilter = null;
                totalCountQFilter = StringUtils.isEmpty((CharSequence)minPk) || StringUtils.isEmpty((CharSequence)maxPk) ? (EntityUtils.pkIsNumber(entityTable.getPkFieldType()) ? new QFilter(billHeadPk, ">=", (Object)0).and(billHeadPk, "<=", (Object)0) : new QFilter(billHeadPk, ">=", (Object)"0").and(billHeadPk, "<=", (Object)"0")) : (EntityUtils.pkIsNumber(entityTable.getPkFieldType()) ? new QFilter(billHeadPk, ">=", (Object)Long.parseLong(minPk)).and(billHeadPk, "<=", (Object)Long.parseLong(maxPk)) : new QFilter(billHeadPk, ">=", (Object)minPk).and(billHeadPk, "<=", (Object)maxPk));
                if (incrementQFilter != null) {
                    totalCountQFilter.and(incrementQFilter);
                }
                totalCount = this.count(orm, entityName, "id", totalCountQFilter.toArray());
                log.info("idsSyncPkRange_billHead {}({}) pkFieldName:{} totalCount:{} minPk,maxPk : [{}, {}]", new Object[]{entityName, entityTable.getTableName(), billHeadPk, totalCount, minPk, maxPk});
                JSONObject incrementConditionJo = null;
                String incrementConditionStr = null;
                if (entityTable.getUploadType().intValue() == UploadTypeEnum.INCREMENT.getKey()) {
                    DynamicObject dynamicObject;
                    Date maxIncrementDate;
                    String string = "";
                    String incrementFieldKey = EntityUtils.getFieldKeyByFieldName(entityTable.getIncrementField(), entityTable);
                    DynamicObjectCollection maxIncrementValueList = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityName, (String)incrementFieldKey, (QFilter[])totalCountQFilter.toArray(), (String)(incrementFieldKey + " desc"), (int)1);
                    if (maxIncrementValueList != null && maxIncrementValueList.size() > 0 && maxIncrementValueList.get(0) != null && (maxIncrementDate = (dynamicObject = (DynamicObject)maxIncrementValueList.get(0)).getDate(incrementFieldKey)) != null) {
                        String string2 = DateFormatUtils.format((Date)maxIncrementDate, (String)"yyyy-MM-dd HH:mm:ss.SSS");
                        incrementConditionJo = new JSONObject();
                        incrementConditionJo.put(entityTable.getIncrementField(), (Object)string2);
                        incrementConditionStr = JSON.toJSONString((Object)incrementConditionJo);
                    }
                }
                ExecuteDetailLog executeDetailLog = this.initDetailLog(orgId, executeLog, entityName, entityTable.getName(), entityTable.getTableName(), totalCount, entityTable.getUploadType(), incrementConditionStr, 0L, null, null);
                this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.EXECUTING.getKey(), null);
                String startPk = minPk;
                int totalPages = totalCount % 100000 == 0 ? totalCount / 100000 : totalCount / 100000 + 1;
                int syncTotalCount = 0;
                String filePath = null;
                QFilter qFilter = null;
                for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                    this.printJvmMemoryUsageInfo("entryEntityStart  pageIndex:" + pageIndex + " tableName:" + entityTable.getTableName());
                    log.info("idsSyncIndexSummary_billHead {}({}) pageIndex:{}/{}", new Object[]{entityName, entityTable.getTableName(), pageIndex, totalPages});
                    if (EntityUtils.pkIsNumber(entityTable.getPkFieldType())) {
                        qFilter = pageIndex == 0 ? new QFilter(billHeadPk, ">=", (Object)Long.parseLong(startPk)) : new QFilter(billHeadPk, ">", (Object)Long.parseLong(startPk));
                        qFilter.and(billHeadPk, "<=", (Object)Long.parseLong(maxPk));
                    } else {
                        qFilter = pageIndex == 0 ? new QFilter(billHeadPk, ">=", (Object)startPk) : new QFilter(billHeadPk, ">", (Object)startPk);
                        qFilter.and(billHeadPk, "<=", (Object)maxPk);
                    }
                    if (incrementQFilter != null) {
                        qFilter.and(incrementQFilter);
                    }
                    QFilter[] qFilters = qFilter.toArray();
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])qFilters, (String)(billHeadPk + " asc"), (int)100000);
                    int dynamicObjectSize = 0;
                    if (dynamicObjectCollection != null) {
                        dynamicObjectSize = dynamicObjectCollection.size();
                    }
                    log.info("dynamicObjectSize start {}({}) pageIndex:{}, {}", new Object[]{entityName, entityTable.getTableName(), pageIndex, dynamicObjectSize});
                    if (dynamicObjectSize <= 0) continue;
                    syncTotalCount += dynamicObjectSize;
                    StringBuilder lineSb = new StringBuilder();
                    String s3ObjectKey = "";
                    int linesSbSize = 0;
                    URLConnection connection = null;
                    OutputStreamWriter s3Out = null;
                    try {
                        S3UploadTableInfo s3UploadTableInfo = tableNameS3PathMap.get(entityTable.getTableName().toLowerCase());
                        String pageUploadS3Url = this.getUploadS3Url(orgId, s3UploadTableInfo.getUuid(), uploadInfo.getTenantId(), uploadInfo.getModelVersionId());
                        log.info("{}/{} {} pageUploadS3Url : {} params:{}", new Object[]{pageIndex, totalPages, entityTable.getTableName(), pageUploadS3Url, s3UploadTableInfo.getUuid() + "=" + uploadInfo.getTenantId() + "=" + uploadInfo.getModelVersionId()});
                        s3ObjectKey = AwsS3Utils.getObjectKey(pageUploadS3Url);
                        URL url = new URL(pageUploadS3Url);
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setDoOutput(true);
                        connection.setRequestProperty("Content-Type", "text/plain");
                        ((HttpURLConnection)connection).setRequestMethod("PUT");
                        connection.setConnectTimeout(86400000);
                        s3Out = new OutputStreamWriter(connection.getOutputStream());
                        for (int i = 0; i < dynamicObjectSize; ++i) {
                            Object fieldObj = null;
                            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                            for (int j = 0; j < entityTable.getFields().size(); ++j) {
                                String fieldValue;
                                fieldObj = dynamicObject.get(j);
                                String string = fieldValue = fieldObj != null ? fieldObj.toString() : "";
                                if (j == 0) {
                                    lineSb.append(fieldValue);
                                    continue;
                                }
                                lineSb.append('\u0001').append(fieldValue);
                            }
                            if (i != dynamicObjectSize - 1) {
                                lineSb.append('\n');
                            }
                            linesSbSize += lineSb.length();
                            s3Out.write(lineSb.toString());
                            lineSb.setLength(0);
                        }
                        Object endPkObj = ((DynamicObject)dynamicObjectCollection.get(dynamicObjectSize - 1)).get(billHeadPk);
                        String endPk = endPkObj != null ? endPkObj.toString() : "";
                        startPkEndPkMap.put(startPk, endPk);
                        startPk = endPk;
                        log.info("idsUploadS3_billHead start {}({}) pageIndex:{}, {}", new Object[]{entityName, entityTable.getTableName(), pageIndex, s3ObjectKey});
                        filePath = StringUtils.isEmpty(filePath) ? s3ObjectKey : filePath + "," + s3ObjectKey;
                        log.info("idsUploadS3_billHead end {}({}) pageIndex:{}, {}", new Object[]{entityName, entityTable.getTableName(), pageIndex, s3ObjectKey});
                        this.incSyncCount(orgId, executeDetailLog.getId(), Long.parseLong(syncTotalCount + ""), linesSbSize);
                        syncTotalCount = 0;
                        continue;
                    }
                    catch (Exception e) {
                        CommonUtil.getStackTrace(e);
                        continue;
                    }
                    finally {
                        try {
                            if (s3Out != null) {
                                s3Out.close();
                                s3Out = null;
                                log.info("s3Out close end");
                            } else {
                                log.info("#####s3Out is null");
                            }
                            if (connection != null) {
                                InputStream is = connection.getInputStream();
                                if (is != null) {
                                    is.close();
                                    is = null;
                                }
                                ((HttpURLConnection)connection).disconnect();
                                connection = null;
                            }
                        }
                        catch (Exception e) {
                            log.info("#####s3Out.close exception:");
                            CommonUtil.getStackTrace(e);
                        }
                    }
                }
                Date endTime = new Date();
                log.info("idsSyncSpendTime_billHead {}({}) totalCount:{}, totalPages:{}, spendTime:{}s([{}, {}])", new Object[]{entityName, entityTable.getTableName(), totalCount, totalPages, (endTime.getTime() - startTime.getTime()) / 1000L, DateFormatUtils.format((Date)startTime, (String)"yyyy-MM-dd HH:mm:ss"), DateFormatUtils.format((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss")});
                this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.SUCCESS.getKey(), filePath);
                continue;
            }
            startTime = new Date();
            String entryEntityPk = entityTable.getPkFiledName();
            int totalPages = startPkEndPkMap != null ? startPkEndPkMap.size() : 0;
            QFilter totalCountQFilter = null;
            totalCountQFilter = StringUtils.isEmpty((CharSequence)billHeadMinPk) || StringUtils.isEmpty((CharSequence)billHeadMaxPk) ? (EntityUtils.pkIsNumber(entityTable.getPkFieldType()) ? new QFilter(billHeadPk, ">=", (Object)0).and(billHeadPk, "<=", (Object)0) : new QFilter(billHeadPk, ">=", (Object)"0").and(billHeadPk, "<=", (Object)"0")) : (EntityUtils.pkIsNumber(billHeadPkType) ? new QFilter(billHeadPk, ">=", (Object)Long.parseLong(billHeadMinPk)).and(billHeadPk, "<=", (Object)Long.parseLong(billHeadMaxPk)) : new QFilter(billHeadPk, ">=", (Object)billHeadMinPk).and(billHeadPk, "<=", (Object)billHeadMaxPk));
            if (StringUtils.isNotEmpty((CharSequence)entryEntityPk)) {
                totalCountQFilter.and(entryEntityPk, "is not null", null);
            }
            if (incrementQFilter != null) {
                totalCountQFilter.and(incrementQFilter);
            }
            totalCount = this.count(orm, entityName, billHeadPk + "," + entityTable.getPkFiledName(), totalCountQFilter.toArray());
            log.info("idsSyncPkRange_entryEntity {}({}) billHeadPk:{}, pkFieldName:{} minPk,maxPk : [{}, {}]", new Object[]{entityName, entityTable.getTableName(), billHeadPk, entityTable.getPkFiledName(), billHeadMinPk, billHeadMaxPk});
            ExecuteDetailLog executeDetailLog = this.initDetailLog(orgId, executeLog, entityName, entityTable.getName(), entityTable.getTableName(), totalCount, entityTable.getUploadType(), null, 0L, null, null);
            this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.EXECUTING.getKey(), null);
            TableCount currentTableCount = new TableCount();
            currentTableCount.setDbName(uploadInfo.getDbName());
            currentTableCount.setLogCount(0L);
            currentTableCount.setTblName(entityTable.getTableName());
            currentTableCount.setFilePath(null);
            if (totalPages > 0) {
                Set<String> startPkSet = startPkEndPkMap.keySet();
                List<List<String>> startPkListList = this.getPageStartPkList(startPkSet);
                ArrayList<Future<TableCount>> resultList = new ArrayList<Future<TableCount>>(startPkListList.size());
                for (int threadIndex = 0; threadIndex < startPkListList.size(); ++threadIndex) {
                    log.info("startSubmit threadIndex : {}", (Object)threadIndex);
                    List<String> list = startPkListList.get(threadIndex);
                    if (list == null || list.isEmpty()) continue;
                    Future<TableCount> future = executorService.submit(new UploadTablePageTaskWithResult(entityTable, entityName, executeDetailLog, uploadInfo, tableNameS3PathMap, billHeadPk, billHeadPkType, orgId, selectFields, list, startPkEndPkMap, entryEntityPk, threadIndex, incrementQFilter));
                    resultList.add(future);
                }
                log.info("#####tableName:{}, resultList:{}", (Object)entityTable.getTableName(), (Object)JSON.toJSONString(resultList));
                for (Future future : resultList) {
                    if (future == null) continue;
                    TableCount tc = null;
                    try {
                        tc = (TableCount)future.get();
                    }
                    catch (NullPointerException e) {
                        log.info("#####fs.get NullPointerException : ");
                        CommonUtil.getStackTrace(e);
                    }
                    catch (InterruptedException e) {
                        log.info("#####fs.get InterruptedException : ");
                        CommonUtil.getStackTrace(e);
                    }
                    catch (ExecutionException e) {
                        log.info("#####fs.get ExecutionException : ");
                        CommonUtil.getStackTrace(e);
                    }
                    if (tc == null) continue;
                    currentTableCount.setLogCount(currentTableCount.getLogCount() + tc.getLogCount());
                    String currentFilePath = currentTableCount.getFilePath();
                    String filePath = tc.getFilePath();
                    if (!StringUtils.isNotEmpty((CharSequence)filePath)) continue;
                    currentFilePath = StringUtils.isNotEmpty((CharSequence)currentFilePath) ? currentFilePath + "," + filePath : filePath;
                    currentTableCount.setFilePath(currentFilePath);
                }
                log.info("######executorService shutdown");
            }
            Date endTime = new Date();
            log.info("idsSyncSpendTime_entryEntity {}({}) totalCount:{}, billHeadRangeMap.totalPages:{}, spendTime:{}s([{}, {}])", new Object[]{entityName, entityTable.getTableName(), totalCount, totalPages, (endTime.getTime() - startTime.getTime()) / 1000L, DateFormatUtils.format((Date)startTime, (String)"yyyy-MM-dd HH:mm:ss"), DateFormatUtils.format((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss")});
            this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.SUCCESS.getKey(), currentTableCount.getFilePath());
        }
    }

    private int count(ORM orm, String entityName, String selectFields, QFilter[] filters) {
        return orm.count(this.getClass().getName(), entityName, selectFields, filters);
    }

    private IncrementCondition getIncrementCondition(Long orgId, ExecuteLog executeLog, EntityTable entityTable) {
        ExecuteDetailLog lastSuccessExecuteDetailLog;
        IncrementCondition incrementCondition = null;
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("entityId", (Object)entityTable.getEntityId());
        paramsJo.put("incrementDate", null);
        paramsJo.put("executeLog", (Object)executeLog);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/execute/detail/log/last", paramsJo);
        ExecuteDetailLog executeDetailLog = lastSuccessExecuteDetailLog = baseResult.getData() == null ? null : (ExecuteDetailLog)JSON.toJavaObject((JSON)JSON.parseObject((String)JSON.toJSONString((Object)baseResult.getData())), ExecuteDetailLog.class);
        if (lastSuccessExecuteDetailLog != null && lastSuccessExecuteDetailLog.getUploadType() != null && lastSuccessExecuteDetailLog.getUploadType().intValue() == UploadTypeEnum.INCREMENT.getKey() && StringUtils.isNotEmpty((CharSequence)lastSuccessExecuteDetailLog.getIncrementCondition())) {
            JSONObject incrementConditionJo = JSON.parseObject((String)lastSuccessExecuteDetailLog.getIncrementCondition());
            for (String fieldName : incrementConditionJo.keySet()) {
                if (!StringUtils.isNotEmpty((CharSequence)incrementConditionJo.get((Object)fieldName).toString())) continue;
                String fieldKey = EntityUtils.getFieldKeyByFieldName(fieldName, entityTable);
                incrementCondition = new IncrementCondition();
                incrementCondition.setFieldKey(fieldKey);
                incrementCondition.setFieldValue(incrementConditionJo.get((Object)fieldName).toString());
            }
        }
        log.info("getIncrementCondition : {}", (Object)(incrementCondition != null ? JSON.toJSONString(incrementCondition) : null));
        return incrementCondition;
    }

    private List<List<String>> getPageStartPkList(Set<String> startPkSet) {
        ArrayList<String> startPkList = new ArrayList<String>(startPkSet);
        startPkList.sort(String::compareTo);
        ArrayList<List<String>> startPkListList = new ArrayList<List<String>>(1);
        int pageSize = startPkList.size() / 1;
        for (int i = 0; i < 1; ++i) {
            int fromIndex = i * pageSize;
            int toIndex = (i + 1) * pageSize;
            List subList = null;
            subList = i == 0 ? startPkList.subList(fromIndex, startPkList.size()) : startPkList.subList(fromIndex, toIndex);
            startPkListList.add(subList);
        }
        return startPkListList;
    }

    private void printJvmMemoryUsageInfo(String title) {
        Runtime run = Runtime.getRuntime();
        long max = run.maxMemory();
        long total = run.totalMemory();
        long free = run.freeMemory();
        long usable = max - total + free;
        log.info("idsJvmInfo \u3010{}\u3011 \u6700\u5927\u5185\u5b58: {}MB, \u5df2\u5206\u914d\u5185\u5b58: {}MB, \u5df2\u5206\u914d\u5185\u5b58\u4e2d\u7684\u5269\u4f59\u7a7a\u95f4: {}MB, \u6700\u5927\u53ef\u7528\u5185\u5b58: {}MB", new Object[]{title, max / 0x100000L, total / 0x100000L, free / 0x100000L, usable / 0x100000L});
    }

    @Override
    public void queryData(Long orgId, String subServiceId, String appId, TenantDTO tenantDTO, String taskName, int executeType, int retryType, long runByUserId, String executeId) {
        ThreadPools.executeOnceIncludeRequestContext((String)"\u5220\u9664\u53ef\u80fd\u5b58\u5728\u7684\u91cd\u8bd5\u6267\u884c\u8ba1\u5212", () -> {
            String retryJobId = subServiceId + "_r";
            TaskUtils.deletePlan(retryJobId);
        });
        if (StringUtils.isNotEmpty((CharSequence)executeId)) {
            this.saveAppExecuteNodeLog(executeId, subServiceId, ExecuteStatusEnum.EXECUTING.getKey(), AppExecuteLogNodeEnum.DATA_CALLING.getKey(), subServiceId, null);
        }
        boolean hasExportFail = false;
        long totalRecordCount = 0L;
        List<ModelType> modelTypeList = Services.get(IModelResultService.class).getOnlineModel(orgId, subServiceId);
        if (CollectionUtils.isEmpty(modelTypeList)) {
            log.info("online model is empty.");
            this.saveAppExecuteNodeLog(executeId, subServiceId, ExecuteStatusEnum.FAIL.getKey(), AppExecuteLogNodeEnum.DATA_CALLING.getKey(), subServiceId, null);
            return;
        }
        String exportDate = KDDateFormatUtils.getDateFormat().format(new Date());
        Map<String, ResultExportLog> fmodeltypeidResultTypeResultExportLogMap = Services.get(IResultExportLogService.class).getFmodeltypeidResultTypeResultExportLogMap(orgId, subServiceId, exportDate);
        for (ModelType modelType : modelTypeList) {
            List<ResultType> resultTypeList = modelType.getResultTypeList();
            if (CollectionUtils.isEmpty(resultTypeList)) {
                log.info("online resulttype is empty");
                continue;
            }
            String fmodeltypeid = modelType.getFmodeltypeid();
            for (ResultType resultType : resultTypeList) {
                long recordCount = this.syncModeltypeResulttypeData(orgId, subServiceId, tenantDTO, fmodeltypeid, resultType, appId, taskName, executeType, fmodeltypeidResultTypeResultExportLogMap, retryType);
                if (recordCount == -1L) {
                    hasExportFail = true;
                    continue;
                }
                totalRecordCount += recordCount;
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)taskName, (CharSequence)"unittest_query_data") && totalRecordCount > 0L) {
            hasExportFail = false;
        }
        if (hasExportFail || totalRecordCount <= 0L) {
            this.setRetryQueryTask(orgId, subServiceId, appId, tenantDTO, taskName, runByUserId);
        } else {
            QFilter qFilter = new QFilter(KEY_APPID, "=", (Object)appId);
            qFilter.and("status", "=", (Object)String.valueOf(EnableEnum.AVAIL.getKey()));
            List pkArray = QueryServiceHelper.queryPrimaryKeys((String)"ids_biz_associate_scheme", (QFilter[])qFilter.toArray(), (String)"id", (int)Integer.MAX_VALUE);
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ids_biz_associate_scheme");
            DynamicObject[] schemeDynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkArray.toArray(), (DynamicObjectType)newDynamicObject.getDynamicObjectType());
            this.executeBizAssociateSchemeTask(schemeDynamicObjectArray, orgId, subServiceId, runByUserId, null);
        }
        if (StringUtils.isNotEmpty((CharSequence)executeId)) {
            if (hasExportFail) {
                this.saveAppExecuteNodeLog(executeId, subServiceId, ExecuteStatusEnum.FAIL.getKey(), AppExecuteLogNodeEnum.DATA_CALLING.getKey(), subServiceId, null);
            } else {
                this.saveAppExecuteNodeLog(executeId, subServiceId, ExecuteStatusEnum.SUCCESS.getKey(), AppExecuteLogNodeEnum.DATA_CALLING.getKey(), subServiceId, null);
            }
        }
    }

    private void setRetryQueryTask(Long orgId, String subServiceId, String appId, TenantDTO tenantDTO, String taskName, long runByUserId) {
        Date now = new Date();
        Date retryExecuteTime = KDDateUtils.addMinutes((Date)now, (int)30);
        if (retryExecuteTime.after(KDDateUtils.parseDateTime((String)(KDDateFormatUtils.getDateFormat().format(now) + " 23:00:00")))) {
            log.info("{}\uff0c 23\u70b9\u540e\u62d2\u7edd\u8bbe\u7f6e\u91cd\u8bd5\u4efb\u52a1", (Object)subServiceId);
            return;
        }
        if (!StringUtils.contains((CharSequence)taskName, (CharSequence)"\u91cd\u8bd5\u4efb\u52a1")) {
            taskName = String.format("%s_\u91cd\u8bd5\u4efb\u52a1", taskName);
        }
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
        JobDao jobDao = of.getJobDao();
        ScheduleDao scheduleDao = of.getScheduleDao();
        TaskDao taskDao = of.getTaskDao();
        String jobId = subServiceId + "_r";
        boolean jobIsExist = jobDao.isExist(jobId);
        String planNumber = jobId;
        boolean taskEnable = true;
        boolean planIsExist = scheduleDao.existedByNumber(planNumber);
        boolean jobSaveResult = false;
        HashMap<String, Object> params = new HashMap<String, Object>(12);
        params.put("ctime", new Date().getTime());
        params.put("executeType", ExecuteTypeEnum.CRONTAB.getKey());
        params.put("appId", appId);
        params.put("subServiceId", subServiceId);
        params.put("taskType", TaskTypeEnum.QUERY.getKey());
        params.put("tenantId", tenantDTO.getTenantId());
        params.put("tenantName", tenantDTO.getTenantName());
        params.put("taskName", taskName);
        params.put("orgId", orgId);
        params.put("customerId", tenantDTO.getCustomerId());
        params.put("dbId", tenantDTO.getDataCenterId());
        params.put("retryType", RetryTypeEnum.RETRY.getKey());
        boolean jobIsDeleted = true;
        JobInfo jobInfo = new JobInfo();
        if (jobIsExist) {
            jobIsDeleted = jobDao.delete(jobId);
        }
        if (jobIsDeleted) {
            TaskUtils.fillJobInfo(runByUserId, jobId, params, taskName, taskEnable, jobInfo);
            if (taskEnable) {
                jobSaveResult = jobDao.save(jobInfo);
                log.info("save jobId : {} with result: {}", (Object)jobInfo.getId(), (Object)jobSaveResult);
            }
        } else {
            log.info("delete jobId : {} failed.", (Object)jobId);
        }
        boolean planIsDeleted = true;
        PlanInfo planInfo = new PlanInfo();
        if (planIsExist) {
            taskDao.deleteTaskByJobId(jobId);
            String scheduleId = scheduleDao.getIdByNumber(planNumber);
            planIsDeleted = proxy.deletePlan(scheduleId);
        }
        TaskUtils.asyncDeleteExtendPlan(proxy, scheduleDao, planNumber, taskDao);
        if (planIsDeleted) {
            String executeTime = KDDateFormatUtils.getDateTimeFormat().format(retryExecuteTime);
            String endTime = DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd 23:00:00");
            TaskUtils.fillPlanInfo(executeTime, endTime, 1, ExecuteIntervalUnitEnum.NONE.getKey(), jobId, taskName, planNumber, taskEnable, planInfo, null);
            if (taskEnable) {
                String planId = proxy.createPlan(planInfo);
                log.info("save planNumber : {} with planId: {}", (Object)planNumber, (Object)planId);
            }
        } else {
            log.info("delete planNumber : {} failed.", (Object)planNumber);
        }
    }

    private long syncModeltypeResulttypeData(Long orgId, String subServiceId, TenantDTO tenantDTO, String fmodeltypeid, ResultType resultType, String appId, String taskName, int executeType, Map<String, ResultExportLog> fmodeltypeidResultTypeResultExportLogMap, int retryType) {
        long recordCount = 0L;
        String resultTypeId = resultType.getId();
        String fmodeltypeidResultTypeId = StringUtils.isEmpty((CharSequence)fmodeltypeid) ? resultTypeId : fmodeltypeid + "__" + resultTypeId;
        ResultExportLog resultExportLog = fmodeltypeidResultTypeResultExportLogMap.get(fmodeltypeidResultTypeId);
        int executeStatus = ExecuteStatusEnum.FAIL.getKey();
        long totalCount = 0L;
        String filePaths = "";
        if (resultExportLog != null) {
            executeStatus = resultExportLog.getExecuteStatus();
            totalCount = resultExportLog.getTotalCount();
            filePaths = resultExportLog.getFilePaths();
        }
        ExecuteLog executeLog = this.initExecuteLog(orgId, subServiceId, null, TaskTypeEnum.QUERY.getKey(), tenantDTO.getTenantName(), resultTypeId, appId, taskName, executeType, retryType, fmodeltypeid);
        this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.EXECUTING.getKey(), null);
        ExecuteDetailLog executeDetailLog = this.initDetailLog(orgId, executeLog, null, null, "T_IDS_RESULT", totalCount, UploadTypeEnum.ALL.getKey(), null, 0L, null, filePaths);
        if (resultExportLog == null) {
            this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.FAIL.getKey(), "\u65e0\u5bfc\u51fa\u65e5\u5fd7");
            this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.FAIL.getKey(), filePaths);
            return -1L;
        }
        if (executeStatus == ExecuteStatusEnum.FAIL.getKey()) {
            this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.FAIL.getKey(), resultExportLog.getFailMsg());
            this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.FAIL.getKey(), filePaths);
            return -1L;
        }
        if (StringUtils.isEmpty((CharSequence)filePaths)) {
            log.info("subServiceId:{}, fmodeltypeid:{}, resultType:{}, ResultExportLog filePaths is empty.", new Object[]{subServiceId, fmodeltypeid, resultTypeId});
            this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.SUCCESS.getKey(), null);
            this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.SUCCESS.getKey(), null);
            return 0L;
        }
        if (resultExportLog.getExecuteStatus().intValue() == ExecuteStatusEnum.SUCCESS.getKey()) {
            this.clearHistoryDataWithPolicy(appId, fmodeltypeid, resultType);
            this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.EXECUTING.getKey(), filePaths);
            List<String> filePathList = Arrays.asList(StringUtils.split((String)filePaths, (String)","));
            for (String s3FilePath : filePathList) {
                s3FilePath = StringUtils.startsWithIgnoreCase((CharSequence)s3FilePath, (CharSequence)"/") ? s3FilePath.substring(1) : s3FilePath;
                try {
                    boolean useMock;
                    String modelResultData = "";
                    JSONObject downloadUrlParamsJo = new JSONObject();
                    downloadUrlParamsJo.put("path", (Object)s3FilePath);
                    downloadUrlParamsJo.put("tenantId", (Object)tenantDTO.getTenantId());
                    downloadUrlParamsJo.put("objectType", (Object)UploadLocationEnum.S3.getId());
                    log.info("downloadUrlParamsJo : {}", (Object)JSON.toJSONString((Object)downloadUrlParamsJo));
                    BaseResult downloadUrlBaseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/object/auth/dowload/path", downloadUrlParamsJo);
                    if (downloadUrlBaseResult != null && downloadUrlBaseResult.getErrcode() == 0) {
                        JSONObject downloadUrlDataJo = downloadUrlBaseResult.getDataAsJSONObject();
                        String s3Url = downloadUrlDataJo.getString("downLoadPath");
                        if (StringUtils.isEmpty((CharSequence)s3Url)) {
                            log.info("#####S3 result file {} downloadUrl [{}] is empty.", (Object)s3FilePath, (Object)s3Url);
                            continue;
                        }
                        useMock = StringUtils.equalsIgnoreCase((CharSequence)s3Url, (CharSequence)"https://bj2-api.kingdee.com/dap/get");
                        if (useMock) {
                            modelResultData = "1\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_result_cosmic\u0001\u00012023-05-15 07:54:21\u00012023-05-15 07:54:21\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"fbosuserid\":\"13466739\",\"fbrand1level\":\"\",\"fbrand2level\":\"\",\"fbrand3level\":\"\",\"fsupplier_fid\":\"1110082709432067072\",\"fbase1level\":\"1668127831567151104\",\"fbase2level\":\"1668127996965335040\",\"fbase3level\":\"1668128097385361408\",\"funitid_fid\":\"11\",\"fprice\":\"24.9900000000\",\"findicator\":\"fpreqty\",\"fvalue1\":\"10.4800000000\",\"fvalue2\":\"20.5000000000\",\"fvalue3\":\"30.5200000000\",\"fvalue4\":\"40.4500000000\"}]\u000130004\n623237\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"fsape\",\"fvalue_12\":\"100.0000000000\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"100.0000000000\",\"fvalue_8\":\"100.0000000000\",\"fvalue_7\":\"100.0000000000\",\"fvalue_6\":\"100.0000000000\",\"fvalue_5\":\"100.0000000000\",\"fvalue_4\":\"100.0000000000\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"\",\"fvalue1\":\"100.0000000000\",\"fvalue2\":\"100.0000000000\",\"fvalue3\":\"100.0000000000\",\"fvalue4\":\"100.0000000000\"}]\u000130004\n623238\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"factqty\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"4.0000000000\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"4.0000000000\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"4.0000000000\",\"fvalue1\":\"\",\"fvalue2\":\"\",\"fvalue3\":\"\",\"fvalue4\":\"\"}]\u000130004\n623239\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"fadoptqty\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"\",\"fvalue1\":\"\",\"fvalue2\":\"\",\"fvalue3\":\"\",\"fvalue4\":\"\"}]\u000130004\n623240\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"fae\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"4.0000000000\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"4.0000000000\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"4.0000000000\",\"fvalue1\":\"2.4600000000\",\"fvalue2\":\"2.5000000000\",\"fvalue3\":\"2.5400000000\",\"fvalue4\":\"2.5800000000\"}]\u000130004\n623241\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"famount\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"62.0000000000\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"62.0000000000\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"62.0000000000\",\"fvalue1\":\"38.1300000000\",\"fvalue2\":\"38.7500000000\",\"fvalue3\":\"39.3700000000\",\"fvalue4\":\"39.9900000000\"}]\u000130004\n623242\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"fape\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"100.0000000000\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"100.0000000000\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"100.0000000000\",\"fvalue1\":\"\",\"fvalue2\":\"\",\"fvalue3\":\"\",\"fvalue4\":\"\"}]\u000130004\n623243\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"favgprice\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"15.5000000000\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"15.5000000000\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"15.5000000000\",\"fvalue1\":\"15.5000000000\",\"fvalue2\":\"15.5000000000\",\"fvalue3\":\"15.5000000000\",\"fvalue4\":\"15.5000000000\"}]\u000130004\n623244\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"fe\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"-4.0000000000\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"-4.0000000000\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"-4.0000000000\",\"fvalue1\":\"2.4600000000\",\"fvalue2\":\"2.5000000000\",\"fvalue3\":\"2.5400000000\",\"fvalue4\":\"2.5800000000\"}]\u000130004\n623245\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"ffillqty\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"\",\"fvalue1\":\"\",\"fvalue2\":\"\",\"fvalue3\":\"\",\"fvalue4\":\"\"}]\u000130004\n623246\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"fpe\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"-100.0000000000\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"-100.0000000000\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"-100.0000000000\",\"fvalue1\":\"\",\"fvalue2\":\"\",\"fvalue3\":\"\",\"fvalue4\":\"\"}]\u000130004\n623247\u000167aa98be65bb4be0a385b9461540419d\u0001mybic.test\u0001\u0001\u0001znsj001012\u0001forecast_error\u0001\u00012023-05-15 08:03:37\u00012023-05-15 08:03:37\u00011\u0001[{\"fmodeltypeid\":\"znsj001012\",\"forgid_fid\":\"100000\",\"fwarehouseid_fid\":\"1665138455459397632\",\"fcustid_fid\":\"382268993437696000\",\"fmaterialid_fid\":\"601840023184081920\",\"findicator\":\"fpreqty\",\"fvalue_12\":\"\",\"fvalue_11\":\"\",\"fvalue_10\":\"\",\"fvalue_9\":\"\",\"fvalue_8\":\"\",\"fvalue_7\":\"\",\"fvalue_6\":\"\",\"fvalue_5\":\"\",\"fvalue_4\":\"\",\"fvalue_3\":\"\",\"fvalue_2\":\"\",\"fvalue_1\":\"\",\"fvalue1\":\"2.4600000000\",\"fvalue2\":\"2.5000000000\",\"fvalue3\":\"2.5400000000\",\"fvalue4\":\"2.5800000000\"}]\u000130004";
                            this.setRetryQueryTask(orgId, subServiceId, appId, tenantDTO, taskName, 0L);
                        } else {
                            log.info("#####start request ids_result data from s3 path:{}", (Object)s3FilePath);
                            modelResultData = AwsS3Utils.readS3File(s3Url);
                        }
                    } else {
                        log.info("#####get downloadS3Url fail : {}", (Object)JSON.toJSONString((Object)downloadUrlBaseResult));
                        continue;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)modelResultData)) {
                        ResultExportMetadata resultExportMetadata = (ResultExportMetadata)JSONObject.parseObject((String)resultExportLog.getMetadata(), ResultExportMetadata.class);
                        List<String> modelResultDataLineList = null;
                        long modelResultSize = 0L;
                        if (StringUtils.isNotEmpty((CharSequence)modelResultData)) {
                            modelResultSize = modelResultData.getBytes(StandardCharsets.UTF_8).length;
                            modelResultDataLineList = Arrays.asList(StringUtils.split((String)modelResultData, (String)"\n"));
                            modelResultData = null;
                        }
                        long lineCount = modelResultDataLineList != null ? (long)modelResultDataLineList.size() : 0L;
                        recordCount += lineCount;
                        log.info("#####start syncModelData ... fmodeltypeid:{}, resultTypeId:{}, total:{}", new Object[]{fmodeltypeid, resultTypeId, lineCount});
                        if (modelResultDataLineList != null && lineCount > 0L) {
                            int size;
                            int total = Integer.parseInt(String.valueOf(lineCount));
                            int pages = total % (size = 10000) == 0 ? total / size : total / size + 1;
                            for (int i = 0; i < pages; ++i) {
                                int fromIndex = i * size;
                                int toIndex = i == pages - 1 ? total : fromIndex + size;
                                log.info("##### start insert modelResultData pages : {}/{} fromIndex:{}~toIndex:{} TOTAL:{}", new Object[]{i + 1, pages, fromIndex, toIndex, total});
                                List<String> resultLineList = modelResultDataLineList.subList(fromIndex, toIndex);
                                this.initResultData(resultLineList, resultExportMetadata, useMock);
                            }
                            this.incSyncCount(orgId, executeDetailLog.getId(), lineCount, modelResultSize);
                        }
                    }
                    log.info("#####end request ids_result data from s3 path:{}", (Object)s3FilePath);
                }
                catch (Exception e) {
                    log.info("#####exception01: queryTaskFromDataService exception.");
                    CommonUtil.getStackTrace(e);
                    this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.FAIL.getKey(), "exception01-" + e.getMessage());
                    this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.FAIL.getKey(), null);
                }
            }
            this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.SUCCESS.getKey(), null);
            this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.SUCCESS.getKey(), null);
        } else {
            String failMsg = resultExportLog == null ? "\u65e0\u5bfc\u51fa\u65e5\u5fd7" : resultExportLog.getFailMsg();
            this.updateExecuteStatus(orgId, executeLog.getId(), ExecuteStatusEnum.FAIL.getKey(), failMsg);
            this.updateDetailExecuteStatus(orgId, executeDetailLog.getId(), ExecuteStatusEnum.FAIL.getKey(), null);
        }
        return recordCount;
    }

    private void insertOneMockData2IdsResult(List<String> modelResultDataLineList) {
        if (!CollectionUtils.isEmpty(modelResultDataLineList)) {
            long id = 1252206649351878656L;
            DeleteServiceHelper.delete((String)"ids_result_all", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
            DynamicObject idsResultDo = BusinessDataServiceHelper.newDynamicObject((String)"ids_result_all");
            idsResultDo.set(KEY_MODELID, (Object)"forecast_result");
            idsResultDo.set(KEY_FMODELTYPEID_AS_FSTOREID, (Object)"znsj001010");
            idsResultDo.set(KEY_CREATETIME, (Object)KDDateUtils.now());
            idsResultDo.set("id", (Object)id);
            String[] split = modelResultDataLineList.get(0).split("\u0001", -1);
            String data = split[split.length - 4];
            idsResultDo.set("data_tag", (Object)data);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{idsResultDo});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBizAssociateSchemeTask(DynamicObject[] schemeDynamicObjectArray, Long orgId, String subServiceId, Long userId, RequirePlanPushDownParams requirePlanPushDownParams) {
        if (schemeDynamicObjectArray != null && schemeDynamicObjectArray.length > 0) {
            HashMap<String, List<EntityType>> idEntryTypeListMap = new HashMap<String, List<EntityType>>();
            HashMap<String, List<EntityType>> idSubEntryTypeListMap = new HashMap<String, List<EntityType>>();
            Map<String, Integer> fieldNameFieldTypeMap = new HashMap<String, Integer>();
            HashMap<String, String> quotefieldBizobjfieldMap = new HashMap<String, String>();
            HashMap<String, DynamicObjectCollection> entityIdFieldMappingCollectionMap = new HashMap<String, DynamicObjectCollection>(15);
            Date createTime = KDDateUtils.now();
            for (DynamicObject schemeDynamicObject : schemeDynamicObjectArray) {
                DynamicObjectCollection fieldMappingCollection;
                long startTime = KDDateUtils.now().getTime();
                idEntryTypeListMap.clear();
                idSubEntryTypeListMap.clear();
                fieldNameFieldTypeMap.clear();
                quotefieldBizobjfieldMap.clear();
                entityIdFieldMappingCollectionMap.clear();
                Long pkId = (Long)schemeDynamicObject.getPkValue();
                String schemeNumber = schemeDynamicObject.getString("number");
                String name = schemeDynamicObject.getString("name");
                String fmodeltypeid = schemeDynamicObject.getString("modeltypeid");
                String fmodeltypename = schemeDynamicObject.getString("modeltypename");
                String resulttype = schemeDynamicObject.getString("resulttype");
                String bizobj = schemeDynamicObject.getDynamicObject("bizobj").getString("number");
                String appId = schemeDynamicObject.getString(KEY_APPID);
                DynamicObject salesplanPeriodDo = null;
                DynamicObject requirePlanDo = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)bizobj, (CharSequence)"ids_salesplan")) {
                    salesplanPeriodDo = this.dealSalesplanPeriodBiz(orgId, subServiceId, fmodeltypeid, schemeNumber, userId);
                    if (salesplanPeriodDo == null) {
                        continue;
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)bizobj, (CharSequence)"ids_requireplan_entry")) {
                    if (requirePlanPushDownParams == null) {
                        log.info("[terminated]requirePlanPushDownParams is null, pushdown terminated.");
                        continue;
                    }
                    requirePlanDo = this.dealRequireplanBiz(orgId, subServiceId, schemeDynamicObject, userId, requirePlanPushDownParams, schemeNumber);
                    if (requirePlanDo == null) {
                        log.info("[terminated]A require plan period with the same name : {} already exists, and the sales plan scheme : {} will not be automatically synchronized", (Object)requirePlanPushDownParams.getBillTitle(), (Object)schemeNumber);
                        continue;
                    }
                }
                if ((fieldMappingCollection = schemeDynamicObject.getDynamicObjectCollection("field_mapping_entry")) != null && !fieldMappingCollection.isEmpty()) {
                    for (DynamicObject fieldMappingDynamicObject : fieldMappingCollection) {
                        DynamicObjectCollection tempFieldMappingCollection;
                        String quoteField = fieldMappingDynamicObject.getString("quotefield");
                        String bizobjField = fieldMappingDynamicObject.getString("bizobjfield");
                        quotefieldBizobjfieldMap.put(quoteField, bizobjField);
                        if (StringUtils.isEmpty((CharSequence)quoteField) || StringUtils.isEmpty((CharSequence)bizobjField)) continue;
                        String entityId = bizobj;
                        if (bizobjField.contains(".")) {
                            entityId = bizobjField.split("\\.")[0];
                        }
                        if ((tempFieldMappingCollection = (DynamicObjectCollection)entityIdFieldMappingCollectionMap.get(entityId)) == null) {
                            tempFieldMappingCollection = new DynamicObjectCollection();
                        }
                        tempFieldMappingCollection.add((Object)fieldMappingDynamicObject);
                        entityIdFieldMappingCollectionMap.put(entityId, tempFieldMappingCollection);
                    }
                }
                if (entityIdFieldMappingCollectionMap.isEmpty()) {
                    log.info("executeSchemeTask failed with entityIdFieldMappingCollectionMap is empty. schemeNumber:{}", (Object)schemeNumber);
                    continue;
                }
                QFilter qFilter = new QFilter(KEY_MODELID, "=", (Object)resulttype);
                qFilter.and(KEY_FMODELTYPEID_AS_FSTOREID, "=", (Object)fmodeltypeid);
                qFilter.and(KEY_CREATETIME, ">=", (Object)kd.ai.ids.core.utils.DateUtils.parseDate(DateFormatUtils.format((Date)createTime, (String)"yyyy-MM-dd 00:00:00"), "yyyy-MM-dd HH:mm:ss"));
                qFilter.and(KEY_CREATETIME, "<=", (Object)kd.ai.ids.core.utils.DateUtils.parseDate(DateFormatUtils.format((Date)createTime, (String)"yyyy-MM-dd 23:59:59"), "yyyy-MM-dd HH:mm:ss"));
                DynamicObject singleDynamicObject = BusinessDataServiceHelper.loadSingle((String)"ids_result_all", (String)"data_tag", (QFilter[])qFilter.toArray());
                if (singleDynamicObject == null) {
                    log.info("executeSchemeTask failed with singleDynamicObject is null with fmodeltypeid:{}, resulttype:{}", (Object)fmodeltypeid, (Object)resulttype);
                    continue;
                }
                String datatag = singleDynamicObject.getString("data_tag");
                ArrayList<String> fields = new ArrayList<String>(10);
                Object datatagObj = JSON.parse((String)datatag);
                if (datatagObj instanceof JSONArray) {
                    JSONArray datatagJa = (JSONArray)datatagObj;
                    if (datatagJa.size() > 0) {
                        for (String key : datatagJa.getJSONObject(0).keySet()) {
                            fields.add(key);
                        }
                    }
                } else {
                    log.info("data_tag is not a jsonarray. -> {}", (Object)datatag);
                }
                DynamicObjectCollection headEntityFieldMappingCollection = (DynamicObjectCollection)entityIdFieldMappingCollectionMap.get(bizobj);
                if (headEntityFieldMappingCollection == null || headEntityFieldMappingCollection.isEmpty()) {
                    log.info("executeSchemeTask failed with billHead field is not configured. schemeNumber:{}", (Object)schemeNumber);
                    continue;
                }
                String[] headQuoteFieldArray = new String[headEntityFieldMappingCollection.size()];
                for (int i = 0; i < headEntityFieldMappingCollection.size(); ++i) {
                    String quoteField;
                    DynamicObject fieldMappingDynamicObject = (DynamicObject)headEntityFieldMappingCollection.get(i);
                    headQuoteFieldArray[i] = quoteField = fieldMappingDynamicObject.getString("quotefield");
                }
                DataSet modeltypeResultTypeDataSet = null;
                DataSet dataDataSet = null;
                DataSet filterDataSet = null;
                DataSet groupConcatDataSet = null;
                try {
                    fieldNameFieldTypeMap = this.getFieldNameFieldTypeMap(fieldNameFieldTypeMap, bizobj);
                    RowMeta rowMeta = this.assemblyRowMeta(fields, fieldNameFieldTypeMap, quotefieldBizobjfieldMap);
                    String entityNumber = "ids_result_all";
                    String algoKey = String.format("kd.ai.ids.core.service.impl.TaskExecuteServiceImpl.%s", "executeSchemeTask");
                    Algo algo = Algo.create((String)algoKey);
                    modeltypeResultTypeDataSet = algo.createDataSet(new Input[]{new OrmInput(algoKey, entityNumber, "data_tag", qFilter.toArray())});
                    dataDataSet = this.extractDataToDataSet(rowMeta, modeltypeResultTypeDataSet, headQuoteFieldArray, fields, fieldNameFieldTypeMap, quotefieldBizobjfieldMap);
                    GroupbyDataSet groupbyDataSet = null;
                    String filterCondition = schemeDynamicObject.getString("filtercondition");
                    if (StringUtils.isNotEmpty((CharSequence)filterCondition)) {
                        filterDataSet = dataDataSet.filter(filterCondition);
                        groupbyDataSet = filterDataSet.groupBy(new String[]{KEY_BILL_HEAD_KEY});
                    } else {
                        groupbyDataSet = dataDataSet.groupBy(new String[]{KEY_BILL_HEAD_KEY});
                    }
                    groupConcatDataSet = groupbyDataSet.groupConcat(KEY_BILL_DATA, KEY_BILL_DATA).finish();
                    while (groupConcatDataSet.hasNext()) {
                        Row row = groupConcatDataSet.next();
                        DynamicObject bizobjDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)bizobj);
                        HashMap<String, DynamicObject> billHeadKeyDynamicObjectMap = new HashMap<String, DynamicObject>(10);
                        HashMap<String, DynamicObjectCollection> entryEntityKeyDynamicObjectCollectionMap = new HashMap<String, DynamicObjectCollection>(10);
                        HashMap<String, DynamicObjectCollection> entryEntityKeySubDynamicObjectCollectionMap = new HashMap<String, DynamicObjectCollection>(10);
                        String rowData = row.getString(1);
                        String billDataArrStr = String.format("[%s]", rowData);
                        JSONArray rowJa = JSONArray.parseArray((String)billDataArrStr);
                        for (Object rowObj : rowJa) {
                            JSONObject rowJo = (JSONObject)rowObj;
                            this.assemblySingleBill(idEntryTypeListMap, idSubEntryTypeListMap, fieldNameFieldTypeMap, entityIdFieldMappingCollectionMap, bizobj, headEntityFieldMappingCollection, bizobjDynamicObject, billHeadKeyDynamicObjectMap, entryEntityKeyDynamicObjectCollectionMap, entryEntityKeySubDynamicObjectCollectionMap, RowDataTypeEnum.JSONOBJECT, rowJo);
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)bizobj, (CharSequence)"ids_salesplan")) {
                            this.dealSalesplanBiz(bizobjDynamicObject, salesplanPeriodDo, fmodeltypeid, fmodeltypename, userId);
                        } else if (StringUtils.equalsIgnoreCase((CharSequence)bizobj, (CharSequence)"ids_requireplan_entry") && requirePlanDo != null) {
                            Long requireplanid = (Long)requirePlanDo.getPkValue();
                            this.dealRequireplanEntryBiz(bizobjDynamicObject, requireplanid, userId);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizobjDynamicObject});
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)bizobj, (CharSequence)"ids_salesplan")) {
                        this.updateSalesplanPeriodStatus(salesplanPeriodDo);
                    }
                }
                catch (Exception e) {
                    CommonUtil.getStackTrace(e);
                }
                finally {
                    if (groupConcatDataSet != null) {
                        groupConcatDataSet.close();
                    }
                    if (dataDataSet != null) {
                        dataDataSet.close();
                    }
                    if (modeltypeResultTypeDataSet != null) {
                        modeltypeResultTypeDataSet.close();
                    }
                }
                this.asyncSendMsg(pkId, schemeNumber, name, appId, fmodeltypeid, resulttype, bizobj, schemeDynamicObject);
                long endTime = KDDateUtils.now().getTime();
                long cost = endTime - startTime;
                log.info("executeSchemeTask success with schemeNumber:{}, cost:{}ms", (Object)schemeNumber, (Object)cost);
            }
        }
    }

    private void updateSalesplanPeriodStatus(DynamicObject salesplanPeriodDo) {
        if (salesplanPeriodDo != null) {
            salesplanPeriodDo.set("enable", (Object)BillEnableEnum.ENABLE.getId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salesplanPeriodDo});
        }
    }

    private void dealSalesplanBiz(DynamicObject bizobjDynamicObject, DynamicObject salesplanPeriodDo, String fmodeltypeid, String fmodeltypename, Long userId) {
        bizobjDynamicObject.set("billno", (Object)this.genSalesplanNumber());
        bizobjDynamicObject.set("billstatus", (Object)BillStatusEnum.STAGING.getId());
        bizobjDynamicObject.set("modeltypeid", (Object)fmodeltypeid);
        bizobjDynamicObject.set("modeltypename", (Object)fmodeltypename);
        bizobjDynamicObject.set("billdate", (Object)KDDateUtils.now());
        bizobjDynamicObject.set("periodid", salesplanPeriodDo.getPkValue());
        bizobjDynamicObject.set("issysgen", (Object)YesNoEnum.YES.getKey());
        bizobjDynamicObject.set("creator", (Object)userId);
        DynamicObjectCollection entryDoc = bizobjDynamicObject.getDynamicObjectCollection("ids_salesplan_entry");
        if (entryDoc != null && entryDoc.size() > 0) {
            JSONObject configJo = JSONObject.parseObject((String)salesplanPeriodDo.getString("config_tag"));
            JSONArray fpreperiodsJa = configJo.getJSONArray("fpreperiods");
            for (DynamicObject entryDo : entryDoc) {
                DynamicObjectCollection indicatorSubEntryDoc = entryDo.getDynamicObjectCollection("ids_salesplan_indicator");
                if (indicatorSubEntryDoc != null && indicatorSubEntryDoc.size() > 0) {
                    int subEntryDocSize = indicatorSubEntryDoc.size();
                    DynamicObject preqtyDo = (DynamicObject)indicatorSubEntryDoc.get(0);
                    BigDecimal price = entryDo.getBigDecimal("price");
                    DynamicObject fillqtyDo = indicatorSubEntryDoc.addNew();
                    DynamicObject preamountDo = indicatorSubEntryDoc.addNew();
                    DynamicObject fillamountDo = indicatorSubEntryDoc.addNew();
                    fillqtyDo.set("indicator", (Object)SalesplanIndicatorEnum.FFILLQTY.getId());
                    fillqtyDo.set("seq", (Object)(subEntryDocSize + 1));
                    preamountDo.set("indicator", (Object)SalesplanIndicatorEnum.FPREAMOUNT.getId());
                    preamountDo.set("seq", (Object)(subEntryDocSize + 2));
                    fillamountDo.set("indicator", (Object)SalesplanIndicatorEnum.FFILLAMOUNT.getId());
                    fillamountDo.set("seq", (Object)(subEntryDocSize + 3));
                    if (fpreperiodsJa != null && fpreperiodsJa.size() > 0) {
                        for (int i = 0; i < fpreperiodsJa.size(); ++i) {
                            String valueFieldKey = String.format("%s%s", "value", i + 1);
                            BigDecimal preqty = preqtyDo.getBigDecimal(valueFieldKey, true);
                            BigDecimal amount = preqty.multiply(price).setScale(2, RoundingMode.HALF_UP);
                            fillqtyDo.set(valueFieldKey, (Object)preqty);
                            preamountDo.set(valueFieldKey, (Object)amount);
                            fillamountDo.set(valueFieldKey, (Object)amount);
                        }
                    }
                }
                entryDo.set("ids_salesplan_indicator", (Object)indicatorSubEntryDoc);
            }
        }
        bizobjDynamicObject.set("ids_salesplan_entry", (Object)entryDoc);
    }

    private void dealRequireplanEntryBiz(DynamicObject bizobjDynamicObject, long requireplanid, Long userId) {
        bizobjDynamicObject.set("requireplanid", (Object)requireplanid);
        bizobjDynamicObject.set("billstatus", (Object)BillStatusEnum.STAGING.getId());
        bizobjDynamicObject.set("creator", (Object)userId);
    }

    private DynamicObject dealSalesplanPeriodBiz(Long orgId, String subServiceId, String fmodeltypeid, String schemeNumber, Long userId) {
        String fitemKey = String.format("%s%s", ModelConfigItemEnum.SALES_PLAN_CONFIG_PREFIX.getId(), fmodeltypeid);
        JSONObject dataJo = this.commonService().getModelConfigItem(orgId, subServiceId, fitemKey);
        JSONObject configJo = dataJo.getJSONObject(fitemKey).getJSONObject("fitemvalue");
        String billTitle = configJo.getString("fbilltitle");
        Long existedPeriodId = this.salesPlanPeriodService().getPeriodIdByName(billTitle);
        if (existedPeriodId == null || existedPeriodId <= 0L) {
            DynamicObject salesplanPeriodDo = BusinessDataServiceHelper.newDynamicObject((String)"ids_salesplan_period");
            CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)salesplanPeriodDo.getDataEntityType().getName(), (DynamicObject)salesplanPeriodDo, null);
            String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)salesplanPeriodDo);
            salesplanPeriodDo.set("name", (Object)billTitle);
            salesplanPeriodDo.set("number", (Object)number);
            salesplanPeriodDo.set("status", (Object)BillStatusEnum.AUDITED.getId());
            salesplanPeriodDo.set("enable", (Object)BillEnableEnum.DISABLE.getId());
            salesplanPeriodDo.set("config", (Object)"\u9500\u552e\u8ba1\u5212\u5355\u914d\u7f6e");
            salesplanPeriodDo.set("config_tag", (Object)configJo.toJSONString());
            salesplanPeriodDo.set("creator", (Object)userId);
            Object[] saveDoArr = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salesplanPeriodDo});
            long periodId = 0L;
            if (saveDoArr != null && saveDoArr.length > 0) {
                DynamicObject newSalesplanPeriodDo = (DynamicObject)saveDoArr[0];
                periodId = (Long)newSalesplanPeriodDo.getPkValue();
                newSalesplanPeriodDo.set("masterid", (Object)periodId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salesplanPeriodDo});
            }
            return salesplanPeriodDo;
        }
        log.info("[terminated]A sales plan period with the same name : {} already exists, and the sales plan scheme : {} will not be automatically synchronized", (Object)billTitle, (Object)schemeNumber);
        return null;
    }

    private String genSalesplanNumber() {
        DynamicObject salesplanDo = BusinessDataServiceHelper.newDynamicObject((String)"ids_salesplan");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)salesplanDo.getDataEntityType().getName(), (DynamicObject)salesplanDo, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)salesplanDo);
    }

    private DynamicObject dealRequireplanBiz(Long orgId, String subServiceId, DynamicObject bizAssociateSchemeDo, Long userId, RequirePlanPushDownParams requirePlanPushDownParams, String schemeNumber) {
        QFilter qFilter = new QFilter("periodid", "=", (Object)requirePlanPushDownParams.getPeriodId()).and("billtitle", "=", (Object)requirePlanPushDownParams.getBillTitle());
        boolean exists = QueryServiceHelper.exists((String)"ids_requireplan", (QFilter[])qFilter.toArray());
        if (exists) {
            log.info("[terminated]requireplan title {} existed", (Object)requirePlanPushDownParams.getBillTitle());
            return null;
        }
        String fmodeltypeid = bizAssociateSchemeDo.getString("modeltypeid");
        String fmodeltypename = bizAssociateSchemeDo.getString("modeltypename");
        String fitemKey = String.format("%s%s", ModelConfigItemEnum.REQUIRE_PLAN_CONFIG_PREFIX.getId(), fmodeltypeid);
        JSONObject dataJo = this.commonService().getModelConfigItem(orgId, subServiceId, fitemKey);
        JSONObject configJo = dataJo.getJSONObject(fitemKey).getJSONObject("fitemvalue");
        DynamicObject requirePlanDo = BusinessDataServiceHelper.newDynamicObject((String)"ids_requireplan");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)requirePlanDo.getDataEntityType().getName(), (DynamicObject)requirePlanDo, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)requirePlanDo);
        requirePlanDo.set("billno", (Object)number);
        requirePlanDo.set("billstatus", (Object)BillStatusEnum.STAGING.getId());
        requirePlanDo.set("billdate", (Object)KDDateUtils.now());
        requirePlanDo.set("billtitle", (Object)requirePlanPushDownParams.getBillTitle());
        requirePlanDo.set("periodid", (Object)requirePlanPushDownParams.getPeriodId());
        requirePlanDo.set("modeltypeid", (Object)fmodeltypeid);
        requirePlanDo.set("modeltypename", (Object)fmodeltypename);
        requirePlanDo.set("config", (Object)"\u9700\u6c42\u8ba1\u5212\u5355\u914d\u7f6e");
        requirePlanDo.set("config_tag", (Object)configJo.toJSONString());
        requirePlanDo.set("creator", (Object)userId);
        DynamicObject[] savedRequirePlanDoArr = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requirePlanDo});
        if (savedRequirePlanDoArr != null && savedRequirePlanDoArr.length > 0) {
            requirePlanDo = savedRequirePlanDoArr[0];
        }
        return requirePlanDo;
    }

    private String getBillHeadKeyValue(String[] headQuoteFieldArray, RowDataTypeEnum rowDataTypeEnum, Object rowData) {
        StringBuilder billHeadKeyValueSb = new StringBuilder();
        for (String headQuoteFieldName : headQuoteFieldArray) {
            Row row;
            String value = "";
            if (StringUtils.equalsIgnoreCase((CharSequence)rowDataTypeEnum.getKey(), (CharSequence)RowDataTypeEnum.ROW.getKey())) {
                row = (Row)rowData;
                value = row.getString(headQuoteFieldName);
            } else {
                row = (JSONObject)rowData;
                value = row.getString(headQuoteFieldName);
            }
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            billHeadKeyValueSb.append(value);
        }
        return billHeadKeyValueSb.toString();
    }

    private Map<String, Integer> getFieldNameFieldTypeMap(Map<String, Integer> fieldNameFieldTypeMap, String bizobj) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizobj);
        fieldNameFieldTypeMap.clear();
        if (mainEntityType != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getAlias())) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entry : allEntities.entrySet()) {
                Map fieldMap;
                EntityType entityType = (EntityType)entry.getValue();
                String entityName = entityType.getName();
                ISimpleProperty primaryKey = entityType.getPrimaryKey();
                if (primaryKey != null) {
                    String pkFieldName = primaryKey.getName();
                    if (!(entityType instanceof BillEntityType)) {
                        pkFieldName = String.format("%s.%s", entityName, pkFieldName);
                    }
                    fieldNameFieldTypeMap.put(pkFieldName, primaryKey.getDbType());
                }
                if ((fieldMap = entityType.getFields()) == null || fieldMap.isEmpty()) continue;
                Iterator iterator = fieldMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String fieldName = (String)iterator.next().getKey();
                    IDataEntityProperty dp = (IDataEntityProperty)fieldMap.get(fieldName);
                    if (StringUtils.isEmpty((CharSequence)dp.getAlias())) continue;
                    if (!(entityType instanceof BillEntityType)) {
                        fieldName = String.format("%s.%s", entityName, fieldName);
                    }
                    if (dp instanceof FieldProp) {
                        FieldProp fieldProp = (FieldProp)dp;
                        fieldNameFieldTypeMap.put(fieldName, fieldProp.getDbType());
                        continue;
                    }
                    if (!(dp instanceof BasedataProp)) continue;
                    BasedataProp basedataProp = (BasedataProp)dp;
                    fieldNameFieldTypeMap.put(fieldName, basedataProp.getDbType());
                }
            }
        }
        return fieldNameFieldTypeMap;
    }

    private void assemblySingleBill(Map<String, List<EntityType>> idEntryTypeListMap, Map<String, List<EntityType>> idSubEntryTypeListMap, Map<String, Integer> fieldNameFieldTypeMap, Map<String, DynamicObjectCollection> entityIdFieldMappingCollectionMap, String bizobj, DynamicObjectCollection headEntityFieldMappingCollection, DynamicObject bizobjDynamicObject, Map<String, DynamicObject> billHeadKeyDynamicObjectMap, Map<String, DynamicObjectCollection> entryEntityKeyDynamicObjectCollectionMap, Map<String, DynamicObjectCollection> entryEntityKeySubDynamicObjectCollectionMap, RowDataTypeEnum rowDataTypeEnum, Object rowData) {
        List<EntityType> entryTypeList;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizobj);
        idEntryTypeListMap.clear();
        idSubEntryTypeListMap.clear();
        fieldNameFieldTypeMap.clear();
        if (mainEntityType != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getAlias())) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entry : allEntities.entrySet()) {
                List entityTypeList;
                String parentName;
                Map fieldMap;
                EntityType entityType = (EntityType)entry.getValue();
                String entityName = entityType.getName();
                ISimpleProperty primaryKey = entityType.getPrimaryKey();
                if (primaryKey != null) {
                    String pkFieldName = primaryKey.getName();
                    if (!(entityType instanceof BillEntityType)) {
                        pkFieldName = String.format("%s.%s", entityName, pkFieldName);
                    }
                    fieldNameFieldTypeMap.put(pkFieldName, primaryKey.getDbType());
                }
                if ((fieldMap = entityType.getFields()) != null && !fieldMap.isEmpty()) {
                    Iterator iterator = fieldMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        String fieldName = (String)iterator.next().getKey();
                        IDataEntityProperty dp = (IDataEntityProperty)fieldMap.get(fieldName);
                        if (StringUtils.isEmpty((CharSequence)dp.getAlias())) continue;
                        if (!(entityType instanceof BillEntityType)) {
                            fieldName = String.format("%s.%s", entityName, fieldName);
                        }
                        if (dp instanceof FieldProp) {
                            FieldProp fieldProp = (FieldProp)dp;
                            fieldNameFieldTypeMap.put(fieldName, fieldProp.getDbType());
                            continue;
                        }
                        if (!(dp instanceof BasedataProp)) continue;
                        BasedataProp basedataProp = (BasedataProp)dp;
                        fieldNameFieldTypeMap.put(fieldName, basedataProp.getDbType());
                    }
                }
                if (entityType instanceof SubEntryType) {
                    parentName = entityType.getParent().getName();
                    entityTypeList = idSubEntryTypeListMap.getOrDefault(parentName, new ArrayList());
                    entityTypeList.add(entityType);
                    idSubEntryTypeListMap.put(parentName, entityTypeList);
                    continue;
                }
                if (entityType instanceof EntryType) {
                    parentName = entityType.getParent().getName();
                    entityTypeList = idEntryTypeListMap.getOrDefault(parentName, new ArrayList());
                    entityTypeList.add(entityType);
                    idEntryTypeListMap.put(parentName, entityTypeList);
                    continue;
                }
                if (!(entityType instanceof BillEntityType)) continue;
            }
        }
        StringBuffer billHeadKey = new StringBuffer();
        if (headEntityFieldMappingCollection != null && !headEntityFieldMappingCollection.isEmpty()) {
            String quoteField;
            Set<String> billHeadKeySet = billHeadKeyDynamicObjectMap.keySet();
            for (DynamicObject fieldMappingDynamicObject : headEntityFieldMappingCollection) {
                quoteField = fieldMappingDynamicObject.getString("quotefield");
                String quoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, quoteField);
                billHeadKey = StringUtils.isEmpty((CharSequence)billHeadKey) ? billHeadKey.append(quoteFieldValue) : billHeadKey.append("->").append(quoteFieldValue);
            }
            for (DynamicObject fieldMappingDynamicObject : headEntityFieldMappingCollection) {
                quoteField = fieldMappingDynamicObject.getString("quotefield");
                String bizobjField = fieldMappingDynamicObject.getString("bizobjfield");
                String quoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, quoteField);
                int fieldType = fieldNameFieldTypeMap.get(bizobjField);
                this.setBizObjFieldValue(bizobjDynamicObject, bizobjField, quoteFieldValue, fieldType);
            }
            if (!billHeadKeySet.contains(billHeadKey.toString())) {
                billHeadKeyDynamicObjectMap.put(billHeadKey.toString(), bizobjDynamicObject);
            }
        }
        if ((entryTypeList = idEntryTypeListMap.get(bizobj)) != null && !entryTypeList.isEmpty()) {
            for (EntityType entityType : entryTypeList) {
                List<EntityType> subEntryTypeList;
                Object entryFieldMappingDynamicObject2;
                String entryEntityId = entityType.getName();
                DynamicObjectCollection tempFieldMappingCollection = entityIdFieldMappingCollectionMap.get(entryEntityId);
                DynamicObjectCollection entryentityCollection = bizobjDynamicObject.getDynamicObjectCollection(entryEntityId);
                StringBuffer entryEntityKey = new StringBuffer(String.format("%s%s%s", entryEntityId, "->", billHeadKey));
                if (tempFieldMappingCollection == null || tempFieldMappingCollection.isEmpty()) continue;
                Set<String> entryEntityKeySet = entryEntityKeyDynamicObjectCollectionMap.keySet();
                for (Object entryFieldMappingDynamicObject2 : tempFieldMappingCollection) {
                    String entryQuoteField = entryFieldMappingDynamicObject2.getString("quotefield");
                    String entryQuoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, entryQuoteField);
                    entryEntityKey = entryEntityKey.append(entryEntityKey).append("->").append(entryQuoteFieldValue);
                }
                DynamicObject entryDynamicObject = new DynamicObject(entryentityCollection.getDynamicObjectType());
                entryFieldMappingDynamicObject2 = tempFieldMappingCollection.iterator();
                while (entryFieldMappingDynamicObject2.hasNext()) {
                    DynamicObject entryFieldMappingDynamicObject3 = (DynamicObject)entryFieldMappingDynamicObject2.next();
                    String entryQuoteField = entryFieldMappingDynamicObject3.getString("quotefield");
                    String entryBizobjField = entryFieldMappingDynamicObject3.getString("bizobjfield");
                    String entryQuoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, entryQuoteField);
                    String entryField = entryBizobjField.split("\\.")[1];
                    int fieldType = fieldNameFieldTypeMap.get(entryBizobjField);
                    this.setBizObjFieldValue(entryDynamicObject, entryField, entryQuoteFieldValue, fieldType);
                }
                if (!entryEntityKeySet.contains(entryEntityKey.toString())) {
                    boolean hasSeqColumn;
                    DynamicProperty seqProperty = entityType.getProperty("seq");
                    boolean bl = hasSeqColumn = seqProperty != null;
                    if (hasSeqColumn) {
                        entryDynamicObject.set("seq", (Object)(entryentityCollection.size() + 1));
                    }
                    entryentityCollection.add((Object)entryDynamicObject);
                    entryEntityKeyDynamicObjectCollectionMap.put(entryEntityKey.toString(), entryentityCollection);
                }
                if ((subEntryTypeList = idSubEntryTypeListMap.get(entryEntityId)) == null || subEntryTypeList.isEmpty()) continue;
                for (EntityType subEntityType : subEntryTypeList) {
                    boolean hasSubSeqColumn;
                    String subEentryEntityId = subEntityType.getName();
                    DynamicObjectCollection subTempFieldMappingCollection = entityIdFieldMappingCollectionMap.get(subEentryEntityId);
                    Set<String> entryEntityKeySubSet = entryEntityKeySubDynamicObjectCollectionMap.keySet();
                    DynamicObjectCollection subEntryentityCollection = null;
                    String subEntryEntityKey = String.format("%s%s%s", subEentryEntityId, "->", entryEntityKey);
                    subEntryentityCollection = entryEntityKeySubSet.contains(subEntryEntityKey) ? entryEntityKeySubDynamicObjectCollectionMap.get(subEntryEntityKey) : entryDynamicObject.getDynamicObjectCollection(subEentryEntityId);
                    if (subTempFieldMappingCollection == null || subTempFieldMappingCollection.isEmpty()) continue;
                    DynamicObject subEntryDynamicObject = new DynamicObject(subEntryentityCollection.getDynamicObjectType());
                    for (DynamicObject entryFieldMappingDynamicObject4 : subTempFieldMappingCollection) {
                        String entryQuoteField = entryFieldMappingDynamicObject4.getString("quotefield");
                        String entryBizobjField = entryFieldMappingDynamicObject4.getString("bizobjfield");
                        String entryQuoteFieldValue = this.getQuoteFieldValue(rowDataTypeEnum, rowData, entryQuoteField);
                        String entryField = entryBizobjField.split("\\.")[1];
                        int fieldType = fieldNameFieldTypeMap.get(entryBizobjField);
                        this.setBizObjFieldValue(subEntryDynamicObject, entryField, entryQuoteFieldValue, fieldType);
                    }
                    DynamicProperty subSeqProperty = subEntityType.getProperty("seq");
                    boolean bl = hasSubSeqColumn = subSeqProperty != null;
                    if (hasSubSeqColumn) {
                        subEntryDynamicObject.set("seq", (Object)(subEntryentityCollection.size() + 1));
                    }
                    subEntryentityCollection.add((Object)subEntryDynamicObject);
                    entryEntityKeySubDynamicObjectCollectionMap.put(subEntryEntityKey, subEntryentityCollection);
                }
            }
        }
    }

    private String getQuoteFieldValue(RowDataTypeEnum rowDataTypeEnum, Object rowData, String quoteField) {
        String quoteFieldValue;
        if (StringUtils.equalsIgnoreCase((CharSequence)rowDataTypeEnum.getKey(), (CharSequence)RowDataTypeEnum.ROW.getKey())) {
            Row row = (Row)rowData;
            quoteFieldValue = row.getString(quoteField);
        } else {
            JSONObject row = (JSONObject)rowData;
            quoteFieldValue = row.getString(quoteField);
        }
        return quoteFieldValue;
    }

    private DataSet extractDataToDataSet(final RowMeta rowMeta, DataSet modeltypeResultTypeDataSet, final String[] headQuoteFieldArray, final List<String> fields, final Map<String, Integer> fieldNameFieldTypeMap, final Map<String, String> quotefieldBizobjfieldMap) {
        log.info("start extractDataToDataSet...");
        long st = KDDateUtils.now().getTime();
        DataSet dataDataSet = modeltypeResultTypeDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] objects = null;
                String data = row.getString("data_tag");
                JSONObject dataJo = TaskExecuteServiceImpl.this.getDataAsJsonObject(data);
                if (dataJo != null) {
                    objects = new Object[fields.size() + 2];
                    String billHeadKeyValue = TaskExecuteServiceImpl.this.getBillHeadKeyValue(headQuoteFieldArray, RowDataTypeEnum.JSONOBJECT, dataJo);
                    objects[0] = billHeadKeyValue;
                    objects[1] = dataJo.toJSONString();
                    for (int i = 0; i < fields.size(); ++i) {
                        Object value;
                        String field = (String)fields.get(i);
                        String bizobjField = quotefieldBizobjfieldMap.getOrDefault(field, field);
                        Integer type = (Integer)fieldNameFieldTypeMap.get(bizobjField);
                        if (type == null) {
                            type = 12;
                        }
                        int fieldType = type;
                        Object fieldValue = dataJo.get((Object)field);
                        String fieldValueStr = fieldValue == null ? "" : fieldValue.toString();
                        objects[i + 2] = value = TaskExecuteServiceImpl.this.getBizObjFieldValue(fieldValueStr, fieldType);
                    }
                }
                return objects;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        long et = KDDateUtils.now().getTime();
        long cost = et - st;
        log.info("end extractDataToDataSet cost : {}ms", (Object)cost);
        return dataDataSet;
    }

    private RowMeta assemblyRowMeta(List<String> fields, Map<String, Integer> fieldNameFieldTypeMap, Map<String, String> quotefieldBizobjfieldMap) {
        Field[] fieldArr = new Field[fields.size() + 2];
        fieldArr[0] = new Field(KEY_BILL_HEAD_KEY, (DataType)DataType.StringType);
        fieldArr[1] = new Field(KEY_BILL_DATA, (DataType)DataType.StringType);
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            String bizobjField = quotefieldBizobjfieldMap.getOrDefault(field, field);
            Integer type = fieldNameFieldTypeMap.get(bizobjField);
            if (type == null) {
                type = 12;
            }
            int fieldType = type;
            DataType dataType = this.getAlgoDataType(fieldType);
            fieldArr[i + 2] = new Field(field, dataType);
        }
        RowMeta rowMeta = new RowMeta(fieldArr);
        return rowMeta;
    }

    private JSONObject getDataAsJsonObject(String data) {
        JSONArray dataJa;
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        JSONObject dataJo = null;
        Object dataObj = JSON.parse((String)data);
        if (dataObj instanceof JSONObject) {
            dataJo = JSON.parseObject((String)data);
        } else if (dataObj instanceof JSONArray && !(dataJa = JSON.parseArray((String)data)).isEmpty()) {
            dataJo = dataJa.getJSONObject(0);
        }
        return dataJo;
    }

    private void asyncSendMsg(Long pkId, String number, String name, String appId, String fmodeltypeid, String resulttype, String bizobj, DynamicObject schemeDynamicObject) {
        String region = schemeDynamicObject.getString("region");
        String queue = schemeDynamicObject.getString("queue");
        String eventnumber = schemeDynamicObject.getString("eventnumber");
        String customparams = schemeDynamicObject.getString("customparams");
        boolean receiveNotice = schemeDynamicObject.getBoolean("receivenotice");
        region = StringUtils.trim((String)region);
        queue = StringUtils.trim((String)queue);
        BizAssociateSchemeMsg msg = new BizAssociateSchemeMsg();
        msg.setId(pkId);
        msg.setNumber(number);
        msg.setName(name);
        msg.setAppid(appId);
        msg.setBizobj(bizobj);
        msg.setModeltypeid(fmodeltypeid);
        msg.setResulttype(resulttype);
        msg.setExecstatus(ExecStatusEnum.SUCCESS.getKey());
        msg.setCustomparams(customparams);
        msg.setMsgctime(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("params", (Object)JSON.toJSONString((Object)msg));
        String msgBody = paramsJo.toJSONString();
        if (receiveNotice && StringUtils.isNotEmpty((CharSequence)eventnumber)) {
            ThreadUtils.execute(() -> {
                log.info("send biz event msg with body: {}", (Object)msgBody);
                EventServiceHelper.triggerEventSubscribe((String)eventnumber, (String)msgBody);
            });
        }
        if (StringUtils.isNotEmpty((CharSequence)region) && StringUtils.isNotEmpty((CharSequence)queue)) {
            String finalRegion = region;
            String finalQueue = queue;
            ThreadUtils.execute(() -> {
                log.info("send MQ msg with body: {}", (Object)msgBody);
                MessagePublisher simplePublisher = MQFactory.get().createSimplePublisher(finalRegion, finalQueue);
                simplePublisher.publish(msgBody);
            });
        }
    }

    private void setBizObjFieldValue(DynamicObject bizobjDynamicObject, String bizobjField, String quoteFieldValue, int fieldType) {
        if (AppConstants.INT_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? Integer.valueOf(Integer.parseInt(quoteFieldValue)) : null);
        } else if (AppConstants.LONG_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? Long.valueOf(Long.parseLong(quoteFieldValue)) : null);
        } else if (AppConstants.FLOAT_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, (Object)(StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? new BigDecimal(quoteFieldValue) : null));
        } else if (AppConstants.CHAR_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, (Object)quoteFieldValue);
        } else if (AppConstants.DATE_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? kd.ai.ids.core.utils.DateUtils.parseDate(quoteFieldValue, "yyyy-MM-dd") : null);
        } else if (AppConstants.DATETIME_LIST.contains(fieldType)) {
            bizobjDynamicObject.set(bizobjField, StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? kd.ai.ids.core.utils.DateUtils.parseDate(quoteFieldValue, "yyyy-MM-dd HH:mm:ss") : null);
        }
    }

    private Object getBizObjFieldValue(String quoteFieldValue, int fieldType) {
        Object value = quoteFieldValue;
        if (AppConstants.INT_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? Integer.valueOf(Integer.parseInt(quoteFieldValue)) : null;
        } else if (AppConstants.LONG_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? Long.valueOf(Long.parseLong(quoteFieldValue)) : null;
        } else if (AppConstants.FLOAT_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? new BigDecimal(quoteFieldValue) : null;
        } else if (AppConstants.CHAR_LIST.contains(fieldType)) {
            value = quoteFieldValue;
        } else if (AppConstants.DATE_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? kd.ai.ids.core.utils.DateUtils.parseDate(quoteFieldValue, "yyyy-MM-dd") : null;
        } else if (AppConstants.DATETIME_LIST.contains(fieldType)) {
            value = StringUtils.isNotEmpty((CharSequence)quoteFieldValue) ? kd.ai.ids.core.utils.DateUtils.parseDate(quoteFieldValue, "yyyy-MM-dd HH:mm:ss") : null;
        }
        return value;
    }

    private DataType getAlgoDataType(int fieldType) {
        StringType dataType = DataType.StringType;
        if (AppConstants.INT_LIST.contains(fieldType)) {
            dataType = DataType.IntegerType;
        } else if (AppConstants.LONG_LIST.contains(fieldType)) {
            dataType = DataType.LongType;
        } else if (AppConstants.FLOAT_LIST.contains(fieldType)) {
            dataType = DataType.DoubleType;
        } else if (AppConstants.CHAR_LIST.contains(fieldType)) {
            dataType = DataType.StringType;
        } else if (AppConstants.DATE_LIST.contains(fieldType)) {
            dataType = DataType.DateType;
        } else if (AppConstants.DATETIME_LIST.contains(fieldType)) {
            dataType = DataType.DateType;
        }
        return dataType;
    }

    private void clearHistoryDataWithPolicy(String appId, String fmodeltypeid, ResultType resultType) {
        String resultTypeId = resultType.getId();
        int retentionPeriod = resultType.getRetentionPeriod();
        log.info("start clearHistoryDataWithPolicy - appId:{}, fmodeltypeid:{}, resultTypeId:{}, retentionPeriod:{}", new Object[]{appId, fmodeltypeid, resultTypeId, retentionPeriod});
        int count = 0;
        if (retentionPeriod != RetentionPeriodEnum.ALL.getKey()) {
            if (retentionPeriod == RetentionPeriodEnum.ONE.getKey()) {
                QFilter qFilter = new QFilter(KEY_APPID, "=", (Object)appId);
                if (StringUtils.isNotEmpty((CharSequence)fmodeltypeid)) {
                    qFilter.and(KEY_FMODELTYPEID_AS_FSTOREID, "=", (Object)fmodeltypeid);
                }
                qFilter.and(KEY_MODELID, "=", (Object)resultTypeId);
                count = DeleteServiceHelper.delete((String)"ids_result_all", (QFilter[])qFilter.toArray());
            } else {
                QFilter qFilter = new QFilter(KEY_APPID, "=", (Object)appId);
                if (StringUtils.isNotEmpty((CharSequence)fmodeltypeid)) {
                    qFilter.and(KEY_FMODELTYPEID_AS_FSTOREID, "=", (Object)fmodeltypeid);
                }
                qFilter.and(KEY_MODELID, "=", (Object)resultTypeId);
                Date now = new Date();
                QFilter timeQFilter1 = new QFilter(KEY_CREATETIME, "<", (Object)DateUtils.addDays((Date)now, (int)(-retentionPeriod)));
                QFilter timeQFilter2 = new QFilter(KEY_CREATETIME, ">=", (Object)kd.ai.ids.core.utils.DateUtils.parseDate(DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd 00:00:00"), "yyyy-MM-dd HH:mm:ss"));
                timeQFilter2.and(KEY_CREATETIME, "<=", (Object)kd.ai.ids.core.utils.DateUtils.parseDate(DateFormatUtils.format((Date)now, (String)"yyyy-MM-dd 23:59:59"), "yyyy-MM-dd HH:mm:ss"));
                qFilter.and(timeQFilter1.or(timeQFilter2));
                count = DeleteServiceHelper.delete((String)"ids_result_all", (QFilter[])qFilter.toArray());
            }
        }
        log.info("end clearHistoryDataWithPolicy - appId:{}, fmodeltypeid:{}, resultTypeId:{}, retentionPeriod:{}, deleteCount:{}", new Object[]{appId, fmodeltypeid, resultTypeId, retentionPeriod, count});
    }

    private Boolean incSyncCount(Long orgId, Long executeDetailLogId, Long syncCount, long compressDataSize) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("executeDetailLogId", (Object)executeDetailLogId);
        paramsJo.put("syncCount", (Object)syncCount);
        paramsJo.put("compressDataSize", (Object)compressDataSize);
        BaseResult initLogBaseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/execute/detail/log/inc/count", paramsJo);
        return Boolean.parseBoolean(initLogBaseResult.getData().toString());
    }

    public boolean updateExecuteStatus(Long orgId, Long executeLogId, Integer executeStatus, String failMsg) {
        boolean flag = false;
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("executeLogId", (Object)executeLogId);
        paramsJo.put("executeStatus", (Object)executeStatus);
        paramsJo.put("failMsg", (Object)failMsg);
        BaseResult initLogBaseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/execute/log/update/status", paramsJo);
        if (initLogBaseResult != null && initLogBaseResult.getErrcode().intValue() == BaseResult.SUCCESS.intValue()) {
            flag = Boolean.parseBoolean(initLogBaseResult.getData().toString());
        }
        return flag;
    }

    private boolean updateDetailExecuteStatus(Long orgId, Long executeDetailLogId, Integer executeStatus, String filePath) {
        boolean flag = false;
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("executeDetailLogId", (Object)executeDetailLogId);
        paramsJo.put("executeStatus", (Object)executeStatus);
        paramsJo.put("filePath", (Object)filePath);
        BaseResult initLogBaseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/execute/detail/log/update/status", paramsJo);
        if (initLogBaseResult != null && initLogBaseResult.getErrcode().intValue() == BaseResult.SUCCESS.intValue()) {
            flag = Boolean.parseBoolean(initLogBaseResult.getData().toString());
        }
        return flag;
    }

    private ExecuteDetailLog initDetailLog(Long orgId, ExecuteLog executeLog, String entityId, String entityName, String tableName, long totalCount, int uploadType, String incrementCondition, long compressDataSize, String minIncrementCondition, String filePath) {
        InitExecuteDetailLogQuery query = new InitExecuteDetailLogQuery();
        query.setExecuteLog(executeLog);
        query.setEntityId(entityId);
        query.setEntityName(entityName);
        query.setTableName(tableName);
        query.setTotalCount(totalCount);
        query.setUploadType(uploadType);
        query.setIncrementCondition(incrementCondition);
        query.setCompressDataSize(compressDataSize);
        query.setMinIncrementCondition(minIncrementCondition);
        query.setFilePath(filePath);
        JSONObject paramsJo = JsonUtils.parseObj(query);
        BaseResult initLogBaseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/execute/detail/log/init", paramsJo);
        ExecuteDetailLog executeDetailLog = (ExecuteDetailLog)JSONObject.parseObject((String)JSONObject.toJSONString((Object)initLogBaseResult.getData()), ExecuteDetailLog.class);
        return executeDetailLog;
    }

    private ExecuteLog initExecuteLog(Long orgId, String subServiceId, String modelVersionId, int taskType, String tenantName, String modelId, String appId, String taskName, int executeType, int retryType, String fmodeltypeid) {
        InitExecuteLogQuery query = new InitExecuteLogQuery();
        query.setSubServiceId(subServiceId);
        query.setExecuteIp(null);
        query.setExecutePort(null);
        query.setExecuteType(executeType);
        query.setModelId(modelId);
        query.setModelVersionId(modelVersionId);
        query.setTaskType(taskType);
        query.setClientId(null);
        query.setClientPattern(ClientPatternEnum.S3.getId());
        query.setAppId(appId);
        query.setTenantName(tenantName);
        query.setTaskName(taskName);
        query.setRetryType(retryType);
        query.setFmodeltypeid(fmodeltypeid);
        log.info("start initExecuteLog...");
        JSONObject paramsJo = JsonUtils.parseObj(query);
        BaseResult initLogBaseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/execute/log/init", paramsJo);
        log.info("end initExecuteLog...{}", (Object)JSONObject.toJSONString((Object)initLogBaseResult));
        ExecuteLog executeLog = (ExecuteLog)JSONObject.parseObject((String)JSONObject.toJSONString((Object)initLogBaseResult.getData()), ExecuteLog.class);
        return executeLog;
    }

    public String getUploadS3Url(Long orgId, String uuid, String tenantId, String modelVersionId) {
        JSONObject dataJo;
        String s3Url = "";
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("uuid", (Object)uuid);
        paramsJo.put("tenantId", (Object)tenantId);
        paramsJo.put("modelVersionId", (Object)modelVersionId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/object/auth/upload/path", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null && (dataJo = JsonUtils.parseObj(baseResult.getData())).containsKey((Object)"upload")) {
            s3Url = dataJo.getString("upload");
        }
        return s3Url;
    }

    private void runWork(Long orgId, UploadDbInfo uploadDbInfo, TenantDTO tenantDTO, long runByUserId, int executeType, String subServiceId, String appId) {
        log.info("#####uploadData2Aws uploadDbInfo : {}", (Object)JSONObject.toJSONString((Object)uploadDbInfo));
        JSONObject paramsJo = JsonUtils.parseObj(uploadDbInfo);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/app/customer/task/runwork", paramsJo);
        if (baseResult != null) {
            if (baseResult.getErrcode() == 0) {
                log.info("#####uploadData2Aws uploadDbInfo success");
                if (executeType == ExecuteTypeEnum.MANUAL.getKey()) {
                    this.saveAppExecuteNodeLog(uploadDbInfo.getExecuteId(), subServiceId, ExecuteStatusEnum.SUCCESS.getKey(), AppExecuteLogNodeEnum.DATA_PREPARATION.getKey(), uploadDbInfo.getModelVersionId(), null);
                    TaskUtils.createAppExecuteCheckTask(tenantDTO, runByUserId, orgId, uploadDbInfo.getExecuteId(), uploadDbInfo.getModelVersionId(), appId, subServiceId);
                }
            } else if (executeType == ExecuteTypeEnum.MANUAL.getKey()) {
                this.saveAppExecuteNodeLog(uploadDbInfo.getExecuteId(), subServiceId, ExecuteStatusEnum.FAIL.getKey(), AppExecuteLogNodeEnum.DATA_PREPARATION.getKey(), uploadDbInfo.getModelVersionId(), String.format("\u8c03\u7528%s\u63a5\u53e3\u5931\u8d25:%s", "/ids/ids/app/customer/task/runwork", baseResult.getDescriptionCn()));
            }
        }
    }

    private Map<String, S3UploadTableInfo> getTableNameS3PathMap(UploadInfo uploadInfo) {
        HashMap<String, S3UploadTableInfo> tableNameS3PathMap = new HashMap<String, S3UploadTableInfo>();
        List<S3UploadTableInfo> s3UploadTableInfoList = uploadInfo.getTableInfoList();
        if (!CollectionUtils.isEmpty(s3UploadTableInfoList)) {
            for (S3UploadTableInfo s3UploadTableInfo : s3UploadTableInfoList) {
                tableNameS3PathMap.put(s3UploadTableInfo.getTableName().toLowerCase(), s3UploadTableInfo);
            }
        }
        return tableNameS3PathMap;
    }

    private void initResultData(List<String> resultLineList, ResultExportMetadata resultExportMetadata, boolean useMock) {
        if (CollectionUtils.isEmpty(resultLineList)) {
            log.info("resultLineList is empty");
            return;
        }
        if (CollectionUtils.isEmpty(resultExportMetadata.getColumnDetails())) {
            log.info("columnDetails is empty");
            return;
        }
        List<ColumnDetail> columnDetails = resultExportMetadata.getColumnDetails();
        DynamicObject[] dynamicObjects = new DynamicObject[resultLineList.size()];
        for (int i = 0; i < resultLineList.size(); ++i) {
            String line = resultLineList.get(i);
            List<String> fieldValueList = Arrays.asList(line.split("\u0001", -1));
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ids_result_all");
            dynamicObject.set("id", (Object)ID.genLongId());
            for (int j = 0; j < columnDetails.size(); ++j) {
                ColumnDetail columnDetail = columnDetails.get(j);
                String fieldName = columnDetail.getFieldName();
                fieldName = fieldName.toLowerCase();
                String fieldValue = fieldValueList.get(j);
                if (StringUtils.equalsIgnoreCase((CharSequence)(fieldName = fieldName.replaceAll("_", "")), (CharSequence)"data")) {
                    dynamicObject.set("data", (Object)ResManager.loadKDString((String)"\u6a21\u578b\u9884\u6d4b\u6570\u636e", (String)"TaskExecuteServiceImpl_0", (String)"ai-ids-core", (Object[])new Object[0]));
                    dynamicObject.set("data_tag", (Object)fieldValue);
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"id")) {
                    dynamicObject.set("id", (Object)ID.genLongId());
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)KEY_CREATETIME)) {
                    if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                    if (fieldValue.contains(" ")) {
                        dynamicObject.set(KEY_CREATETIME, (Object)kd.ai.ids.core.utils.DateUtils.parseDate(fieldValue, "yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    dynamicObject.set(KEY_CREATETIME, (Object)kd.ai.ids.core.utils.DateUtils.parseDate(fieldValue + " 00:00:00", "yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"modtime")) {
                    if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                    if (fieldValue.contains(" ")) {
                        dynamicObject.set("modtime", (Object)kd.ai.ids.core.utils.DateUtils.parseDate(fieldValue, "yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    dynamicObject.set("modtime", (Object)kd.ai.ids.core.utils.DateUtils.parseDate(fieldValue + " 00:00:00", "yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                dynamicObject.set(fieldName, (Object)fieldValue);
            }
            if (useMock) {
                dynamicObject.set("modtime", (Object)KDDateUtils.now());
                dynamicObject.set(KEY_CREATETIME, (Object)KDDateUtils.now());
                dynamicObject.set("isenable", (Object)1);
                dynamicObject.set("acqtime", (Object)KDDateFormatUtils.getDateFormat().format(KDDateUtils.now()));
            }
            dynamicObjects[i] = dynamicObject;
        }
        if (dynamicObjects.length > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            log.info("#####save success");
        }
    }

    @Override
    public void syncNeedUpdateTaskList2K3Cloud(TenantDTO tenantDTO, long runByUserId, long orgId) {
        List taskQueryDTOList;
        log.info("syncNeedUpdateTaskList2K3Cloud start...");
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("tenantId", (Object)tenantDTO.getTenantId());
        BaseResult baseResult = this.idsServerService().getBaseResultByPost(orgId, "/ids/ids/app/customer/task/querybatch", paramsJo);
        log.info("#####getNeedUpdateTaskList:{}", (Object)JSONObject.toJSONString((Object)baseResult));
        if (baseResult.getData() != null && !CollectionUtils.isEmpty((Collection)(taskQueryDTOList = (List)JSON.parseObject((String)JSONObject.toJSONString((Object)baseResult.getData()), (TypeReference)new TypeReference<List<TaskQueryResult>>(){}, (Feature[])new Feature[0])))) {
            JobDispatcherProxy proxy = new JobDispatcherProxy();
            ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
            JobDao jobDao = of.getJobDao();
            ScheduleDao scheduleDao = of.getScheduleDao();
            TaskDao taskDao = of.getTaskDao();
            for (TaskQueryResult taskQueryDTO : taskQueryDTOList) {
                if (!taskQueryDTO.isMod()) continue;
                String jobId = Objects.equals(taskQueryDTO.getTaskType(), TaskTypeEnum.UPLOAD.getKey()) ? taskQueryDTO.getModelVersionId() : taskQueryDTO.getSubServiceId();
                String taskName = taskQueryDTO.getName();
                boolean jobIsExist = jobDao.isExist(jobId);
                String planNumber = jobId;
                boolean taskEnable = !Objects.equals(taskQueryDTO.getStatus(), TaskStatusEnum.DISABLE.getKey());
                boolean planIsExist = scheduleDao.existedByNumber(planNumber);
                boolean jobSaveResult = false;
                HashMap<String, Object> params = new HashMap<String, Object>(12);
                params.put("ctime", new Date().getTime());
                params.put("executeType", ExecuteTypeEnum.CRONTAB.getKey());
                params.put("appId", taskQueryDTO.getAppId());
                params.put("modelVersionId", taskQueryDTO.getModelVersionId());
                params.put("subServiceId", taskQueryDTO.getSubServiceId());
                params.put("taskType", taskQueryDTO.getTaskType());
                params.put("tenantId", tenantDTO.getTenantId());
                params.put("tenantName", tenantDTO.getTenantName());
                params.put("taskName", taskQueryDTO.getName());
                params.put("orgId", orgId);
                params.put("customerId", tenantDTO.getCustomerId());
                params.put("dbId", tenantDTO.getDataCenterId());
                boolean jobIsDeleted = true;
                JobInfo jobInfo = new JobInfo();
                if (jobIsExist) {
                    jobIsDeleted = jobDao.delete(jobId);
                }
                if (jobIsDeleted) {
                    TaskUtils.fillJobInfo(runByUserId, jobId, params, taskName, taskEnable, jobInfo);
                    if (taskEnable) {
                        jobSaveResult = jobDao.save(jobInfo);
                        log.info("save jobId : {} with result: {}", (Object)jobInfo.getId(), (Object)jobSaveResult);
                    }
                } else {
                    log.info("delete jobId : {} failed.", (Object)jobId);
                }
                boolean planIsDeleted = true;
                PlanInfo planInfo = new PlanInfo();
                if (planIsExist) {
                    taskDao.deleteTaskByJobId(jobId);
                    String scheduleId = scheduleDao.getIdByNumber(planNumber);
                    planIsDeleted = proxy.deletePlan(scheduleId);
                }
                TaskUtils.asyncDeleteExtendPlan(proxy, scheduleDao, planNumber, taskDao);
                if (planIsDeleted) {
                    TaskUtils.fillPlanInfo(taskQueryDTO.getExecuteTime(), taskQueryDTO.getEndTime(), taskQueryDTO.getExecuteInterval(), taskQueryDTO.getExecuteIntervalUnit(), jobId, taskName, planNumber, taskEnable, planInfo, taskQueryDTO.getCron());
                    if (taskEnable) {
                        String planId = proxy.createPlan(planInfo);
                        log.info("save planNumber : {} with planId: {}", (Object)planNumber, (Object)planId);
                    }
                } else {
                    log.info("delete planNumber : {} failed.", (Object)planNumber);
                }
                this.changeTaskMod2False(orgId, tenantDTO.getCustomerId(), taskQueryDTO);
            }
        }
        log.info("syncNeedUpdateTaskList2K3Cloud end.");
    }

    @Override
    public void appExecuteCheck(int executeType, String executeId, long orgId, String subServiceId, String appId, TenantDTO tenantDTO, long runByUserId) {
        boolean canExecuteQueryTask = this.sfStandardService().canExecuteQueryTask(subServiceId);
        if (canExecuteQueryTask) {
            log.info("appExecuteCheck ok ...");
            String planNumber = subServiceId;
            DynamicObject planDo = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (QFilter[])new QFilter("number", "=", (Object)planNumber).toArray());
            String planName = planDo.getString("name");
            TaskUtils.deletePlan(executeId);
            this.taskExecuteService().queryData(orgId, subServiceId, appId, tenantDTO, planName, executeType, RetryTypeEnum.NORMAL.getKey(), runByUserId, executeId);
        } else {
            log.info("{} canExecuteQueryTask : {}", (Object)executeId, (Object)canExecuteQueryTask);
        }
    }

    private void changeTaskMod2False(Long orgId, String customerId, TaskQueryResult taskQueryDTO) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("customerId", (Object)customerId);
        paramsJo.put("tenantId", (Object)taskQueryDTO.getTenantId());
        paramsJo.put("taskType", (Object)taskQueryDTO.getTaskType());
        paramsJo.put("subServiceId", (Object)taskQueryDTO.getSubServiceId());
        paramsJo.put("modelVersionId", (Object)taskQueryDTO.getModelVersionId());
        paramsJo.put("beginTime", (Object)taskQueryDTO.getBeginTime());
        paramsJo.put("endTime", (Object)taskQueryDTO.getEndTime());
        paramsJo.put("description", (Object)taskQueryDTO.getDescription());
        paramsJo.put("executeInterval", (Object)taskQueryDTO.getExecuteInterval());
        paramsJo.put("executeIntervalUnit", (Object)taskQueryDTO.getExecuteIntervalUnit());
        paramsJo.put("executeTime", (Object)taskQueryDTO.getExecuteTime());
        paramsJo.put("name", (Object)taskQueryDTO.getName());
        paramsJo.put("mod", (Object)Boolean.FALSE);
        BaseResult baseResult = this.idsServerService().getBaseResultByPost(orgId, "/ids/ids/app/customer/task/mod", paramsJo);
        log.info("#####IdsServerApiUtils.modTask paramsJo:{}, result :{}", (Object)JSONObject.toJSONString((Object)paramsJo), (Object)JSONObject.toJSONString((Object)baseResult));
    }

    class UploadTablePageTaskWithResult
    implements Callable<TableCount> {
        private final EntityTable entityTable;
        private final String entityNumber;
        private final ExecuteDetailLog executeDetailLog;
        private final UploadInfo uploadInfo;
        private final Map<String, S3UploadTableInfo> tableNameS3PathMap;
        private final String billHeadPk;
        private final String billHeadPkType;
        private final Long orgId;
        private final String selectFields;
        private final List<String> pageStartPkList;
        private final Map<String, String> startPkEndPkMap;
        private final String entryEntityPk;
        private final int threadIndex;
        private final QFilter incrementQFilter;

        public UploadTablePageTaskWithResult(EntityTable entityTable, String entityNumber, ExecuteDetailLog executeDetailLog, UploadInfo uploadInfo, Map<String, S3UploadTableInfo> tableNameS3PathMap, String billHeadPk, String billHeadPkType, Long orgId, String selectFields, List<String> pageStartPkList, Map<String, String> startPkEndPkMap, String entryEntityPk, int threadIndex, QFilter incrementQFilter) {
            this.entityTable = entityTable;
            this.entityNumber = entityNumber;
            this.executeDetailLog = executeDetailLog;
            this.uploadInfo = uploadInfo;
            this.tableNameS3PathMap = tableNameS3PathMap;
            this.billHeadPk = billHeadPk;
            this.billHeadPkType = billHeadPkType;
            this.orgId = orgId;
            this.selectFields = selectFields;
            this.pageStartPkList = pageStartPkList;
            this.startPkEndPkMap = startPkEndPkMap;
            this.entryEntityPk = entryEntityPk;
            this.threadIndex = threadIndex;
            this.incrementQFilter = incrementQFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TableCount call() {
            log.info("start exec threadIndex:{} tableName:{}", (Object)this.threadIndex, (Object)this.entityTable.getTableName());
            TableCount tableCount = new TableCount();
            tableCount.setDbName(this.uploadInfo.getDbName());
            tableCount.setTblName(this.entityTable.getTableName());
            tableCount.setLogCount(0L);
            String filePath = null;
            S3UploadTableInfo s3UploadTableInfo = this.tableNameS3PathMap.get(this.entityTable.getTableName().toLowerCase());
            if (s3UploadTableInfo == null) {
                log.info("##### s3UploadTableInfo is null, tableNameS3PathMap:{}, Exception s3UploadTableInfo:{}", (Object)JSON.toJSONString(this.tableNameS3PathMap), (Object)JSON.toJSONString((Object)s3UploadTableInfo));
                return tableCount;
            }
            int totalPages = this.pageStartPkList.size();
            int pageIndex = 0;
            int syncTotalCount = 0;
            QFilter qFilter = null;
            for (String startPk : this.pageStartPkList) {
                TaskExecuteServiceImpl.this.printJvmMemoryUsageInfo("entryEntityStart threadIndex:" + this.threadIndex + " pageIndex:" + pageIndex + " tableName:" + this.entityTable.getTableName());
                String endPk = this.startPkEndPkMap.get(startPk);
                log.info("idsSyncIndexSummary_entryEntity {}({}) pageIndex:{}/{}", new Object[]{this.entityNumber, this.entityTable.getTableName(), pageIndex, totalPages});
                if (EntityUtils.pkIsNumber(this.billHeadPkType)) {
                    qFilter = pageIndex == 0 && this.threadIndex == 0 ? new QFilter(this.billHeadPk, ">=", (Object)Long.parseLong(startPk)) : new QFilter(this.billHeadPk, ">", (Object)Long.parseLong(startPk));
                    qFilter.and(this.billHeadPk, "<=", (Object)Long.parseLong(endPk));
                } else {
                    qFilter = pageIndex == 0 && this.threadIndex == 0 ? new QFilter(this.billHeadPk, ">=", (Object)startPk) : new QFilter(this.billHeadPk, ">", (Object)startPk);
                    qFilter.and(this.billHeadPk, "<=", (Object)endPk);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.entryEntityPk)) {
                    qFilter.and(this.entryEntityPk, "is not null", null);
                }
                if (this.incrementQFilter != null) {
                    qFilter.and(this.incrementQFilter);
                }
                QFilter[] qFilters = qFilter.toArray();
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)this.entityNumber, (String)this.selectFields, (QFilter[])qFilters, null);
                int dynamicObjectSize = 0;
                if (dynamicObjectCollection != null) {
                    dynamicObjectSize = dynamicObjectCollection.size();
                }
                if (dynamicObjectSize > 0) {
                    syncTotalCount += dynamicObjectSize;
                    StringBuilder lineSb = new StringBuilder();
                    String s3ObjectKey = "";
                    int linesSbSize = 0;
                    URLConnection connection = null;
                    URL url = null;
                    OutputStreamWriter s3Out = null;
                    try {
                        String pageUploadS3Url = TaskExecuteServiceImpl.this.getUploadS3Url(this.orgId, s3UploadTableInfo.getUuid(), this.uploadInfo.getTenantId(), this.uploadInfo.getModelVersionId());
                        s3ObjectKey = AwsS3Utils.getObjectKey(pageUploadS3Url);
                        url = new URL(pageUploadS3Url);
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setDoOutput(true);
                        connection.setRequestProperty("Content-Type", "text/plain");
                        ((HttpURLConnection)connection).setRequestMethod("PUT");
                        connection.setConnectTimeout(86400000);
                        s3Out = new OutputStreamWriter(connection.getOutputStream());
                        for (int i = 0; i < dynamicObjectSize; ++i) {
                            Object fieldObj = null;
                            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                            for (int j = 0; j < this.entityTable.getFields().size(); ++j) {
                                String fieldValue;
                                fieldObj = dynamicObject.get(j);
                                String string = fieldValue = fieldObj != null ? fieldObj.toString() : "";
                                if (j == 0) {
                                    lineSb.append(fieldValue);
                                    continue;
                                }
                                lineSb.append('\u0001').append(fieldValue);
                            }
                            if (i != dynamicObjectSize - 1) {
                                lineSb.append('\n');
                            }
                            linesSbSize += lineSb.length();
                            s3Out.write(lineSb.toString());
                            lineSb.setLength(0);
                        }
                        log.info("idsUploadS3_billHead start {}({}) pageIndex:{}", new Object[]{this.entityNumber, this.entityTable.getTableName(), pageIndex});
                        filePath = StringUtils.isEmpty(filePath) ? s3ObjectKey : filePath + "," + s3ObjectKey;
                        log.info("idsUploadS3_billHead end {}({}) pageIndex:{}", new Object[]{this.entityNumber, this.entityTable.getTableName(), pageIndex});
                        TaskExecuteServiceImpl.this.incSyncCount(this.orgId, this.executeDetailLog.getId(), Long.parseLong(syncTotalCount + ""), linesSbSize);
                        tableCount.setLogCount(tableCount.getLogCount() + (long)syncTotalCount);
                        syncTotalCount = 0;
                    }
                    catch (Exception e) {
                        CommonUtil.getStackTrace(e);
                    }
                    finally {
                        try {
                            if (s3Out != null) {
                                s3Out.close();
                                s3Out = null;
                                log.info("s3Out close end");
                            } else {
                                log.info("#####s3Out is null");
                            }
                            if (connection != null) {
                                InputStream is = connection.getInputStream();
                                if (is != null) {
                                    is.close();
                                    is = null;
                                }
                                ((HttpURLConnection)connection).disconnect();
                                connection = null;
                            }
                        }
                        catch (Exception e) {
                            log.info("#####s3Out.close exception:");
                            CommonUtil.getStackTrace(e);
                        }
                    }
                }
                ++pageIndex;
            }
            tableCount.setFilePath(filePath);
            log.info("end exec threadIndex:{} tableName:{}", (Object)this.threadIndex, (Object)this.entityTable.getTableName());
            return tableCount;
        }
    }
}

