/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.BizApp;
import kd.ai.ids.core.entity.model.BizCloud;
import kd.ai.ids.core.entity.model.Entity;
import kd.ai.ids.core.entity.model.EntityCatalog;
import kd.ai.ids.core.entity.model.EntityTable;
import kd.ai.ids.core.entity.model.Field;
import kd.ai.ids.core.entity.model.TenantExtra;
import kd.ai.ids.core.enumtype.UploadTypeEnum;
import kd.ai.ids.core.enumtype.XtypeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.query.clientserver.EntityCatalogSyncQuery;
import kd.ai.ids.core.query.clientserver.EntityStructSyncQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantModelInfoDTO;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.ITenantModelService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.EntityUtils;
import kd.ai.ids.core.utils.JsonUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import org.apache.commons.lang3.StringUtils;

public class TenantModelServiceImpl
implements ITenantModelService {
    private static final Log log = LogFactory.getLog(ITenantModelService.class);

    @Override
    public TenantModelInfoDTO getTenantModelInfo(Long orgId, String tenantId) {
        TenantModelInfoDTO tenantModelInfoDTO = null;
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("tenantId", (Object)tenantId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/tenant/model/info", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            tenantModelInfoDTO = (TenantModelInfoDTO)baseResult.getDataAsJSONObject().toJavaObject(TenantModelInfoDTO.class);
        }
        return tenantModelInfoDTO;
    }

    @Override
    public void syncTenantModel(Long orgId, String description, String tenantId, String productVersion) {
        EntityCatalog syncEntityCatalog = null;
        List<String> syncEntityIdList = null;
        TenantExtra tenantExtra = Services.get(ITenantService.class).getTenantExtra(tenantId);
        if (tenantExtra != null) {
            String catalogSyncRange = tenantExtra.getCatalogSyncRange();
            String entitySyncRange = tenantExtra.getEntitySyncRange();
            if (StringUtils.isNotEmpty((CharSequence)catalogSyncRange)) {
                syncEntityCatalog = (EntityCatalog)JSONObject.parseObject((String)catalogSyncRange, EntityCatalog.class);
            }
            if (StringUtils.isNotEmpty((CharSequence)entitySyncRange)) {
                syncEntityIdList = Arrays.asList(entitySyncRange.split(","));
            }
        }
        EntityCatalog entityCatalog = this.getBizAppsEntityCatalog(syncEntityCatalog, syncEntityIdList);
        log.info("#####entityCatalog:{}", (Object)JSONObject.toJSONString((Object)entityCatalog));
        EntityCatalogSyncQuery entityCatalogSyncQuery = new EntityCatalogSyncQuery();
        entityCatalogSyncQuery.setTenantId(tenantId);
        entityCatalogSyncQuery.setCatalog(JSONObject.toJSONString((Object)entityCatalog));
        entityCatalogSyncQuery.setDescription(description);
        entityCatalogSyncQuery.setK3CloudVersion(productVersion);
        entityCatalogSyncQuery.setIsUpdate(YesNoEnum.YES.getKey());
        BaseResult entityCatalogSyncResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/entity/catalog/sync", JsonUtils.parseObj(entityCatalogSyncQuery));
        if (entityCatalogSyncResult.getErrcode() == 0) {
            JSONObject catalogResultJo = entityCatalogSyncResult.getData() == null ? null : JsonUtils.parseObj(entityCatalogSyncResult.getData());
            List<EntityTable> entityTableList = EntityUtils.getEntityTableListFromCatalog(entityCatalogSyncQuery.getCatalog());
            if (!CollectionUtils.isEmpty(entityTableList)) {
                for (EntityTable entityTable : entityTableList) {
                    try {
                        EntityCatalog entityEntityCatalog = new EntityCatalog();
                        entityEntityCatalog.setId(entityTable.getEntityId());
                        entityEntityCatalog.setText(entityTable.getName());
                        entityEntityCatalog.setXtype(XtypeEnum.ENTITY.getKey());
                        log.info("syncTenantModel entityId:{}", (Object)entityTable.getEntityId());
                        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityTable.getEntityId());
                        entityEntityCatalog.setParentid(mainEntityType.getAppId());
                        Entity entity = this.getEntityStructByMainEntityType(entityEntityCatalog, mainEntityType);
                        if (entity == null) continue;
                        String tenantModelVersion = catalogResultJo == null ? null : catalogResultJo.getString("tenantModelVersion");
                        EntityStructSyncQuery entityStructSyncQuery = new EntityStructSyncQuery();
                        entityStructSyncQuery.setEntityId(entityTable.getEntityId());
                        entityStructSyncQuery.setK3CloudVersion(productVersion);
                        entityStructSyncQuery.setStruct(JSONObject.toJSONString((Object)entity));
                        entityStructSyncQuery.setTenantId(tenantId);
                        entityStructSyncQuery.setTenantModelVersion(tenantModelVersion);
                        entityStructSyncQuery.setEntityName(entity.getName());
                        entityStructSyncQuery.setTableName(entity.getTableName());
                        entityStructSyncQuery.setAppId(mainEntityType.getAppId());
                        BaseResult entityStructSyncResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/entity/struct/sync", JsonUtils.parseObj(entityStructSyncQuery));
                        log.info("#####entityStructSyncResult : {}", (Object)JSONObject.toJSONString((Object)entityStructSyncResult));
                    }
                    catch (Exception e) {
                        CommonUtil.getStackTrace(e);
                    }
                }
                log.info("#####syncEntityListOver ...");
            }
        }
        log.info("#####entityCatalogSyncResult:{}", (Object)JSONObject.toJSONString((Object)entityCatalogSyncResult));
    }

    private EntityCatalog getBizAppsEntityCatalog(EntityCatalog syncEntityCatalog, List<String> syncEntityIdList) {
        List<EntityCatalog> syncBizCloudList;
        EntityCatalog allEntityCatalog = new EntityCatalog();
        allEntityCatalog.setId("0");
        allEntityCatalog.setParentid("0");
        allEntityCatalog.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TenantModelServiceImpl_0", (String)"ai-ids-core", (Object[])new Object[0]));
        allEntityCatalog.setXtype(XtypeEnum.CATALOG.getKey());
        allEntityCatalog.setEntity(null);
        allEntityCatalog.setChildren(null);
        ArrayList<Object> bizCloudList = new ArrayList<Object>();
        DynamicObjectCollection allBizCloudList = BizCloudServiceHelp.getAllBizClouds();
        if (allBizCloudList != null && !allBizCloudList.isEmpty()) {
            for (DynamicObject bizCloudDo : allBizCloudList) {
                BizCloud bizCloud = new BizCloud();
                bizCloud.setId(bizCloudDo.getString("id"));
                bizCloud.setName(bizCloudDo.getString("name"));
                if (syncEntityCatalog != null) {
                    List bizCloudIdList;
                    List<EntityCatalog> syncBizCloudList2 = syncEntityCatalog.getChildren();
                    if (CollectionUtils.isEmpty(syncBizCloudList2) || !(bizCloudIdList = syncBizCloudList2.stream().map(EntityCatalog::getId).collect(Collectors.toList())).contains(bizCloud.getId())) continue;
                    bizCloudList.add(bizCloud);
                    continue;
                }
                bizCloudList.add(bizCloud);
            }
        }
        HashMap<String, ArrayList<String>> syncCloudIdBizAppIdListMap = new HashMap<String, ArrayList<String>>();
        if (syncEntityCatalog != null && !CollectionUtils.isEmpty(syncBizCloudList = syncEntityCatalog.getChildren())) {
            for (EntityCatalog cloudEntityCatalog : syncBizCloudList) {
                String cloudId = cloudEntityCatalog.getId();
                syncCloudIdBizAppIdListMap.put(cloudId, null);
                List<EntityCatalog> list = cloudEntityCatalog.getChildren();
                if (CollectionUtils.isEmpty(list)) continue;
                for (EntityCatalog syncBizApp : list) {
                    ArrayList<String> bizAppIdList = (ArrayList<String>)syncCloudIdBizAppIdListMap.get(cloudId);
                    if (bizAppIdList == null) {
                        bizAppIdList = new ArrayList<String>();
                    }
                    bizAppIdList.add(syncBizApp.getId());
                    syncCloudIdBizAppIdListMap.put(cloudId, bizAppIdList);
                }
            }
        }
        DynamicObjectCollection allBizAppList = BizAppServiceHelp.getAllBizApps();
        HashMap<String, ArrayList<BizApp>> cloudIdBizAppMap = new HashMap<String, ArrayList<BizApp>>();
        if (allBizAppList != null && !allBizAppList.isEmpty()) {
            ArrayList<BizApp> bizAppList = null;
            for (DynamicObject dynamicObject : allBizAppList) {
                List cloudBizAppIdList;
                Set cloudIdSet;
                String cloudId = dynamicObject.getString("bizcloud");
                String bizAppId = dynamicObject.getString("id");
                if (!CollectionUtils.isEmpty(syncCloudIdBizAppIdListMap) && (!(cloudIdSet = syncCloudIdBizAppIdListMap.keySet()).contains(cloudId) || !CollectionUtils.isEmpty((Collection)(cloudBizAppIdList = (List)syncCloudIdBizAppIdListMap.get(cloudId))) && !cloudBizAppIdList.contains(bizAppId))) continue;
                BizApp bizApp = new BizApp();
                bizApp.setId(bizAppId);
                bizApp.setName(dynamicObject.getString("name"));
                bizApp.setNumber(dynamicObject.getString("number"));
                bizApp.setDescription(dynamicObject.getString("description"));
                bizApp.setCloudId(cloudId);
                bizAppList = (ArrayList<BizApp>)cloudIdBizAppMap.get(cloudId);
                if (bizAppList == null) {
                    bizAppList = new ArrayList<BizApp>();
                }
                bizAppList.add(bizApp);
                cloudIdBizAppMap.put(bizApp.getCloudId(), bizAppList);
            }
        }
        ArrayList<EntityCatalog> bizCloudEntityCatalogList = new ArrayList<EntityCatalog>();
        if (!bizCloudList.isEmpty()) {
            for (BizCloud bizCloud : bizCloudList) {
                EntityCatalog bizCloudCatalog = new EntityCatalog();
                bizCloudCatalog.setXtype(XtypeEnum.CATALOG.getKey());
                bizCloudCatalog.setId(bizCloud.getId());
                bizCloudCatalog.setParentid("0");
                bizCloudCatalog.setText(bizCloud.getName());
                bizCloudCatalog.setEntity(null);
                List bizAppList = (List)cloudIdBizAppMap.get(bizCloud.getId());
                if (bizAppList != null && !bizAppList.isEmpty()) {
                    ArrayList<EntityCatalog> bizAppEntityCatalogList = new ArrayList<EntityCatalog>();
                    for (BizApp bizApp : bizAppList) {
                        EntityCatalog bizAppEntityCatalog = new EntityCatalog();
                        bizAppEntityCatalog.setId(bizApp.getId());
                        bizAppEntityCatalog.setParentid(bizApp.getCloudId());
                        bizAppEntityCatalog.setText(bizApp.getName());
                        bizAppEntityCatalog.setXtype(XtypeEnum.CATALOG.getKey());
                        bizAppEntityCatalog.setEntity(null);
                        List<EntityCatalog> bizObjectList = this.getBizObjectListByAppId(bizAppEntityCatalog.getId(), syncEntityIdList);
                        if (CollectionUtils.isEmpty(bizObjectList)) continue;
                        bizAppEntityCatalog.setChildren(bizObjectList);
                        bizAppEntityCatalogList.add(bizAppEntityCatalog);
                    }
                    if (!CollectionUtils.isEmpty(bizAppEntityCatalogList)) {
                        bizCloudCatalog.setChildren(bizAppEntityCatalogList);
                    }
                }
                if (CollectionUtils.isEmpty(bizCloudCatalog.getChildren())) continue;
                bizCloudEntityCatalogList.add(bizCloudCatalog);
            }
        }
        allEntityCatalog.setChildren(bizCloudEntityCatalogList);
        log.info("#####allEntityCatalog : " + JSONObject.toJSONString((Object)allEntityCatalog));
        return allEntityCatalog;
    }

    private List<EntityCatalog> getBizObjectListByAppId(String bizappid, List<String> syncEntityIdList) {
        DynamicObject[] dynamicObjects = this.getDynamicObjectByAppId(bizappid, syncEntityIdList);
        ArrayList<EntityCatalog> bizObjectEntityCatalogList = new ArrayList<EntityCatalog>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String entityId = dynamicObject.getString("id");
            EntityCatalog bizObjectEntityCatalog = new EntityCatalog();
            bizObjectEntityCatalog.setId(entityId);
            bizObjectEntityCatalog.setParentid(bizappid);
            bizObjectEntityCatalog.setText(dynamicObject.getString("name"));
            bizObjectEntityCatalog.setXtype(XtypeEnum.ENTITY.getKey());
            bizObjectEntityCatalog.setEntity(null);
            bizObjectEntityCatalog.setChildren(null);
            bizObjectEntityCatalogList.add(bizObjectEntityCatalog);
        }
        return bizObjectEntityCatalogList;
    }

    @Override
    public Entity getEntityStructByMainEntityType(EntityCatalog entityCatalog, MainEntityType mainEntityType) {
        Entity entity = null;
        if (mainEntityType != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getAlias())) {
            entity = new Entity();
            Map allEntities = mainEntityType.getAllEntities();
            HashMap<String, EntityType> idBillEntityTypeMap = new HashMap<String, EntityType>();
            HashMap<String, List> idEntryTypeListMap = new HashMap<String, List>();
            HashMap<String, List> idSubEntityTypeListMap = new HashMap<String, List>();
            for (Map.Entry entry : allEntities.entrySet()) {
                List entityTypeList;
                String parentName;
                String key = (String)entry.getKey();
                EntityType entityType = (EntityType)entry.getValue();
                if (entityType instanceof SubEntryType) {
                    log.info("#####" + entityType.getName() + "\u662f\u5b50\u5355\u636e\u4f53");
                    parentName = entityType.getParent().getName();
                    entityTypeList = idSubEntityTypeListMap.getOrDefault(parentName, new ArrayList());
                    entityTypeList.add(entityType);
                    idSubEntityTypeListMap.put(parentName, entityTypeList);
                    continue;
                }
                if (entityType instanceof EntryType) {
                    log.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u4f53");
                    parentName = entityType.getParent().getName();
                    entityTypeList = idEntryTypeListMap.getOrDefault(parentName, new ArrayList());
                    entityTypeList.add(entityType);
                    idEntryTypeListMap.put(parentName, entityTypeList);
                    continue;
                }
                if (!(entityType instanceof BillEntityType)) continue;
                log.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u5934");
                idBillEntityTypeMap.put(key, entityType);
            }
            HashMap<String, List<Field>> entityFieldListMap = new HashMap<String, List<Field>>();
            String displayName = "";
            if (mainEntityType.getDisplayName() != null) {
                displayName = mainEntityType.getDisplayName().getLocaleValue();
            }
            this.getEntityFieldListMap(mainEntityType.getName(), displayName, mainEntityType.getProperties(), entityFieldListMap);
            String keyPrefixId = entityCatalog.getParentid();
            for (Map.Entry entry : idBillEntityTypeMap.entrySet()) {
                String billEntityTypeName = (String)entry.getKey();
                EntityType billEntity = (EntityType)entry.getValue();
                String billEntityKey = keyPrefixId + "_" + billEntityTypeName;
                Field billEntityPkField = this.fillEntity(entityCatalog.getParentid(), billEntityKey, entity, billEntity, entityFieldListMap, "");
                ArrayList<Entity> entryEntityList = new ArrayList<Entity>();
                List entryTypeList = (List)idEntryTypeListMap.get(billEntityTypeName);
                if (!CollectionUtils.isEmpty((Collection)entryTypeList)) {
                    for (EntityType entityType : entryTypeList) {
                        String entryName = entityType.getName();
                        Entity entryEntity = new Entity();
                        String entryEntityKey = keyPrefixId + "_" + billEntityTypeName + "_" + entityType.getName();
                        Field entryEntityPkField = this.fillEntity(entityType.getParent().getName(), entryEntityKey, entryEntity, entityType, entityFieldListMap, entryName);
                        String entityTypeName = entityType.getName();
                        List subEntityTypeList = (List)idSubEntityTypeListMap.get(entityTypeName);
                        ArrayList<Entity> subEntityList = new ArrayList<Entity>();
                        if (!CollectionUtils.isEmpty((Collection)subEntityTypeList)) {
                            for (EntityType subEntityType : subEntityTypeList) {
                                String subEntryName = subEntityType.getName();
                                Entity subEntity = new Entity();
                                String subEntityKey = keyPrefixId + "_" + billEntityTypeName + "_" + entityTypeName + "_" + subEntityType.getName();
                                this.fillEntity(subEntityType.getParent().getName(), subEntityKey, subEntity, subEntityType, entityFieldListMap, entryName + "." + subEntryName);
                                List<Field> subEntityFieldList = subEntity.getFields();
                                Field entryEntityPkFieldNew = (Field)JSON.parseObject((String)JSONObject.toJSONString((Object)entryEntityPkField), Field.class);
                                entryEntityPkFieldNew.setName(entryEntityPkFieldNew.getName().replace("PK", "FK"));
                                subEntityFieldList.add(0, entryEntityPkFieldNew);
                                subEntity.setFields(subEntityFieldList);
                                subEntity.setChildren(new ArrayList<Entity>());
                                if (!StringUtils.isNotEmpty((CharSequence)subEntity.getTableName())) continue;
                                subEntityList.add(subEntity);
                            }
                        }
                        List<Field> entryEntityFieldList = entryEntity.getFields();
                        Field billEntityPkFieldNew = (Field)JSON.parseObject((String)JSONObject.toJSONString((Object)billEntityPkField), Field.class);
                        billEntityPkFieldNew.setName(billEntityPkFieldNew.getName().replace("PK", "FK"));
                        entryEntityFieldList.add(0, billEntityPkFieldNew);
                        entryEntity.setFields(entryEntityFieldList);
                        entryEntity.setChildren(subEntityList);
                        if (!StringUtils.isNotEmpty((CharSequence)entryEntity.getTableName())) continue;
                        entryEntityList.add(entryEntity);
                    }
                }
                entity.setChildren(entryEntityList);
            }
            entityCatalog.setEntity(entity);
        }
        return entity;
    }

    private String getParentEntityId(IDataEntityType dataEntityType) {
        String parentId = "";
        while (dataEntityType != null) {
            String pid = dataEntityType.getName();
            parentId = StringUtils.isEmpty((CharSequence)parentId) ? pid : String.format("%s.%s", pid, parentId);
            dataEntityType = dataEntityType.getParent();
        }
        parentId = !StringUtils.contains((CharSequence)parentId, (CharSequence)".") ? "" : parentId.substring(parentId.indexOf(46) + 1);
        return parentId;
    }

    private void getEntityFieldListMap(String entityName, String entityDisplayName, DataEntityPropertyCollection properties, Map<String, List<Field>> entityFieldListMap) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (IDataEntityProperty dp : properties) {
            String mainName;
            String parentEntityId = this.getParentEntityId(dp.getParent());
            if (dp instanceof EntryProp) {
                EntryProp entry = (EntryProp)dp;
                DynamicObjectType dot = entry.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = dot.getProperties();
                String displayName = "";
                if (entry.getDisplayName() != null) {
                    displayName = entry.getDisplayName().getLocaleValue();
                }
                this.getEntityFieldListMap(entry.getName(), displayName, entryProperties, entityFieldListMap);
                continue;
            }
            if (!this.canShow(dp)) continue;
            String mainKey = dp.getName();
            String pkName = "";
            if (dp.getParent() != null && dp.getParent().getPrimaryKey() != null) {
                pkName = dp.getParent().getPrimaryKey().getName();
            }
            String mainDisplayName = this.getDisplayName(dp);
            if (StringUtils.equalsIgnoreCase((CharSequence)pkName, (CharSequence)mainKey)) {
                if (StringUtils.isNotEmpty((CharSequence)entityDisplayName)) {
                    mainDisplayName = String.format("%s%s", entityDisplayName, mainDisplayName);
                }
                mainDisplayName = String.format("%s %s", mainDisplayName, "PK");
            }
            if (StringUtils.isNotEmpty((CharSequence)parentEntityId)) {
                mainKey = String.format("%s.%s", parentEntityId, mainKey);
            }
            if (StringUtils.isEmpty((CharSequence)(mainName = dp.getAlias()))) {
                mainName = mainKey.replaceAll("\\.", "_");
            }
            if (dp instanceof BasedataProp) {
                MainEntityType dataEntityType;
                String baseEntityName;
                BasedataProp bd = (BasedataProp)dp;
                DynamicObjectType ref = bd.getDynamicComplexPropertyType();
                DataEntityPropertyCollection subPS = ref.getProperties();
                String baseEntityDisplayName = baseEntityName = bd.getBaseEntityId();
                if (StringUtils.isNotEmpty((CharSequence)baseEntityName) && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityName)) != null && dataEntityType.getDisplayName() != null) {
                    baseEntityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                }
                for (IDataEntityProperty subDP : subPS) {
                    if (!this.canShow(subDP)) continue;
                    String fieldType = EntityUtils.getFieldTypeNameByDp(subDP);
                    String subKey = subDP.getName();
                    String subDisplayName = this.getDisplayName(subDP);
                    String subName = subDP.getAlias();
                    if (StringUtils.isEmpty((CharSequence)subName)) {
                        subName = subKey.replaceAll("\\.", "_");
                    }
                    Field field = new Field();
                    field.setEnumKv(null);
                    field.setName(String.format("%s.%s", mainDisplayName, subDisplayName));
                    if (StringUtils.equalsIgnoreCase((CharSequence)"id", (CharSequence)subKey)) {
                        field.setRefEntityId(baseEntityName);
                        field.setRefEntityName(baseEntityDisplayName);
                    }
                    field.setFieldName(String.format("%s.%s", mainKey, subKey));
                    String key = String.format("%s_%s", mainName, subName);
                    field.setKey(key);
                    field.setFieldType(fieldType);
                    field.setBaseFieldKey(null);
                    if (keyList.contains(field.getKey())) continue;
                    fieldList.add(field);
                    keyList.add(field.getKey());
                }
                continue;
            }
            String fieldType = EntityUtils.getFieldTypeNameByDp(dp);
            Field field = new Field();
            field.setEnumKv(null);
            field.setName(mainDisplayName);
            field.setFieldName(mainKey);
            field.setKey(mainName);
            field.setFieldType(fieldType);
            field.setBaseFieldKey(null);
            if (keyList.contains(field.getKey())) continue;
            fieldList.add(field);
            keyList.add(field.getKey());
        }
        entityFieldListMap.put(entityName, fieldList);
    }

    private boolean canShow(IDataEntityProperty dp) {
        return !(dp instanceof DynamicLocaleProperty) && StringUtils.isNotEmpty((CharSequence)dp.getAlias());
    }

    private String getDisplayName(IDataEntityProperty dp) {
        LocaleString displayName = dp.getDisplayName();
        if (displayName != null) {
            return displayName.getLocaleValue();
        }
        return dp.getName();
    }

    private Field fillEntity(String parentId, String entityKey, Entity entity, EntityType entityType, Map<String, List<Field>> entityIdFieldListMap, String rootName) {
        String entityNumber = entityType.getName();
        List<Field> fieldList = entityIdFieldListMap.get(entityNumber);
        String entityName = entityType.getDisplayName().getLocaleValue();
        entity.setId(entityNumber);
        entity.setKey(entityKey);
        entity.setName(entityName);
        entity.setUploadType(UploadTypeEnum.ALL.getKey());
        entity.setIncrementField(null);
        entity.setParentId(parentId);
        Field pkField = this.getPkField(entityType, rootName);
        if (pkField != null) {
            entity.setPkFieldName(pkField.getFieldName());
            entity.setPkFieldType(pkField.getFieldType());
        }
        entity.setTableName(entityType.getAlias());
        entity.setIsFormGroup(0);
        entity.setFields(fieldList);
        entity.setChildren(null);
        return pkField;
    }

    private Field getPkField(EntityType entityType, String rootName) {
        String primaryKey = entityType.getPrimaryKey().getAlias();
        String primaryFieldName = entityType.getPrimaryKey().getName();
        if (StringUtils.isNotEmpty((CharSequence)rootName)) {
            primaryFieldName = rootName + "." + primaryFieldName;
        }
        String pkFieldType = EntityUtils.getFieldTypeNameByDbType(entityType.getPrimaryKey().getDbType());
        Field pkField = new Field();
        pkField.setKey(primaryKey);
        pkField.setBaseFieldKey(null);
        pkField.setEnumKv(null);
        pkField.setFieldName(primaryFieldName);
        pkField.setName(entityType.getDisplayName().getLocaleValue() + " PK");
        pkField.setFieldType(pkFieldType);
        return pkField;
    }

    private DynamicObject[] getDynamicObjectByAppId(String bizappid, List<String> syncEntityIdList) {
        String entityName = "bos_entityobject";
        QFilter qFilter = new QFilter("bizappid", "=", (Object)bizappid).and("tablename", "is not null", null).and("tablename", "!=", (Object)" ");
        if (syncEntityIdList != null && !syncEntityIdList.isEmpty()) {
            qFilter = new QFilter("id", "in", syncEntityIdList).and(qFilter);
        }
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,number,bizappid,tablename,modeltype";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qFilters);
        log.info("#####doList.length=" + dynamicObjects.length);
        return dynamicObjects;
    }
}

