/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import kd.ai.ids.core.cache.AppCache;
import kd.ai.ids.core.cache.SessionCache;
import kd.ai.ids.core.entity.model.TenantExtra;
import kd.ai.ids.core.enumtype.EnableEnum;
import kd.ai.ids.core.enumtype.IdsPermissionEnum;
import kd.ai.ids.core.enumtype.LabelTypeEnum;
import kd.ai.ids.core.query.label.LabelQuery;
import kd.ai.ids.core.query.label.TypeLabelKeys;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.ILabelService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.service.KDDateFormatUtils;

public class TenantServiceImpl
implements ITenantService {
    public ILabelService labelService() {
        return Services.get(ILabelService.class);
    }

    public IIdsServerService idsServer() {
        return Services.get(IIdsServerService.class);
    }

    @Override
    public TenantDTO getTenantDTO(Long orgId, String customerId, String dbId) {
        String cacheKey = "TenantDTO_" + orgId + "/" + customerId + "/" + dbId;
        String cacheData = SessionCache.get().get(cacheKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cacheData)) {
            return (TenantDTO)JSON.parseObject((String)cacheData, TenantDTO.class);
        }
        TenantDTO tenantDTO = null;
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("customerId", (Object)customerId);
        paramsJo.put("dataCenterId", (Object)dbId);
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/ids/tenant/query", paramsJo, 3000);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS) && baseResult.getData() != null) {
            JSONObject data = baseResult.getDataAsJSONObject();
            tenantDTO = (TenantDTO)data.toJavaObject(TenantDTO.class);
            SessionCache.get().put(cacheKey, data.toJSONString(), 5);
        } else if (Objects.equals(baseResult.getErrcode(), BaseResult.SERVICE_UNAVAILABLE) || Objects.equals(baseResult.getErrcode(), BaseResult.NO_PERMISSION)) {
            tenantDTO = new TenantDTO();
            tenantDTO.setIdsPermission(IdsPermissionEnum.UNAVAILABLE.getKey());
        }
        return tenantDTO;
    }

    @Override
    public void clearCache(Long orgId, String customerId, String dbId) {
        String cacheKey = "TenantDTO_" + orgId + "/" + customerId + "/" + dbId;
        AppCache.get().remove(cacheKey);
    }

    @Override
    public TenantExtra getTenantExtra(String tenantId) {
        JSONObject dataJo;
        TenantExtra tenantExtra = null;
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("tenantId", (Object)tenantId);
        BaseResult baseResultByPost = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/tenant/extra/get", paramsJo);
        if (Objects.equals(baseResultByPost.getErrcode(), BaseResult.SUCCESS) && (dataJo = baseResultByPost.getDataAsJSONObject()) != null) {
            tenantExtra = (TenantExtra)JSONObject.parseObject((String)dataJo.toJSONString(), TenantExtra.class);
        }
        return tenantExtra;
    }

    @Override
    public void createTenant(RequestContext rc, String productVersion) {
        IdsParameter idsParameter = Services.get(IIdsParameterService.class).getIdsParameter(rc.getOrgId());
        String authorityClientId = idsParameter.getAuthorityAppId();
        ArrayList<TypeLabelKeys> typeLabelKeysList = new ArrayList<TypeLabelKeys>();
        String platformCode = this.labelService().getPlatformCode();
        String customerLabelType = String.format("%s_customer", platformCode);
        Account account = AccountUtils.getAccountById((String)rc.getAccountId());
        String dataCenterName = account.getAccountName();
        String customerName = rc.getTenantId();
        if (rc.getTenantInfo() != null) {
            customerName = rc.getTenantInfo().getName();
        }
        if (StringUtils.isNotEmpty((CharSequence)dataCenterName)) {
            customerName = dataCenterName;
        }
        String extCustomerId = String.format("%s_%s", rc.getTenantId(), rc.getAccountId());
        this.createCustomerLabel(rc, extCustomerId, customerName, customerLabelType);
        TypeLabelKeys sourceTypeLabelKeys = new TypeLabelKeys();
        sourceTypeLabelKeys.setLabelType(LabelTypeEnum.SOURCE.getKey());
        sourceTypeLabelKeys.setLabelKeyList(Arrays.asList(StringUtils.split((String)platformCode, (String)",")));
        typeLabelKeysList.add(sourceTypeLabelKeys);
        TypeLabelKeys customerTypeLabelKeys = new TypeLabelKeys();
        customerTypeLabelKeys.setLabelType(customerLabelType);
        customerTypeLabelKeys.setLabelKeyList(Collections.singletonList(extCustomerId));
        typeLabelKeysList.add(customerTypeLabelKeys);
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("customerId", (Object)rc.getTenantId());
        paramsJo.put("tenantName", (Object)customerName);
        paramsJo.put("customerName", (Object)customerName);
        paramsJo.put("tenantSource", (Object)platformCode);
        paramsJo.put("tenantDesc", (Object)rc.getClientFullContextPath());
        paramsJo.put("tenantArea", null);
        paramsJo.put("labels", typeLabelKeysList);
        paramsJo.put("dataCenterId", (Object)rc.getAccountId());
        paramsJo.put("dataCenter", (Object)dataCenterName);
        paramsJo.put("authorityClientId", (Object)authorityClientId);
        paramsJo.put("productVersion", (Object)productVersion);
        paramsJo.put("productVersionUtime", (Object)KDDateFormatUtils.getDateTimeFormat().format(new Date()));
        this.idsServer().getBaseResultByPost(rc.getOrgId(), "/ids/ids/tenant/add", paramsJo);
        this.clearCache(rc.getOrgId(), rc.getTenantId(), rc.getAccountId());
    }

    @Override
    public BaseResult agreementGrantAdd(RequestContext rc, String tenantId) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("tenantId", (Object)tenantId);
        paramsJo.put("userName", (Object)String.format("%s(%s)", rc.getUserName(), rc.getCurrUserId()));
        paramsJo.put("platformCode", (Object)this.labelService().getPlatformCode());
        paramsJo.put("lastUserId", (Object)rc.getCurrUserId());
        paramsJo.put("lastUserName", (Object)rc.getUserName());
        BaseResult baseResult = Services.get(IIdsServerService.class).getBaseResultByPost("/ids/clientproxy/agreement/grant/add", paramsJo);
        return baseResult;
    }

    private void createCustomerLabel(RequestContext rc, String extCustomerId, String customerName, String customerLabelType) {
        LabelQuery labelQuery = new LabelQuery();
        labelQuery.setLabelKey(extCustomerId);
        labelQuery.setLabelName(customerName);
        labelQuery.setEnable(EnableEnum.AVAIL.getKey());
        labelQuery.setLabelType(customerLabelType);
        this.labelService().save(rc.getOrgId(), labelQuery);
    }
}

