/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AwsS3Utils {
    private static final Log log = LogFactory.getLog(AwsS3Utils.class);

    private AwsS3Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readS3File(String s3Url) {
        String str = "";
        int retryIndex = 0;
        boolean needRetry = false;
        do {
            if (needRetry && retryIndex > 0) {
                int sleepTimeout = AwsS3Utils.getSleepTime(retryIndex);
                log.info("readS3File:{}, retryIndex:{}, sleep {}s", new Object[]{s3Url, retryIndex, sleepTimeout});
                try {
                    Thread.sleep(sleepTimeout * 1000);
                }
                catch (InterruptedException e) {
                    CommonUtil.getStackTrace(e);
                }
            }
            ++retryIndex;
            InputStream inputStream = null;
            try {
                URL presignedUrl = new URL(s3Url);
                HttpURLConnection connection = (HttpURLConnection)presignedUrl.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(3600000);
                inputStream = connection.getInputStream();
                str = AwsS3Utils.inputStreamToString(inputStream);
                int responseCode = connection.getResponseCode();
                log.info("readS3File:{}, retryIndex:{}, responseCode: {}", new Object[]{s3Url, retryIndex, responseCode});
                needRetry = false;
            }
            catch (Exception e) {
                needRetry = true;
                CommonUtil.getStackTrace(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignore) {
                        needRetry = true;
                    }
                }
            }
        } while (retryIndex < 6 && needRetry);
        return str;
    }

    public static String getObjectKey(String s3Url) {
        if (s3Url.contains("?")) {
            s3Url = s3Url.replaceFirst("https://", "");
            s3Url = s3Url.substring(s3Url.indexOf("/") + 1, s3Url.indexOf("?"));
            try {
                s3Url = URLDecoder.decode(s3Url, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s3Url;
    }

    private static String inputStreamToString(InputStream inputStream) {
        StringBuilder buffer = new StringBuilder();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                if (StringUtils.isNotEmpty((CharSequence)buffer)) {
                    buffer.append("\n").append(str);
                    continue;
                }
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        catch (Exception e) {
            CommonUtil.getStackTrace(e);
        }
        return buffer.toString();
    }

    public static int getSleepTime(int retryIndex) {
        int sleepTime;
        switch (retryIndex) {
            case 0: 
            case 1: {
                sleepTime = 5;
                break;
            }
            case 2: {
                sleepTime = 10;
                break;
            }
            case 3: {
                sleepTime = 30;
                break;
            }
            case 4: {
                sleepTime = 120;
                break;
            }
            default: {
                sleepTime = 240;
            }
        }
        return sleepTime;
    }
}

