/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import com.alibaba.fastjson.JSONArray;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);

    private CommonUtil() {
    }

    public static String getStackTrace(Exception e) {
        String message = e.getMessage();
        log.error("error:" + message, (Throwable)e);
        return message;
    }

    public static JSONArray emptyIfNull(JSONArray array) {
        if (array == null) {
            return new JSONArray();
        }
        return array;
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public static JSONArray nullIfEmpty(JSONArray array) {
        if (array != null && !array.isEmpty()) {
            return array;
        }
        return null;
    }

    public static boolean useMock() {
        String mock;
        boolean useMock;
        String appName = System.getenv("appName");
        if (appName == null) {
            appName = System.getProperty("appName");
        }
        if (appName == null) {
            appName = "";
        }
        useMock = (useMock = "true".equals(mock = System.getProperty("ai.ids.mock"))) || appName.contains("smoke") && (appName.contains("devother") || appName.contains("patchother") || appName.contains("baseline"));
        return useMock;
    }

    public static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                CommonUtil.getStackTrace(e);
            }
        }
    }
}

