/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;

public class ConfigFileUtil {
    private static final Log log = LogFactory.getLog(ConfigFileUtil.class);

    private ConfigFileUtil() {
    }

    public static List<String> loadFile(String fileName) {
        ArrayList<String> fileDataList = new ArrayList<String>();
        try {
            ClassLoader classLoader = ConfigFileUtil.findClassLoader();
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls == null) {
                return fileDataList;
            }
            while (urls.hasMoreElements()) {
                ConfigFileUtil.parseUrl(fileDataList, urls.nextElement());
            }
        }
        catch (Exception e) {
            log.warn("Exception when load  file: " + fileName + ").", (Throwable)e);
        }
        return fileDataList;
    }

    private static void parseUrl(List<String> fileDataList, URL url) {
        log.info("load ids config from " + url);
        try (InputStream is = url.openStream();){
            String fileData = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            fileData = fileData.trim();
            if (!fileData.isEmpty()) {
                fileDataList.add(fileData);
            }
        }
        catch (Exception e) {
            log.warn("Exception when load file: " + url + ") in " + url, (Throwable)e);
        }
    }

    private static ClassLoader findClassLoader() {
        return ConfigFileUtil.class.getClassLoader();
    }
}

