/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.ai.ids.core.enumtype.gpe.TimeGranularityEnum;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    private static final Log log = LogFactory.getLog(DateUtils.class);
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS = "yyyy-MM-dd HH:mm:ss";

    public static Date beginOfMonth(String dateStr) {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cale.setTime(formatter.parse(dateStr));
            cale.add(2, 0);
            cale.set(5, 1);
        }
        catch (ParseException e) {
            CommonUtil.getStackTrace(e);
        }
        return cale.getTime();
    }

    public static Date endOfMonth(String dateStr) {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cale.setTime(formatter.parse(dateStr));
            cale.add(2, 1);
            cale.set(5, 0);
        }
        catch (ParseException e) {
            CommonUtil.getStackTrace(e);
        }
        return cale.getTime();
    }

    public static Date parseDate(String dateStr, String pattern) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)dateStr, (String[])new String[]{pattern});
        }
        catch (ParseException e) {
            CommonUtil.getStackTrace(e);
            return null;
        }
    }

    public static List<String> getNewProductPredictPeriodList(String ffirstdistributiondate) {
        ArrayList<String> dateRangeList = new ArrayList<String>(12);
        Date ffirstdistributiondateDate = KDDateUtils.parseDate((String)ffirstdistributiondate);
        Date theWeekStart = KDDateUtils.getTheWeekStart((int)0, (Date)ffirstdistributiondateDate);
        String formatString = "MM-dd";
        for (int i = 0; i < 12; ++i) {
            Date endDate = KDDateUtils.addDays((Date)theWeekStart, (int)6);
            SimpleDateFormat dateformat = new SimpleDateFormat(formatString);
            dateformat.setTimeZone(KDDateUtils.getTimeZone());
            dateRangeList.add(String.format("%s~%s", dateformat.format(theWeekStart), dateformat.format(endDate)));
            theWeekStart = KDDateUtils.addDays((Date)endDate, (int)1);
        }
        return dateRangeList;
    }

    public static List<Date> dateToWeek(Date mdate) {
        int b = mdate.getDay();
        ArrayList<Date> list = new ArrayList<Date>();
        Long fTime = mdate.getTime() - (long)(b * 24 * 3600000);
        for (int a = 1; a <= 7; ++a) {
            Date fdate = new Date();
            fdate.setTime(fTime + (long)(a * 24 * 3600000));
            list.add(a - 1, fdate);
        }
        return list;
    }

    public static Long getDistanceDays(String str1, String str2) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS);
        long days = 0L;
        try {
            Date one = df.parse(str1);
            Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            days = diff / 86400000L;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return days;
    }

    public static Long getDistanceDays(Date d1, Date d2) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS);
        return DateUtils.getDistanceDays(df.format(d1), df.format(d2));
    }

    public static String formatConsuming(Long ms) {
        if (ms == 0L) {
            return "0\u79d2";
        }
        Integer ss = 1000;
        Integer mi = ss * 60;
        Integer hh = mi * 60;
        Integer dd = hh * 24;
        Long day = ms / (long)dd.intValue();
        Long hour = (ms - day * (long)dd.intValue()) / (long)hh.intValue();
        Long minute = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue()) / (long)mi.intValue();
        Long second = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue()) / (long)ss.intValue();
        Long milliSecond = ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue() - second * (long)ss.intValue();
        StringBuilder sb = new StringBuilder();
        if (day > 0L) {
            sb.append(day).append("\u5929");
        }
        if (hour > 0L) {
            sb.append(hour).append("\u5c0f\u65f6");
        }
        if (minute > 0L) {
            sb.append(minute).append("\u5206");
        }
        if (second > 0L) {
            sb.append(second).append("\u79d2");
        }
        if (second <= 0L && milliSecond > 0L) {
            sb.append(milliSecond).append("\u6beb\u79d2");
        }
        return sb.toString();
    }

    public static List<String> calPredictPeriod(Date predictStartDate, int predictLength, String timeGranularity) {
        ArrayList<String> predictPeroidList = new ArrayList<String>(3);
        DateFormat dateFormat = KDDateFormatUtils.getDateFormat();
        for (int i = 0; i < predictLength; ++i) {
            Date date = null;
            if (StringUtils.equalsIgnoreCase((CharSequence)timeGranularity, (CharSequence)TimeGranularityEnum.FDATE.getId())) {
                date = KDDateUtils.addDays((Date)predictStartDate, (int)i);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)timeGranularity, (CharSequence)TimeGranularityEnum.FWEEK.getId())) {
                date = KDDateUtils.addWeeks((Date)predictStartDate, (int)i);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)timeGranularity, (CharSequence)TimeGranularityEnum.FMONTH.getId())) {
                date = KDDateUtils.addMonths((Date)predictStartDate, (int)i);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)timeGranularity, (CharSequence)TimeGranularityEnum.FYEAR.getId())) {
                date = KDDateUtils.addYears((Date)predictStartDate, (int)i);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)timeGranularity, (CharSequence)TimeGranularityEnum.FHALF_YEAR.getId())) {
                date = KDDateUtils.addMonths((Date)predictStartDate, (int)(6 * i));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)timeGranularity, (CharSequence)TimeGranularityEnum.FQUARTER.getId())) {
                date = KDDateUtils.addMonths((Date)predictStartDate, (int)(3 * i));
            }
            predictPeroidList.add(dateFormat.format(date));
        }
        return predictPeroidList;
    }
}

