/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.ids.core.entity.model.Entity;
import kd.ai.ids.core.entity.model.EntityCatalog;
import kd.ai.ids.core.entity.model.EntityTable;
import kd.ai.ids.core.entity.model.Field;
import kd.ai.ids.core.entity.model.TableField;
import kd.ai.ids.core.enumtype.gpe.FieldRoleEnum;
import kd.ai.ids.core.enumtype.gpe.FieldTypeEnum;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.RegexUtils;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class EntityUtils {
    private static final Log log = LogFactory.getLog(EntityUtils.class);

    private EntityUtils() {
    }

    public static String getCnName(JSONArray nameArray) {
        String cnName = "";
        for (Object nameO : nameArray) {
            JSONObject nameJo = JsonUtils.parseObj(nameO);
            if (nameJo.getIntValue("Key") != 2052) continue;
            cnName = nameJo.getString("Value");
        }
        return cnName;
    }

    public static boolean pkIsNumber(String pkFieldType) {
        return StringUtils.containsIgnoreCase((CharSequence)pkFieldType, (CharSequence)"int") || StringUtils.containsIgnoreCase((CharSequence)pkFieldType, (CharSequence)"long");
    }

    public static String getFieldKeyByFieldName(String fieldName, EntityTable entityTable) {
        String fieldKey = fieldName;
        List<TableField> tableFieldList = entityTable.getFields();
        if (tableFieldList != null && !tableFieldList.isEmpty()) {
            for (TableField tableField : tableFieldList) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)tableField.getFieldName(), (CharSequence)fieldName)) continue;
                fieldKey = tableField.getTableFieldName();
                break;
            }
        }
        return fieldKey;
    }

    public static String getFieldTypeNameByXtype(int xtype) {
        String typeName = "";
        switch (xtype) {
            case 34: 
            case 35: 
            case 36: 
            case 98: 
            case 99: 
            case 165: 
            case 167: 
            case 173: 
            case 175: 
            case 189: 
            case 231: 
            case 239: 
            case 241: {
                typeName = "STRING";
                break;
            }
            case 48: 
            case 52: 
            case 56: 
            case 104: 
            case 127: {
                typeName = "INT";
                break;
            }
            case 59: 
            case 60: 
            case 62: 
            case 106: 
            case 108: 
            case 122: {
                typeName = "NUMBER";
                break;
            }
            case -1: {
                typeName = "BOOLEAN";
                break;
            }
            case -2: {
                typeName = "DATE";
                break;
            }
            case 58: 
            case 61: {
                typeName = "DATETIME";
                break;
            }
            default: {
                typeName = "STRING";
            }
        }
        return typeName;
    }

    public static String getFieldTypeNameByDp(IDataEntityProperty dp) {
        String typeName = FieldTypeEnum.STRING.getId();
        if (dp instanceof BigIntProp || dp instanceof LongProp) {
            typeName = FieldTypeEnum.LONG.getId();
        } else if (dp instanceof IntegerProp) {
            typeName = FieldTypeEnum.INT.getId();
        } else if (dp instanceof DecimalProp) {
            typeName = FieldTypeEnum.DECIMAL.getId();
        } else if (dp instanceof DateProp) {
            typeName = FieldTypeEnum.DATE.getId();
        } else if (dp instanceof DateTimeProp) {
            typeName = FieldTypeEnum.DATETIME.getId();
        } else if (dp instanceof BooleanProp) {
            typeName = FieldTypeEnum.BOOLEAN.getId();
        }
        return typeName;
    }

    public static String getFieldTypeNameByDbType(Integer dbType) {
        if (dbType == null) {
            return "STRING";
        }
        String typeName = "";
        switch (dbType) {
            case 4: {
                typeName = "INT";
                break;
            }
            case -5: {
                typeName = "LONG";
                break;
            }
            case 3: {
                typeName = "DECIMAL";
                break;
            }
            case 1: {
                typeName = "BOOLEAN";
                break;
            }
            case 91: {
                typeName = "DATE";
                break;
            }
            case 93: {
                typeName = "DATETIME";
                break;
            }
            case -9: 
            case 0: 
            case 12: {
                typeName = "STRING";
                break;
            }
            default: {
                typeName = "STRING";
            }
        }
        return typeName;
    }

    public static List<EntityTable> getHeadEntityTableList(EntityCatalog entityCatalog) {
        ArrayList<EntityTable> headEntityTableList = new ArrayList<EntityTable>();
        List<EntityTable> entityTableList = EntityUtils.getEntityTableList(entityCatalog);
        for (EntityTable entityTable : entityTableList) {
            if (!StringUtils.isEmpty((CharSequence)entityTable.getParentEntityId())) continue;
            headEntityTableList.add(entityTable);
        }
        return headEntityTableList;
    }

    public static List<EntityTable> getEntityTableList(EntityCatalog entityCatalog) {
        ArrayList<EntityTable> entityTableList = new ArrayList<EntityTable>();
        List<EntityCatalog> firstChildrenArray = entityCatalog.getChildren();
        if (firstChildrenArray != null) {
            for (EntityCatalog firstO : firstChildrenArray) {
                List<EntityCatalog> secondChildrenArray = firstO.getChildren();
                if (secondChildrenArray == null) continue;
                for (EntityCatalog secondO : secondChildrenArray) {
                    List<EntityCatalog> thirdChildrenArray = secondO.getChildren();
                    if (thirdChildrenArray == null) continue;
                    for (EntityCatalog thirdO : thirdChildrenArray) {
                        log.info(JSONObject.toJSONString((Object)thirdO));
                        if (thirdO == null || thirdO.getEntity() == null) continue;
                        Entity entityJo = thirdO.getEntity();
                        String entityId = entityJo.getId();
                        Integer uploadType = entityJo.getUploadType();
                        String incrementField = entityJo.getIncrementField();
                        String pkFieldName = entityJo.getPkFieldName();
                        String pkFieldType = entityJo.getPkFieldType();
                        int isFormGroup = entityJo.getIsFormGroup();
                        String key = entityJo.getKey();
                        String parentEntityId = "";
                        EntityUtils.getEntityTableListFromEntity(entityTableList, entityJo, entityId, uploadType, incrementField, pkFieldName, pkFieldType, isFormGroup, key, parentEntityId);
                    }
                }
            }
        }
        log.info("#####entryList : {}", (Object)JSONObject.toJSONString(entityTableList));
        return entityTableList;
    }

    private static List<EntityTable> getEntityTableListFromEntity(List<EntityTable> entityTableList, Entity entityJo, String entityId, int uploadType, String incrementField, String pkFieldName, String pkFieldType, int isFormGroup, String key, String parentEntityId) {
        List<Entity> children;
        EntityTable entityTable = new EntityTable();
        entityTable.setEntityId(isFormGroup == 0 ? entityId : entityJo.getId());
        entityTable.setUploadType(uploadType);
        entityTable.setIncrementField(incrementField);
        entityTable.setPkFiledName(pkFieldName);
        entityTable.setPkFieldType(pkFieldType);
        entityTable.setIsFormGroup(isFormGroup);
        entityTable.setKey(key);
        entityTable.setParentEntityId(parentEntityId);
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        List<Field> fieldArray = entityJo.getFields();
        log.info("#####fieldsO:{}", fieldArray);
        if (fieldArray != null && !fieldArray.isEmpty()) {
            for (Field fieldJo : fieldArray) {
                if (fieldJo == null) continue;
                TableField field = new TableField();
                field.setFieldName(fieldJo.getKey());
                field.setFieldType(fieldJo.getFieldType());
                field.setComment(fieldJo.getName());
                field.setTableFieldName(fieldJo.getFieldName());
                fieldList.add(field);
            }
        }
        entityTable.setFields(fieldList);
        entityTable.setName(entityJo.getName());
        entityTable.setTableName(entityJo.getTableName());
        if (!CollectionUtils.isEmpty(fieldList)) {
            entityTableList.add(entityTable);
        }
        if ((children = entityJo.getChildren()) != null && !children.isEmpty()) {
            for (Entity childrenEntityJo : children) {
                pkFieldName = childrenEntityJo.getPkFieldName();
                pkFieldType = childrenEntityJo.getPkFieldType();
                int childrenIsFormGroup = childrenEntityJo.getIsFormGroup();
                String childrenKey = childrenEntityJo.getKey();
                parentEntityId = entityId;
                EntityUtils.getEntityTableListFromEntity(entityTableList, childrenEntityJo, entityId, uploadType, incrementField, pkFieldName, pkFieldType, childrenIsFormGroup, childrenKey, parentEntityId);
            }
        }
        log.info("#####entityList : {}", entityTableList);
        return entityTableList;
    }

    public static List<EntityTable> getEntityTableListFromCatalog(String catalog) {
        ArrayList<EntityTable> entityTableList = new ArrayList<EntityTable>();
        JSONObject entityCatalogJo = JsonUtils.parseObj(catalog);
        JSONArray firstChildrenArray = entityCatalogJo.getJSONArray("children");
        if (firstChildrenArray != null) {
            for (Object firstO : firstChildrenArray) {
                JSONObject firstJo = JsonUtils.parseObj(firstO);
                JSONArray secondChildrenArray = firstJo.getJSONArray("children");
                if (secondChildrenArray == null) continue;
                for (Object secondO : secondChildrenArray) {
                    JSONObject secondJo = JsonUtils.parseObj(secondO);
                    JSONArray thirdChildrenArray = secondJo.getJSONArray("children");
                    if (thirdChildrenArray == null) continue;
                    for (Object thirdO : thirdChildrenArray) {
                        JSONObject thirdJo = JsonUtils.parseObj(thirdO);
                        log.info(JSONObject.toJSONString((Object)thirdJo));
                        if (thirdJo == null) continue;
                        String entityId = thirdJo.getString("id");
                        String name = thirdJo.getString("text");
                        EntityTable entityTable = new EntityTable();
                        entityTable.setEntityId(entityId);
                        entityTable.setName(name);
                        entityTableList.add(entityTable);
                    }
                }
            }
        }
        String entryList = JSONObject.toJSONString(entityTableList);
        log.info("#####entryList : {}", (Object)entryList);
        return entityTableList;
    }

    public static String getCommentFromEnumKv(Map<String, Object> enumKvJo) {
        StringBuilder comment = new StringBuilder();
        if (enumKvJo != null) {
            for (Map.Entry<String, Object> entry : enumKvJo.entrySet()) {
                String item = entry.getKey() + "-" + entry.getValue();
                if (comment.length() > 0) {
                    comment.append(' ');
                }
                comment.append(item);
            }
        }
        return comment.toString();
    }

    public static String getFieldRoleByFieldType(String fieldType) {
        String fieldRole = FieldRoleEnum.DIM.getId();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldType)) {
            if (fieldType.equalsIgnoreCase(FieldTypeEnum.DATE.getId()) || fieldType.equalsIgnoreCase(FieldTypeEnum.DATETIME.getId())) {
                fieldRole = FieldRoleEnum.TIME.getId();
            } else if (fieldType.equalsIgnoreCase(FieldTypeEnum.INT.getId()) || fieldType.equalsIgnoreCase(FieldTypeEnum.DECIMAL.getId())) {
                fieldRole = FieldRoleEnum.METRIC.getId();
            } else if (fieldType.equalsIgnoreCase(FieldTypeEnum.LONG.getId()) || fieldType.equalsIgnoreCase(FieldTypeEnum.STRING.getId()) || fieldType.equalsIgnoreCase(FieldTypeEnum.BOOLEAN.getId())) {
                fieldRole = FieldRoleEnum.DIM.getId();
            }
        }
        return fieldRole;
    }

    public static String getFieldTypeByFieldValue(String fieldValue) {
        String fieldType = FieldTypeEnum.STRING.getId();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldValue)) {
            if (RegexUtils.isInt(fieldValue)) {
                fieldType = FieldTypeEnum.INT.getId();
            } else if (RegexUtils.isLong(fieldValue)) {
                fieldType = FieldTypeEnum.LONG.getId();
            } else if (RegexUtils.isDecimal(fieldValue)) {
                fieldType = FieldTypeEnum.DECIMAL.getId();
            } else if (RegexUtils.isDate(fieldValue)) {
                fieldType = FieldTypeEnum.DATE.getId();
            } else if (RegexUtils.isDateTime(fieldValue)) {
                fieldType = FieldTypeEnum.DATETIME.getId();
            }
        }
        return fieldType;
    }

    public static QFilter transFilterJson2QFilter(String entityId, String filterJson) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        filterBuilder.buildFilter();
        QFilter qFilter = filterBuilder.getQFilter();
        return qFilter;
    }
}

