/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static Log logger = LogFactory.getLog(HttpClientUtils.class);

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        String data = "";
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpClientParams.setCookiePolicy((HttpParams)client.getParams(), (String)"compatibility");
        HttpPost post = new HttpPost(url);
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (body != null && body.size() != 0) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(body.size());
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    params.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                post.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader == null || !"gzip".equalsIgnoreCase(respHeader.getValue()) && !"x-gzip".equalsIgnoreCase(respHeader.getValue())) {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                } else {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HttpClientUtils.getHTMLContent(in);
                }
            }
        }
        catch (IOException var14) {
            throw var14;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas) {
        String var11;
        CloseableHttpClient httpclient = HttpClients.createSystem();
        try {
            HttpResponse response;
            InputStream in;
            block18: {
                Object contentType;
                HttpPost httppost = new HttpPost(url);
                if (headers != null && headers.size() > 0) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httppost.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                in = null;
                MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.STRICT, null, Charset.forName("UTF-8"));
                if (formDatas != null && !formDatas.isEmpty()) {
                    for (FormDataEntity e : formDatas) {
                        try {
                            in = e.getValueInputStream();
                            if (in != null) {
                                InputStreamBody inputStreamBody = new InputStreamBody(in, ContentType.create((String)"text/csv", (Charset)Consts.UTF_8), e.getFileName());
                                reqEntity.addPart(e.getKey(), (ContentBody)inputStreamBody);
                                continue;
                            }
                            contentType = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)Charset.forName("UTF-8"));
                            StringBody stringBody = new StringBody(e.getValueString(), contentType);
                            reqEntity.addPart(e.getKey(), (ContentBody)stringBody);
                        }
                        finally {
                            CommonUtil.safeClose(in);
                            in = null;
                        }
                    }
                }
                httppost.setEntity((HttpEntity)reqEntity);
                response = httpclient.execute((HttpUriRequest)httppost);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) break block18;
                logger.error("[GPE api]request exception httpStatus:{} with url:{}", (Object)statusCode, (Object)url);
                contentType = BaseResult.fail("", String.format("\u63a5\u53e3\u670d\u52a1\u54cd\u5e94\u72b6\u6001\u5f02\u5e38 - Http\u72b6\u6001\u7801:%s", statusCode)).toJSONString();
                CommonUtil.safeClose(in);
                return contentType;
            }
            try {
                HttpEntity resEntity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)resEntity);
                EntityUtils.consume((HttpEntity)resEntity);
                var11 = result;
            }
            catch (IOException var31) {
                String string;
                try {
                    logger.error((Throwable)var31);
                    string = BaseResult.fail("", "\u63a5\u53e3\u670d\u52a1\u5f02\u5e38 - IOException").toJSONString();
                }
                catch (Throwable throwable) {
                    CommonUtil.safeClose(in);
                    throw throwable;
                }
                CommonUtil.safeClose(in);
                httpclient.getConnectionManager().shutdown();
                return string;
            }
            CommonUtil.safeClose(in);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return var11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException var12) {
            logger.error((Throwable)var12);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException var11) {
                logger.error((Throwable)var11);
            }
        }
        return sb.toString();
    }

    public static class FormDataEntity {
        private String key;
        private String valueString;
        private InputStream valueInputStream;
        private String fileName;

        public FormDataEntity(String key, String value) {
            this.key = key;
            this.valueString = value;
        }

        public FormDataEntity(String key, InputStream value, String fileName) {
            this.key = key;
            this.valueInputStream = value;
            this.fileName = fileName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValueString() {
            return this.valueString;
        }

        public InputStream getValueInputStream() {
            return this.valueInputStream;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

