/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;

public class HttpUtils {
    private static final Log log = LogFactory.getLog(HttpUtils.class);

    private HttpUtils() {
    }

    public static String doGet(String url) {
        return HttpUtils.doGet(url, null);
    }

    public static String doGet(String url, Map<String, Object> paramsMap) {
        return HttpClientUtils.get((String)url, paramsMap);
    }

    public static String doGet(String url, Map<String, String> headerMap, Map<String, Object> paramsMap) {
        return HttpClientUtils.get((String)url, headerMap, paramsMap);
    }

    public static String doGet(String url, Map<String, String> headerMap, Map<String, Object> paramsMap, int connectionTimeout, int readTimeout) {
        return HttpClientUtils.get((String)url, headerMap, paramsMap, (int)connectionTimeout, (int)readTimeout);
    }

    public static String doPostJson(String url, String json) throws Exception {
        return HttpUtils.doPostJson(url, json, null);
    }

    public static String doPostJson(String url, String json, Map<String, String> headerMap) throws Exception {
        return HttpClientUtils.postAppJson((String)url, headerMap, (Map)JSON.parseObject((String)json));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostJson(String url, String json, Map<String, String> headerMap, int connectionTimeout, int readTimeout) throws Exception {
        long begin = System.currentTimeMillis();
        try {
            String string = HttpClientUtils.postAppJson((String)url, headerMap, (Map)JSON.parseObject((String)json), (int)connectionTimeout, (int)readTimeout);
            return string;
        }
        finally {
            log.info("{} cost:{}ms", (Object)url, (Object)(System.currentTimeMillis() - begin));
        }
    }
}

