/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class StrUtils {
    private StrUtils() {
    }

    public static String trimSplitChar(String joinStr) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)joinStr, (CharSequence)",")) {
            joinStr = joinStr.substring(1);
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)joinStr, (CharSequence)",")) {
            joinStr = joinStr.substring(0, joinStr.length() - 1);
        }
        return StringUtils.trimToEmpty((String)joinStr);
    }

    public static String leftAddChar(String str, int number, int length) {
        int addLength = length - String.valueOf(number).length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < addLength; ++i) {
            sb.append(str);
        }
        sb.append(number);
        return sb.toString();
    }

    public static String parseTopDomain(String clientUrl) {
        String topDomain = null;
        if (StringUtils.isNotEmpty((CharSequence)clientUrl)) {
            String[] domainTagArr;
            int length;
            int startIndex = clientUrl.indexOf("://");
            topDomain = clientUrl.substring(startIndex + 3);
            int endIndex = topDomain.indexOf(47);
            if (StringUtils.contains((CharSequence)(topDomain = topDomain.substring(0, endIndex)), (CharSequence)":")) {
                topDomain = topDomain.split(":", 2)[0];
            }
            if ((length = (domainTagArr = topDomain.split("\\.")).length) > 2) {
                List<String> domainTagList = Arrays.asList(domainTagArr);
                domainTagList = domainTagList.subList(length - 2, length);
                topDomain = String.join((CharSequence)".", domainTagList);
            }
        }
        return topDomain;
    }

    public static String getSupersetRedirectUrl(String url) {
        try {
            String encodeUrl = URLEncoder.encode(url, "utf-8");
            url = String.format("%s%snext=%s", url, url.contains("?") ? "&" : "?", encodeUrl);
        }
        catch (UnsupportedEncodingException e) {
            CommonUtil.getStackTrace(e);
        }
        return url;
    }

    public static String getMatcher(String source, String regex) {
        String result = "";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            result = matcher.group(NumberUtils.INTEGER_ONE);
        }
        return result;
    }

    public static List<String> splitStr2List(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Arrays.asList(StringUtils.split((String)str, (String)","));
        }
        return new ArrayList<String>();
    }

    public static Boolean str2Boolean(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Boolean.parseBoolean(str);
        }
        return null;
    }

    public static String valueList2InStr(List<String> valueList, String quoteChar) {
        String valuesStr = "";
        if (CollectionUtils.isNotEmpty(valueList)) {
            for (String value : valueList) {
                value = String.format("%s%s%s", quoteChar, value, quoteChar);
                if (StringUtils.isEmpty((CharSequence)valuesStr)) {
                    valuesStr = value;
                    continue;
                }
                valuesStr = String.format("%s,%s", valuesStr, value);
            }
        }
        return valuesStr;
    }

    public static String formatLargeTextSummary(String text) {
        if (StringUtils.isNotEmpty((CharSequence)text) && text.length() > 200) {
            text = String.format("%s...", text.substring(0, 200));
        }
        return text;
    }

    public static String replaceProxyIp(String url, String proxyIp) {
        if (StringUtils.isNotEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)proxyIp)) {
            String regex = "https?://([^/]+)";
            String ip = StrUtils.getMatcher(url, regex);
            url = StringUtils.replace((String)url, (String)ip, (String)proxyIp);
        }
        return url;
    }
}

