/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import com.alibaba.fastjson.JSONObject;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.ai.ids.core.enumtype.ExecuteIntervalUnitEnum;
import kd.ai.ids.core.enumtype.ExecuteTypeEnum;
import kd.ai.ids.core.enumtype.TaskTypeEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class TaskUtils {
    protected static Log log = LogFactory.getLog((String)"kd.ai.ids.core.utils.TaskUtils");

    private TaskUtils() {
    }

    public static RepeatModeEnum getRepeatModeByExecuteIntervalUnit(int executeIntervalUnit) {
        switch (executeIntervalUnit) {
            case 0: {
                return RepeatModeEnum.NONE;
            }
            case 1: {
                return RepeatModeEnum.ByMinutes;
            }
            case 2: {
                return RepeatModeEnum.ByDays;
            }
            case 3: {
                return RepeatModeEnum.ByWeeks;
            }
            case 4: {
                return RepeatModeEnum.ByMonths;
            }
            case 5: {
                return RepeatModeEnum.ByYears;
            }
            case 6: {
                return RepeatModeEnum.ByCustomize;
            }
        }
        return RepeatModeEnum.ByDays;
    }

    public static Boolean deletePlan(String jobId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
        JobDao jobDao = of.getJobDao();
        ScheduleDao scheduleDao = of.getScheduleDao();
        TaskDao taskDao = of.getTaskDao();
        boolean jobIsExist = jobDao.isExist(jobId);
        String planNumber = jobId;
        boolean planIsExist = scheduleDao.existedByNumber(planNumber);
        boolean jobIsDeleted = true;
        if (jobIsExist) {
            jobIsDeleted = jobDao.delete(jobId);
            if (jobIsDeleted) {
                log.info("delete jobId : {} success.", (Object)jobId);
            } else {
                log.info("delete jobId : {} failed.", (Object)jobId);
            }
        }
        boolean planIsDeleted = true;
        if (planIsExist) {
            taskDao.deleteTaskByJobId(jobId);
            String scheduleId = scheduleDao.getIdByNumber(planNumber);
            planIsDeleted = proxy.deletePlan(scheduleId);
        }
        TaskUtils.asyncDeleteExtendPlan(proxy, scheduleDao, planNumber, taskDao);
        if (planIsDeleted) {
            log.info("delete planNumber : {} success.", (Object)planNumber);
        } else {
            log.info("delete planNumber : {} failed.", (Object)planNumber);
        }
        return planIsDeleted;
    }

    public static void asyncDeleteExtendPlan(JobDispatcherProxy proxy, ScheduleDao scheduleDao, String planNumber, TaskDao taskDao) {
        ThreadUtils.execute(() -> {
            String possiblePlanNumber = String.format("%s%s", planNumber, "_SKDP_S");
            if (!StringUtils.startsWithIgnoreCase((CharSequence)possiblePlanNumber, (CharSequence)String.format("%s_", "ids"))) {
                possiblePlanNumber = String.format("%s_%s", "ids", possiblePlanNumber);
            }
            taskDao.deleteTaskByJobId(possiblePlanNumber);
            String possibleSchedulerId = scheduleDao.getIdByNumber(possiblePlanNumber);
            if (StringUtils.isNotEmpty((CharSequence)possibleSchedulerId)) {
                proxy.deletePlan(possibleSchedulerId);
            }
        });
    }

    public static void fillPlanInfo(String executeTime, String endTime, int executeInterval, int executeIntervalUnit, String jobId, String taskName, String planNumber, boolean taskEnable, PlanInfo planInfo, String cron) {
        if (executeIntervalUnit == ExecuteIntervalUnitEnum.CRON.getKey()) {
            CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
            CronParser parser = new CronParser(cronDefinition);
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cron));
            Optional zonedDateTime = executionTime.nextExecution(ZonedDateTime.now());
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            executeTime = ((ZonedDateTime)zonedDateTime.get()).format(fmt);
            planInfo.setCronExpression(cron);
        } else {
            RepeatModeEnum repeatModeEnum = TaskUtils.getRepeatModeByExecuteIntervalUnit(executeIntervalUnit);
            planInfo.setRepeatMode(repeatModeEnum);
        }
        planInfo.setPeriod(executeInterval);
        planInfo.setEnable(taskEnable);
        planInfo.setJobId(jobId);
        Date startTimeD = DateUtils.parseDate(executeTime, "yyyy-MM-dd HH:mm:ss");
        Date endTimeD = DateUtils.parseDate(endTime, "yyyy-MM-dd HH:mm:ss");
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startTimeD);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endTimeD);
        planInfo.setStartTime(startCalendar);
        planInfo.setEndTime(endCalendar);
        planInfo.setName(taskName);
        planInfo.setNumber(planNumber);
        planInfo.setId(planNumber);
    }

    public static void fillJobInfo(long runByUserId, String jobId, Map<String, Object> params, String taskName, boolean enable, JobInfo jobInfo) {
        jobInfo.setAppId("ids");
        jobInfo.setRunByUserId(runByUserId);
        jobInfo.setCaption(taskName);
        jobInfo.setEnable(enable);
        jobInfo.setId(jobId);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setName(taskName);
        jobInfo.setScheduleId(jobId);
        jobInfo.setNumber(jobId);
        jobInfo.setTaskClassname("kd.ai.ids.plugin.job.TaskExecutionJobPlugin");
        jobInfo.setParams(params);
        jobInfo.setRetryTime(3);
    }

    public static void createCommonTask(TenantDTO tenantDTO, long runByUserId, long orgId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
        JobDao jobDao = of.getJobDao();
        ScheduleDao scheduleDao = of.getScheduleDao();
        TaskDao taskDao = of.getTaskDao();
        String taskName = "\u667a\u80fd\u6570\u636e\u670d\u52a1_\u5b9a\u65f6\u7ef4\u62a4\u4efb\u52a1";
        String jobId = "ids_common_maintain_job_id";
        String cron = "ss mm 8,13,18,21 * * ?";
        if (StringUtils.isNotEmpty((CharSequence)cron) && (StringUtils.containsIgnoreCase((CharSequence)cron, (CharSequence)"ss") || StringUtils.containsIgnoreCase((CharSequence)cron, (CharSequence)"mm"))) {
            cron = StringUtils.replace((String)cron, (String)"ss", (String)(RandomUtils.nextInt((int)0, (int)59) + ""));
            cron = StringUtils.replace((String)cron, (String)"mm", (String)(RandomUtils.nextInt((int)0, (int)10) + ""));
        }
        boolean jobIsExist = jobDao.isExist(jobId);
        String planNumber = "ids_common_maintain_plan_id";
        boolean taskEnable = true;
        boolean planIsExist = scheduleDao.existedByNumber(planNumber);
        boolean jobSaveResult = false;
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("ctime", new Date().getTime());
        params.put("orgId", orgId);
        params.put("taskType", TaskTypeEnum.COMMON.getKey());
        params.put("tenantId", tenantDTO.getTenantId());
        params.put("customerId", tenantDTO.getCustomerId());
        params.put("dbId", tenantDTO.getDataCenterId());
        params.put("executeType", ExecuteTypeEnum.CRONTAB.getKey());
        params.put("taskName", taskName);
        params.put("executeUserId", runByUserId);
        boolean jobIsDeleted = true;
        JobInfo jobInfo = new JobInfo();
        if (jobIsExist) {
            jobIsDeleted = jobDao.delete(jobId);
        }
        if (jobIsDeleted) {
            TaskUtils.fillJobInfo(runByUserId, jobId, params, taskName, taskEnable, jobInfo);
            if (taskEnable) {
                jobSaveResult = jobDao.save(jobInfo);
                log.info("save jobId : {} with result: {}", (Object)jobInfo.getId(), (Object)jobSaveResult);
            }
        } else {
            log.info("delete jobId : {} failed.", (Object)jobId);
        }
        boolean planIsDeleted = true;
        PlanInfo planInfo = new PlanInfo();
        if (planIsExist) {
            taskDao.deleteTaskByJobId(jobId);
            String scheduleId = scheduleDao.getIdByNumber(planNumber);
            planIsDeleted = proxy.deletePlan(scheduleId);
        }
        TaskUtils.asyncDeleteExtendPlan(proxy, scheduleDao, planNumber, taskDao);
        if (planIsDeleted) {
            String startTime = String.format("%s %s", KDDateFormatUtils.getDateFormat().format(new Date()), "21:00:02");
            String endTime = "9999-12-31 23:59:59";
            int executeIntervalUnit = ExecuteIntervalUnitEnum.CRON.getKey();
            TaskUtils.fillPlanInfo(startTime, endTime, 1, executeIntervalUnit, jobId, taskName, planNumber, taskEnable, planInfo, cron);
            if (taskEnable) {
                String planId = proxy.createPlan(planInfo);
                TaskUtils.saveTenantExtra(orgId, tenantDTO, planInfo.getNumber(), planInfo.getCronExpression());
                log.info("save planNumber : {} with planId: {}", (Object)planNumber, (Object)planId);
            }
        } else {
            log.info("delete planNumber : {} failed.", (Object)planNumber);
        }
    }

    public static void createAppExecuteCheckTask(TenantDTO tenantDTO, long runByUserId, long orgId, String executeId, String modelVersionId, String appId, String subServiceId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
        JobDao jobDao = of.getJobDao();
        ScheduleDao scheduleDao = of.getScheduleDao();
        TaskDao taskDao = of.getTaskDao();
        String taskName = String.format("\u5e94\u7528\u6267\u884c\u68c0\u6d4b\u4efb\u52a1\uff08\u5173\u8054\u6570\u636e\u51c6\u5907\u4efb\u52a1\u7f16\u7801\uff1a%s\uff09", modelVersionId);
        String jobId = executeId;
        String cron = "58 * * * * ?";
        boolean jobIsExist = jobDao.isExist(jobId);
        String planNumber = executeId;
        boolean taskEnable = true;
        boolean planIsExist = scheduleDao.existedByNumber(planNumber);
        boolean jobSaveResult = false;
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("ctime", new Date().getTime());
        params.put("orgId", orgId);
        params.put("taskType", TaskTypeEnum.APP_EXECUTE_CHECK.getKey());
        params.put("tenantId", tenantDTO.getTenantId());
        params.put("customerId", tenantDTO.getCustomerId());
        params.put("dbId", tenantDTO.getDataCenterId());
        params.put("executeType", ExecuteTypeEnum.CRONTAB.getKey());
        params.put("taskName", taskName);
        params.put("executeUserId", runByUserId);
        params.put("executeId", executeId);
        params.put("appId", appId);
        params.put("subServiceId", subServiceId);
        boolean jobIsDeleted = true;
        JobInfo jobInfo = new JobInfo();
        if (jobIsExist) {
            jobIsDeleted = jobDao.delete(jobId);
        }
        if (jobIsDeleted) {
            TaskUtils.fillJobInfo(runByUserId, jobId, params, taskName, taskEnable, jobInfo);
            if (taskEnable) {
                jobSaveResult = jobDao.save(jobInfo);
                log.info("save jobId : {} with result: {}", (Object)jobInfo.getId(), (Object)jobSaveResult);
            }
        } else {
            log.info("delete jobId : {} failed.", (Object)jobId);
        }
        boolean planIsDeleted = true;
        PlanInfo planInfo = new PlanInfo();
        if (planIsExist) {
            taskDao.deleteTaskByJobId(jobId);
            String scheduleId = scheduleDao.getIdByNumber(planNumber);
            planIsDeleted = proxy.deletePlan(scheduleId);
        }
        TaskUtils.asyncDeleteExtendPlan(proxy, scheduleDao, planNumber, taskDao);
        if (planIsDeleted) {
            String startTime = KDDateFormatUtils.getDateTimeFormat().format(KDDateUtils.now());
            String endTime = String.format("%s %s", KDDateFormatUtils.getDateFormat().format(KDDateUtils.now()), "23:59:59");
            int executeIntervalUnit = ExecuteIntervalUnitEnum.CRON.getKey();
            TaskUtils.fillPlanInfo(startTime, endTime, 1, executeIntervalUnit, jobId, taskName, planNumber, taskEnable, planInfo, cron);
            if (taskEnable) {
                String planId = proxy.createPlan(planInfo);
                log.info("save planNumber : {} with planId: {}", (Object)planNumber, (Object)planId);
            }
        } else {
            log.info("delete planNumber : {} failed.", (Object)planNumber);
        }
    }

    private static void saveTenantExtra(Long orgId, TenantDTO tenantDTO, String planId, String cron) {
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("tenantId", (Object)tenantDTO.getTenantId());
        paramsJo.put("commonTaskId", (Object)planId);
        paramsJo.put("commonTaskCron", (Object)cron);
        paramsJo.put("commonTaskRebuild", (Object)YesNoEnum.NO.getKey());
        BaseResult baseResultByPost = Services.get(IIdsServerService.class).getBaseResultByPost(orgId, "/ids/clientproxy/tenant/extra/saveorupdate", paramsJo);
        log.info("saveTenantExtra over");
    }
}

