/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.utils;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.ids.core.utils.CommonUtil;
import kd.bos.context.OperationContext;
import kd.bos.context.OperationContextCreator;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.RequestContextRunnable;

public final class ThreadUtils {
    private static final Log log = LogFactory.getLog(ThreadUtils.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ids-threadPool", (int)20, (String)"ids");
    private static final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){
        private final AtomicInteger atomicInteger = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ai.ids.sch-" + this.atomicInteger.incrementAndGet());
        }
    });

    private ThreadUtils() {
    }

    public static void execute(Runnable runnable) {
        threadPool.execute(runnable, RequestContextCreator.createForThreadPool());
    }

    public static void schedule(Runnable command, long delay, TimeUnit unit) {
        OperationContext oc = OperationContextCreator.getOrCreateDefault((String)"ids");
        RequestContext rc = RequestContextCreator.createForThreadPool();
        Object runnable = new RequestContextRunnable(command, rc, oc);
        runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
        scheduledExecutor.schedule((Runnable)runnable, delay, unit);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            CommonUtil.getStackTrace(e);
        }
    }
}

