/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.ai.ids.core.enumtype.ExecuteStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.gpe.ErrorCodeEnum;
import kd.ai.ids.core.enumtype.gpe.RequestTypeEnum;
import kd.ai.ids.core.query.gpe.GpeRequestContext;
import kd.ai.ids.core.service.IGpeServerService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IOpenAPIService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.PermUtils;
import kd.ai.ids.core.utils.StrUtils;
import kd.ai.ids.mservice.GpeService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GpeServiceImpl
implements GpeService {
    private final Log log = LogFactory.getLog(GpeServiceImpl.class);

    private IGpeServerService gpeServerService() {
        return (IGpeServerService)Services.get(IGpeServerService.class);
    }

    private IIdsParameterService idsParameterService() {
        return (IIdsParameterService)Services.get(IIdsParameterService.class);
    }

    private IOpenAPIService openAPIService() {
        return (IOpenAPIService)Services.get(IOpenAPIService.class);
    }

    private boolean hasSaveThirdAppPerm(RequestContext rc) {
        String appId = this.idsParameterService().getIdsParameter(Long.valueOf(rc.getOrgId())).getThirdAppId();
        long existedThirdAppId = this.openAPIService().findThirdApp(appId);
        boolean hasPermission = PermUtils.hasPermission((Object)rc.getCurrUserId(), (Object)"open", (Object)"third_app", (Object)"QXX0009");
        return existedThirdAppId > 0L || hasPermission;
    }

    public String predict(String requestId, Integer requestType, String bizAppId, String bizParams) {
        CustomApiResult customApiResult = null;
        try {
            RequestContext rc = RequestContext.get();
            if (!this.hasSaveThirdAppPerm(rc)) {
                this.log.info("error:{}", (Object)ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getName());
                CustomApiResult result = CustomApiResult.fail((String)ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getId(), (String)ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getName());
                return JSONObject.toJSONString((Object)result);
            }
            JSONObject paramJo = new JSONObject();
            paramJo.put("requestId", (Object)requestId);
            paramJo.put("requestType", (Object)String.valueOf(requestType));
            paramJo.put("bizAppId", (Object)bizAppId);
            paramJo.put("bizParams", (Object)JSONObject.parseObject((String)bizParams));
            DynamicObject bizRequestDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_GPE_BIZ_REQUEST.getId());
            bizRequestDo.set("requestid", (Object)requestId);
            bizRequestDo.set("requesttype", (Object)String.valueOf(requestType));
            bizRequestDo.set("executestatus", (Object)ExecuteStatusEnum.INIT.getKey());
            bizRequestDo.set("bizappid", (Object)bizAppId);
            bizRequestDo.set("reqparams", (Object)"\u8bf7\u6c42\u53c2\u6570\u6982\u89c8");
            bizRequestDo.set("reqparams_tag", (Object)paramJo.toJSONString());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRequestDo});
            GpeRequestContext gpeRequestContext = new GpeRequestContext(rc);
            customApiResult = this.gpeServerService().getCustomApiResult(gpeRequestContext, "/gpes/algorithm/api/predict", paramJo);
            if (requestType.intValue() == RequestTypeEnum.SYNC.getKey()) {
                if (customApiResult.isStatus()) {
                    bizRequestDo.set("executestatus", (Object)ExecuteStatusEnum.SUCCESS.getKey());
                } else {
                    bizRequestDo.set("executestatus", (Object)ExecuteStatusEnum.FAIL.getKey());
                    bizRequestDo.set("failmsg", (Object)StrUtils.formatLargeTextSummary((String)customApiResult.getMessage()));
                    bizRequestDo.set("failmsg_tag", (Object)customApiResult.getMessage());
                }
                bizRequestDo.set("response", (Object)"\u8bf7\u6c42\u54cd\u5e94\u6982\u89c8");
                bizRequestDo.set("response_tag", (Object)JSONObject.toJSONString((Object)customApiResult));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRequestDo});
            }
        }
        catch (Exception e) {
            this.log.error("requestId:{} error:" + e.getMessage(), (Object)requestId, (Object)e);
            customApiResult = CustomApiResult.fail((String)ErrorCodeEnum.FAIL.getId(), (String)ErrorCodeEnum.PREDICT_API_EXCEPTION.getName());
        }
        return JSONObject.toJSONString((Object)customApiResult);
    }

    public String getRequestStatus(String requestId, String bizAppId) {
        CustomApiResult customApiResult = null;
        DynamicObject bizRequestDo = BusinessDataServiceHelper.loadSingle((String)IdsFormIdEnum.IDS_GPE_BIZ_REQUEST.getId(), (QFilter[])new QFilter("requestid", "=", (Object)requestId).and("bizappid", "=", (Object)bizAppId).toArray());
        if (bizRequestDo != null) {
            String executeStatus = bizRequestDo.getString("executestatus");
            String failMsg = bizRequestDo.getString("failmsg_tag");
            JSONObject dataJo = new JSONObject();
            dataJo.put("status", (Object)(StringUtils.isNotEmpty((CharSequence)executeStatus) ? Integer.parseInt(executeStatus) : ExecuteStatusEnum.INIT.getKey()));
            dataJo.put("failMsg", (Object)failMsg);
            customApiResult = CustomApiResult.success((Object)dataJo);
        } else {
            this.log.info("requestId:{} bizAppId:{} not found", (Object)requestId, (Object)bizAppId);
            customApiResult = CustomApiResult.fail((String)ErrorCodeEnum.REQUEST_ID_NOT_FOUND.getId(), (String)ErrorCodeEnum.REQUEST_ID_NOT_FOUND.getName());
        }
        return JSONObject.toJSONString((Object)customApiResult);
    }

    public String getPredictResult(String requestId, String bizAppId) {
        CustomApiResult customApiResult = null;
        DynamicObject bizRequestDo = BusinessDataServiceHelper.loadSingle((String)IdsFormIdEnum.IDS_GPE_BIZ_REQUEST.getId(), (QFilter[])new QFilter("requestid", "=", (Object)requestId).and("bizappid", "=", (Object)bizAppId).toArray());
        if (bizRequestDo != null) {
            String response = bizRequestDo.getString("response_tag");
            JSONObject dataJo = new JSONObject();
            if (StringUtils.isNotEmpty((CharSequence)response)) {
                dataJo = JSONObject.parseObject((String)response);
            }
            if (dataJo.containsKey((Object)"status") && dataJo.containsKey((Object)"errorCode")) {
                customApiResult = (CustomApiResult)JSONObject.toJavaObject((JSON)dataJo, CustomApiResult.class);
            } else {
                customApiResult = CustomApiResult.success((Object)dataJo);
                customApiResult.setErrorCode(ErrorCodeEnum.SUCCESS.getId());
            }
        } else {
            this.log.info("requestId:{} bizAppId:{} not found", (Object)requestId, (Object)bizAppId);
            customApiResult = CustomApiResult.fail((String)ErrorCodeEnum.REQUEST_ID_NOT_FOUND.getId(), (String)ErrorCodeEnum.REQUEST_ID_NOT_FOUND.getName());
        }
        return JSONObject.toJSONString((Object)customApiResult);
    }
}

