/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.sf.std.SfOnlineScheme;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.sf.std.SubChannelEnum;
import kd.ai.ids.core.query.clientproxy.helper.AppInfoQuery;
import kd.ai.ids.core.query.clientproxy.helper.NewSchemeidQuery;
import kd.ai.ids.core.query.server.SubAddQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.SubserviceDTO;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IHelperService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.ISfStandardService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.TaskUtils;
import kd.ai.ids.mservice.IdsService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class IdsServiceImpl
implements IdsService {
    private final Log logger = LogFactory.getLog(IdsServiceImpl.class);

    public static ITenantService tenantService() {
        return (ITenantService)Services.get(ITenantService.class);
    }

    public static IHelperService helperService() {
        return (IHelperService)Services.get(IHelperService.class);
    }

    public static IDataappService dataappService() {
        return (IDataappService)Services.get(IDataappService.class);
    }

    public static ISfStandardService sfStandardService() {
        return (ISfStandardService)Services.get(ISfStandardService.class);
    }

    public IIdsServerService idsServer() {
        return (IIdsServerService)Services.get(IIdsServerService.class);
    }

    public String getAppInfo(String appId) {
        AppInfoQuery query = new AppInfoQuery();
        query.setAppId(appId);
        this.logger.info("query:{}", (Object)query);
        BaseResult baseResult = IdsServiceImpl.helperService().getAppInfo(query);
        return baseResult.toJSONString();
    }

    public String newSchemeid(String appId) {
        RequestContext rc = RequestContext.get();
        long orgId = OrgUnitServiceHelper.getRootOrgId();
        TenantDTO tenantDTO = IdsServiceImpl.tenantService().getTenantDTO(Long.valueOf(orgId), rc.getTenantId(), rc.getAccountId());
        if (tenantDTO == null) {
            return BaseResult.fail((String)"tenant not found", (String)String.format("\u79df\u6237\u4e0d\u5b58\u5728\u3002customerId:%s\uff0caccountId:%s", rc.getTenantId(), rc.getAccountId())).toJSONString();
        }
        NewSchemeidQuery query = new NewSchemeidQuery();
        query.setTenantId(tenantDTO.getTenantId());
        query.setAppId(appId);
        this.logger.info("query:{}", (Object)query);
        BaseResult baseResult = IdsServiceImpl.helperService().newSchemeid(query);
        return baseResult.toJSONString();
    }

    public String getSchemeInfo(String appId, String fschemeids) {
        String[] fschemeidArr;
        if (StringUtils.isEmpty((CharSequence)fschemeids)) {
            return BaseResult.fail((String)"fail", (String)"\u9884\u6d4b\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a").toJSONString();
        }
        RequestContext rc = RequestContext.get();
        long orgId = OrgUnitServiceHelper.getRootOrgId();
        TenantDTO tenantDTO = IdsServiceImpl.tenantService().getTenantDTO(Long.valueOf(orgId), rc.getTenantId(), rc.getAccountId());
        if (tenantDTO == null) {
            return BaseResult.fail((String)"tenant not found", (String)String.format("\u79df\u6237\u4e0d\u5b58\u5728\u3002customerId:%s\uff0caccountId:%s", rc.getTenantId(), rc.getAccountId())).toJSONString();
        }
        String subServiceId = IdsServiceImpl.dataappService().getSubServiceId(Long.valueOf(orgId), tenantDTO.getTenantId(), appId);
        JSONArray dataJa = IdsServiceImpl.sfStandardService().getOnlineSchemeList(subServiceId);
        Map<Integer, SfOnlineScheme> map = null;
        if (dataJa != null && !dataJa.isEmpty()) {
            List sfOnlineSchemeList = dataJa.toJavaList(SfOnlineScheme.class);
            map = sfOnlineSchemeList.stream().collect(Collectors.toMap(SfOnlineScheme::getFschemeid, a -> a, (k1, k2) -> k1));
        }
        JSONArray dataArr = new JSONArray();
        for (String fschemeid : fschemeidArr = fschemeids.split(",")) {
            SfOnlineScheme sfOnlineScheme;
            JSONObject jo = new JSONObject();
            jo.put("fschemeid", (Object)fschemeid);
            int status = YesNoEnum.NO.getKey();
            if (map != null && (sfOnlineScheme = map.get(Integer.parseInt(fschemeid))) != null) {
                status = YesNoEnum.YES.getKey();
            }
            jo.put("status", (Object)status);
            dataArr.add((Object)jo);
        }
        BaseResult baseResult = BaseResult.success((String)"success", (String)"\u83b7\u53d6\u6210\u529f");
        baseResult.setData((Object)dataArr);
        return baseResult.toJSONString();
    }

    public String appSubscribe(String appId, String fdatasource) {
        RequestContext rc = RequestContext.get();
        long orgId = OrgUnitServiceHelper.getRootOrgId();
        String productVersion = "unknown";
        TenantDTO tenantDTO = IdsServiceImpl.tenantService().getTenantDTO(Long.valueOf(orgId), rc.getTenantId(), rc.getAccountId());
        if (tenantDTO == null) {
            IdsServiceImpl.tenantService().createTenant(rc, productVersion);
            tenantDTO = IdsServiceImpl.tenantService().getTenantDTO(Long.valueOf(orgId), rc.getTenantId(), rc.getAccountId());
        }
        if (tenantDTO == null) {
            this.logger.info("\u521b\u5efa\u79df\u6237\u5931\u8d25");
            return BaseResult.fail((String)"fail", (String)"\u521b\u5efa\u79df\u6237\u5931\u8d25").toJSONString();
        }
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("tenantId", (Object)tenantDTO.getTenantId());
        paramsJo.put("idsPermission", (Object)YesNoEnum.YES.getKey());
        BaseResult modIdsPermissionBa = this.idsServer().getBaseResultByPost(Long.valueOf(orgId), "/ids/ids/tenant/mod/baseInfo", paramsJo);
        if (!modIdsPermissionBa.isSuccess()) {
            this.logger.info("\u81ea\u52a8\u6388\u6743\u5931\u8d25");
            return BaseResult.fail((String)"fail", (String)"\u81ea\u52a8\u6388\u6743\u5931\u8d25").toJSONString();
        }
        BaseResult baseResult = BaseResult.success((String)"success", (String)"\u64cd\u4f5c\u6210\u529f");
        BaseResult grantAddBa = IdsServiceImpl.tenantService().agreementGrantAdd(rc, tenantDTO.getTenantId());
        if (!grantAddBa.isSuccess()) {
            this.logger.info("\u81ea\u52a8\u7b7e\u7f72\u9690\u79c1\u534f\u8bae\u5931\u8d25");
            return BaseResult.fail((String)"fail", (String)"\u81ea\u52a8\u7b7e\u7f72\u9690\u79c1\u534f\u8bae\u5931\u8d25").toJSONString();
        }
        JSONObject subServiceJo = IdsServiceImpl.dataappService().getSubService(Long.valueOf(orgId), tenantDTO.getTenantId(), appId);
        if (subServiceJo == null) {
            TaskUtils.createCommonTask((TenantDTO)tenantDTO, (long)rc.getCurrUserId(), (long)rc.getOrgId());
            SubAddQuery subAddQuery = new SubAddQuery();
            subAddQuery.setAppId(appId);
            subAddQuery.setCustomerId(tenantDTO.getCustomerId());
            subAddQuery.setTenantId(tenantDTO.getTenantId());
            subAddQuery.setDataCenter(tenantDTO.getDataCenter());
            subAddQuery.setDataCenterId(tenantDTO.getDataCenterId());
            subAddQuery.setSubChannel("");
            subAddQuery.setSubChannel(SubChannelEnum.DIFF.getId());
            IdsServiceImpl.dataappService().subAdd(subAddQuery);
            subServiceJo = IdsServiceImpl.dataappService().getSubService(Long.valueOf(orgId), tenantDTO.getTenantId(), appId);
            if (subServiceJo == null) {
                this.logger.info("\u8ba2\u9605\u5931\u8d25");
                return BaseResult.fail((String)"fail", (String)"\u8ba2\u9605\u5931\u8d25").toJSONString();
            }
        }
        SubserviceDTO subserviceDTO = (SubserviceDTO)JSONObject.toJavaObject((JSON)subServiceJo, SubserviceDTO.class);
        BaseResult subServiceInitBa = IdsServiceImpl.sfStandardService().subServiceInit(subserviceDTO.getSubServiceId(), tenantDTO.getTenantId(), fdatasource);
        if (!subServiceInitBa.isSuccess()) {
            this.logger.info("\u81ea\u52a8\u5f00\u901a\u8ba2\u9605\u5931\u8d25");
            return BaseResult.fail((String)"fail", (String)"\u81ea\u52a8\u5f00\u901a\u8ba2\u9605\u5931\u8d25").toJSONString();
        }
        JSONObject dataJo = new JSONObject();
        dataJo.put("tenantId", (Object)tenantDTO.getTenantId());
        dataJo.put("subServiceId", (Object)subserviceDTO.getSubServiceId());
        baseResult.setData((Object)dataJo);
        return baseResult.toJSONString();
    }
}

