/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.mservice;

import com.alibaba.fastjson.JSONObject;
import kd.ai.ids.core.enumtype.gpe.ErrorCodeEnum;
import kd.ai.ids.core.query.gpe.GpeRequestContext;
import kd.ai.ids.core.service.IGpeServerService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.mservice.TokenizeService;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;

public class TokenizeServiceImpl
implements TokenizeService {
    private final Log log = LogFactory.getLog(TokenizeServiceImpl.class);

    private IGpeServerService gpeServerService() {
        return (IGpeServerService)Services.get(IGpeServerService.class);
    }

    public String tokenize(String requestId, String text) {
        CustomApiResult customApiResult = null;
        try {
            RequestContext rc = RequestContext.get();
            GpeRequestContext gpeRequestContext = new GpeRequestContext(rc);
            JSONObject paramJo = new JSONObject();
            paramJo.put("requestId", (Object)requestId);
            paramJo.put("text", (Object)text);
            customApiResult = this.gpeServerService().getCustomApiResult(gpeRequestContext, "/gpes/algorithm/api/tokenize", paramJo);
        }
        catch (Exception e) {
            this.log.error("requestId:{} error:" + e.getMessage(), (Object)requestId, (Object)e);
            customApiResult = CustomApiResult.fail((String)ErrorCodeEnum.TOKENIZE_API_EXCEPTION.getId(), (String)ErrorCodeEnum.TOKENIZE_API_EXCEPTION.getName());
        }
        return JSONObject.toJSONString((Object)customApiResult);
    }
}

