/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class NewProductBillOperationPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(NewProductBillOperationPlugin.class);
    public static final String QUIT_STATUS_EXIT = "exit";
    public static final String QUIT_STATUS_NORMAL = "normal";
    private static final String BILL_FORM_ID = "ids_new_product";

    public void beginOperationTransaction(final BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        Arrays.stream(dynamicObjects).forEach(new Consumer<DynamicObject>(){

            @Override
            public void accept(DynamicObject dynamicObject) {
                String operationKey = e.getOperationKey();
                Object pk = dynamicObject.getPkValue();
                DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)pk, (String)NewProductBillOperationPlugin.BILL_FORM_ID);
                if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                    String exitStatus = entity.getString("status");
                    if (StringUtils.equals((CharSequence)exitStatus, (CharSequence)NewProductBillOperationPlugin.QUIT_STATUS_EXIT)) {
                        Object productCode = entity.get("newproductcode");
                        logger.info("new product exit,new product code : {}", productCode);
                        DynamicObject productExitEntity = BusinessDataServiceHelper.loadSingle((String)"ids_new_product_exit", (QFilter[])new QFilter[]{new QFilter("newproductcode", "=", productCode)});
                        if (productExitEntity != null) {
                            int code = DeleteServiceHelper.delete((String)"ids_new_product_exit", (QFilter[])new QFilter[]{new QFilter("newproductcode", "=", productCode)});
                            logger.info("delete result code:{}", (Object)code);
                            entity.set("status", (Object)NewProductBillOperationPlugin.QUIT_STATUS_NORMAL);
                            long userId = UserServiceHelper.getCurrentUserId();
                            entity.set("auditor", (Object)userId);
                            entity.set("auditdate", (Object)new Date());
                            SaveServiceHelper.saveOperate((String)NewProductBillOperationPlugin.BILL_FORM_ID, (DynamicObject[])new DynamicObject[]{entity}, (OperateOption)OperateOption.create());
                        }
                    } else {
                        long userId = UserServiceHelper.getCurrentUserId();
                        entity.set("auditor", (Object)userId);
                        entity.set("auditdate", (Object)new Date());
                        SaveServiceHelper.saveOperate((String)NewProductBillOperationPlugin.BILL_FORM_ID, (DynamicObject[])new DynamicObject[]{entity}, (OperateOption)OperateOption.create());
                    }
                } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
                    long userId = UserServiceHelper.getCurrentUserId();
                    entity.set("auditor", (Object)0);
                    entity.set("auditdate", null);
                    SaveServiceHelper.saveOperate((String)NewProductBillOperationPlugin.BILL_FORM_ID, (DynamicObject[])new DynamicObject[]{entity}, (OperateOption)OperateOption.create());
                }
            }
        });
    }
}

