/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class NewProductBillPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(NewProductBillPlugin.class);
    public static final String QUIT_STATUS_EXIT = "exit";
    public static final String QUIT_STATUS_NORMAL = "normal";
    private static final String BILL_FORM_ID = "ids_new_product";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.stream().forEach(new Consumer<DynamicObject>(){

                    @Override
                    public void accept(DynamicObject dynamicObject) {
                        String productCode = dynamicObject.getString("newproductcode");
                        DynamicObject productCodeEntity = QueryServiceHelper.queryOne((String)"ids_new_product_exit", (String)"id,status,newproductcode,createtime,modifytime", (QFilter[])new QFilter[]{new QFilter("newproductcode", "=", (Object)productCode)});
                        if (productCodeEntity != null) {
                            String mainStatus;
                            String exitStatus = productCodeEntity.getString("status");
                            if (!StringUtils.equalsIgnoreCase((CharSequence)exitStatus, (CharSequence)(mainStatus = dynamicObject.getString("status")))) {
                                logger.info("modify exit status.");
                                dynamicObject.set("status", (Object)exitStatus);
                                Object pk = dynamicObject.getPkValue();
                                DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)pk, (String)NewProductBillPlugin.BILL_FORM_ID);
                                entity.set("status", (Object)exitStatus);
                                SaveServiceHelper.saveOperate((String)NewProductBillPlugin.BILL_FORM_ID, (DynamicObject[])new DynamicObject[]{entity}, (OperateOption)OperateOption.create());
                            }
                        } else {
                            String mainStatus = dynamicObject.getString("status");
                            if (StringUtils.equalsIgnoreCase((CharSequence)mainStatus, (CharSequence)NewProductBillPlugin.QUIT_STATUS_EXIT)) {
                                Object pk = dynamicObject.getPkValue();
                                DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)pk, (String)NewProductBillPlugin.BILL_FORM_ID);
                                entity.set("status", (Object)NewProductBillPlugin.QUIT_STATUS_NORMAL);
                                SaveServiceHelper.saveOperate((String)NewProductBillPlugin.BILL_FORM_ID, (DynamicObject[])new DynamicObject[]{entity}, (OperateOption)OperateOption.create());
                            }
                        }
                        Object aiproi = dynamicObject.get("aipriority");
                        if (aiproi != null) {
                            String value = (String)aiproi;
                            if (StringUtils.equalsIgnoreCase((CharSequence)"L", (CharSequence)StringUtils.trim((String)value))) {
                                dynamicObject.set("aipriority", (Object)"\u666e\u901a");
                            } else if (StringUtils.equalsIgnoreCase((CharSequence)"U", (CharSequence)StringUtils.trim((String)value))) {
                                dynamicObject.set("aipriority", (Object)"\u4f18\u5148");
                            }
                        }
                    }
                });
                return rows;
            }
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterColumn createTimeFilter = args.getFilterColumn("createtime");
        createTimeFilter.setDefaultValue("24");
        FilterColumn exitColumn = args.getFilterColumn("status");
        exitColumn.setDefaultValue(QUIT_STATUS_NORMAL);
        FilterColumn orgFilter = args.getFilterColumn("orgid.number");
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        Long switchOrg = RequestContext.get().getOrgId();
        boolean isInventory = OrgUnitServiceHelper.checkOrgFunction((Long)switchOrg, (String)"05");
        if (isInventory) {
            orgFilter.setDefaultValue(String.valueOf(switchOrg));
        }
    }
}

