/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.utils.DateUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class NewProductMultiSchemeAnaPlugin
extends BaseFormPlugin {
    private static final String KEY_NS_COMPOSITION_ANA = "ai_ids_ns_composition_ana";
    private static final String KEY_LABEL_PREDICT_OBJ = "labelpredictobj";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_PREVALUESUM = "prevaluesum";
    private static final String[] ENTRY_ENTITY_DIFFERENCE_COL_ARR = new String[]{"firstweekdistributionqty", "price", "priceposition", "prevaluesum"};

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String idListStr = (String)formShowParameter.getCustomParam("idList");
        List idList = JSONArray.parseArray((String)idListStr, Long.class);
        QFilter qFilter = new QFilter("id", "in", (Object)idList);
        DynamicObject[] schemeDoArr = BusinessDataServiceHelper.load((String)"ids_ns_predict_scheme", (String)"id,name,number,orgid,orgid.name,warehouseid,warehouseid.name,materialid,materialid.id,materialid.masterid.baseunit.id,materialid.masterid.id,materialid.masterid.name,price,priceposition,caltime,firstweekdistributionqty,firstdistributiondate,requestid,predictstatus,predictdata,predictdata_tag", (QFilter[])qFilter.toArray());
        if (schemeDoArr != null && schemeDoArr.length > 0) {
            int rowCount = schemeDoArr.length;
            HashMap colValueListMap = new HashMap();
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, rowCount);
            String ffirstdistributiondateStr = "";
            JSONArray dataList = new JSONArray();
            String predictObjName = "";
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject schemeDo = schemeDoArr[i];
                if (StringUtils.isEmpty((CharSequence)predictObjName)) {
                    predictObjName = String.format("%s>%s>%s", schemeDo.getString("orgid.name"), schemeDo.getString("warehouseid.name"), schemeDo.getString("materialid.masterid.name"));
                }
                Date ffirstdistributiondate = schemeDo.getDate("firstdistributiondate");
                JSONObject predictdataJo = JSONObject.parseObject((String)schemeDo.getString("predictdata_tag"));
                long prevaluesum = this.prevalueSum(predictdataJo);
                predictdataJo.put("name", (Object)schemeDo.getString("name"));
                predictdataJo.put("number", (Object)schemeDo.getString("number"));
                if (StringUtils.isEmpty((CharSequence)ffirstdistributiondateStr)) {
                    ffirstdistributiondateStr = KDDateFormatUtils.getDateFormat().format(ffirstdistributiondate);
                }
                dataList.add((Object)predictdataJo);
                for (String col : ENTRY_ENTITY_DIFFERENCE_COL_ARR) {
                    String colValue = col.equalsIgnoreCase(KEY_PREVALUESUM) ? String.valueOf(prevaluesum) : schemeDo.get(col).toString();
                    ArrayList<String> valueList = (ArrayList<String>)colValueListMap.get(col);
                    if (valueList == null) {
                        valueList = new ArrayList<String>();
                    }
                    if (!valueList.contains(colValue)) {
                        valueList.add(colValue);
                    }
                    colValueListMap.put(col, valueList);
                }
                this.getModel().setValue("name", (Object)schemeDo.getString("name"), rowIndex[i]);
                this.getModel().setValue("materialid", (Object)schemeDo.getLong("materialid.masterid.id"), rowIndex[i]);
                this.getModel().setValue("firstweekdistributionqty", (Object)schemeDo.getInt("firstweekdistributionqty"), rowIndex[i]);
                this.getModel().setValue("baseunit", (Object)schemeDo.getLong("materialid.masterid.baseunit.id"), rowIndex[i]);
                this.getModel().setValue("firstdistributiondate", (Object)schemeDo.getDate("firstdistributiondate"), rowIndex[i]);
                this.getModel().setValue("price", (Object)schemeDo.getBigDecimal("price"), rowIndex[i]);
                this.getModel().setValue("priceposition", (Object)schemeDo.getString("priceposition"), rowIndex[i]);
                this.getModel().setValue(KEY_PREVALUESUM, (Object)prevaluesum, rowIndex[i]);
            }
            for (String col : ENTRY_ENTITY_DIFFERENCE_COL_ARR) {
                List valueList = (List)colValueListMap.get(col);
                if (valueList == null || valueList.size() <= 1) continue;
                entryGrid.setColumnProperty(col, "bc", (Object)"#FFF1D4");
                entryGrid.setColumnProperty(col, "fc", (Object)"#0E5FD8");
            }
            this.setLabelText(KEY_LABEL_PREDICT_OBJ, predictObjName);
            List periodList = DateUtils.getNewProductPredictPeriodList((String)ffirstdistributiondateStr);
            JSONObject dataJo = new JSONObject();
            dataJo.put("periodList", (Object)periodList);
            dataJo.put("dataList", (Object)dataList);
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("containerId", KEY_NS_COMPOSITION_ANA);
            customData.put("chartType", "ids_part_ana");
            customData.put("timestamp", new Date().getTime());
            customData.put("data", dataJo);
            customData.put("uniqueCode", this.getView().getPageId());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl(KEY_NS_COMPOSITION_ANA);
            customControl.setData(customData);
        }
    }

    private long prevalueSum(JSONObject predictdataJo) {
        JSONArray prevalueJa;
        JSONArray prevalueJaNdarray;
        JSONObject dataJo = predictdataJo.getJSONObject("data");
        long prevaluesum = 0L;
        if (dataJo != null && (prevalueJaNdarray = dataJo.getJSONArray("ndarray")) != null && prevalueJaNdarray.size() > 0 && (prevalueJa = prevalueJaNdarray.getJSONArray(0)) != null && prevalueJa.size() > 0) {
            for (Object o : prevalueJa) {
                BigDecimal prevalueD = (BigDecimal)o;
                long prevalue = prevalueD.setScale(0, RoundingMode.HALF_UP).longValue();
                prevaluesum += prevalue;
            }
        }
        return prevaluesum;
    }
}

