/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.ids.core.enumtype.PredictStatusEnum;
import kd.ai.ids.core.query.data.NewProductBatchGetPredictDataQuery;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.plugin.form.BaseListPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class NewProductPredictBillListPlugin
extends BaseListPlugin {
    private static final Log log = LogFactory.getLog(NewProductPredictBillListPlugin.class);
    private static final String KEY_BTN_MULTI_SCHEME_COMPARISON = "multischemecomparison";
    private static final String KEY_BTN_REFRESH = "refresh";
    private static final String KEY_TOOLBARAP = "toolbarap";

    private String getSubServiceId() {
        return this.getCache().get("subServiceId");
    }

    private void setSubServiceId() {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
        String subServiceId = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
        this.getCache().put("subServiceId", subServiceId);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        this.updatePredictDataStatus();
    }

    private void updatePredictDataStatus() {
        RequestContext rc = RequestContext.get();
        QFilter qFilter = new QFilter("predictstatus", "=", (Object)PredictStatusEnum.PROCESSING.getKey());
        DynamicObject[] schemeDoArr = BusinessDataServiceHelper.load((String)"ids_ns_predict_scheme", (String)"id,predictstatus,requestid,predictdata,predictdata_tag", (QFilter[])qFilter.toArray());
        if (schemeDoArr != null && schemeDoArr.length > 0) {
            log.info("\u5f85\u66f4\u65b0\u72b6\u6001\u9884\u6d4b\u8bb0\u5f55\u5171%s\u6761", (Object)schemeDoArr.length);
            this.setSubServiceId();
            ArrayList<String> requestIdList = new ArrayList<String>();
            for (DynamicObject schemeDo : schemeDoArr) {
                String requestId = schemeDo.getString("requestid");
                if (!StringUtils.isNotEmpty((CharSequence)requestId)) continue;
                requestIdList.add(requestId);
            }
            String subServiceId = this.getSubServiceId();
            NewProductBatchGetPredictDataQuery query = new NewProductBatchGetPredictDataQuery();
            query.setNeedData(true);
            query.setRequestIdList(requestIdList);
            query.setSubServiceId(subServiceId);
            JSONObject batchPredictDataJo = this.newProductService().batchGetPredictData(Long.valueOf(rc.getOrgId()), subServiceId, query);
            JSONArray listJa = batchPredictDataJo.getJSONArray("list");
            HashMap<String, JSONObject> requestIdPredictDataJoMap = new HashMap<String, JSONObject>();
            if (listJa != null && listJa.size() > 0) {
                for (Object o : listJa) {
                    JSONObject predictDataJo = (JSONObject)o;
                    String requestId = predictDataJo.getString("requestId");
                    requestIdPredictDataJoMap.put(requestId, predictDataJo);
                }
                for (DynamicObject schemeDo : schemeDoArr) {
                    String requestId = schemeDo.getString("requestid");
                    String predictStatus = PredictStatusEnum.FAIL.getKey();
                    JSONObject itemJo = (JSONObject)requestIdPredictDataJoMap.get(requestId);
                    if (itemJo != null && StringUtils.equalsIgnoreCase((CharSequence)(predictStatus = itemJo.getString("predictStatus")), (CharSequence)PredictStatusEnum.SUCCESS.getKey())) {
                        String predicatDataStr = ResManager.loadKDString((String)"\u9884\u6d4b\u7ed3\u679c\u6570\u636e", (String)"NewProductPredictBillListPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]);
                        JSONObject predictData = itemJo.getJSONObject("predictData");
                        schemeDo.set("predictdata", (Object)predicatDataStr);
                        schemeDo.set("predictdata_tag", (Object)predictData);
                    }
                    schemeDo.set("predictstatus", (Object)predictStatus);
                }
                Object[] saveSchemeDoArr = SaveServiceHelper.save((DynamicObject[])schemeDoArr);
                log.info("\u6210\u529f\u66f4\u65b0\u72b6\u6001\u9884\u6d4b\u8bb0\u5f55\u5171%s\u6761", (Object)(saveSchemeDoArr != null ? saveSchemeDoArr.length : 0));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("number".equals(args.getFieldName()) && args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent) {
            args.setCancel(true);
            BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Object pkId = linkClickEvent.getCurrentRow().getPrimaryKeyValue();
            DynamicObject predictSchemeDo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ids_ns_predict_scheme");
            String name = predictSchemeDo.getString("name");
            String caption = ResManager.loadKDString((String)"\u65b0\u54c1\u5b9e\u65f6\u9884\u6d4b\u7ed3\u679c-%s", (String)"NewProductPredictBillListPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ids_ns_predict_result");
            fsp.setCaption(String.format(caption, name));
            fsp.setCustomParam("id", pkId);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(fsp);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        RequestContext rc = RequestContext.get();
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            ListSelectedRowCollection listSelectedData = donothing.getListSelectedData();
            if (listSelectedData == null || listSelectedData.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"Common_Select_Operation_Data", (String)"ai-ids-plugin", (Object[])new Object[0]));
                return;
            }
            Object[] pkArray = listSelectedData.getPrimaryKeyValues();
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ids_ns_predict_scheme");
            DynamicObject[] selectedDynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)newDynamicObject.getDynamicObjectType());
            if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BTN_MULTI_SCHEME_COMPARISON, (CharSequence)operateKey)) {
                int selectedDataSize = listSelectedData.size();
                if (selectedDataSize > 5) {
                    this.getView().showTipNotification(String.format("\u4e00\u6b21\u6700\u591a\u652f\u63015\u4e2a\u65b9\u6848\u8fdb\u884c\u5bf9\u6bd4\uff0c\u5f53\u524d\u9009\u4e2d\u6570\u91cf\uff1a%s\u3002", selectedDataSize));
                    return;
                }
                ArrayList<String> nsCodeList = new ArrayList<String>();
                for (DynamicObject dynamicObject : selectedDynamicObjectArray) {
                    long orgid = dynamicObject.getDynamicObject("orgid").getLong("id");
                    long warehouseid = dynamicObject.getDynamicObject("warehouseid").getLong("id");
                    DynamicObject materialDo = dynamicObject.getDynamicObject("materialid");
                    long materialid = materialDo != null ? materialDo.getLong("id") : 0L;
                    Date firstdistributiondate = dynamicObject.getDate("firstdistributiondate");
                    String nsCode = String.format("%s_%s_%s_%s", orgid, warehouseid, materialid, KDDateFormatUtils.getDateFormat().format(firstdistributiondate));
                    if (!nsCodeList.contains(nsCode)) {
                        nsCodeList.add(nsCode);
                        if (nsCodeList.size() > 1) {
                            this.getView().showTipNotification("\u4ec5\u652f\u6301\u9009\u62e9\u540c\u4e00\u4e2a\u65b0\u54c1\uff08\u5e93\u5b58\u7ec4\u7ec7+\u4ed3\u5e93+\u65b0\u54c1+\u9996\u6b21\u94fa\u8d27\u65e5\u671f\u4e00\u81f4\uff09\u7684\u9884\u6d4b\u8bb0\u5f55\u8fdb\u884c\u5bf9\u6bd4\u3002");
                            return;
                        }
                    }
                    String predictStatus = dynamicObject.getString("predictstatus");
                    if (StringUtils.equalsIgnoreCase((CharSequence)PredictStatusEnum.SUCCESS.getKey(), (CharSequence)predictStatus)) continue;
                    this.getView().showTipNotification("\u4ec5\u5141\u8bb8\u5bf9\u9884\u6d4b\u6210\u529f\u7684\u65b9\u6848\u8fdb\u884c\u5bf9\u6bd4\u3002");
                    return;
                }
                String caption = ResManager.loadKDString((String)"\u591a\u65b9\u6848\u5bf9\u6bd4\u5206\u6790", (String)"NewProductPredictBillListPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("ids_ns_multi_scheme_ana");
                fsp.setCaption(caption);
                fsp.setCustomParam("idList", (Object)JSONArray.toJSONString((Object)pkArray));
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(fsp);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterColumn createTimeFilter = args.getFilterColumn("caltime");
        createTimeFilter.setDefaultValue("24");
        FilterColumn exitColumn = args.getFilterColumn("predictstatus");
        exitColumn.setDefaultValue(PredictStatusEnum.SUCCESS.getKey());
        FilterColumn orgFilter = args.getFilterColumn("orgid.number");
        Long switchOrg = RequestContext.get().getOrgId();
        boolean isInventory = OrgUnitServiceHelper.checkOrgFunction((Long)switchOrg, (String)"05");
        if (isInventory) {
            orgFilter.setDefaultValue(String.valueOf(switchOrg));
        }
    }
}

