/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.ids.core.service.IRealtimePredictService;
import kd.ai.ids.core.service.Services;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;

public class NewProductPredictBillViewPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(NewProductPredictBillViewPlugin.class);
    IRealtimePredictService service = (IRealtimePredictService)Services.get(IRealtimePredictService.class);

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"materialid")) {
            this.relationHandle();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"firstdistributiondate")) {
            this.loadPricePosition();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"price")) {
            this.loadPricePosition();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"warehouseid")) {
            this.relationHandle();
        }
    }

    private void loadPricePosition() {
        Long materialMaseterId = this.getMaterialMasterId();
        String orgNumber = this.getOrgNumber();
        String warehouseNumber = this.getWarehouseNumber();
        Object dateValue = this.getModel().getValue("firstdistributiondate");
        Object priceValue = this.getModel().getValue("price");
        if (dateValue != null && priceValue != null) {
            Date firstdistributiondate = (Date)dateValue;
            BigDecimal price = (BigDecimal)priceValue;
            if (price.longValue() != 0L) {
                this.initPricePosition(orgNumber, warehouseNumber, materialMaseterId, firstdistributiondate, price);
            }
        }
    }

    private void relationHandle() {
        Long orgId = this.getOrgId();
        Long materialId = this.getMaterialId();
        Long materialMasterId = this.getMaterialMasterId();
        Long warehouseId = this.getWarehouseId();
        String orgNumber = this.getOrgNumber();
        String warehouseNumber = this.getWarehouseNumber();
        if (orgId != null && warehouseId != null && materialId != null) {
            this.initRelationFiled(orgId, materialMasterId, materialId, warehouseId, orgNumber, warehouseNumber);
        }
    }

    private void initRelationFiled(Long orgId, Long materialMasterId, Long materialId, Long warehouseId, String orgNumber, String warehouseNumber) {
        BigDecimal bd;
        IDataModel model = this.getModel();
        Date firstdistributiondate = this.service.getFirstDistributiondate(orgId, materialId, warehouseId);
        model.setValue("firstdistributiondate", (Object)firstdistributiondate);
        BigDecimal firstweekdistributionqty = this.service.getFirstweekdistributionqty(firstdistributiondate, orgId, materialId, warehouseId);
        model.setValue("firstweekdistributionqty", (Object)firstweekdistributionqty);
        BigDecimal price = this.service.getPrice(orgId, materialId, warehouseId);
        model.setValue("price", (Object)price);
        if (firstdistributiondate != null && price != null && (bd = price).longValue() != 0L) {
            this.initPricePosition(orgNumber, warehouseNumber, materialMasterId, firstdistributiondate, price);
        }
    }

    private void initPricePosition(String orgNumber, String warehouseNumber, Long materialMasterId, Date firstdistributiondate, BigDecimal price) {
        IDataModel model = this.getModel();
        JSONObject pricePosition = this.service.getPricePosition(orgNumber, warehouseNumber, materialMasterId, firstdistributiondate != null ? DateFormatUtils.format((Date)firstdistributiondate, (String)"yyyyMMdd") : null, price);
        model.setValue("priceposition", (Object)pricePosition.getString("fpriceposition"));
    }

    private Long getOrgId() {
        IBillModel model = (IBillModel)this.getModel();
        Object value = model.getValue("orgid");
        if (value != null) {
            DynamicObject org = (DynamicObject)value;
            Long orgId = org.getLong("id");
            return orgId;
        }
        return null;
    }

    private String getOrgNumber() {
        IBillModel model = (IBillModel)this.getModel();
        Object value = model.getValue("orgid");
        if (value != null) {
            DynamicObject org = (DynamicObject)value;
            String orgNumber = org.getString("number");
            return orgNumber;
        }
        return null;
    }

    private Long getWarehouseId() {
        IBillModel model = (IBillModel)this.getModel();
        Object value = model.getValue("warehouseid");
        if (value != null) {
            DynamicObject house = (DynamicObject)value;
            Long houseId = house.getLong("id");
            return houseId;
        }
        return null;
    }

    private String getWarehouseNumber() {
        IBillModel model = (IBillModel)this.getModel();
        Object value = model.getValue("warehouseid");
        if (value != null) {
            DynamicObject house = (DynamicObject)value;
            String houseNumber = house.getString("number");
            return houseNumber;
        }
        return null;
    }

    private Long getMaterialId() {
        IBillModel model = (IBillModel)this.getModel();
        Object value = model.getValue("materialid");
        if (value != null) {
            DynamicObject material = (DynamicObject)value;
            Long materialId = material.getLong("id");
            return materialId;
        }
        return null;
    }

    private Long getMaterialMasterId() {
        IBillModel model = (IBillModel)this.getModel();
        Object value = model.getValue("materialid");
        if (value != null) {
            DynamicObject material = (DynamicObject)value;
            Long materialMasterId = material.getLong("masterid.id");
            return materialMasterId;
        }
        return null;
    }

    private String getMaterialNumber() {
        IBillModel model = (IBillModel)this.getModel();
        Object value = model.getValue("materialid");
        if (value != null) {
            DynamicObject material = (DynamicObject)value;
            String materialNumber = material.getString("masterid.number");
            return materialNumber;
        }
        return null;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"bar_start_predict")) {
            if (!this.validateForm()) {
                return;
            }
            if (!this.materialIsNewProduct()) {
                this.getView().showErrorNotification("\u5f55\u5165\u7269\u6599\u4e0d\u662f\u65b0\u54c1\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
                return;
            }
            String requestId = this.startPredict();
            if (StringUtils.isEmpty((CharSequence)requestId)) {
                logger.info("predict fail...");
            }
            this.savePredictRecord(requestId);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private boolean materialIsNewProduct() {
        return this.service.materialIsNewProduct(this.getOrgId(), this.getWarehouseId(), this.getMaterialId());
    }

    private boolean materialHasSale() {
        return this.service.materialHasSale(this.getOrgId(), this.getWarehouseId(), this.getMaterialId());
    }

    private void openPredictAnalystPage(Long pk) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ids_ns_predict_result");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Long> customParams = new HashMap<String, Long>();
        customParams.put("id", pk);
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }

    private boolean validateForm() {
        IBillModel model = (IBillModel)this.getModel();
        Object price = model.getValue("price");
        if (price == null) {
            this.getView().showErrorNotification("\"\u53c2\u8003\u4ef7\u683c\"\u5fc5\u987b\u5927\u4e8e0\u3002");
            return false;
        }
        BigDecimal value = (BigDecimal)price;
        if (value.compareTo(BigDecimal.ZERO) <= 0) {
            this.getView().showErrorNotification("\"\u53c2\u8003\u4ef7\u683c\"\u5fc5\u987b\u5927\u4e8e0\u3002");
            return false;
        }
        Object firstweekdistributionqty = model.getValue("firstweekdistributionqty");
        if (firstweekdistributionqty == null) {
            this.getView().showErrorNotification("\u521d\u59cb\u5468\u94fa\u8d27\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        BigDecimal qty = (BigDecimal)firstweekdistributionqty;
        if (qty.compareTo(BigDecimal.ZERO) <= 0) {
            this.getView().showErrorNotification("\u521d\u59cb\u5468\u94fa\u8d27\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        if (!this.materialHasSale()) {
            Object datevalue = model.getValue("firstdistributiondate");
            if (datevalue != null) {
                Date firstdistributiondate = (Date)datevalue;
                Date nowDate = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                String firstDayStr = sdf.format(firstdistributiondate);
                String nowDayStr = sdf.format(nowDate);
                if (Long.parseLong(firstDayStr) < Long.parseLong(nowDayStr)) {
                    this.getView().showErrorNotification("\u65b0\u54c1\u65e0\u9500\u552e\u65f6\uff0c\u9996\u6b21\u94fa\u8d27\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002");
                    return false;
                }
            } else {
                this.getView().showErrorNotification("\u9996\u6b21\u94fa\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return false;
            }
        }
        return true;
    }

    private String savePredictRecord(String requestId) {
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("materialid");
        Object materialId = material.get("id");
        Object caseName = model.getValue("name");
        Object remark = model.getValue("remark");
        DynamicObject org = (DynamicObject)model.getValue("orgid");
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouseid");
        Object orgid = org.get("id");
        Object warehouseId = warehouse.get("id");
        DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"ids_ns_predict_scheme");
        entity.set("materialid", materialId);
        entity.set("name", caseName);
        String materialNumber = material.getString("masterid.number");
        String predictNumber = this.service.genPredictNumber(this.getMaterialId(), materialNumber);
        model.setValue("number", (Object)predictNumber);
        entity.set("number", (Object)predictNumber);
        entity.set("orgid", orgid);
        entity.set("warehouseid", warehouseId);
        entity.set("remark", remark);
        entity.set("firstweekdistributionqty", model.getValue("firstweekdistributionqty"));
        entity.set("firstdistributiondate", model.getValue("firstdistributiondate"));
        entity.set("price", model.getValue("price"));
        entity.set("priceposition", model.getValue("priceposition"));
        entity.set("creatorid", model.getValue("creatorid"));
        entity.set("createtime", model.getValue("createtime"));
        entity.set("requestid", (Object)requestId);
        entity.set("caltime", (Object)new Date());
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            entity.set("predictstatus", (Object)"fail");
        } else {
            entity.set("predictstatus", (Object)"processing");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        Long pk = (Long)entity.getPkValue();
        this.openPredictAnalystPage(pk);
        return requestId;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    private String startPredict() {
        IRealtimePredictService realtimePredictService = (IRealtimePredictService)Services.get(IRealtimePredictService.class);
        String orgNumber = this.getOrgNumber();
        String warehouseNumber = this.getWarehouseNumber();
        String materialNumber = this.getMaterialNumber();
        Long materialId = this.getMaterialId();
        Long materialMasterId = this.getMaterialMasterId();
        Object dateValue = this.getModel().getValue("firstdistributiondate");
        String firstdistributiondate = "";
        if (dateValue != null) {
            firstdistributiondate = DateFormatUtils.format((Date)((Date)dateValue), (String)"yyyy-MM-dd");
        }
        logger.info("firstdistributiondate:{}", (Object)firstdistributiondate);
        BigDecimal price = this.getModel().getValue("price") != null ? (BigDecimal)this.getModel().getValue("price") : null;
        String fpriceposition = "";
        if (this.getModel().getValue("priceposition") != null) {
            fpriceposition = (String)this.getModel().getValue("priceposition");
        }
        logger.info("fpriceposition:{}", (Object)fpriceposition);
        BigDecimal ffirstweekdistributionqty = null;
        if (this.getModel().getValue("firstweekdistributionqty") != null) {
            ffirstweekdistributionqty = (BigDecimal)this.getModel().getValue("firstweekdistributionqty");
        }
        logger.info("ffirstweekdistributionqty:{}", ffirstweekdistributionqty);
        String fseasonalproducts = realtimePredictService.getSeasonProductFlag(orgNumber, warehouseNumber, materialMasterId, firstdistributiondate);
        logger.info("fseasonalproducts:{}", (Object)fseasonalproducts);
        JSONObject result = realtimePredictService.submitPredict(orgNumber, warehouseNumber, materialNumber, materialMasterId, firstdistributiondate, price, fpriceposition, ffirstweekdistributionqty, fseasonalproducts);
        String requestId = result.getString("requestId");
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            logger.info("predict fail");
        }
        logger.info("requestId:{}", (Object)requestId);
        return requestId;
    }
}

