/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.service.IRealtimePredictService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class NewProductPredictResultPlugin
extends AbstractFormPlugin
implements CountDownListener {
    private IdsPageCache cache;
    private IRealtimePredictService realtimePredictService = (IRealtimePredictService)Services.get(IRealtimePredictService.class);
    private static final String COUNT_DOWN_CONTROL = "countdownap";
    private static int duration = 3;
    private static final String PRE_STATUS = "pre_status";
    private static final String REQUIREID = "requestid";
    private static final String PK = "pk";
    private static final String FIRST_DISTRIBUTION_DATE = "ffirstdistributiondateStr";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String PRE_TOTAL_COUNT = "pre_total_count";
    private static final String PRE_PRICE = "pre_price";

    public IdsPageCache getCache() {
        return this.cache;
    }

    public void initialize() {
        super.initialize();
        if (this.cache == null) {
            this.cache = new IdsPageCache(this.getView().getPageId());
        }
    }

    public void destory() {
        super.destory();
        if (this.cache != null) {
            this.cache.saveChanges();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.cache != null) {
            this.cache.release();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CountDown countDown = (CountDown)this.getControl(COUNT_DOWN_CONTROL);
        countDown.addCountDownListener((CountDownListener)this);
    }

    public void onCountDownEnd(CountDownEvent evt) {
        super.onCountDownEnd(evt);
        String status = this.getCache().get(PRE_STATUS);
        if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"fail")) {
            this.setFailPredictResultStatus();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"processing")) {
            CountDown countDown = (CountDown)this.getControl(COUNT_DOWN_CONTROL);
            countDown.setDuration(duration);
            this.setProcessingPredictResultStatus();
            this.refresh();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"success")) {
            this.setSuccessPredictResultStatus();
        }
    }

    public void afterCreateNewData(EventObject e) {
        long pk;
        DynamicObject object;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object obj = formShowParameter.getCustomParam("id");
        this.getView().setVisible(Boolean.FALSE, new String[]{"pre_fail_img"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pre_fail_tips"});
        if (obj != null && (object = BusinessDataServiceHelper.loadSingle((Object)(pk = ((Long)obj).longValue()), (String)"ids_ns_predict_scheme")) != null) {
            CountDown countDown = (CountDown)this.getControl(COUNT_DOWN_CONTROL);
            countDown.setDuration(duration);
            countDown.start();
            String name = object.getString(NAME);
            String number = object.getString(NUMBER);
            String requestId = object.getString(REQUIREID);
            this.getCache().put(REQUIREID, requestId);
            this.getCache().put(PK, String.valueOf(pk));
            this.getCache().put(NAME, name);
            this.getCache().put(NUMBER, number);
            Date firstdistributiondate = object.getDate("firstdistributiondate");
            String ffirstdistributiondateStr = KDDateFormatUtils.getDateFormat().format(firstdistributiondate);
            this.getCache().put(FIRST_DISTRIBUTION_DATE, ffirstdistributiondateStr);
            this.getView().setFormTitle(new LocaleString("\u65b0\u54c1\u5b9e\u65f6\u9884\u6d4b\u7ed3\u679c-" + name));
            Label predictNameLabel = (Label)this.getControl("predict_name");
            predictNameLabel.setText(name);
            this.initFormData(object);
            String orgNumber = this.getOrgNumber(object);
            String warehouseNumber = this.getWarehouseNumber(object);
            DynamicObject material = object.getDynamicObject("materialid");
            Long materialMasterId = material.getLong("masterid.id");
            String materialNumber = material.getString("masterid.number");
            String materialName = material.getString("masterid.name");
            Object pkvalue = object.getPkValue();
            String baseLevel3GroupName = this.getMaterialBaseLevel3GroupName(materialMasterId);
            this.initPredictData(pkvalue, requestId, number, name, ffirstdistributiondateStr);
            this.initSkuAnalystData(baseLevel3GroupName, orgNumber, warehouseNumber, materialMasterId);
            this.initQtyAnalystData(baseLevel3GroupName, orgNumber, warehouseNumber, materialMasterId);
            this.initMaterialSalesAnalysis(baseLevel3GroupName, orgNumber, warehouseNumber, materialMasterId, materialNumber, materialName);
        }
    }

    private String getOrgNumber(DynamicObject object) {
        DynamicObject org = object.getDynamicObject("orgid");
        String orgNumber = org.getString(NUMBER);
        return orgNumber;
    }

    private String getWarehouseNumber(DynamicObject object) {
        DynamicObject warehouse = object.getDynamicObject("warehouseid");
        String warehouseNumber = warehouse.getString(NUMBER);
        return warehouseNumber;
    }

    private void initFormData(DynamicObject object) {
        DynamicObject material;
        Label numberName = (Label)this.getControl(NUMBER);
        numberName.setText(object.getString(NUMBER));
        Label org = (Label)this.getControl("org");
        DynamicObject orgObject = object.getDynamicObject("orgid");
        if (orgObject != null) {
            String orgName = orgObject.getString(NAME);
            org.setText(orgName);
        }
        Label warehouse = (Label)this.getControl("warehouse");
        DynamicObject warehouseObject = object.getDynamicObject("warehouseid");
        if (warehouseObject != null) {
            String warehouseName = warehouseObject.getString(NAME);
            warehouse.setText(warehouseName);
        }
        if ((material = object.getDynamicObject("materialid")) != null) {
            String materialName = material.getString("masterid.name");
            Label material_name = (Label)this.getControl("material_name");
            material_name.setText(materialName);
            Label material_number = (Label)this.getControl("material_number");
            String materialNumber = material.getString("masterid.number");
            material_number.setText(materialNumber);
            String unit = material.getString("masterid.baseunit.name");
            Label baseunit = (Label)this.getControl("baseunit");
            baseunit.setText(unit);
        }
        Label price = (Label)this.getControl("price");
        Object pr = object.get("price");
        if (pr != null) {
            BigDecimal bp = (BigDecimal)pr;
            String text = String.valueOf(bp.setScale(2, 4));
            this.getCache().put(PRE_PRICE, text);
            price.setText(text);
        }
        Label priceposition = (Label)this.getControl("price_position");
        String ps = String.valueOf(object.get("priceposition"));
        if (StringUtils.equalsIgnoreCase((CharSequence)ps, (CharSequence)"high")) {
            priceposition.setText("\u9ad8");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ps, (CharSequence)"middle")) {
            priceposition.setText("\u4e2d");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ps, (CharSequence)"low")) {
            priceposition.setText("\u4f4e");
        }
        Label firstweekdistributionqty = (Label)this.getControl("firstweekdistributionqty");
        Object qty = object.get("firstweekdistributionqty");
        if (qty != null) {
            BigDecimal bqty = (BigDecimal)qty;
            firstweekdistributionqty.setText(String.valueOf(bqty.setScale(2, 4)));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Object cdate = object.get("caltime");
        if (cdate != null) {
            Label caltime = (Label)this.getControl("caltime");
            Date cfdate = (Date)cdate;
            caltime.setText(sdf.format(cfdate));
        }
        Label firstdistributiondate = (Label)this.getControl("firstdistributiondate");
        Object date = object.get("firstdistributiondate");
        if (date != null) {
            Date fdate = (Date)date;
            firstdistributiondate.setText(sdf.format(fdate));
        }
        Label creatorid = (Label)this.getControl("creatorid");
        creatorid.setText(object.getDynamicObject("creatorid").getString(NAME));
        String status = object.getString("predictstatus");
        this.getCache().put(PRE_STATUS, status);
    }

    private String getMaterialBaseLevel3GroupName(Long materialMasterId) {
        Map groupNames = this.realtimePredictService.getMaterialBaseGroupsName(materialMasterId);
        if (groupNames != null && !groupNames.isEmpty()) {
            String value = this.getLastBaseLevel(groupNames);
            return StringUtils.isEmpty((CharSequence)value) ? "" : value;
        }
        return "";
    }

    private String getLastBaseLevel(Map<String, String> groupNames) {
        List keyLists;
        if (groupNames != null && !groupNames.isEmpty() && (keyLists = groupNames.keySet().stream().filter(s -> s.startsWith("fbase")).collect(Collectors.toList())) != null && !keyLists.isEmpty()) {
            int length = keyLists.size();
            int groupSize = length / 2;
            String lastLevelName = groupNames.get(String.format("fbase%slevel_name", groupSize));
            return lastLevelName;
        }
        return "";
    }

    private void initSkuAnalystData(String baseLevel3GroupName, String orgNumber, String warehouseNumber, Long materialMasterId) {
        JSONObject data = this.realtimePredictService.priceSkuAnalysis(orgNumber, warehouseNumber, materialMasterId);
        Label baselevelSkuLabel = (Label)this.getControl("baselevel_sku");
        baselevelSkuLabel.setText(StringUtils.isEmpty((CharSequence)baseLevel3GroupName) ? "" : baseLevel3GroupName + "-");
        if (data != null) {
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("chartType", "ids_sku_pie");
            customData.put("containerId", "ai_ids_ns_price_sku_ana");
            customData.put("timestamp", new Date().getTime());
            customData.put("data", data);
            customData.put("uniqueCode", "ids_sku_pie_" + this.getView().getPageId());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl("ai_ids_ns_price_sku_ana");
            customControl.setData(customData);
        } else {
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("containerId", "ai_ids_ns_price_sku_ana");
            customData.put("chartType", "ids_sku_pie");
            customData.put("timestamp", new Date().getTime());
            customData.put("data", new JSONObject());
            customData.put("uniqueCode", "ids_sku_pie_" + this.getView().getPageId());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl("ai_ids_ns_price_sku_ana");
            customControl.setData(customData);
        }
    }

    private void initMaterialSalesAnalysis(String baseLevel3GroupName, String orgNumber, String warehouseNumber, Long materialMasterId, String materialNumber, String materialName) {
        Label baselevelMaterialLabel = (Label)this.getControl("baselevel_material");
        baselevelMaterialLabel.setText(StringUtils.isEmpty((CharSequence)baseLevel3GroupName) ? "" : baseLevel3GroupName + "-");
        JSONObject data = this.realtimePredictService.materialSalesAnalysis(orgNumber, warehouseNumber, materialMasterId);
        if (data != null) {
            data.put("currentid", (Object)materialNumber);
            data.put("className", (Object)baseLevel3GroupName);
            String priceStr = this.getCache().get(PRE_PRICE);
            String countStr = this.getCache().get(PRE_TOTAL_COUNT);
            if (!StringUtils.isEmpty((CharSequence)priceStr) && !StringUtils.isEmpty((CharSequence)countStr)) {
                BigDecimal price = new BigDecimal(priceStr);
                BigDecimal count = new BigDecimal(countStr);
                BigDecimal fpreamount = price.multiply(count);
                BigDecimal bd = fpreamount.setScale(2, 4);
                data.put("fpreamount", (Object)bd);
                this.addCurrentMaterial(data, materialNumber, materialName, bd);
            } else {
                data.put("fpreamount", (Object)new BigDecimal(0));
                this.addCurrentMaterial(data, materialNumber, materialName, new BigDecimal(0));
            }
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("containerId", "ai_ids_ns_mats_sales_ana");
            customData.put("chartType", "ids_sku_ana");
            customData.put("timestamp", new Date().getTime());
            customData.put("data", data);
            customData.put("uniqueCode", "ids_sku_ana_" + this.getView().getPageId());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl("ai_ids_ns_mats_sales_ana");
            customControl.setData(customData);
        } else {
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("containerId", "ai_ids_ns_mats_sales_ana");
            customData.put("chartType", "ids_sku_ana");
            customData.put("timestamp", new Date().getTime());
            customData.put("data", new JSONObject());
            customData.put("uniqueCode", "ids_sku_ana_" + this.getView().getPageId());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl("ai_ids_ns_mats_sales_ana");
            customControl.setData(customData);
        }
    }

    private void addCurrentMaterial(JSONObject data, String materialNumber, String materialName, BigDecimal fpreamount) {
        JSONArray fdata = data.getJSONArray("fdata");
        JSONObject material = new JSONObject();
        material.put("id", (Object)materialNumber);
        material.put(NAME, (Object)materialName);
        material.put("famount", (Object)fpreamount);
        material.put("famountpercent", (Object)new BigDecimal(0));
        if (fdata != null && fdata.size() > 0) {
            for (int i = 0; i < fdata.size(); ++i) {
                JSONObject item = fdata.getJSONObject(i);
                String number = item.getString("id");
                if (!StringUtils.equals((CharSequence)number, (CharSequence)materialNumber)) continue;
                fdata.remove(i);
            }
            fdata.add((Object)material);
        } else {
            JSONArray array = new JSONArray();
            data.put("fdata", (Object)array);
        }
    }

    private void initQtyAnalystData(String baseLevel3GroupName, String orgNumber, String warehouseNumber, Long materialMasterId) {
        JSONObject data = this.realtimePredictService.priceQtyAnalysis(orgNumber, warehouseNumber, materialMasterId);
        Label baselevelSkuLabel = (Label)this.getControl("baselevel_qty");
        baselevelSkuLabel.setText(StringUtils.isEmpty((CharSequence)baseLevel3GroupName) ? "" : baseLevel3GroupName + "-");
        if (data != null) {
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("chartType", "ids_sku_bar");
            customData.put("containerId", "ai_ids_ns_price_qty_ana");
            customData.put("timestamp", new Date().getTime());
            data.put("baseLevelLastGroupName", (Object)baseLevel3GroupName);
            customData.put("data", data);
            customData.put("uniqueCode", "ids_qty_pie_" + this.getView().getPageId());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl("ai_ids_ns_price_qty_ana");
            customControl.setData(customData);
        } else {
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("containerId", "ai_ids_ns_price_qty_ana");
            customData.put("chartType", "ids_sku_bar");
            customData.put("timestamp", new Date().getTime());
            JSONObject jo = new JSONObject();
            jo.put("baseLevelLastGroupName", (Object)baseLevel3GroupName);
            customData.put("data", jo);
            customData.put("uniqueCode", "ids_qty_pie_" + this.getView().getPageId());
            customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
            customData.put("pageId", this.getView().getPageId());
            CustomControl customControl = (CustomControl)this.getControl("ai_ids_ns_price_qty_ana");
            customControl.setData(customData);
        }
    }

    private String initPredictData(Object pk, String requestId, String number, String name, String ffirstdistributiondateStr) {
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ids_ns_predict_scheme");
        String status = entity.getString("predictstatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"success")) {
            this.setSuccessPredictResultStatus();
            String predictData = entity.getString("predictdata_tag");
            JSONObject dataObject = JSONObject.parseObject((String)predictData);
            JSONObject data = dataObject != null ? dataObject.getJSONObject("data") : new JSONObject();
            this.displayPredictData(name, number, ffirstdistributiondateStr, data);
            return "processing";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"fail")) {
            this.setFailPredictResultStatus();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"processing")) {
            this.setProcessingPredictResultStatus();
            this.refresh();
        }
        return status;
    }

    private void refresh() {
        String pk = this.getCache().get(PK);
        String requestId = this.getCache().get(REQUIREID);
        String number = this.getCache().get(NUMBER);
        String name = this.getCache().get(NAME);
        String ffirstdistributiondateStr = this.getCache().get(FIRST_DISTRIBUTION_DATE);
        JSONObject object = this.realtimePredictService.singlePredictData(requestId);
        if (object != null) {
            String predictStatus = object.getString("predictStatus");
            this.getCache().put(PRE_STATUS, predictStatus);
            if (StringUtils.equalsIgnoreCase((CharSequence)predictStatus, (CharSequence)"processing")) {
                this.setProcessingPredictResultStatus();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)predictStatus, (CharSequence)"fail")) {
                this.setFailPredictResultStatus();
                DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ids_ns_predict_scheme");
                entity.set("predictstatus", (Object)"fail");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
            } else if (StringUtils.equalsIgnoreCase((CharSequence)predictStatus, (CharSequence)"success")) {
                this.setSuccessPredictResultStatus();
                JSONObject predictData = object.getJSONObject("predictData");
                if (predictData != null) {
                    JSONObject data = predictData.getJSONObject("data");
                    DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ids_ns_predict_scheme");
                    entity.set("predictstatus", (Object)"success");
                    entity.set("predictdata", (Object)"\u9884\u6d4b\u7ed3\u679c\u6570\u636e");
                    entity.set("predictdata_tag", (Object)JSONObject.toJSONString((Object)predictData));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
                    this.displayPredictData(name, number, ffirstdistributiondateStr, data);
                }
            }
        }
    }

    private void setFailPredictResultStatus() {
        CountDown countDown = (CountDown)this.getControl(COUNT_DOWN_CONTROL);
        countDown.pause();
        countDown.release();
        this.getView().setVisible(Boolean.TRUE, new String[]{"pre_fail_img"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"pre_fail_tips"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"img_failed"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"img_success"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"img_processing"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"status"});
        Label pstatus = (Label)this.getControl("status");
        pstatus.setText("\u9884\u6d4b\u5931\u8d25");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "#FB2323");
        this.getView().updateControlMetadata("status", map);
        this.getView().setVisible(Boolean.FALSE, new String[]{"total_label"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"ai_ids_ns_predict_data"});
    }

    private void setSuccessPredictResultStatus() {
        CountDown countDown = (CountDown)this.getControl(COUNT_DOWN_CONTROL);
        countDown.pause();
        countDown.release();
        this.getView().setVisible(Boolean.FALSE, new String[]{"pre_fail_img"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pre_fail_tips"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"img_failed"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"img_success"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"img_processing"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"status"});
        Label pstatus = (Label)this.getControl("status");
        pstatus.setText("\u9884\u6d4b\u6210\u529f");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "#1BA854");
        this.getView().updateControlMetadata("status", map);
        this.getView().setVisible(Boolean.TRUE, new String[]{"total_label"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"ai_ids_ns_predict_data"});
    }

    private void setProcessingPredictResultStatus() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"pre_fail_img"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pre_fail_tips"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"img_failed"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"img_success"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"img_processing"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"status"});
        Label pstatus = (Label)this.getControl("status");
        pstatus.setText("\u9884\u6d4b\u4e2d");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", "#5582F3");
        this.getView().updateControlMetadata("status", map);
        this.getView().setVisible(Boolean.FALSE, new String[]{"total_label"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"ai_ids_ns_predict_data"});
    }

    private void displayPredictData(String name, String number, String ffirstdistributiondateStr, JSONObject data) {
        JSONArray ndarray;
        BigDecimal total = new BigDecimal(0);
        if (data != null && (ndarray = data.getJSONArray("ndarray")) != null && !ndarray.isEmpty()) {
            for (int i = 0; i < ndarray.size(); ++i) {
                JSONArray arr = ndarray.getJSONArray(0);
                for (int j = 0; j < arr.size(); ++j) {
                    BigDecimal bd = arr.getBigDecimal(j);
                    total = total.add(bd.setScale(0, 4));
                }
            }
        }
        Label predict_data_total = (Label)this.getControl("predict_data_total");
        NumberFormat nf = NumberFormat.getInstance();
        this.getCache().put(PRE_TOTAL_COUNT, String.valueOf(total.setScale(2, 4)));
        predict_data_total.setText(nf.format(total.setScale(2, 4)));
        List periodList = DateUtils.getNewProductPredictPeriodList((String)ffirstdistributiondateStr);
        JSONObject dataJo = new JSONObject();
        JSONArray dataList = new JSONArray();
        JSONObject dataItem = new JSONObject();
        dataItem.put(NAME, (Object)name);
        dataItem.put(NUMBER, (Object)number);
        dataItem.put("data", (Object)data);
        dataList.add((Object)dataItem);
        dataJo.put("periodList", (Object)periodList);
        dataJo.put("dataList", (Object)dataList);
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("containerId", "ai_ids_ns_predict_data");
        customData.put("chartType", "ids_predict_result");
        customData.put("timestamp", new Date().getTime());
        customData.put("uniqueCode", this.getView().getPageId());
        customData.put("data", dataJo);
        customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("pageId", this.getView().getPageId());
        CustomControl customControl = (CustomControl)this.getControl("ai_ids_ns_predict_data");
        customControl.setData(customData);
    }
}

