/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.plugin.form.BaseListPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class RequirePlanBillListPlugin
extends BaseListPlugin {
    private static final String KEY_TOOLBARAP = "toolbarap";
    private static final String KEY_BAR_DELETE = "bar_delete";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("billno".equals(args.getFieldName()) && args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent) {
            args.setCancel(true);
            BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Object pkId = linkClickEvent.getCurrentRow().getPrimaryKeyValue();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ids_requireplan");
            String billTitle = object.getString("billtitle");
            String config = object.getString("config_tag");
            JSONObject requirePlanConfig = JSONObject.parseObject((String)config);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ids_requireplan_entry");
            fsp.setCaption(String.format("\u9700\u6c42\u8ba1\u5212\u5355-%s", billTitle));
            fsp.setCustomParam("id", pkId);
            fsp.setCustomParam("config_tag", (Object)requirePlanConfig);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(fsp);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operatorKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operatorKey, (CharSequence)"delete")) {
            ListSelectedRowCollection selectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (selectedRowCollection != null && !selectedRowCollection.isEmpty()) {
                List requirePlanIds = selectedRowCollection.stream().filter(new Predicate<ListSelectedRow>(){

                    @Override
                    public boolean test(ListSelectedRow listSelectedRow) {
                        String billstatus = listSelectedRow.getBillStatus();
                        return StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"A");
                    }
                }).map(new Function<ListSelectedRow, Long>(){

                    @Override
                    public Long apply(ListSelectedRow listSelectedRow) {
                        return (Long)listSelectedRow.getPrimaryKeyValue();
                    }
                }).collect(Collectors.toList());
                QFilter[] filters = new QFilter[]{new QFilter("requireplanid", "in", requirePlanIds)};
                DeleteServiceHelper.delete((String)"ids_requireplan_entry", (QFilter[])filters);
                DeleteServiceHelper.delete((String)"ids_requireplan", (QFilter[])new QFilter[]{new QFilter("id", "in", requirePlanIds)});
                DeleteServiceHelper.delete((String)IdsFormIdEnum.IDS_SALESPLAN_PUSH_HIS.getId(), (QFilter[])new QFilter("requireplanid", "in", requirePlanIds).toArray());
            }
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operatorKey, (CharSequence)"view")) {
            IListView view = (IListView)this.getView();
            Object pkId = view.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ids_requireplan");
            String billTitle = object.getString("billtitle");
            String config = object.getString("config_tag");
            JSONObject requirePlanConfig = JSONObject.parseObject((String)config);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ids_requireplan_detail");
            fsp.setCaption(String.format("\u9700\u6c42\u8ba1\u5212\u5355\u660e\u7ec6-%s", billTitle));
            fsp.setCustomParam("id", pkId);
            fsp.setCustomParam("config_tag", (Object)requirePlanConfig);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(fsp);
        }
    }

    private Long getLastPeriodId() {
        DynamicObject periodDo;
        Long periodId = null;
        DynamicObject[] lastSingleSalesplanDoArr = BusinessDataServiceHelper.load((String)"ids_salesplan", (String)"id,periodid", null, (String)"id desc", (int)1);
        if (lastSingleSalesplanDoArr != null && lastSingleSalesplanDoArr.length > 0 && (periodDo = lastSingleSalesplanDoArr[0].getDynamicObject("periodid")) != null) {
            periodId = (Long)periodDo.getPkValue();
        }
        return periodId;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long periodId = (Long)formShowParameter.getCustomParam("periodid");
        if (periodId == null) {
            periodId = this.getLastPeriodId();
        }
        if (periodId != null) {
            FilterColumn filterColumn = args.getFilterColumn("periodid.number");
        }
    }
}

