/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.constants.RequirePlanConstants;
import kd.ai.ids.core.entity.model.RequirePlanBase;
import kd.ai.ids.core.entity.model.RequirePlanCustomer;
import kd.ai.ids.core.entity.model.RequirePlanInv;
import kd.ai.ids.core.entity.model.RequirePlanMaterial;
import kd.ai.ids.core.entity.model.RequirePlanTree;
import kd.ai.ids.core.entity.model.RequirePlanWarehouse;
import kd.ai.ids.core.enumtype.CustomControlEventNameEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IRequirePlanService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.ListUtils;
import kd.ai.ids.core.utils.PermUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class RequirePlanEntryBillPlugin
extends AbstractBillPlugIn
implements TreeNodeClickListener,
TreeNodeCheckListener,
TreeNodeQueryListener,
ListboxClickListener,
SearchEnterListener,
CellClickListener {
    private IdsPageCache cache;
    public static RequirePlanTree tree = new RequirePlanTree();
    private static final Log logger = LogFactory.getLog(RequirePlanEntryBillPlugin.class);
    private IRequirePlanService requirePlanService = (IRequirePlanService)Services.get(IRequirePlanService.class);
    private static Map<String, TreeNode> treeNodeMap = new ConcurrentHashMap<String, TreeNode>();
    private static final String KEY_BAR_SAVE = "bar_save";
    private static final String KEY_BAR_SUBMIT = "bar_submit";
    private static final String KEY_BAR_UNSUBMIT = "bar_unsubmit";
    private static final String KEY_BAR_AUDIT = "bar_audit";
    private static final String KEY_BAR_UNAUDIT = "bar_unaudit";
    private static final String KEY_BAR_EXPORT = "bar_export";
    private static final String KEY_ENTRYENTITY = "ids_req_indicator_entry";
    private static final String KEY_EXPORT_ENTRYENTITY = "export_entryentity";
    private static final char PRE_COL_SPE_FLAG = '_';
    private static final String PRE_COL_FLAG = "value";
    private static final String FEATURE_PRE_COL_FIX = "value";
    private static final String HISTORY_PRE_COL_FIX = String.format("%s%s", "value", Character.valueOf('_'));
    private static final String DEFAULT_CANNOT_MODIFY_METRICS = "default_cannot_modify_metrics";
    private static final String COMBO_METRIC_SELECTOR = "metric_select";
    private static final String COMBO_HIS_PRE_SELECTOR = "his_select";
    private static final String COMBO_FEATURE_PRE_SELECTOR = "feature_select";
    private static final String COMBO_DIM_SELECTOR = "dim_select";
    private static final String COMBO_ADOPTQTY_SELECTOR = "fill_select";
    private static final String ENTRY_COL_INDICATOR = "indicator";
    private static final String ENTRY_COL_INDICATOR_NAME = "indicator_name";
    private static final String COMBO_PREMODELTYPE_ID = "modeltypeid";
    private static final String TREE_ROOT_NODE = "dim";
    private static final String TREE_CONTROL_KEY = "dim_tree";
    private static final boolean TREE_NODE_DISPLAY_NUMBER = false;
    private static final boolean TREE_SEARCH_INGRO_CASE = true;
    private static final String TREE_NODE_PREFIX_MATERIAL = "material_";
    private static final String TREE_NODE_PREFIX_INVORG = "invorg_";
    private static final String TREE_NODE_PREFIX_WAREHOUSE = "warehouse_";
    private static final String TREE_NODE_PREFIX_CUSTOMER = "customer_";
    private static final String CURRENT_DISPLAY_COL_HIS_CACHE_KEY = "pre_period_col_his_cache";
    private static final String CURRENT_DISPLAY_COL_FEA_CACHE_KEY = "pre_period_col_fea_cache";
    private static final String CURRENT_DISPLAY_METRIC_ROW_COUNT_KEY = "current_metric_row_count";
    private static final String CURRENT_SELECTED_NODE_TYPE = "current_select_node_type_";
    private static final String CURRENT_SELECTED_NODE_ID = "current_select_node_id_";
    private static final String CURRENT_SHOW_METRICS = "current_show_metrics";
    private static final String CURRENT_METRIC_ROW_INDEX = "current_metric_row_index_";
    private static final String ROW_INDEX_MAPPING_METRICS = "row_index_mappping_metrics";
    private static final String CURRENT_ADOPTQTY_TYPE = "current_adoptqty_type";
    private static final String CONTROL_LIST_BOX = "listboxap";
    private static final String INDICATOR_NAME_CACHE_PRE = "indicator_";
    private static final String DIM_SUM_DATA_NODE_PRE = "dim_sum_data_";
    private static final String DIM_SUM_DATA_NODE_PRE_AMOUNT = "dim_sum_data_amount";
    private static final String DIM_SUM_DATA_NODE_PRE_QTY = "dim_sum_data_qty";
    private static final String CHAT_SHOW_METRIC_QTY = "fqty";
    private static final String CHAT_SHOW_METRIC_AMOUNT = "famount";
    private static final String CHAT_SHOW_PRE_TYPE_ACTIVE = "active_chat_pre_type";
    private static final String CONTROL_LABEL_EXPAND = "bar_expand";
    private static final String CONTROL_LABEL_COLLAPSE = "bar_collapse";
    private static final String CONTROL_LABEL_BASE_UNIT = "label_baseunit";
    private static final String CONTROL_LABEL_COUNT_UNIT = "label_countunit";
    private static final String TREE_SEARCH_CONTROL = "dim_tree_search";
    private static final boolean ENTRY_INDICATOR_COL_FIX = true;
    private static final String CUSTOM_EVENT_SHOW_TIPS = "showTip";
    private static final String CUSTOM_CONTROL_CHAT = "ai_ids_req_value_ana";
    private static final String KEY_FIELDKEY_RENAME_MAP = "fieldkey_rename_map";
    private static final String CURRENT_VALUE_CHANGED_CELL_FIELD_KEY = "current_value_changed_cell_field_key";

    public IdsPageCache getCache() {
        return this.cache;
    }

    public void initialize() {
        super.initialize();
        if (this.cache == null) {
            this.cache = new IdsPageCache(this.getView().getPageId());
        }
    }

    public void destory() {
        super.destory();
        if (this.cache != null) {
            this.cache.saveChanges();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.cache != null) {
            this.cache.release();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Listbox box = (Listbox)this.getView().getControl(CONTROL_LIST_BOX);
        box.addListboxClickListener((ListboxClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
        Label expand = (Label)this.getControl(CONTROL_LABEL_EXPAND);
        expand.addClickListener((ClickListener)this);
        expand.addItemClickListener((ItemClickListener)this);
        Label collapse = (Label)this.getControl(CONTROL_LABEL_COLLAPSE);
        collapse.addClickListener((ClickListener)this);
        collapse.addItemClickListener((ItemClickListener)this);
        Search search = (Search)this.getControl(TREE_SEARCH_CONTROL);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_EXPORT_ENTRYENTITY});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object idObject = formShowParameter.getCustomParam("id");
        if (idObject != null) {
            long requirePlanId = (Long)idObject;
            JSONObject requirePlanConfig = (JSONObject)formShowParameter.getCustomParam("config_tag");
            this.getCache().put("config_tag", JSONObject.toJSONString((Object)requirePlanConfig));
            this.initCombo(requirePlanConfig);
            this.initListbox();
            this.initRequirePlanBillHead(requirePlanId);
            this.loadingRequirePlanData(requirePlanId);
            this.loadingExportRequirePlanData(requirePlanId);
        }
    }

    private void initListbox() {
        ListboxItem listboxItem1 = new ListboxItem(CHAT_SHOW_METRIC_QTY, "\u6570\u91cf");
        ListboxItem listboxItem2 = new ListboxItem(CHAT_SHOW_METRIC_AMOUNT, "\u91d1\u989d");
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>();
        itemlist.add(listboxItem1);
        itemlist.add(listboxItem2);
        Listbox box = (Listbox)this.getView().getControl(CONTROL_LIST_BOX);
        box.addItems(itemlist);
    }

    private void loadingRequirePlanData(long requirePlanId) {
        List dims = this.getCache().getAsList("fpredimentype", String.class);
        JSONObject data = this.requirePlanService.loadingRequireData(requirePlanId, dims, new HashMap());
        this.getCache().put("require_plan_data_cache", JSONObject.toJSONString((Object)data));
        tree = this.resetDimShowTree(dims, data);
        if (tree != null) {
            this.showTree(tree);
            List nodes = tree.getChildren();
            if (nodes != null && !nodes.isEmpty()) {
                RequirePlanBase firstNode = (RequirePlanBase)nodes.get(0);
                String nodeId = firstNode.getNodeId();
                String nodeType = firstNode.getNodeType();
                String treeNodeId = String.format("%s_%s", nodeType, nodeId);
                this.setColEditable(Boolean.FALSE);
                this.getCache().put(CURRENT_SELECTED_NODE_TYPE, nodeType);
                this.getCache().put(CURRENT_SELECTED_NODE_ID, treeNodeId);
                this.dimNodeClick(treeNodeId, nodeType);
                TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
                TreeNode node = treeNodeMap.get(treeNodeId);
                if (node != null) {
                    treeView.focusNode(node);
                }
            }
        }
    }

    private void handleDimChange(PropertyChangedArgs e) {
        JSONObject data;
        String str;
        ChangeData[] changeData = e.getChangeSet();
        List<String> dims = new ArrayList<String>();
        if (changeData[0] != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(str = (String)changeData[0].getNewValue()))) {
            String[] arrays = str.substring(1, str.lastIndexOf(44)).split(",");
            dims = Arrays.asList(arrays);
        }
        if ((tree = this.resetDimShowTree(dims, data = this.getCache().getAsObject("require_plan_data_cache"))) != null) {
            this.showTree(tree);
        }
    }

    private void showTree(RequirePlanTree tree) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
        if (treeView != null) {
            treeView.deleteAllNodes();
            treeView.setMulti(Boolean.FALSE.booleanValue());
            String rootNodeId = TREE_ROOT_NODE;
            TreeNode root = new TreeNode("", rootNodeId, "\u7ef4\u5ea6");
            treeView.setRootVisible(Boolean.FALSE.booleanValue());
            treeView.addNode(root);
            treeView.expand(TREE_ROOT_NODE);
            treeView.setDraggable(Boolean.FALSE.booleanValue());
            if (tree != null) {
                List nodes = tree.getChildren();
                this.addTreeNodes(root, rootNodeId, nodes);
            }
        }
    }

    private void addTreeNodes(TreeNode root, String rootNodeId, List<RequirePlanBase> rootNodes) {
        for (RequirePlanBase node : rootNodes) {
            String nodeId = node.getNodeId();
            String nodeName = node.getNodeName();
            String nodeType = node.getNodeType();
            String nodeNumber = node.getNodeNumber();
            String currentNodeId = String.format("%s_%s", nodeType, nodeId);
            String showName = "";
            showName = String.format("%s", nodeName);
            TreeNode tNode = new TreeNode(rootNodeId, currentNodeId, showName);
            treeNodeMap.put(currentNodeId, tNode);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)nodeType, (CharSequence)"material")) {
                if (tree.containsLevel("fmaterialid")) {
                    root.addChild(tNode);
                }
            } else {
                root.addChild(tNode);
            }
            if (node.getChildren().isEmpty()) continue;
            this.addTreeNodes(tNode, currentNodeId, node.getChildren());
        }
    }

    private RequirePlanTree resetDimShowTree(List<String> lists, JSONObject data) {
        if (tree != null) {
            tree.getChildren().clear();
            tree.getLevels().clear();
            List dims = lists.stream().filter(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return true;
                }
            }).collect(Collectors.toList());
            JSONObject dic = data.getJSONObject("dic");
            if (dims.contains("finvorgid")) {
                final JSONObject org = dic.getJSONObject("finvorgid");
                org.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String orgId) {
                        JSONObject orgEntry = org.getJSONObject(orgId);
                        String name = orgEntry.getString("name");
                        String number = orgEntry.getString("number");
                        RequirePlanInv orgNode = new RequirePlanInv(orgId, name);
                        orgNode.setNodeNumber(number);
                        tree.addChild((RequirePlanBase)orgNode);
                    }
                });
                tree.addLevel("finvorgid");
            }
            if (dims.contains("fwarehouseid")) {
                JSONObject warehouse;
                if (tree.containsLevel("finvorgid")) {
                    warehouse = dic.getJSONObject("fwarehouseid");
                    warehouse.keySet().stream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String warehouseId) {
                            JSONObject whEntry = warehouse.getJSONObject(warehouseId);
                            String name = whEntry.getString("name");
                            String parentOrg = whEntry.getString("parent_org");
                            String number = whEntry.getString("number");
                            RequirePlanWarehouse whNode = new RequirePlanWarehouse(warehouseId, name);
                            whNode.setNodeNumber(number);
                            whNode.setParent(parentOrg);
                            RequirePlanBase parentNode = RequirePlanEntryBillPlugin.this.findParentNode(tree.getChildren(), parentOrg, "invorg");
                            if (parentNode != null) {
                                parentNode.addChild((RequirePlanBase)whNode);
                            }
                        }
                    });
                } else {
                    warehouse = dic.getJSONObject("fwarehouseid");
                    warehouse.keySet().stream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String warehouseId) {
                            JSONObject whEntry = warehouse.getJSONObject(warehouseId);
                            String name = whEntry.getString("name");
                            String number = whEntry.getString("number");
                            RequirePlanWarehouse whNode = new RequirePlanWarehouse(warehouseId, name);
                            whNode.setNodeNumber(number);
                            tree.getChildren().add(whNode);
                        }
                    });
                }
                tree.addLevel("fwarehouseid");
            }
            if (dims.contains("fcustid")) {
                JSONObject customer;
                if (tree.containsLevel("fwarehouseid")) {
                    customer = dic.getJSONObject("fcustid");
                    customer.keySet().stream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String custId) {
                            JSONObject custEntry = customer.getJSONObject(custId);
                            String name = custEntry.getString("name");
                            String number = custEntry.getString("number");
                            String parentWarehouse = custEntry.getString("parent_warehouse");
                            RequirePlanCustomer custNode = new RequirePlanCustomer(custId, name);
                            custNode.setNodeNumber(number);
                            custNode.setParent(parentWarehouse);
                            RequirePlanBase parentNode = RequirePlanEntryBillPlugin.this.findParentNode(tree.getChildren(), parentWarehouse, "warehouse");
                            if (parentNode != null) {
                                parentNode.addChild((RequirePlanBase)custNode);
                            }
                        }
                    });
                    tree.addLevel("fcustid");
                } else {
                    if (dims.contains("finvorgid")) {
                        customer = dic.getJSONObject("fcustid");
                        customer.keySet().stream().forEach(new Consumer<String>(){

                            @Override
                            public void accept(String custId) {
                                JSONObject custEntry = customer.getJSONObject(custId);
                                String name = custEntry.getString("name");
                                String parentOrg = custEntry.getString("parent_org");
                                String number = custEntry.getString("number");
                                RequirePlanCustomer custNode = new RequirePlanCustomer(custId, name);
                                custNode.setParent(parentOrg);
                                custNode.setNodeNumber(number);
                                RequirePlanBase parentNode = RequirePlanEntryBillPlugin.this.findParentNode(tree.getChildren(), parentOrg, "invorg");
                                if (parentNode != null) {
                                    parentNode.addChild((RequirePlanBase)custNode);
                                }
                            }
                        });
                    } else {
                        customer = dic.getJSONObject("fcustid");
                        customer.keySet().stream().forEach(new Consumer<String>(){

                            @Override
                            public void accept(String custId) {
                                JSONObject custEntry = customer.getJSONObject(custId);
                                String name = custEntry.getString("name");
                                String number = custEntry.getString("number");
                                RequirePlanCustomer custNode = new RequirePlanCustomer(custId, name);
                                custNode.setNodeNumber(number);
                                tree.getChildren().add(custNode);
                            }
                        });
                    }
                    tree.addLevel("fcustid");
                }
            }
            final JSONObject preData = data.getJSONObject("data");
            if (tree.containsLevel("fcustid")) {
                preData.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String materialId) {
                        JSONObject materialData = preData.getJSONObject(materialId);
                        JSONObject dimData = materialData.getJSONObject(RequirePlanEntryBillPlugin.TREE_ROOT_NODE);
                        String custId = dimData.getString("fcustid");
                        RequirePlanBase parentNode = RequirePlanEntryBillPlugin.this.findParentNode(tree.getChildren(), custId, "customer");
                        String name = materialData.getString("name");
                        RequirePlanMaterial materalNode = new RequirePlanMaterial(materialId, name);
                        materalNode.setData(materialData);
                        String number = materialData.getString("number");
                        materalNode.setNodeNumber(number);
                        if (parentNode != null) {
                            parentNode.addChild((RequirePlanBase)materalNode);
                        }
                        RequirePlanEntryBillPlugin.this.getCache().put(String.format("%s_%s", materalNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                    }
                });
                tree.addLevel("fmaterialid");
            } else if (tree.containsLevel("fwarehouseid")) {
                preData.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String materialId) {
                        JSONObject materialData = preData.getJSONObject(materialId);
                        JSONObject dimData = materialData.getJSONObject(RequirePlanEntryBillPlugin.TREE_ROOT_NODE);
                        String warehouseId = dimData.getString("fwarehouseid");
                        RequirePlanBase parentNode = RequirePlanEntryBillPlugin.this.findParentNode(tree.getChildren(), warehouseId, "warehouse");
                        String name = materialData.getString("name");
                        RequirePlanMaterial materalNode = new RequirePlanMaterial(materialId, name);
                        materalNode.setData(materialData);
                        if (parentNode != null) {
                            parentNode.addChild((RequirePlanBase)materalNode);
                        }
                        String number = materialData.getString("number");
                        materalNode.setNodeNumber(number);
                        RequirePlanEntryBillPlugin.this.getCache().put(String.format("%s_%s", materalNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                    }
                });
                tree.addLevel("fmaterialid");
            } else if (tree.containsLevel("finvorgid")) {
                preData.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String materialId) {
                        JSONObject materialData = preData.getJSONObject(materialId);
                        JSONObject dimData = materialData.getJSONObject(RequirePlanEntryBillPlugin.TREE_ROOT_NODE);
                        String invorgId = dimData.getString("finvorgid");
                        RequirePlanBase parentNode = RequirePlanEntryBillPlugin.this.findParentNode(tree.getChildren(), invorgId, "invorg");
                        String name = materialData.getString("name");
                        RequirePlanMaterial materalNode = new RequirePlanMaterial(materialId, name);
                        materalNode.setData(materialData);
                        if (parentNode != null) {
                            parentNode.addChild((RequirePlanBase)materalNode);
                        }
                        String number = materialData.getString("number");
                        materalNode.setNodeNumber(number);
                        RequirePlanEntryBillPlugin.this.getCache().put(String.format("%s_%s", materalNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                    }
                });
                tree.addLevel("fmaterialid");
            } else {
                preData.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String materialId) {
                        JSONObject materialData = preData.getJSONObject(materialId);
                        String name = materialData.getString("name");
                        RequirePlanMaterial materalNode = new RequirePlanMaterial(materialId, name);
                        materalNode.setData(materialData);
                        String number = materialData.getString("number");
                        materalNode.setNodeNumber(number);
                        tree.addChild((RequirePlanBase)materalNode);
                        RequirePlanEntryBillPlugin.this.getCache().put(String.format("%s_%s", materalNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                    }
                });
                tree.addLevel("fmaterialid");
            }
            if (!dims.contains("fmaterialid")) {
                tree.removeLevel("fmaterialid");
            }
        }
        return tree;
    }

    private RequirePlanMaterial findMaterialNode(List<RequirePlanBase> nodes, final String materialTreeNodeId) {
        List _nodes;
        List<RequirePlanBase> materialNodes = this.findMaterialNodes(nodes);
        if (materialNodes != null && !materialNodes.isEmpty() && (_nodes = materialNodes.stream().filter(new Predicate<RequirePlanBase>(){

            @Override
            public boolean test(RequirePlanBase requirePlanBase) {
                String _nodeId = requirePlanBase.getNodeId();
                String nodeType = requirePlanBase.getNodeType();
                return org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)materialTreeNodeId, (CharSequence)String.format("%s_%s", nodeType, _nodeId));
            }
        }).collect(Collectors.toList())) != null && !_nodes.isEmpty()) {
            return (RequirePlanMaterial)_nodes.get(0);
        }
        return null;
    }

    private List<RequirePlanBase> findMaterialNodes(List<RequirePlanBase> nodes, String parentNodeId, String parentNodeType) {
        RequirePlanBase currentNode = this.findParentNode(nodes, parentNodeId, parentNodeType);
        if (currentNode != null) {
            return this.findMaterialNodes(currentNode.getChildren());
        }
        return new ArrayList<RequirePlanBase>();
    }

    private List<RequirePlanBase> findMaterialNodes(List<RequirePlanBase> nodes) {
        if (!nodes.isEmpty()) {
            RequirePlanBase first = nodes.get(0);
            String nodeType = first.getNodeType();
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"material")) {
                ArrayList<RequirePlanBase> allNodes = new ArrayList<RequirePlanBase>();
                for (RequirePlanBase item : nodes) {
                    allNodes.addAll(item.getChildren());
                }
                return this.findMaterialNodes(allNodes);
            }
            return nodes;
        }
        return new ArrayList<RequirePlanBase>();
    }

    private List<RequirePlanBase> searchMaterialNodesByStr(String findStr, String searchType) {
        return this.searchMaterialNodesByStr(tree.getChildren(), findStr, searchType);
    }

    private List<RequirePlanBase> searchMaterialNodesByStr(List<RequirePlanBase> nodes, String findStr, String searchType) {
        if (nodes != null && !nodes.isEmpty()) {
            RequirePlanBase first = nodes.get(0);
            String nodeType = first.getNodeType();
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"material")) {
                ArrayList<RequirePlanBase> allNodes = new ArrayList<RequirePlanBase>();
                for (RequirePlanBase item : nodes) {
                    allNodes.addAll(item.getChildren());
                }
                return this.searchMaterialNodesByStr(allNodes, findStr, searchType);
            }
            ArrayList<RequirePlanBase> res = new ArrayList<RequirePlanBase>();
            for (RequirePlanBase node : nodes) {
                String number = node.getNodeNumber();
                String name = node.getNodeName();
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)searchType, (CharSequence)"number") && number.toLowerCase().indexOf(findStr.toLowerCase()) != -1) {
                    res.add(node);
                    continue;
                }
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)searchType, (CharSequence)"name") || name.toLowerCase().indexOf(findStr.toLowerCase()) == -1) continue;
                res.add(node);
            }
            return res;
        }
        return new ArrayList<RequirePlanBase>();
    }

    private RequirePlanBase findParentNode(List<RequirePlanBase> nodes, String findNodeId, String findNodeType) {
        if (nodes.isEmpty()) {
            return null;
        }
        RequirePlanBase node = nodes.get(0);
        String nodeType = node.getNodeType();
        if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)findNodeType)) {
            ArrayList<RequirePlanBase> allNodes = new ArrayList<RequirePlanBase>();
            for (RequirePlanBase item : nodes) {
                allNodes.addAll(item.getChildren());
            }
            return this.findParentNode(allNodes, findNodeId, findNodeType);
        }
        for (RequirePlanBase requirePlanBase : nodes) {
            String type = requirePlanBase.getNodeType();
            String nodeId = requirePlanBase.getNodeId();
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)findNodeType) || !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeId, (CharSequence)findNodeId)) continue;
            return requirePlanBase;
        }
        return null;
    }

    private void initRequirePlanBillHead(long pk) {
        DynamicObject requirePlanObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ids_requireplan");
        IDataModel model = this.getModel();
        String modeltypeid = requirePlanObject.getString(COMBO_PREMODELTYPE_ID);
        String billno = requirePlanObject.getString("billno");
        model.setValue("requireplanid", (Object)pk);
        model.setValue("billno", (Object)billno);
        DynamicObject period = requirePlanObject.getDynamicObject("periodid");
        long periodid = (Long)period.getPkValue();
        this.loadingBizAssociateScheme(modeltypeid, periodid);
        String billstatus = requirePlanObject.getString("billstatus");
        model.setValue("billstatus", (Object)billstatus);
        this.getCache().put("billsatus_cache", billstatus);
        this.refreshBtnStatus();
        String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
        IFormView view = this.getView();
        if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)currentNodeType, (CharSequence)"material")) {
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_SAVE});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{KEY_BAR_SAVE});
        }
    }

    private void refreshBtnStatus() {
        IDataModel model = this.getModel();
        String billstatus = (String)model.getValue("billstatus");
        IFormView view = this.getView();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"A")) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            view.setEnable(Boolean.TRUE, new String[]{KEY_BAR_SAVE});
            view.setEnable(Boolean.TRUE, new String[]{KEY_BAR_SUBMIT});
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_UNSUBMIT});
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_AUDIT});
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_UNAUDIT});
            String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)currentNodeType, (CharSequence)"material")) {
                this.setColEditable(Boolean.TRUE);
                this.setAllHisMetricColDisable();
                this.setFeaMetricColDisable();
            }
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"B")) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_SAVE});
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_SUBMIT});
            view.setEnable(Boolean.TRUE, new String[]{KEY_BAR_UNSUBMIT});
            view.setEnable(Boolean.TRUE, new String[]{KEY_BAR_AUDIT});
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_UNAUDIT});
            this.setColEditable(Boolean.FALSE);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"C")) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_SAVE});
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_SUBMIT});
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_UNSUBMIT});
            view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_AUDIT});
            view.setEnable(Boolean.TRUE, new String[]{KEY_BAR_UNAUDIT});
            this.setColEditable(Boolean.FALSE);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String fieldKey = e.getKey();
        if (fieldKey.startsWith(HISTORY_PRE_COL_FIX)) {
            e.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)COMBO_METRIC_SELECTOR)) {
            this.getCache().remove("metric_cell_value_change_type");
            this.handleMetricChange(e);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)COMBO_HIS_PRE_SELECTOR)) {
            this.handlePeriodSelectChange(e, HISTORY_PRE_COL_FIX);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)COMBO_FEATURE_PRE_SELECTOR)) {
            this.handlePeriodSelectChange(e, "value");
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)COMBO_DIM_SELECTOR)) {
            this.handleDimChange(e);
        } else if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)COMBO_ADOPTQTY_SELECTOR) && name.startsWith("value") && name.indexOf(95) == -1) {
            ChangeData[] data = e.getChangeSet();
            this.rowFeatureCellDataChange(name, data);
        }
    }

    private void rowFeatureCellDataChange(String fieldKey, ChangeData[] changeData) {
        if (changeData != null && changeData.length > 0) {
            ChangeData data = changeData[0];
            DynamicObject dynamicObject = data.getDataEntity();
            String metric = dynamicObject.getString(ENTRY_COL_INDICATOR);
            String changeType = this.getCache().get("metric_cell_value_change_type");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)metric, (CharSequence)CHAT_SHOW_METRIC_AMOUNT) && org.apache.commons.lang3.StringUtils.equals((CharSequence)changeType, (CharSequence)metric)) {
                this.amountFeatureDataChange(fieldKey, data);
            }
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)metric, (CharSequence)"fadoptqty") && org.apache.commons.lang3.StringUtils.equals((CharSequence)changeType, (CharSequence)metric)) {
                this.adoptFeatureDataChange(fieldKey, data);
            }
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)metric, (CharSequence)"favgprice") && org.apache.commons.lang3.StringUtils.equals((CharSequence)changeType, (CharSequence)metric)) {
                this.avgPriceFeatureDataChange(fieldKey, data);
            }
        }
    }

    private void changeRelationCellStyle(String fieldKey, int row, String coreColor) {
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        CellStyle cs = new CellStyle();
        cs.setFieldKey(fieldKey);
        cs.setRow(row);
        cs.setForeColor(coreColor);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(1);
        cellStyles.add(cs);
        grid.setCellStyle(cellStyles);
    }

    private void amountFeatureDataChange(String fieldKey, ChangeData data) {
        DynamicObject avgDynamicObject;
        BigDecimal avgPrice;
        JSONObject showMetrics;
        Object newValue;
        BigDecimal afterValue;
        Object oldValue = data.getOldValue();
        BigDecimal beforeValue = (BigDecimal)oldValue;
        if (beforeValue.compareTo(afterValue = (BigDecimal)(newValue = data.getNewValue())) == 0) {
            return;
        }
        String avgRow = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, "favgprice"));
        String adoptqtyRow = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, "fadoptqty"));
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)avgRow) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)adoptqtyRow) && (showMetrics = this.getCache().getAsObject(CURRENT_SHOW_METRICS)) != null && showMetrics.containsKey((Object)"favgprice") && showMetrics.containsKey((Object)"fadoptqty") && (avgPrice = (avgDynamicObject = grid.getModel().getEntryRowEntity(KEY_ENTRYENTITY, Integer.parseInt(avgRow))).getBigDecimal(fieldKey)).compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal newQty = afterValue.divide(avgPrice, 2, 4);
            this.getModel().setValue(fieldKey, (Object)newQty, Integer.parseInt(adoptqtyRow));
            String changeType = this.getCache().get("metric_cell_value_change_type");
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)changeType, (CharSequence)CHAT_SHOW_METRIC_AMOUNT)) {
                this.changeRelationCellStyle(fieldKey, Integer.parseInt(adoptqtyRow), "#5582F3");
                String amountRow = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, CHAT_SHOW_METRIC_AMOUNT));
                this.changeRelationCellStyle(fieldKey, Integer.parseInt(amountRow), "#212121");
            }
        }
    }

    private void setCurrentChangedField(String field) {
        this.getCache().put(CURRENT_VALUE_CHANGED_CELL_FIELD_KEY, field);
    }

    private String getCurrentChangedField() {
        return this.getCache().get(CURRENT_VALUE_CHANGED_CELL_FIELD_KEY);
    }

    private void adoptFeatureDataChange(String fieldKey, ChangeData data) {
        JSONObject showMetrics;
        Object newValue;
        BigDecimal afterValue;
        Object oldValue = data.getOldValue();
        BigDecimal beforeValue = (BigDecimal)oldValue;
        if (beforeValue.compareTo(afterValue = (BigDecimal)(newValue = data.getNewValue())) == 0) {
            return;
        }
        String avgRow = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, "favgprice"));
        String amountRow = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, CHAT_SHOW_METRIC_AMOUNT));
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)avgRow) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)amountRow) && (showMetrics = this.getCache().getAsObject(CURRENT_SHOW_METRICS)) != null && showMetrics.containsKey((Object)"favgprice") && showMetrics.containsKey((Object)CHAT_SHOW_METRIC_AMOUNT)) {
            DynamicObject avgDynamicObject = grid.getModel().getEntryRowEntity(KEY_ENTRYENTITY, Integer.parseInt(avgRow));
            BigDecimal avgPrice = avgDynamicObject.getBigDecimal(fieldKey);
            BigDecimal newAmount = afterValue.multiply(avgPrice);
            this.getModel().setValue(fieldKey, (Object)newAmount, Integer.parseInt(amountRow));
            String changeType = this.getCache().get("metric_cell_value_change_type");
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)changeType, (CharSequence)"fadoptqty")) {
                this.changeRelationCellStyle(fieldKey, Integer.parseInt(amountRow), "#5582F3");
                String adoptqtyRow = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, "fadoptqty"));
                this.changeRelationCellStyle(fieldKey, Integer.parseInt(adoptqtyRow), "#212121");
            }
        }
    }

    private void avgPriceFeatureDataChange(String fieldKey, ChangeData data) {
        JSONObject showMetrics;
        Object newValue;
        BigDecimal afterValue;
        Object oldValue = data.getOldValue();
        BigDecimal beforeValue = (BigDecimal)oldValue;
        if (beforeValue.compareTo(afterValue = (BigDecimal)(newValue = data.getNewValue())) == 0) {
            return;
        }
        String adoptqtyRow = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, "fadoptqty"));
        String amountRow = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, CHAT_SHOW_METRIC_AMOUNT));
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)adoptqtyRow) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)amountRow) && (showMetrics = this.getCache().getAsObject(CURRENT_SHOW_METRICS)) != null && showMetrics.containsKey((Object)"fadoptqty") && showMetrics.containsKey((Object)CHAT_SHOW_METRIC_AMOUNT)) {
            DynamicObject adoptDynamicObject = grid.getModel().getEntryRowEntity(KEY_ENTRYENTITY, Integer.parseInt(adoptqtyRow));
            BigDecimal adoptQty = adoptDynamicObject.getBigDecimal(fieldKey);
            BigDecimal newAmount = afterValue.multiply(adoptQty);
            this.getModel().setValue(fieldKey, (Object)newAmount, Integer.parseInt(amountRow));
            String changeType = this.getCache().get("metric_cell_value_change_type");
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)changeType, (CharSequence)"favgprice")) {
                this.changeRelationCellStyle(fieldKey, Integer.parseInt(amountRow), "#5582F3");
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)currentNodeType, (CharSequence)"material")) {
            JSONObject rowMetricMapping;
            String metric;
            String fieldKey = cellClickEvent.getFieldKey();
            int row = cellClickEvent.getRow();
            if (fieldKey.startsWith("value") && fieldKey.indexOf(95) == -1 && (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)(metric = (rowMetricMapping = this.getCache().getAsObject(ROW_INDEX_MAPPING_METRICS)).getString(String.valueOf(row))), (CharSequence)CHAT_SHOW_METRIC_AMOUNT) || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)metric, (CharSequence)"fadoptqty") || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)metric, (CharSequence)"favgprice"))) {
                this.getCache().put("metric_cell_value_change_type", metric);
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private boolean isMetricCanModifyChange(final List<String> metrics) {
        final List canNotEditMetrics = this.getCache().getAsList(DEFAULT_CANNOT_MODIFY_METRICS, String.class);
        if (canNotEditMetrics != null) {
            List unSelectMetrics = canNotEditMetrics.stream().filter(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return !metrics.contains(s);
                }
            }).collect(Collectors.toList());
            if (!unSelectMetrics.isEmpty()) {
                this.getModel().setValue(COMBO_METRIC_SELECTOR, (Object)String.format(",%s,", org.apache.commons.lang3.StringUtils.join((Iterable)canNotEditMetrics, (String)",")));
                return false;
            }
            List lists = metrics.stream().filter(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return !canNotEditMetrics.contains(s);
                }
            }).collect(Collectors.toList());
            if (!lists.isEmpty()) {
                return true;
            }
            JSONObject indicators = this.getCache().getAsObject(CURRENT_SHOW_METRICS);
            if (indicators != null) {
                final ArrayList shows = new ArrayList();
                indicators.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String s) {
                        shows.add(s);
                    }
                });
                List hiddens = ListUtils.diff(shows, metrics);
                if (!hiddens.isEmpty()) {
                    for (String metricId : hiddens) {
                        String row = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, metricId));
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)row)) continue;
                        int rowindex = Integer.parseInt(row);
                        this.getModel().deleteEntryRow(KEY_ENTRYENTITY, rowindex);
                        indicators.remove((Object)metricId);
                    }
                    this.getCache().put(CURRENT_SHOW_METRICS, JSONObject.toJSONString((Object)indicators));
                }
            }
            return false;
        }
        return true;
    }

    private void handleMetricChange(PropertyChangedArgs e) {
        String str;
        ChangeData[] changeData = e.getChangeSet();
        List<String> metrics = new ArrayList<String>();
        if (changeData[0] != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(str = (String)changeData[0].getNewValue()))) {
            String[] arrays = str.substring(1, str.lastIndexOf(44)).split(",");
            metrics = Arrays.asList(arrays);
        }
        if (!this.isMetricCanModifyChange(metrics)) {
            return;
        }
        String json = this.getCache().get("config_tag");
        JSONObject requirePlanConfig = JSONObject.parseObject((String)json);
        JSONArray findicators = requirePlanConfig.getJSONArray("findicators");
        JSONArray selected = new JSONArray();
        for (int i = 0; i < findicators.size(); ++i) {
            JSONObject indicator = findicators.getJSONObject(i);
            String id = indicator.getString("id");
            if (!metrics.contains(id)) continue;
            selected.add((Object)indicator);
        }
        this.dynamicShowMetricRow(selected);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getCache().get(CURRENT_SELECTED_NODE_TYPE))) {
            String nodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
            String nodeId = this.getCache().get(CURRENT_SELECTED_NODE_ID);
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"material")) {
                this.setColEditable(Boolean.TRUE);
                this.setFeaMetricColDisable();
                this.setAllHisMetricColDisable();
                this.materialNodeClick(nodeId);
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"customer")) {
                this.setColEditable(Boolean.FALSE);
                this.dimNodeClick(nodeId, nodeType);
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"invorg")) {
                this.setColEditable(Boolean.FALSE);
                this.dimNodeClick(nodeId, nodeType);
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"warehouse")) {
                this.setColEditable(Boolean.FALSE);
                this.dimNodeClick(nodeId, nodeType);
            }
        } else {
            this.setColEditable(Boolean.FALSE);
        }
    }

    private void setAllHisMetricColDisable() {
        int rowcount = Integer.parseInt(this.getCache().get(CURRENT_DISPLAY_METRIC_ROW_COUNT_KEY));
        List showHisList = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        int hisCount = showHisList.size();
        for (int i = 0; i < rowcount; ++i) {
            for (int j = 0; j < hisCount; ++j) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{String.format("%s%s", HISTORY_PRE_COL_FIX, j + 1)});
            }
        }
    }

    private void handlePeriodSelectChange(PropertyChangedArgs e, String flag) {
        String str;
        ChangeData[] changeData = e.getChangeSet();
        ArrayList<String> his = new ArrayList<String>();
        if (changeData[0] != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(str = (String)changeData[0].getNewValue()))) {
            his.add(str);
        }
        if (his != null && !his.isEmpty()) {
            String hd = (String)his.get(0);
            int showCount = Integer.parseInt(hd.substring(flag.length()));
            ArrayList<String> showLists = new ArrayList<String>(showCount);
            for (int i = 0; i < showCount; ++i) {
                showLists.add(String.format("%s%s", flag, i + 1));
            }
            this.showPeriodGridColumn(showLists, flag);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getCache().get(CURRENT_SELECTED_NODE_TYPE))) {
            String nodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
            String nodeId = this.getCache().get(CURRENT_SELECTED_NODE_ID);
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"material")) {
                this.setColEditable(Boolean.TRUE);
                this.setFeaMetricColDisable();
                this.setAllHisMetricColDisable();
                this.materialNodeClick(nodeId);
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"customer")) {
                this.setColEditable(Boolean.FALSE);
                this.dimNodeClick(nodeId, nodeType);
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"invorg")) {
                this.setColEditable(Boolean.FALSE);
                this.dimNodeClick(nodeId, nodeType);
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"warehouse")) {
                this.setColEditable(Boolean.FALSE);
                this.dimNodeClick(nodeId, nodeType);
            }
        } else {
            this.setColEditable(Boolean.FALSE);
        }
    }

    private void showPeriodGridColumn(List<String> showList, String flag) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            String key = fieldEdit.getFieldKey();
            if (!key.startsWith("value")) continue;
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)HISTORY_PRE_COL_FIX)) {
                if (!key.startsWith(flag)) continue;
                if (showList.contains(key)) {
                    fieldEdit.setVisible(key, Boolean.TRUE.booleanValue());
                    continue;
                }
                fieldEdit.setVisible(key, Boolean.FALSE.booleanValue());
                continue;
            }
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)"value") || key.contains("_")) continue;
            if (showList.contains(key)) {
                fieldEdit.setVisible(key, Boolean.TRUE.booleanValue());
                continue;
            }
            fieldEdit.setVisible(key, Boolean.FALSE.booleanValue());
        }
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)HISTORY_PRE_COL_FIX)) {
            this.getCache().put(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, showList);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)"value")) {
            this.getCache().put(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, showList);
        }
    }

    private void dynamicShowMetricRow(JSONArray selectMetrics) {
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        int count = selectMetrics.size();
        if (count == 0) {
            return;
        }
        int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, count);
        JSONObject indicator = new JSONObject();
        JSONObject rowMetricIndexs = new JSONObject();
        for (int i = 0; i < count; ++i) {
            JSONObject metric = selectMetrics.getJSONObject(i);
            String metricName = metric.getString("name");
            String metricId = metric.getString("id");
            this.getModel().setValue(ENTRY_COL_INDICATOR, (Object)metricId, rowIndex[i]);
            this.getModel().setValue(ENTRY_COL_INDICATOR_NAME, (Object)metricName, rowIndex[i]);
            this.getCache().put(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, metricId), String.valueOf(rowIndex[i]));
            rowMetricIndexs.put(String.valueOf(rowIndex[i]), (Object)metricId);
            indicator.put(metricId, (Object)metric);
        }
        this.getCache().put(CURRENT_DISPLAY_METRIC_ROW_COUNT_KEY, String.valueOf(selectMetrics.size()));
        this.getCache().put(CURRENT_SHOW_METRICS, JSONObject.toJSONString((Object)indicator));
        this.getCache().put(ROW_INDEX_MAPPING_METRICS, JSONObject.toJSONString((Object)rowMetricIndexs));
    }

    private void initCombo(JSONObject requirePlanConfig) {
        String fpredimentype = requirePlanConfig.getString("fpredimentype");
        List<String> lists = Arrays.asList(fpredimentype.split("/"));
        this.getCache().put("fpredimentype", lists);
        this.getCache().put(CHAT_SHOW_PRE_TYPE_ACTIVE, CHAT_SHOW_METRIC_QTY);
        this.initDimSelectCombo(lists);
        JSONArray findicators = requirePlanConfig.getJSONArray("findicators");
        if (findicators != null) {
            this.initMetricSelect(findicators);
        }
        this.getCache().put("findicators", (List)findicators);
        if (findicators != null && !findicators.isEmpty()) {
            for (int i = 0; i < findicators.size(); ++i) {
                JSONObject indicator = findicators.getJSONObject(i);
                String id = indicator.getString("id");
                String name = indicator.getString("name");
                this.getCache().put(String.format("%s%s", INDICATOR_NAME_CACHE_PRE, id), name);
            }
        }
        int fhistorytntype = requirePlanConfig.getIntValue("fhistorytntype");
        int pretntype = requirePlanConfig.getIntValue("ftntype");
        this.getCache().put("fhistorytntype", String.valueOf(fhistorytntype));
        this.getCache().put("ftntype", String.valueOf(pretntype));
        List<String> showHisList = this.initHisSelect(fhistorytntype);
        List<String> showFList = this.initFeatureSelect(pretntype);
        this.hiddenGridColumn(showHisList, showFList);
        this.setColEditable(Boolean.FALSE);
        this.setFeaMetricColDisable();
    }

    private List<String> getHisPeriods(JSONObject config) {
        JSONArray fhistoryperiods = config.getJSONArray("fhistoryperiods");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < fhistoryperiods.size(); ++i) {
            list.add(fhistoryperiods.getString(i));
        }
        return list;
    }

    private List<String> getFeaPeriods(JSONObject config) {
        JSONArray fpreperiods = config.getJSONArray("fpreperiods");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < fpreperiods.size(); ++i) {
            list.add(fpreperiods.getString(i));
        }
        return list;
    }

    private void hiddenGridColumn(List<String> showHisList, List<String> showFList) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            String key = fieldEdit.getFieldKey();
            if (!key.startsWith(HISTORY_PRE_COL_FIX) && !key.startsWith("value") || showHisList.contains(key) || showFList.contains(key)) continue;
            fieldEdit.setVisible(key, Boolean.FALSE.booleanValue());
        }
        Optional.ofNullable(entryGrid).ifPresent(e -> {
            e.setColumnProperty(ENTRY_COL_INDICATOR, "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty(ENTRY_COL_INDICATOR_NAME, "isFixed", (Object)Boolean.TRUE);
        });
        this.changeHeaderNames(showHisList, HISTORY_PRE_COL_FIX);
        this.changeHeaderNames(showFList, "value");
        this.getCache().put(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, showHisList);
        this.getCache().put(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, showFList);
    }

    private void changeHeaderNames(List<String> list, String flag) {
        block3: {
            JSONObject config;
            EntryGrid entryGrid;
            block2: {
                entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
                config = this.getCache().getAsObject("config_tag");
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)HISTORY_PRE_COL_FIX)) break block2;
                List<String> hisPeriods = this.getHisPeriods(config);
                int hisCount = hisPeriods.size();
                for (String his : list) {
                    int t = Integer.parseInt(his.substring(HISTORY_PRE_COL_FIX.length()));
                    String period = hisPeriods.get(hisCount - t);
                    entryGrid.setColumnProperty(his, "header", (Object)new LocaleString(period));
                }
                break block3;
            }
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)"value")) break block3;
            List<String> feaPeriods = this.getFeaPeriods(config);
            for (String fea : list) {
                int t = Integer.parseInt(fea.substring("value".length()));
                String period = feaPeriods.get(t - 1);
                entryGrid.setColumnProperty(fea, "header", (Object)new LocaleString(period));
                if (t != 1) continue;
                entryGrid.setColumnProperty(fea, "tbc", (Object)"#C7E5FF");
                entryGrid.setColumnProperty(fea, "bc", (Object)"#C7E5FF");
            }
        }
    }

    private List<String> initHisSelect(int count) {
        ArrayList<String> res = new ArrayList<String>();
        ComboEdit select = (ComboEdit)this.getControl(COMBO_HIS_PRE_SELECTOR);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        JSONObject config = this.getCache().getAsObject("config_tag");
        List<String> hisPeriods = this.getHisPeriods(config);
        for (int i = 0; i < count; ++i) {
            String date;
            ComboItem item;
            if (i == 0) {
                item = new ComboItem();
                date = hisPeriods.get(count - 1);
                item.setCaption(new LocaleString(date));
                item.setValue(String.format("%s1", HISTORY_PRE_COL_FIX));
                items.add(item);
                res.add(String.format("%s1", HISTORY_PRE_COL_FIX));
                continue;
            }
            item = new ComboItem();
            date = hisPeriods.get(count - 1);
            item.setCaption(new LocaleString(String.format("%s \u81f3 %s", hisPeriods.get(count - i - 1), date)));
            item.setValue(String.format("%s%s", HISTORY_PRE_COL_FIX, i + 1));
            items.add(item);
            res.add(String.format("%s%s", HISTORY_PRE_COL_FIX, i + 1));
        }
        select.setComboItems(items);
        this.getModel().setValue(COMBO_HIS_PRE_SELECTOR, (Object)String.format("%s", String.format("%s%s", HISTORY_PRE_COL_FIX, count)));
        return res;
    }

    private List<String> initFeatureSelect(int count) {
        ArrayList<String> res = new ArrayList<String>();
        ComboEdit select = (ComboEdit)this.getControl(COMBO_FEATURE_PRE_SELECTOR);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        JSONObject config = this.getCache().getAsObject("config_tag");
        List<String> feaPeriods = this.getFeaPeriods(config);
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                String date = feaPeriods.get(i);
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(date));
                item.setValue(String.format("%s1", "value"));
                items.add(item);
                res.add(String.format("%s1", "value"));
                continue;
            }
            ComboItem item = new ComboItem();
            String date = feaPeriods.get(i);
            item.setCaption(new LocaleString(String.format("%s \u81f3 %s", feaPeriods.get(0), date)));
            item.setValue(String.format("%s%s", "value", i + 1));
            items.add(item);
            res.add(String.format("%s%s", "value", i + 1));
        }
        select.setComboItems(items);
        this.getModel().setValue(COMBO_FEATURE_PRE_SELECTOR, (Object)String.format("%s", String.format("%s%s", "value", count)));
        return res;
    }

    private void setColEditable(boolean enable) {
        int rowcount = Integer.parseInt(this.getCache().get(CURRENT_DISPLAY_METRIC_ROW_COUNT_KEY));
        List showHisList = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        List showFList = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
        int hisCount = showHisList.size();
        int fCount = showFList.size();
        for (int i = 0; i < rowcount; ++i) {
            for (int j = 0; j < hisCount; ++j) {
                this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{String.format("%s%s", HISTORY_PRE_COL_FIX, j + 1)});
            }
            for (int m = 0; m < fCount; ++m) {
                this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{String.format("%s%s", "value", m + 1)});
            }
        }
    }

    private void setFeaMetricColDisable() {
        JSONObject indicators = this.getCache().getAsObject(CURRENT_SHOW_METRICS);
        final List<String> canEditMetrics = Arrays.asList("famount,favgprice,fadoptqty".split(","));
        final String billstatus = this.getCache().get("billsatus_cache");
        if (indicators != null) {
            final IFormView view = this.getView();
            List showFList = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
            final int fCount = showFList.size();
            final String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
            indicators.keySet().stream().forEach(new Consumer<String>(){

                @Override
                public void accept(String metric) {
                    String str = RequirePlanEntryBillPlugin.this.getCache().get(String.format("%s%s", RequirePlanEntryBillPlugin.CURRENT_METRIC_ROW_INDEX, metric));
                    if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
                        int metricRowIndex = Integer.parseInt(str);
                        for (int m = 0; m < fCount; ++m) {
                            if (canEditMetrics.contains(metric)) {
                                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)currentNodeType, (CharSequence)"material")) {
                                    if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"A")) {
                                        view.setEnable(Boolean.FALSE, metricRowIndex, new String[]{String.format("%s%s", "value", m + 1)});
                                        continue;
                                    }
                                    view.setEnable(Boolean.TRUE, metricRowIndex, new String[]{String.format("%s%s", "value", m + 1)});
                                    continue;
                                }
                                view.setEnable(Boolean.FALSE, metricRowIndex, new String[]{String.format("%s%s", "value", m + 1)});
                                continue;
                            }
                            view.setEnable(Boolean.FALSE, metricRowIndex, new String[]{String.format("%s%s", "value", m + 1)});
                        }
                    }
                }
            });
        }
    }

    private void initDimSelectCombo(List<String> lists) {
        ComboEdit dimSelect = (ComboEdit)this.getControl(COMBO_DIM_SELECTOR);
        ArrayList<ComboItem> dimSelectItems = new ArrayList<ComboItem>(lists.size());
        ArrayList<String> defaultSelect = new ArrayList<String>(lists.size());
        for (String dim : lists) {
            ComboItem ci = new ComboItem();
            String name = "";
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dim, (CharSequence)"finvorgid")) {
                name = "\u5e93\u5b58\u7ec4\u7ec7";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dim, (CharSequence)"fwarehouseid")) {
                name = "\u4ed3\u5e93";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dim, (CharSequence)"fcustid")) {
                name = "\u5ba2\u6237";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dim, (CharSequence)"fmaterialid")) {
                name = "\u7269\u6599";
            }
            ci.setCaption(new LocaleString(name));
            ci.setValue(dim);
            dimSelectItems.add(ci);
            defaultSelect.add(dim);
        }
        dimSelect.setComboItems(dimSelectItems);
        this.getModel().setValue(COMBO_DIM_SELECTOR, (Object)String.format(",%s,", org.apache.commons.lang3.StringUtils.join(defaultSelect, (String)",")));
    }

    private JSONArray initMetricSelect(JSONArray findicators) {
        ComboEdit select = (ComboEdit)this.getControl(COMBO_METRIC_SELECTOR);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        StringBuilder sb = new StringBuilder();
        sb.append(',');
        ArrayList<String> defaultSelect = new ArrayList<String>();
        JSONArray selectMetrics = new JSONArray();
        for (int i = 0; i < findicators.size(); ++i) {
            JSONObject item = findicators.getJSONObject(i);
            String name = item.getString("name");
            String id = item.getString("id");
            boolean canshow = item.getBooleanValue("canshow");
            if (!canshow) continue;
            boolean canselect = item.getBooleanValue("canselect");
            ComboItem ci = new ComboItem();
            ci.setCaption(new LocaleString(name));
            ci.setValue(id);
            if (!canselect) {
                defaultSelect.add(id);
                selectMetrics.add((Object)item);
                ci.setDisable(Boolean.TRUE.booleanValue());
            }
            items.add(ci);
        }
        select.setComboItems(items);
        this.getCache().put(DEFAULT_CANNOT_MODIFY_METRICS, defaultSelect);
        this.getModel().setValue(COMBO_METRIC_SELECTOR, (Object)String.format(",%s,", org.apache.commons.lang3.StringUtils.join(defaultSelect, (String)",")));
        this.dynamicShowMetricRow(selectMetrics);
        return selectMetrics;
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        treeNodeEvent.getNodeId();
    }

    private void materialNodeClick(String nodeId) {
        JSONObject data = this.getCache().getAsObject(nodeId);
        final JSONObject entryids = data.getJSONObject("entryids");
        final JSONObject indicator = data.getJSONObject(ENTRY_COL_INDICATOR);
        String materialId = data.getString("id");
        this.initRequireHead(data, materialId);
        String fpredimentypeCode = data.getString("fpredimentypeCode");
        String fpredimentypeCodeName = data.getString("fpredimentypeCodeName");
        this.getCache().put(CURRENT_SELECTED_NODE_TYPE, "material");
        this.getCache().put(CURRENT_SELECTED_NODE_ID, nodeId);
        Object requirePlanFid = data.get((Object)"fid");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        final JSONObject showMetrics = this.getCache().getAsObject(CURRENT_SHOW_METRICS);
        entryEntity.stream().forEach(new Consumer<DynamicObject>(){

            @Override
            public void accept(DynamicObject object) {
                String indicator = object.getString(RequirePlanEntryBillPlugin.ENTRY_COL_INDICATOR);
                Object entryid = entryids.get((Object)indicator);
                object.set("id", entryid);
            }
        });
        if (indicator != null && !indicator.isEmpty()) {
            indicator.keySet().stream().forEach(new Consumer<String>(){

                @Override
                public void accept(String metric) {
                    if (showMetrics.containsKey((Object)metric)) {
                        JSONObject predata = indicator.getJSONObject(metric);
                        RequirePlanEntryBillPlugin.this.showPreData(predata, metric);
                    }
                }
            });
            JSONObject salePreData = this.getMaterialSalePredictAnaChatData(indicator, this.getActivePretype());
            salePreData.put("fpredimentypeCodeName", (Object)fpredimentypeCodeName);
            JSONObject markData = this.loadMarkAnaData(fpredimentypeCode, indicator);
            markData.put("fpredimentypeCodeName", (Object)fpredimentypeCodeName);
            this.showSaleAnaAndMarkPredictChat(salePreData, markData);
        }
    }

    private void initRequireHead(JSONObject data, String materialId) {
        Object obj;
        if (data != null) {
            JSONObject materialProp = data.getJSONObject("materialProp");
            if (materialProp != null) {
                this.getModel().setValue("orgid", materialProp.get((Object)"finvorgid"));
                this.getModel().setValue("warehouseid", materialProp.get((Object)"fwarehouseid"));
                this.getModel().setValue("custid", materialProp.get((Object)"fcustid"));
            }
            this.getModel().setValue("materialid", (Object)materialId);
        }
        if ((obj = this.getModel().getValue("materialid")) instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)obj;
            String baseunit = dy.getString("baseunit.name");
            Label labelBaseunit = (Label)this.getControl(CONTROL_LABEL_BASE_UNIT);
            labelBaseunit.setText(String.format("\u57fa\u672c\u5355\u4f4d\uff1a%s", baseunit));
            Label label = (Label)this.getControl(CONTROL_LABEL_COUNT_UNIT);
        }
    }

    private String getActivePretype() {
        return this.getCache().get(CHAT_SHOW_PRE_TYPE_ACTIVE);
    }

    private BigDecimal getLastHistoryAvgPrice(JSONObject indicator) {
        JSONObject data;
        if (indicator.containsKey((Object)"favgprice") && (data = indicator.getJSONObject("favgprice")).containsKey((Object)"value_1")) {
            BigDecimal bd = data.getBigDecimal("value_1");
            return bd;
        }
        return new BigDecimal(0);
    }

    private List<String> combinPeriod(JSONObject config, int fCount, int hCount) {
        int i;
        JSONArray fhistoryperiods = config.getJSONArray("fhistoryperiods");
        JSONArray fpreperiods = config.getJSONArray("fpreperiods");
        LinkedList<String> list = new LinkedList<String>();
        int hisCount = fhistoryperiods.size();
        for (i = hCount; i > 0; --i) {
            list.add(fhistoryperiods.getString(hisCount - i));
        }
        for (i = 0; i < fCount; ++i) {
            list.add(fpreperiods.getString(i));
        }
        return list;
    }

    private JSONObject genQtyMetricData(JSONObject predata, String metricId, String metricName, List<String> showFList, List<String> showHList) {
        JSONObject metricData = new JSONObject();
        metricData.put("id", (Object)metricId);
        LinkedList<BigDecimal> valueList = new LinkedList<BigDecimal>();
        for (int i = showHList.size() - 1; i >= 0; --i) {
            valueList.add(predata.getBigDecimal(showHList.get(i)));
        }
        for (String f : showFList) {
            valueList.add(predata.getBigDecimal(f));
        }
        metricData.put("valueList", valueList);
        metricData.put("name", (Object)metricName);
        return metricData;
    }

    private JSONObject genMaterialAmountMetricData(JSONObject avgPrices, JSONObject predata, String metricId, String metricName, List<String> showFList, List<String> showHList, boolean metricCanMultiply) {
        JSONObject metricData = new JSONObject();
        metricData.put("id", (Object)metricId);
        LinkedList<BigDecimal> valueList = new LinkedList<BigDecimal>();
        for (int i = showHList.size() - 1; i >= 0; --i) {
            BigDecimal value = predata.getBigDecimal(showHList.get(i));
            if (metricCanMultiply) {
                if (avgPrices != null) {
                    BigDecimal price = avgPrices.getBigDecimal(showHList.get(i));
                    if (price == null) {
                        valueList.add(value);
                        continue;
                    }
                    valueList.add(price.multiply(value));
                    continue;
                }
                valueList.add(value);
                continue;
            }
            valueList.add(value);
        }
        for (String f : showFList) {
            BigDecimal value = predata.getBigDecimal(f);
            if (metricCanMultiply) {
                if (avgPrices != null) {
                    BigDecimal price = avgPrices.getBigDecimal(f);
                    if (price == null) {
                        valueList.add(value);
                        continue;
                    }
                    valueList.add(price.multiply(value));
                    continue;
                }
                valueList.add(value);
                continue;
            }
            valueList.add(value);
        }
        metricData.put("valueList", valueList);
        metricData.put("name", (Object)metricName);
        return metricData;
    }

    private JSONObject genAmountMetricData(JSONObject predata, String metricId, String metricName, List<String> showFList, List<String> showHList) {
        JSONObject metricData = new JSONObject();
        metricData.put("id", (Object)metricId);
        LinkedList<BigDecimal> valueList = new LinkedList<BigDecimal>();
        for (int i = showHList.size() - 1; i >= 0; --i) {
            BigDecimal value = predata.getBigDecimal(showHList.get(i));
            valueList.add(value);
        }
        for (String f : showFList) {
            BigDecimal value = predata.getBigDecimal(f);
            valueList.add(value);
        }
        metricData.put("valueList", valueList);
        metricData.put("name", (Object)metricName);
        return metricData;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object obj = evt.getNodeId();
        String nodeId = (String)obj;
        if (nodeId.startsWith(TREE_NODE_PREFIX_MATERIAL)) {
            this.getCache().put(CURRENT_SELECTED_NODE_TYPE, "material");
            this.getCache().put(CURRENT_SELECTED_NODE_ID, nodeId);
            IDataModel model = this.getModel();
            String billstatus = (String)model.getValue("billstatus");
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"A")) {
                this.setColEditable(Boolean.FALSE);
                IFormView view = this.getView();
                view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_SAVE});
                this.setFeaMetricColDisable();
                this.setAllHisMetricColDisable();
                this.materialNodeClick(nodeId);
            } else {
                IFormView view = this.getView();
                view.setEnable(Boolean.TRUE, new String[]{KEY_BAR_SAVE});
                this.setColEditable(Boolean.TRUE);
                this.setAllHisMetricColDisable();
                this.setFeaMetricColDisable();
                this.materialNodeClick(nodeId);
            }
        } else if (nodeId.startsWith(TREE_NODE_PREFIX_CUSTOMER)) {
            this.getCache().put(CURRENT_SELECTED_NODE_TYPE, "customer");
            this.getCache().put(CURRENT_SELECTED_NODE_ID, nodeId);
            this.setColEditable(Boolean.FALSE);
            this.dimNodeClick(nodeId, "customer");
        } else if (nodeId.startsWith(TREE_NODE_PREFIX_WAREHOUSE)) {
            this.getCache().put(CURRENT_SELECTED_NODE_TYPE, "warehouse");
            this.getCache().put(CURRENT_SELECTED_NODE_ID, nodeId);
            this.setColEditable(Boolean.FALSE);
            this.dimNodeClick(nodeId, "warehouse");
        } else if (nodeId.startsWith(TREE_NODE_PREFIX_INVORG)) {
            this.getCache().put(CURRENT_SELECTED_NODE_TYPE, "invorg");
            this.getCache().put(CURRENT_SELECTED_NODE_ID, nodeId);
            this.setColEditable(Boolean.FALSE);
            this.dimNodeClick(nodeId, "invorg");
        }
    }

    private void dimNodeClick(String nodeId, String nodeType) {
        IFormView view = this.getView();
        view.setEnable(Boolean.FALSE, new String[]{KEY_BAR_SAVE});
        if (tree != null) {
            String _nodeId = nodeId.substring(nodeType.length() + 1);
            List<RequirePlanBase> allMaterialNodes = this.findMaterialNodes(tree.getChildren(), _nodeId, nodeType);
            if (allMaterialNodes != null && !allMaterialNodes.isEmpty()) {
                JSONObject salePreData;
                JSONArray indicators = this.getCache().getAsArray("findicators");
                final HashMap<String, Boolean> sumFlag = new HashMap<String, Boolean>(indicators.size());
                for (int i = 0; i < indicators.size(); ++i) {
                    JSONObject item = indicators.getJSONObject(i);
                    String id = item.getString("id");
                    String name = item.getString("name");
                    Boolean canadd = item.getBoolean("canadd");
                    if (canadd == null) {
                        canadd = RequirePlanConstants.REQUIRE_DEFAULT_CANADD_METRICS.contains(id) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    sumFlag.put(id, canadd);
                }
                final JSONObject showMetrics = this.getCache().getAsObject(CURRENT_SHOW_METRICS);
                final JSONObject alldata = new JSONObject();
                final JSONObject allAmountData = new JSONObject();
                String activePreType = this.getActivePretype();
                allMaterialNodes.stream().forEach(new Consumer<RequirePlanBase>(){

                    @Override
                    public void accept(RequirePlanBase requirePlanBase) {
                        String type = requirePlanBase.getNodeType();
                        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"material")) {
                            RequirePlanMaterial material = (RequirePlanMaterial)requirePlanBase;
                            String materialId = material.getNodeId();
                            JSONObject data = RequirePlanEntryBillPlugin.this.getCache().getAsObject(String.format("%s_%s", type, materialId));
                            final JSONObject indicator = data.getJSONObject(RequirePlanEntryBillPlugin.ENTRY_COL_INDICATOR);
                            final JSONObject avgPrices = indicator.getJSONObject("favgprice");
                            showMetrics.keySet().stream().forEach(new Consumer<String>(){

                                @Override
                                public void accept(String metric) {
                                    JSONObject predata = indicator.getJSONObject(metric);
                                    boolean cadd = (Boolean)sumFlag.get(metric);
                                    if (cadd) {
                                        if (alldata.containsKey((Object)metric)) {
                                            JSONObject mdata = alldata.getJSONObject(metric);
                                            JSONObject amountData = allAmountData.getJSONObject(metric);
                                            if (predata != null) {
                                                RequirePlanEntryBillPlugin.this.algPreAmountData(amountData, predata, avgPrices);
                                                RequirePlanEntryBillPlugin.this.algPreData(mdata, predata);
                                            }
                                        } else {
                                            JSONObject mdata = new JSONObject();
                                            JSONObject amountData = new JSONObject();
                                            alldata.put(metric, (Object)mdata);
                                            allAmountData.put(metric, (Object)amountData);
                                            if (predata != null) {
                                                RequirePlanEntryBillPlugin.this.algPreAmountData(amountData, predata, avgPrices);
                                                RequirePlanEntryBillPlugin.this.algPreData(mdata, predata);
                                            }
                                        }
                                    } else {
                                        alldata.put(metric, (Object)predata);
                                        allAmountData.put(metric, (Object)predata);
                                    }
                                }
                            });
                        }
                    }
                });
                alldata.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String metric) {
                        JSONObject data = alldata.getJSONObject(metric);
                        if (data != null) {
                            RequirePlanEntryBillPlugin.this.showPreData(data, metric);
                        }
                    }
                });
                showMetrics.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String metric) {
                        boolean cadd = (Boolean)sumFlag.get(metric);
                        if (!cadd) {
                            RequirePlanEntryBillPlugin.this.showPreData(new JSONObject(), metric);
                        }
                    }
                });
                this.getCache().remove("metric_cell_value_change_type");
                this.getCache().put(String.format("%s%s", DIM_SUM_DATA_NODE_PRE_AMOUNT, nodeId), JSONObject.toJSONString((Object)allAmountData));
                this.getCache().put(String.format("%s%s", DIM_SUM_DATA_NODE_PRE_QTY, nodeId), JSONObject.toJSONString((Object)alldata));
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)activePreType, (CharSequence)CHAT_SHOW_METRIC_AMOUNT)) {
                    salePreData = this.getDimSalePredictAnaChatData(allAmountData, this.getActivePretype());
                    JSONObject markData = new JSONObject();
                    salePreData.put("fpredimentypeCodeName", (Object)"");
                    markData.put("fpredimentypeCodeName", (Object)"");
                    this.showSaleAnaAndMarkPredictChat(salePreData, markData);
                } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)activePreType, (CharSequence)CHAT_SHOW_METRIC_QTY)) {
                    salePreData = this.getDimSalePredictAnaChatData(alldata, this.getActivePretype());
                    JSONObject markData = new JSONObject();
                    salePreData.put("fpredimentypeCodeName", (Object)"");
                    markData.put("fpredimentypeCodeName", (Object)"");
                    this.showSaleAnaAndMarkPredictChat(salePreData, markData);
                }
            }
        }
    }

    private JSONObject loadMarkAnaData(String fpredimentypeCode, JSONObject indicator) {
        String[] endDates;
        JSONObject config = this.getCache().getAsObject("config_tag");
        String fpretimetype = config.getString("fpretimetype");
        List<String> hisPeriods = this.getHisPeriods(config);
        List<String> feaPeriods = this.getFeaPeriods(config);
        String startDateRange = hisPeriods.get(0);
        String endDateRange = feaPeriods.get(feaPeriods.size() - 1);
        String[] startDates = startDateRange.split("~");
        JSONObject data = this.requirePlanService.loadMarkAnaData(fpredimentypeCode, fpretimetype, startDates[0], (endDates = endDateRange.split("~"))[0]);
        if (data != null) {
            String pretype;
            if (data.getIntValue("errcode") == 0 && !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)(pretype = this.getActivePretype()), (CharSequence)CHAT_SHOW_METRIC_QTY) && org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)pretype, (CharSequence)CHAT_SHOW_METRIC_AMOUNT)) {
                data.put("fprevaluetype", (Object)CHAT_SHOW_METRIC_AMOUNT);
                BigDecimal avgPrice = this.getLastHistoryAvgPrice(indicator);
                JSONArray values = data.getJSONArray("values");
                if (values != null && !values.isEmpty()) {
                    for (int i = 0; i < values.size(); ++i) {
                        JSONObject value = values.getJSONObject(i);
                        JSONArray tags = value.getJSONArray("tags");
                        for (int j = 0; j < tags.size(); ++j) {
                            JSONObject tag = tags.getJSONObject(j);
                            BigDecimal tagValue = tag.getBigDecimal("value");
                            tag.put("value", (Object)tagValue.multiply(avgPrice));
                        }
                    }
                }
            }
        } else {
            data = new JSONObject();
        }
        return data;
    }

    private void algPreData(JSONObject sum, JSONObject predata) {
        BigDecimal temp;
        BigDecimal bd;
        List hisList = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        List feaList = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
        for (String his : hisList) {
            bd = predata.getBigDecimal(his);
            if (!sum.containsKey((Object)his)) {
                sum.put(his, (Object)bd);
                continue;
            }
            temp = sum.getBigDecimal(his);
            sum.put(his, (Object)temp.add(bd));
        }
        for (String his : feaList) {
            bd = predata.getBigDecimal(his);
            if (!sum.containsKey((Object)his)) {
                sum.put(his, (Object)bd);
                continue;
            }
            temp = sum.getBigDecimal(his);
            sum.put(his, (Object)temp.add(bd));
        }
    }

    private void algPreAmountData(JSONObject sum, JSONObject predata, JSONObject avgPrices) {
        BigDecimal price;
        BigDecimal temp;
        BigDecimal price2;
        BigDecimal bd;
        List hisList = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        List feaList = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
        for (String his : hisList) {
            bd = predata.getBigDecimal(his);
            if (!sum.containsKey((Object)his)) {
                if (avgPrices != null) {
                    price2 = avgPrices.getBigDecimal(his);
                    if (price2 == null) {
                        sum.put(his, (Object)bd);
                        continue;
                    }
                    sum.put(his, (Object)bd.multiply(price2));
                    continue;
                }
                sum.put(his, (Object)bd);
                continue;
            }
            temp = sum.getBigDecimal(his);
            if (avgPrices != null) {
                price = avgPrices.getBigDecimal(his);
                if (price == null) {
                    sum.put(his, (Object)temp.add(bd));
                    continue;
                }
                sum.put(his, (Object)temp.add(bd.multiply(price)));
                continue;
            }
            sum.put(his, (Object)temp.add(bd));
        }
        for (String fea : feaList) {
            bd = predata.getBigDecimal(fea);
            if (!sum.containsKey((Object)fea)) {
                if (avgPrices != null) {
                    price2 = avgPrices.getBigDecimal(fea);
                    if (price2 == null) {
                        sum.put(fea, (Object)bd);
                        continue;
                    }
                    sum.put(fea, (Object)bd.multiply(price2));
                    continue;
                }
                sum.put(fea, (Object)bd);
                continue;
            }
            temp = sum.getBigDecimal(fea);
            if (avgPrices != null) {
                price = avgPrices.getBigDecimal(fea);
                if (price == null) {
                    sum.put(fea, (Object)temp.add(bd));
                    continue;
                }
                sum.put(fea, (Object)temp.add(bd.multiply(price)));
                continue;
            }
            sum.put(fea, (Object)temp.add(bd));
        }
    }

    private void showPreData(JSONObject predata, String metric) {
        List hisCols = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        List feaCols = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
        String index = this.getCache().get(String.format("%s%s", CURRENT_METRIC_ROW_INDEX, metric));
        for (String his : hisCols) {
            this.getModel().setValue(his, (Object)predata.getBigDecimal(his), Integer.parseInt(index));
        }
        for (String fea : feaCols) {
            this.getModel().setValue(fea, (Object)predata.getBigDecimal(fea), Integer.parseInt(index));
        }
    }

    private RequirePlanBase findCurrentNode(String nodeId, String nodeType) {
        List nodes = tree.getChildren();
        String _nodeId = nodeId.substring(nodeType.length() + 1);
        RequirePlanBase currentNode = this.findParentNode(nodes, _nodeId, nodeType);
        return currentNode;
    }

    private void expandNode(TreeView treeView, RequirePlanBase currentNode, boolean expandChildren) {
        if (currentNode != null) {
            treeView.expand(String.format("%s_%s", currentNode.getNodeType(), currentNode.getNodeId()));
            if (expandChildren) {
                List childrens = currentNode.getChildren();
                for (RequirePlanBase child : childrens) {
                    if (child.getChildren().isEmpty()) continue;
                    this.expandNode(treeView, child, Boolean.TRUE);
                }
            }
        }
    }

    private void collapseNode(TreeView treeView, RequirePlanBase currentNode, boolean collapseChildren) {
        if (currentNode != null) {
            treeView.collapse(String.format("%s_%s", currentNode.getNodeType(), currentNode.getNodeId()));
            if (collapseChildren) {
                List childrens = currentNode.getChildren();
                for (RequirePlanBase child : childrens) {
                    if (child.getChildren().isEmpty()) continue;
                    this.collapseNode(treeView, child, Boolean.TRUE);
                }
            }
        }
    }

    private boolean hasPermission(String btnKey) {
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        String appId = AppMetadataCache.getAppInfo((String)"ids").getAppId();
        if (KEY_BAR_SAVE.equals(btnKey)) {
            return PermUtils.hasPermission((Object)currentUserId, (Object)appId, (Object)"ids_requireplan_entry", (Object)"QXX0003");
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_BAR_SAVE)) {
            if (!this.hasPermission(KEY_BAR_SAVE)) {
                return;
            }
            if (!this.canEdit()) {
                this.getView().showErrorNotification("\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\u4e0d\u80fd\u4fee\u6539!");
                return;
            }
            this.getView().showLoading(null, 5000);
            this.save();
            this.getView().hideLoading();
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_BAR_SUBMIT)) {
            this.submit();
            this.refreshBtnStatus();
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_BAR_UNSUBMIT)) {
            this.unsubmit();
            this.refreshBtnStatus();
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_BAR_AUDIT)) {
            this.audit();
            this.refreshBtnStatus();
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)KEY_BAR_UNAUDIT)) {
            this.unaudit();
            this.refreshBtnStatus();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        RequestContext rc = RequestContext.get();
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CONTROL_LABEL_EXPAND)) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
            String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
            String currentNodeId = this.getCache().get(CURRENT_SELECTED_NODE_ID);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)currentNodeType)) {
                return;
            }
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)currentNodeType, (CharSequence)"material")) {
                return;
            }
            this.expandNode(treeView, this.findCurrentNode(currentNodeId, currentNodeType), Boolean.TRUE);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CONTROL_LABEL_COLLAPSE)) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
            String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
            String currentNodeId = this.getCache().get(CURRENT_SELECTED_NODE_ID);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)currentNodeType)) {
                return;
            }
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)currentNodeType, (CharSequence)"material")) {
                return;
            }
            this.collapseNode(treeView, this.findCurrentNode(currentNodeId, currentNodeType), Boolean.TRUE);
        }
    }

    private void submit() {
        IDataModel model = this.getModel();
        Object requireId = model.getValue("requireplanid");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)requireId, (String)"ids_requireplan");
        if (object != null) {
            String billstatus = object.getString("billstatus");
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"A")) {
                this.getView().showTipNotification("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u6682\u5b58\u624d\u80fd\u63d0\u4ea4\u3002", Integer.valueOf(3000));
                return;
            }
            long userId = UserServiceHelper.getCurrentUserId();
            object.set("billstatus", (Object)"B");
            object.set("modifier", (Object)userId);
            object.set("modifytime", (Object)new Date());
            SaveServiceHelper.saveOperate((String)"ids_requireplan", (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
            model.setValue("billstatus", (Object)"B");
            this.getCache().put("billsatus_cache", "B");
            this.getView().showSuccessNotification("\u63d0\u4ea4\u6210\u529f", Integer.valueOf(3000));
        }
    }

    private void unsubmit() {
        IDataModel model = this.getModel();
        Object requireId = model.getValue("requireplanid");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)requireId, (String)"ids_requireplan");
        if (object != null) {
            String billstatus = object.getString("billstatus");
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"B")) {
                this.getView().showTipNotification("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", Integer.valueOf(3000));
                return;
            }
            object.set("billstatus", (Object)"A");
            object.set("modifytime", (Object)new Date());
            SaveServiceHelper.saveOperate((String)"ids_requireplan", (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
            model.setValue("billstatus", (Object)"A");
            this.getCache().put("billsatus_cache", "A");
            this.getView().showSuccessNotification("\u64a4\u9500\u6210\u529f", Integer.valueOf(3000));
        }
    }

    private void audit() {
        IDataModel model = this.getModel();
        Object requireId = model.getValue("requireplanid");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)requireId, (String)"ids_requireplan");
        if (object != null) {
            String billstatus = object.getString("billstatus");
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"B")) {
                this.getView().showTipNotification("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", Integer.valueOf(3000));
                return;
            }
            object.set("billstatus", (Object)"C");
            long userId = UserServiceHelper.getCurrentUserId();
            object.set("modifytime", (Object)new Date());
            object.set("auditor", (Object)userId);
            object.set("auditdate", (Object)new Date());
            SaveServiceHelper.saveOperate((String)"ids_requireplan", (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
            model.setValue("billstatus", (Object)"C");
            this.getCache().put("billsatus_cache", "C");
            this.getView().showSuccessNotification("\u5ba1\u6838\u6210\u529f", Integer.valueOf(3000));
        }
    }

    private void unaudit() {
        IDataModel model = this.getModel();
        Object requireId = model.getValue("requireplanid");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)requireId, (String)"ids_requireplan");
        if (object != null) {
            String billstatus = object.getString("billstatus");
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"C")) {
                this.getView().showTipNotification("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u53cd\u5ba1\u6838\u3002", Integer.valueOf(3000));
                return;
            }
            object.set("billstatus", (Object)"A");
            long userId = UserServiceHelper.getCurrentUserId();
            object.set("modifytime", (Object)new Date());
            object.set("auditor", (Object)userId);
            object.set("auditdate", (Object)new Date());
            SaveServiceHelper.saveOperate((String)"ids_requireplan", (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
            model.setValue("billstatus", (Object)"A");
            this.getCache().put("billsatus_cache", "A");
            this.getView().showSuccessNotification("\u53cd\u5ba1\u6838\u6210\u529f", Integer.valueOf(3000));
        }
    }

    private void updateRequirePlanEntryStatus(final String status) {
        IDataModel model = this.getModel();
        Object requireid = model.getValue("requireplanid");
        DynamicObject[] entries = BusinessDataServiceHelper.load((String)"ids_requireplan_entry", (String)"id,billno,billstaus,requireplanid", (QFilter[])new QFilter[]{new QFilter("requireplanid", "=", requireid)});
        if (entries != null && entries.length > 0) {
            Arrays.stream(entries).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject object) {
                    object.set("billstatus", (Object)status);
                }
            });
            SaveServiceHelper.update((DynamicObject[])entries);
        }
    }

    private boolean canEdit() {
        DynamicObject object;
        IDataModel model = this.getModel();
        Object requireId = model.getValue("requireplanid");
        if (requireId != null && (object = BusinessDataServiceHelper.loadSingle((Object)requireId, (String)"ids_requireplan")) != null) {
            String billstatus = object.getString("billstatus");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)billstatus, (CharSequence)"A")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return true;
    }

    private void save() {
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("materialid");
        Object materialId = material.getPkValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        EntryData data = entryGrid.getEntryData();
        DynamicObject[] entries = data.getDataEntitys();
        SaveServiceHelper.update((DynamicObject[])entries);
        Object requireId = model.getValue("requireplanid");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)requireId, (String)"ids_requireplan");
        if (object != null) {
            String billstatus = object.getString("billstatus");
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)billstatus, (CharSequence)"A")) {
                this.getView().showErrorNotification("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u6682\u5b58\u624d\u80fd\u4fee\u6539\u3002");
                return;
            }
            long userId = UserServiceHelper.getCurrentUserId();
            object.set("modifier", (Object)userId);
            object.set("modifytime", (Object)new Date());
            SaveServiceHelper.saveOperate((String)"ids_requireplan", (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
            this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f", Integer.valueOf(3000));
        }
        this.loadingExportRequirePlanData((Long)requireId);
    }

    private void refreshData(long requireId, Object materialId) {
        String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
        final String currentNodeId = this.getCache().get(CURRENT_SELECTED_NODE_ID);
        if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)currentNodeType, (CharSequence)"material")) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("materialid", materialId);
        List dims = this.getCache().getAsList("fpredimentype", String.class);
        JSONObject data = this.requirePlanService.loadingRequireData(requireId, dims, params);
        if (data == null) {
            return;
        }
        final JSONObject preDataJo = data.getJSONObject("data");
        if (preDataJo == null) {
            return;
        }
        preDataJo.keySet().stream().forEach(new Consumer<String>(){

            @Override
            public void accept(String _materialId) {
                JSONObject materialData = preDataJo.getJSONObject(_materialId);
                String cacheNodeId = String.format("%s_%s", "material", _materialId);
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)cacheNodeId, (CharSequence)currentNodeId)) {
                    JSONObject hisData = RequirePlanEntryBillPlugin.this.getCache().getAsObject(cacheNodeId);
                    RequirePlanEntryBillPlugin.this.getCache().put(cacheNodeId, JSONObject.toJSONString((Object)materialData));
                    String row = RequirePlanEntryBillPlugin.this.getCache().get(String.format("%s_%s", "row_material_index", cacheNodeId));
                    if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)row)) {
                        int rowindex = Integer.parseInt(row);
                        RequirePlanEntryBillPlugin.this.updateExportMaterialData(materialData, rowindex);
                    }
                }
            }
        });
    }

    private void updateExportMaterialData(JSONObject materialData, int rowindex) {
        final JSONObject indicators = materialData.getJSONObject(ENTRY_COL_INDICATOR);
        final JSONObject materialRowData = new JSONObject();
        materialRowData.put("export_invorg", (Object)materialData.getString("orgName"));
        materialRowData.put("export_warehouse", (Object)materialData.getString("warehouseName"));
        materialRowData.put("export_material_name", (Object)materialData.getString("name"));
        materialRowData.put("export_material_number", (Object)materialData.getString("number"));
        materialRowData.put("export_customer", (Object)materialData.getString("customerName"));
        final HashSet metrics = new HashSet();
        indicators.keySet().stream().forEach(new Consumer<String>(){

            @Override
            public void accept(String metric) {
                metrics.add(metric);
                JSONObject metricData = indicators.getJSONObject(metric);
                RequirePlanEntryBillPlugin.this.genExportMaterialRowData(materialRowData, metricData, metric);
            }
        });
        List preExportMetrics = RequirePlanConstants.PRE_EXPORT_METRICS;
        HashSet<String> showMetrics = new HashSet<String>();
        for (String metric : metrics) {
            if (!preExportMetrics.contains(metric)) continue;
            showMetrics.add(metric);
        }
        this.refreshExportMaterialMetricRow(materialRowData, showMetrics, rowindex);
    }

    private void refreshExportMaterialMetricRow(JSONObject materialRowData, Set<String> metrics, int rowindex) {
        int fhistorytntype = Integer.parseInt(this.getCache().get("fhistorytntype"));
        int pretntype = Integer.parseInt(this.getCache().get("ftntype"));
        ArrayList<String> showFList = new ArrayList<String>();
        ArrayList<String> showHisList = new ArrayList<String>();
        for (String metric : metrics) {
            int i;
            for (i = 0; i < pretntype; ++i) {
                showFList.add(String.format("%s%s_%s", "fea_", metric, i + 1));
            }
            for (i = fhistorytntype; i > 0; --i) {
                showHisList.add(String.format("%s%s_%s", "his_", metric, i));
            }
        }
        String export_invorg = materialRowData.getString("export_invorg");
        String export_warehouse = materialRowData.getString("export_warehouse");
        String export_material_name = materialRowData.getString("export_material_name");
        String export_material_number = materialRowData.getString("export_material_number");
        String export_customer = materialRowData.getString("export_customer");
        this.getModel().setValue("export_invorg", (Object)export_invorg, rowindex);
        this.getModel().setValue("export_warehouse", (Object)export_warehouse, rowindex);
        this.getModel().setValue("export_material_name", (Object)export_material_name, rowindex);
        this.getModel().setValue("export_material_number", (Object)export_material_number, rowindex);
        this.getModel().setValue("export_customer", (Object)export_customer, rowindex);
        for (String his : showHisList) {
            this.getModel().setValue(his, (Object)materialRowData.getBigDecimal(String.format("%s", his)), rowindex);
        }
        for (String fea : showFList) {
            this.getModel().setValue(fea, (Object)materialRowData.getBigDecimal(String.format("%s", fea)), rowindex);
        }
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        this.getCache().put(CHAT_SHOW_PRE_TYPE_ACTIVE, itemId);
        String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
        String currentNodeId = this.getCache().get(CURRENT_SELECTED_NODE_ID);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)currentNodeType, (CharSequence)"material")) {
            JSONObject data = this.getCache().getAsObject(currentNodeId);
            JSONObject indicator = data.getJSONObject(ENTRY_COL_INDICATOR);
            JSONObject salePreData = this.getMaterialSalePredictAnaChatData(indicator, itemId);
            String fpredimentypeCode = data.getString("fpredimentypeCode");
            String fpredimentypeCodeName = data.getString("fpredimentypeCodeName");
            JSONObject markData = this.loadMarkAnaData(fpredimentypeCode, indicator);
            salePreData.put("fpredimentypeCodeName", (Object)fpredimentypeCodeName);
            markData.put("fpredimentypeCodeName", (Object)fpredimentypeCodeName);
            this.showSaleAnaAndMarkPredictChat(salePreData, markData);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)itemId, (CharSequence)CHAT_SHOW_METRIC_AMOUNT)) {
            JSONObject dimdata = this.getCache().getAsObject(String.format("%s%s", DIM_SUM_DATA_NODE_PRE_AMOUNT, currentNodeId));
            JSONObject salePreData = this.getDimSalePredictAnaChatData(dimdata, itemId);
            salePreData.put("fpredimentypeCodeName", (Object)"");
            JSONObject markData = new JSONObject();
            markData.put("fpredimentypeCodeName", (Object)"");
            this.showSaleAnaAndMarkPredictChat(salePreData, markData);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)itemId, (CharSequence)CHAT_SHOW_METRIC_QTY)) {
            JSONObject dimdata = this.getCache().getAsObject(String.format("%s%s", DIM_SUM_DATA_NODE_PRE_QTY, currentNodeId));
            JSONObject salePreData = this.getDimSalePredictAnaChatData(dimdata, itemId);
            salePreData.put("fpredimentypeCodeName", (Object)"");
            JSONObject markData = new JSONObject();
            markData.put("fpredimentypeCodeName", (Object)"");
            this.showSaleAnaAndMarkPredictChat(salePreData, markData);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_CONTROL_KEY);
        String[] searchTypes = new String[]{"number", "name"};
        ArrayList<RequirePlanBase> res = new ArrayList<RequirePlanBase>();
        for (String type : searchTypes) {
            List<RequirePlanBase> nodes = this.searchMaterialNodesByStr(text, type);
            res.addAll(nodes);
        }
        if (!res.isEmpty()) {
            for (RequirePlanBase node : res) {
                String nodeId = node.getNodeId();
                String nodeType = node.getNodeType();
                String treeNodeId = String.format("%s_%s", nodeType, nodeId);
                TreeNode treeNode = treeNodeMap.get(treeNodeId);
                if (treeNode == null) continue;
                treeView.focusNode(treeNode);
            }
        }
    }

    private void initExportGridColumn(Set<String> metrics) {
        int fhistorytntype = Integer.parseInt(this.getCache().get("fhistorytntype"));
        int pretntype = Integer.parseInt(this.getCache().get("ftntype"));
        ArrayList<String> showFList = new ArrayList<String>();
        ArrayList<String> showHisList = new ArrayList<String>();
        for (String metric : metrics) {
            int i;
            for (i = 0; i < pretntype; ++i) {
                showFList.add(String.format("%s%s_%s", "fea_", metric, i + 1));
            }
            for (i = fhistorytntype; i > 0; --i) {
                showHisList.add(String.format("%s%s_%s", "his_", metric, i));
            }
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_EXPORT_ENTRYENTITY);
        List fieldEdits = entryGrid.getFieldEdits();
        List preDimTypes = this.getCache().getAsList("fpredimentype", String.class);
        JSONObject fieldKeyRenameJo = this.getCache().getAsObject(KEY_FIELDKEY_RENAME_MAP);
        for (FieldEdit fieldEdit : fieldEdits) {
            String key = fieldEdit.getFieldKey();
            if (RequirePlanConstants.EXPORT_PRE_DIM_TYPE_MAP.containsKey(key)) {
                String mappingName = (String)RequirePlanConstants.EXPORT_PRE_DIM_TYPE_MAP.get(key);
                if (!preDimTypes.contains(mappingName)) {
                    fieldEdit.setVisible(key, Boolean.FALSE.booleanValue());
                } else {
                    String dimFieldKey = (String)RequirePlanConstants.DIM_TYPE_MAPPING.get(mappingName);
                    if (fieldKeyRenameJo != null && fieldKeyRenameJo.containsKey((Object)dimFieldKey)) {
                        String renameName = fieldKeyRenameJo.getString(dimFieldKey);
                        fieldEdit.setCaption(new LocaleString(renameName));
                    }
                }
            }
            if (!key.startsWith("his_") && !key.startsWith("fea_") || showHisList.contains(key) || showFList.contains(key)) continue;
            fieldEdit.setVisible(key, Boolean.FALSE.booleanValue());
        }
        this.changeExportHeaderNames(showHisList, "his_");
        this.changeExportHeaderNames(showFList, "fea_");
    }

    private void changeExportHeaderNames(List<String> list, String flag) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_EXPORT_ENTRYENTITY);
        JSONObject config = this.getCache().getAsObject("config_tag");
        List<String> hisPeriods = this.getHisPeriods(config);
        int hisCount = hisPeriods.size();
        List<String> feaPeriods = this.getFeaPeriods(config);
        for (String fieldKey : list) {
            String period;
            int t;
            if (fieldKey.startsWith("his_")) {
                t = Integer.parseInt(fieldKey.substring(fieldKey.lastIndexOf("_") + 1));
                period = hisPeriods.get(hisCount - t);
                entryGrid.setColumnProperty(fieldKey, "header", (Object)new LocaleString(period));
                continue;
            }
            if (!fieldKey.startsWith("fea_")) continue;
            t = Integer.parseInt(fieldKey.substring(fieldKey.lastIndexOf("_") + 1));
            period = feaPeriods.get(t - 1);
            entryGrid.setColumnProperty(fieldKey, "header", (Object)new LocaleString(period));
        }
    }

    private void showAllRequirePlanData(JSONObject data) {
        final JSONObject preData = data.getJSONObject("data");
        if (preData != null) {
            final JSONArray requirePlanData = new JSONArray();
            final HashSet metrics = new HashSet();
            preData.keySet().stream().forEach(new Consumer<String>(){

                @Override
                public void accept(String materialId) {
                    JSONObject materialData = preData.getJSONObject(materialId);
                    final JSONObject indicators = materialData.getJSONObject(RequirePlanEntryBillPlugin.ENTRY_COL_INDICATOR);
                    final JSONObject materialRowData = new JSONObject();
                    materialRowData.put("export_invorg", (Object)materialData.getString("orgName"));
                    materialRowData.put("export_warehouse", (Object)materialData.getString("warehouseName"));
                    materialRowData.put("export_material_name", (Object)materialData.getString("name"));
                    materialRowData.put("export_material_number", (Object)materialData.getString("number"));
                    materialRowData.put("export_customer", (Object)materialData.getString("customerName"));
                    materialRowData.put("row_material_index", (Object)String.format("%s_%s_%s", "row_material_index", "material", materialId));
                    indicators.keySet().stream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String metric) {
                            metrics.add(metric);
                            JSONObject metricData = indicators.getJSONObject(metric);
                            RequirePlanEntryBillPlugin.this.genExportMaterialRowData(materialRowData, metricData, metric);
                        }
                    });
                    requirePlanData.add((Object)materialRowData);
                }
            });
            List preExportMetrics = RequirePlanConstants.PRE_EXPORT_METRICS;
            HashSet<String> showMetrics = new HashSet<String>();
            for (String metric : metrics) {
                if (!preExportMetrics.contains(metric)) continue;
                showMetrics.add(metric);
            }
            this.initExportGridColumn(showMetrics);
            this.showMaterialMetricRow(requirePlanData, showMetrics);
        }
    }

    private JSONObject genExportMaterialRowData(JSONObject materialRowData, JSONObject metricData, String metric) {
        BigDecimal data;
        int i;
        int fhistorytntype = Integer.parseInt(this.getCache().get("fhistorytntype"));
        int pretntype = Integer.parseInt(this.getCache().get("ftntype"));
        for (i = 0; i < pretntype; ++i) {
            data = metricData.getBigDecimal(String.format("%s%s", "value", i + 1));
            materialRowData.put(String.format("%s%s_%s", "fea_", metric, i + 1), (Object)data);
        }
        for (i = fhistorytntype; i > 0; --i) {
            data = metricData.getBigDecimal(String.format("%s%s", HISTORY_PRE_COL_FIX, i));
            materialRowData.put(String.format("%s%s_%s", "his_", metric, i), (Object)data);
        }
        return materialRowData;
    }

    private void showMaterialMetricRow(JSONArray data, Set<String> metrics) {
        this.getModel().deleteEntryData(KEY_EXPORT_ENTRYENTITY);
        int fhistorytntype = Integer.parseInt(this.getCache().get("fhistorytntype"));
        int pretntype = Integer.parseInt(this.getCache().get("ftntype"));
        ArrayList<String> showFList = new ArrayList<String>();
        ArrayList<String> showHisList = new ArrayList<String>();
        for (String metric : metrics) {
            int i;
            for (i = 0; i < pretntype; ++i) {
                showFList.add(String.format("%s%s_%s", "fea_", metric, i + 1));
            }
            for (i = fhistorytntype; i > 0; --i) {
                showHisList.add(String.format("%s%s_%s", "his_", metric, i));
            }
        }
        int count = data.size();
        if (count == 0) {
            return;
        }
        int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_EXPORT_ENTRYENTITY, count);
        JSONObject indicator = new JSONObject();
        for (int i = 0; i < count; ++i) {
            BigDecimal bd;
            JSONObject rowData = data.getJSONObject(i);
            String rowOrgMaterialIndex = rowData.getString("row_material_index");
            this.getCache().put(String.format("%s", rowOrgMaterialIndex), String.valueOf(rowIndex[i]));
            String export_invorg = rowData.getString("export_invorg");
            String export_warehouse = rowData.getString("export_warehouse");
            String export_material_name = rowData.getString("export_material_name");
            String export_material_number = rowData.getString("export_material_number");
            String export_customer = rowData.getString("export_customer");
            this.getModel().setValue("export_invorg", (Object)export_invorg, rowIndex[i]);
            this.getModel().setValue("export_warehouse", (Object)export_warehouse, rowIndex[i]);
            this.getModel().setValue("export_material_name", (Object)export_material_name, rowIndex[i]);
            this.getModel().setValue("export_material_number", (Object)export_material_number, rowIndex[i]);
            this.getModel().setValue("export_customer", (Object)export_customer, rowIndex[i]);
            for (String his : showHisList) {
                bd = rowData.getBigDecimal(String.format("%s", his));
                if (bd.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue(his, null, rowIndex[i]);
                    continue;
                }
                this.getModel().setValue(his, (Object)bd.setScale(2, 4), rowIndex[i]);
            }
            for (String fea : showFList) {
                bd = rowData.getBigDecimal(String.format("%s", fea));
                if (bd.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue(fea, null, rowIndex[i]);
                    continue;
                }
                this.getModel().setValue(fea, (Object)bd.setScale(2, 4), rowIndex[i]);
            }
        }
    }

    private void loadingExportRequirePlanData(long requirePlanId) {
        List dims = this.getCache().getAsList("fpredimentype", String.class);
        JSONObject data = this.requirePlanService.loadingRequireData(requirePlanId, dims, new HashMap());
        this.showAllRequirePlanData(data);
        String currentNodeType = this.getCache().get(CURRENT_SELECTED_NODE_TYPE);
        String currentMaterialId = this.getCache().get(CURRENT_SELECTED_NODE_ID);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"material", (CharSequence)currentNodeType)) {
            this.refreshTreeNodeMaterialData(data, currentMaterialId);
        }
    }

    private void refreshTreeNodeMaterialData(JSONObject data, String materialTreeNodeId) {
        RequirePlanMaterial materialNode;
        if (tree != null && (materialNode = this.findMaterialNode(tree.getChildren(), materialTreeNodeId)) != null) {
            JSONObject preData = data.getJSONObject("data");
            String nodeType = materialNode.getNodeType();
            Set keys = preData.keySet();
            for (String materialId : keys) {
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)String.format("%s_%s", nodeType, materialId), (CharSequence)materialTreeNodeId)) continue;
                JSONObject materialData = preData.getJSONObject(materialId);
                materialNode.setData(materialData);
                this.getCache().put(String.format("%s_%s", materialNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                break;
            }
        }
    }

    private JSONObject getMaterialSalePredictAnaChatData(final JSONObject indicator, final String type) {
        final List showFList = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
        final List showHList = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        JSONObject chatData = new JSONObject();
        final JSONArray dataList = new JSONArray();
        chatData.put("dataList", (Object)dataList);
        chatData.put("fprevaluetype", (Object)type);
        JSONObject config = this.getCache().getAsObject("config_tag");
        chatData.put("periodList", this.combinPeriod(config, showFList.size(), showHList.size()));
        indicator.keySet().stream().forEach(new Consumer<String>(){

            @Override
            public void accept(String metric) {
                if (RequirePlanConstants.chatShowMetrics.containsKey(metric)) {
                    if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)RequirePlanEntryBillPlugin.CHAT_SHOW_METRIC_QTY)) {
                        JSONObject predata = indicator.getJSONObject(metric);
                        String metricTips = (String)RequirePlanConstants.metricTips.get(metric);
                        dataList.add((Object)RequirePlanEntryBillPlugin.this.genQtyMetricData(predata, metric, metricTips, showFList, showHList));
                    } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)RequirePlanEntryBillPlugin.CHAT_SHOW_METRIC_AMOUNT)) {
                        JSONObject predata = indicator.getJSONObject(metric);
                        JSONObject avgPrices = indicator.getJSONObject("favgprice");
                        String metricTips = (String)RequirePlanConstants.metricTips.get(metric);
                        if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"fape", (CharSequence)metric)) {
                            dataList.add((Object)RequirePlanEntryBillPlugin.this.genMaterialAmountMetricData(avgPrices, predata, metric, metricTips, showFList, showHList, Boolean.TRUE));
                        } else {
                            dataList.add((Object)RequirePlanEntryBillPlugin.this.genMaterialAmountMetricData(avgPrices, predata, metric, metricTips, showFList, showHList, Boolean.FALSE));
                        }
                    }
                }
            }
        });
        return chatData;
    }

    private JSONObject getDimSalePredictAnaChatData(final JSONObject indicator, final String type) {
        final List showFList = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
        final List showHList = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        JSONObject chatData = new JSONObject();
        final JSONArray dataList = new JSONArray();
        chatData.put("dataList", (Object)dataList);
        chatData.put("fprevaluetype", (Object)type);
        JSONObject config = this.getCache().getAsObject("config_tag");
        chatData.put("periodList", this.combinPeriod(config, showFList.size(), showHList.size()));
        indicator.keySet().stream().forEach(new Consumer<String>(){

            @Override
            public void accept(String metric) {
                if (RequirePlanConstants.chatShowMetrics.containsKey(metric)) {
                    if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)RequirePlanEntryBillPlugin.CHAT_SHOW_METRIC_QTY)) {
                        JSONObject predata = indicator.getJSONObject(metric);
                        String metricTips = (String)RequirePlanConstants.metricTips.get(metric);
                        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)metric, (CharSequence)"fape")) {
                            dataList.add((Object)RequirePlanEntryBillPlugin.this.genQtyMetricData(new JSONObject(), metric, metricTips, showFList, showHList));
                        } else {
                            dataList.add((Object)RequirePlanEntryBillPlugin.this.genQtyMetricData(predata, metric, metricTips, showFList, showHList));
                        }
                    } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)RequirePlanEntryBillPlugin.CHAT_SHOW_METRIC_AMOUNT)) {
                        JSONObject predata = indicator.getJSONObject(metric);
                        String metricTips = (String)RequirePlanConstants.metricTips.get(metric);
                        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)metric, (CharSequence)"fape")) {
                            dataList.add((Object)RequirePlanEntryBillPlugin.this.genAmountMetricData(new JSONObject(), metric, metricTips, showFList, showHList));
                        } else {
                            dataList.add((Object)RequirePlanEntryBillPlugin.this.genAmountMetricData(predata, metric, metricTips, showFList, showHList));
                        }
                    }
                }
            }
        });
        return chatData;
    }

    private void showSaleAnaAndMarkPredictChat(JSONObject salePreData, JSONObject markData) {
        JSONObject data = new JSONObject();
        data.put("sale_ana_data", (Object)salePreData);
        data.put("mark_data", (Object)markData);
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("chartType", "ids_require_ana");
        customData.put("containerId", CUSTOM_CONTROL_CHAT);
        customData.put("timestamp", new Date().getTime());
        customData.put("data", data);
        customData.put("uniqueCode", "ai_ids_req_value_ana_" + this.getView().getPageId());
        customData.put("eventName", CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("pageId", this.getView().getPageId());
        CustomControl customControl = (CustomControl)this.getControl(CUSTOM_CONTROL_CHAT);
        customControl.setData(customData);
    }

    public void customEvent(CustomEventArgs e) {
        JSONObject info;
        String args;
        super.customEvent(e);
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        if (CUSTOM_CONTROL_CHAT.equals(controlKey) && CUSTOM_EVENT_SHOW_TIPS.equals(eventName) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(args = e.getEventArgs())) && (info = JSONObject.parseObject((String)args)) != null) {
            String msg = info.getString("descriptionCn");
            this.getView().showTipNotification(msg != null ? msg : "", Integer.valueOf(3000));
        }
    }

    private void loadingBizAssociateScheme(String fmodeltypeid, long periodId) {
        QFilter qFilter = new QFilter("appid", "=", (Object)((IDataappService)Services.get(IDataappService.class)).getSalesForecastAppIdByPlatformCode()).and("bizobj", "=", (Object)"ids_requireplan_entry").and(COMBO_PREMODELTYPE_ID, "=", (Object)fmodeltypeid).and("status", "=", (Object)String.valueOf(YesNoEnum.YES.getKey()));
        DynamicObject bizAssociateSchemeDo = BusinessDataServiceHelper.loadSingle((String)"ids_biz_associate_scheme", (QFilter[])qFilter.toArray());
        if (bizAssociateSchemeDo != null) {
            HashMap<String, String> fieldKeyRenameMap = new HashMap<String, String>();
            DynamicObjectCollection fieldMappingDoc = bizAssociateSchemeDo.getDynamicObjectCollection("field_mapping_entry");
            if (fieldMappingDoc != null && fieldMappingDoc.size() > 0) {
                for (DynamicObject fieldMappingDo : fieldMappingDoc) {
                    String quoteField = fieldMappingDo.getString("quotefield");
                    String bizobjField = fieldMappingDo.getString("bizobjfield");
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)quoteField) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bizobjField)) continue;
                    String[] splitArr = bizobjField.split("\\.");
                    String realBizobjFieldId = splitArr[splitArr.length - 1];
                    String renameField = fieldMappingDo.getString("renamefield");
                    if (!StringUtils.isNotEmpty((CharSequence)renameField)) continue;
                    fieldKeyRenameMap.put(realBizobjFieldId, renameField);
                    fieldKeyRenameMap.put(String.format("%s.name", realBizobjFieldId), renameField);
                    if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)realBizobjFieldId, (CharSequence)"bizoperatorid")) continue;
                    fieldKeyRenameMap.put(String.format("%s.operatorname", realBizobjFieldId), renameField);
                }
            }
            this.getCache().put(KEY_FIELDKEY_RENAME_MAP, JSONObject.toJSONString(fieldKeyRenameMap));
        }
    }
}

