/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.bill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.constants.RequirePlanConstants;
import kd.ai.ids.core.entity.model.RequirePlanBase;
import kd.ai.ids.core.entity.model.RequirePlanCustomer;
import kd.ai.ids.core.entity.model.RequirePlanInv;
import kd.ai.ids.core.entity.model.RequirePlanMaterial;
import kd.ai.ids.core.entity.model.RequirePlanTree;
import kd.ai.ids.core.entity.model.RequirePlanWarehouse;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IRequirePlanService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.ListUtils;
import kd.ai.ids.plugin.bill.RequirePlanEntryBillPlugin;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RequirePlanEntryDetailPlugin
extends AbstractBillPlugIn {
    private IdsPageCache cache;
    public static RequirePlanTree tree = new RequirePlanTree();
    private static final Log logger = LogFactory.getLog(RequirePlanEntryBillPlugin.class);
    private IRequirePlanService requirePlanService = (IRequirePlanService)Services.get(IRequirePlanService.class);
    private static final String COMBO_DIM_SELECTOR = "dim_select";
    private static final String COMBO_METRIC_SELECTOR = "metric_select";
    private static final String INDICATOR_NAME_CACHE_PRE = "indicator_";
    private static final String FEATURE_PRE_COL_FIX = "fea_";
    private static final String HISTORY_PRE_COL_FIX = "his_";
    private static final String FEATURE_PRE_COL_VALUE_FIX = "value";
    private static final String HISTORY_PRE_COL_VALUE_FIX = "value_";
    private static final String KEY_ENTRYENTITY = "ids_req_indicator_detail";
    private static final String CURRENT_DISPLAY_COL_HIS_CACHE_KEY = "pre_period_col_his_cache";
    private static final String CURRENT_DISPLAY_COL_FEA_CACHE_KEY = "pre_period_col_fea_cache";
    private static final String CURRENT_DISPLAY_METRIC_ROW_COUNT_KEY = "current_metric_row_count";
    private static final String KEY_FIELDKEY_RENAME_MAP = "fieldkey_rename_map";
    private static final String CURRENT_SELECTED_DIMS = "current_selected_dims";
    private static final String CURRENT_SELECTED_METRIC = "current_selected_metric";
    private static final String DEFAULT_SHOW_METRIC = "default_show_metric";
    private static final String KEY_HAS_INIT_SHOW_METRIC = "is_init_show_metric";

    public IdsPageCache getCache() {
        return this.cache;
    }

    public void initialize() {
        super.initialize();
        if (this.cache == null) {
            this.cache = new IdsPageCache(this.getView().getPageId());
        }
    }

    public void destory() {
        super.destory();
        if (this.cache != null) {
            this.cache.saveChanges();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.cache != null) {
            this.cache.release();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setStatus(OperationStatus.VIEW);
        Object idObject = formShowParameter.getCustomParam("id");
        if (idObject != null) {
            long requirePlanId = (Long)idObject;
            JSONObject requirePlanConfig = (JSONObject)formShowParameter.getCustomParam("config_tag");
            this.getCache().put("config_tag", JSONObject.toJSONString((Object)requirePlanConfig));
            this.initCombo(requirePlanConfig);
            this.initRequirePlanBillHead(requirePlanId);
            this.loadingRequirePlanData(requirePlanId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)COMBO_METRIC_SELECTOR)) {
            this.handleMetricChange(e);
            grid.setPageIndex(1);
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)COMBO_DIM_SELECTOR)) {
            this.handleDimChange(e);
            grid.setPageIndex(1);
        }
    }

    private void handleDimChange(PropertyChangedArgs e) {
        String str;
        ChangeData[] changeData = e.getChangeSet();
        List<String> dims = new ArrayList<String>();
        if (changeData[0] != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(str = (String)changeData[0].getNewValue()))) {
            String[] arrays = str.substring(1, str.lastIndexOf(44)).split(",");
            dims = Arrays.asList(arrays);
        }
        this.getCache().put(CURRENT_SELECTED_DIMS, dims);
        JSONObject data = this.getCache().getAsObject("require_plan_data_cache");
        this.resetDimShowTree(dims, data);
        this.showRequireSummaryData();
    }

    private void handleMetricChange(PropertyChangedArgs e) {
        String str;
        ChangeData[] changeData = e.getChangeSet();
        List<String> metrics = new ArrayList<String>();
        if (changeData[0] != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(str = (String)changeData[0].getNewValue()))) {
            String[] arrays = str.substring(1, str.lastIndexOf(44)).split(",");
            metrics = Arrays.asList(arrays);
        }
        this.handleMetricDisplay(metrics);
        this.showRequireSummaryData();
    }

    private void handleMetricDisplay(List<String> metrics) {
        List defaults = this.getCache().getAsList(DEFAULT_SHOW_METRIC, String.class);
        List hiddens = ListUtils.diff((Collection)defaults, metrics);
        this.getCache().put(CURRENT_SELECTED_METRIC, metrics);
        List showHisList = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        List showFList = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
        ArrayList<String> cols = new ArrayList<String>();
        cols.addAll(showFList);
        cols.addAll(showHisList);
        if (!hiddens.isEmpty()) {
            this.displayMetricData(hiddens, cols, Boolean.FALSE);
        }
        if (!metrics.isEmpty()) {
            this.displayMetricData(metrics, cols, Boolean.TRUE);
        }
    }

    private void displayMetricData(List<String> metrics, List<String> cols, Boolean visible) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            String key = fieldEdit.getFieldKey();
            if (!key.startsWith(HISTORY_PRE_COL_FIX) && !key.startsWith(FEATURE_PRE_COL_FIX)) continue;
            for (String metric : metrics) {
                if (!key.startsWith(String.format("%s%s_", FEATURE_PRE_COL_FIX, metric)) && !key.startsWith(String.format("%s%s_", HISTORY_PRE_COL_FIX, metric)) || !cols.contains(key)) continue;
                fieldEdit.setVisible(key, visible.booleanValue());
            }
        }
    }

    private void initRequirePlanBillHead(long pk) {
        DynamicObject requirePlanObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ids_requireplan");
        String modeltypeid = requirePlanObject.getString("modeltypeid");
        DynamicObject period = requirePlanObject.getDynamicObject("periodid");
        if (period != null) {
            long periodid = (Long)period.getPkValue();
            this.loadingBizAssociateScheme(modeltypeid, periodid);
        }
    }

    private void loadingRequirePlanData(long requirePlanId) {
        List dims = this.getCache().getAsList("fpredimentype", String.class);
        JSONObject data = this.requirePlanService.loadingRequireData(requirePlanId, dims, new HashMap());
        this.getCache().put("require_plan_data_cache", JSONObject.toJSONString((Object)data));
        this.resetDimShowTree(dims, data);
        this.showRequireSummaryData();
    }

    private RequirePlanTree resetDimShowTree(List<String> lists, JSONObject data) {
        if (tree != null) {
            tree.getChildren().clear();
            tree.getLevels().clear();
            List dims = lists.stream().filter(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return true;
                }
            }).collect(Collectors.toList());
            JSONObject dic = data.getJSONObject("dic");
            if (dims.contains("finvorgid")) {
                final JSONObject org = dic.getJSONObject("finvorgid");
                org.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String orgId) {
                        JSONObject orgEntry = org.getJSONObject(orgId);
                        String name = orgEntry.getString("name");
                        String number = orgEntry.getString("number");
                        RequirePlanInv orgNode = new RequirePlanInv(orgId, name);
                        orgNode.setNodeNumber(number);
                        tree.addChild((RequirePlanBase)orgNode);
                    }
                });
                tree.addLevel("finvorgid");
            }
            if (dims.contains("fwarehouseid")) {
                JSONObject warehouse;
                if (tree.containsLevel("finvorgid")) {
                    warehouse = dic.getJSONObject("fwarehouseid");
                    warehouse.keySet().stream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String warehouseId) {
                            JSONObject whEntry = warehouse.getJSONObject(warehouseId);
                            String name = whEntry.getString("name");
                            String parentOrg = whEntry.getString("parent_org");
                            String number = whEntry.getString("number");
                            RequirePlanWarehouse whNode = new RequirePlanWarehouse(warehouseId, name);
                            whNode.setNodeNumber(number);
                            whNode.setParent(parentOrg);
                            RequirePlanBase parentNode = RequirePlanEntryDetailPlugin.this.findParentNode(tree.getChildren(), parentOrg, "invorg");
                            if (parentNode != null) {
                                parentNode.addChild((RequirePlanBase)whNode);
                            }
                        }
                    });
                } else {
                    warehouse = dic.getJSONObject("fwarehouseid");
                    warehouse.keySet().stream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String warehouseId) {
                            JSONObject whEntry = warehouse.getJSONObject(warehouseId);
                            String name = whEntry.getString("name");
                            String number = whEntry.getString("number");
                            RequirePlanWarehouse whNode = new RequirePlanWarehouse(warehouseId, name);
                            whNode.setNodeNumber(number);
                            tree.getChildren().add(whNode);
                        }
                    });
                }
                tree.addLevel("fwarehouseid");
            }
            if (dims.contains("fcustid")) {
                JSONObject customer;
                if (tree.containsLevel("fwarehouseid")) {
                    customer = dic.getJSONObject("fcustid");
                    customer.keySet().stream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String custId) {
                            JSONObject custEntry = customer.getJSONObject(custId);
                            String name = custEntry.getString("name");
                            String number = custEntry.getString("number");
                            String parentWarehouse = custEntry.getString("parent_warehouse");
                            RequirePlanCustomer custNode = new RequirePlanCustomer(custId, name);
                            custNode.setNodeNumber(number);
                            custNode.setParent(parentWarehouse);
                            RequirePlanBase parentNode = RequirePlanEntryDetailPlugin.this.findParentNode(tree.getChildren(), parentWarehouse, "warehouse");
                            if (parentNode != null) {
                                parentNode.addChild((RequirePlanBase)custNode);
                            }
                        }
                    });
                    tree.addLevel("fcustid");
                } else {
                    if (dims.contains("finvorgid")) {
                        customer = dic.getJSONObject("fcustid");
                        customer.keySet().stream().forEach(new Consumer<String>(){

                            @Override
                            public void accept(String custId) {
                                JSONObject custEntry = customer.getJSONObject(custId);
                                String name = custEntry.getString("name");
                                String parentOrg = custEntry.getString("parent_org");
                                String number = custEntry.getString("number");
                                RequirePlanCustomer custNode = new RequirePlanCustomer(custId, name);
                                custNode.setParent(parentOrg);
                                custNode.setNodeNumber(number);
                                RequirePlanBase parentNode = RequirePlanEntryDetailPlugin.this.findParentNode(tree.getChildren(), parentOrg, "invorg");
                                if (parentNode != null) {
                                    parentNode.addChild((RequirePlanBase)custNode);
                                }
                            }
                        });
                    } else {
                        customer = dic.getJSONObject("fcustid");
                        customer.keySet().stream().forEach(new Consumer<String>(){

                            @Override
                            public void accept(String custId) {
                                JSONObject custEntry = customer.getJSONObject(custId);
                                String name = custEntry.getString("name");
                                String number = custEntry.getString("number");
                                RequirePlanCustomer custNode = new RequirePlanCustomer(custId, name);
                                custNode.setNodeNumber(number);
                                tree.getChildren().add(custNode);
                            }
                        });
                    }
                    tree.addLevel("fcustid");
                }
            }
            final JSONObject preData = data.getJSONObject("data");
            if (tree.containsLevel("fcustid")) {
                preData.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String materialId) {
                        JSONObject materialData = preData.getJSONObject(materialId);
                        JSONObject dimData = materialData.getJSONObject("dim");
                        String custId = dimData.getString("fcustid");
                        RequirePlanBase parentNode = RequirePlanEntryDetailPlugin.this.findParentNode(tree.getChildren(), custId, "customer");
                        String name = materialData.getString("name");
                        RequirePlanMaterial materalNode = new RequirePlanMaterial(materialId, name);
                        materalNode.setData(materialData);
                        String number = materialData.getString("number");
                        materalNode.setNodeNumber(number);
                        if (parentNode != null) {
                            parentNode.addChild((RequirePlanBase)materalNode);
                        }
                        RequirePlanEntryDetailPlugin.this.getCache().put(String.format("%s_%s", materalNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                    }
                });
                tree.addLevel("fmaterialid");
            } else if (tree.containsLevel("fwarehouseid")) {
                preData.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String materialId) {
                        JSONObject materialData = preData.getJSONObject(materialId);
                        JSONObject dimData = materialData.getJSONObject("dim");
                        String warehouseId = dimData.getString("fwarehouseid");
                        RequirePlanBase parentNode = RequirePlanEntryDetailPlugin.this.findParentNode(tree.getChildren(), warehouseId, "warehouse");
                        String name = materialData.getString("name");
                        RequirePlanMaterial materalNode = new RequirePlanMaterial(materialId, name);
                        materalNode.setData(materialData);
                        if (parentNode != null) {
                            parentNode.addChild((RequirePlanBase)materalNode);
                        }
                        String number = materialData.getString("number");
                        materalNode.setNodeNumber(number);
                        RequirePlanEntryDetailPlugin.this.getCache().put(String.format("%s_%s", materalNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                    }
                });
                tree.addLevel("fmaterialid");
            } else if (tree.containsLevel("finvorgid")) {
                preData.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String materialId) {
                        JSONObject materialData = preData.getJSONObject(materialId);
                        JSONObject dimData = materialData.getJSONObject("dim");
                        String invorgId = dimData.getString("finvorgid");
                        RequirePlanBase parentNode = RequirePlanEntryDetailPlugin.this.findParentNode(tree.getChildren(), invorgId, "invorg");
                        String name = materialData.getString("name");
                        RequirePlanMaterial materalNode = new RequirePlanMaterial(materialId, name);
                        materalNode.setData(materialData);
                        if (parentNode != null) {
                            parentNode.addChild((RequirePlanBase)materalNode);
                        }
                        String number = materialData.getString("number");
                        materalNode.setNodeNumber(number);
                        RequirePlanEntryDetailPlugin.this.getCache().put(String.format("%s_%s", materalNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                    }
                });
                tree.addLevel("fmaterialid");
            } else {
                preData.keySet().stream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String materialId) {
                        JSONObject materialData = preData.getJSONObject(materialId);
                        String name = materialData.getString("name");
                        RequirePlanMaterial materalNode = new RequirePlanMaterial(materialId, name);
                        materalNode.setData(materialData);
                        String number = materialData.getString("number");
                        materalNode.setNodeNumber(number);
                        tree.addChild((RequirePlanBase)materalNode);
                        RequirePlanEntryDetailPlugin.this.getCache().put(String.format("%s_%s", materalNode.getNodeType(), materialId), JSONObject.toJSONString((Object)materialData));
                    }
                });
                tree.addLevel("fmaterialid");
            }
            if (!dims.contains("fmaterialid")) {
                tree.removeLevel("fmaterialid");
            }
        }
        return tree;
    }

    private RequirePlanBase findParentNode(List<RequirePlanBase> nodes, String findNodeId, String findNodeType) {
        if (nodes.isEmpty()) {
            return null;
        }
        RequirePlanBase node = nodes.get(0);
        String nodeType = node.getNodeType();
        if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)findNodeType)) {
            ArrayList<RequirePlanBase> allNodes = new ArrayList<RequirePlanBase>();
            for (RequirePlanBase item : nodes) {
                allNodes.addAll(item.getChildren());
            }
            return this.findParentNode(allNodes, findNodeId, findNodeType);
        }
        for (RequirePlanBase requirePlanBase : nodes) {
            String type = requirePlanBase.getNodeType();
            String nodeId = requirePlanBase.getNodeId();
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)findNodeType) || !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeId, (CharSequence)findNodeId)) continue;
            return requirePlanBase;
        }
        return null;
    }

    private void loadingBizAssociateScheme(String fmodeltypeid, long periodId) {
        QFilter qFilter = new QFilter("appid", "=", (Object)((IDataappService)Services.get(IDataappService.class)).getSalesForecastAppIdByPlatformCode()).and("bizobj", "=", (Object)"ids_requireplan_entry").and("modeltypeid", "=", (Object)fmodeltypeid).and("status", "=", (Object)String.valueOf(YesNoEnum.YES.getKey()));
        DynamicObject bizAssociateSchemeDo = BusinessDataServiceHelper.loadSingle((String)"ids_biz_associate_scheme", (QFilter[])qFilter.toArray());
        if (bizAssociateSchemeDo != null) {
            HashMap<String, String> fieldKeyRenameMap = new HashMap<String, String>();
            DynamicObjectCollection fieldMappingDoc = bizAssociateSchemeDo.getDynamicObjectCollection("field_mapping_entry");
            if (fieldMappingDoc != null && fieldMappingDoc.size() > 0) {
                for (DynamicObject fieldMappingDo : fieldMappingDoc) {
                    String quoteField = fieldMappingDo.getString("quotefield");
                    String bizobjField = fieldMappingDo.getString("bizobjfield");
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)quoteField) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bizobjField)) continue;
                    String[] splitArr = bizobjField.split("\\.");
                    String realBizobjFieldId = splitArr[splitArr.length - 1];
                    String renameField = fieldMappingDo.getString("renamefield");
                    if (!StringUtils.isNotEmpty((CharSequence)renameField)) continue;
                    fieldKeyRenameMap.put(realBizobjFieldId, renameField);
                    fieldKeyRenameMap.put(String.format("%s.name", realBizobjFieldId), renameField);
                    if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)realBizobjFieldId, (CharSequence)"bizoperatorid")) continue;
                    fieldKeyRenameMap.put(String.format("%s.operatorname", realBizobjFieldId), renameField);
                }
            }
            this.getCache().put(KEY_FIELDKEY_RENAME_MAP, JSONObject.toJSONString(fieldKeyRenameMap));
        }
    }

    private void initCombo(JSONObject requirePlanConfig) {
        String fpredimentype = requirePlanConfig.getString("fpredimentype");
        List<String> lists = Arrays.asList(fpredimentype.split("/"));
        this.getCache().put("fpredimentype", lists);
        this.initDimSelectCombo(lists);
        JSONArray findicators = requirePlanConfig.getJSONArray("findicators");
        if (findicators != null) {
            this.initMetricSelect(findicators);
        }
        this.getCache().put("findicators", (List)findicators);
        if (findicators != null && !findicators.isEmpty()) {
            for (int i = 0; i < findicators.size(); ++i) {
                JSONObject indicator = findicators.getJSONObject(i);
                String id = indicator.getString("id");
                String name = indicator.getString("name");
                this.getCache().put(String.format("%s%s", INDICATOR_NAME_CACHE_PRE, id), name);
            }
        }
        int fhistorytntype = requirePlanConfig.getIntValue("fhistorytntype");
        int pretntype = requirePlanConfig.getIntValue("ftntype");
        this.getCache().put("fhistorytntype", String.valueOf(fhistorytntype));
        this.getCache().put("ftntype", String.valueOf(pretntype));
        List<String> showHisList = this.initHisSelect(fhistorytntype);
        List<String> showFList = this.initFeatureSelect(pretntype);
        this.hiddenGridColumn(showHisList, showFList);
    }

    private void initDimSelectCombo(List<String> lists) {
        ComboEdit dimSelect = (ComboEdit)this.getControl(COMBO_DIM_SELECTOR);
        ArrayList<ComboItem> dimSelectItems = new ArrayList<ComboItem>(lists.size());
        ArrayList<String> defaultSelect = new ArrayList<String>(lists.size());
        for (String dim : lists) {
            ComboItem ci = new ComboItem();
            String name = "";
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dim, (CharSequence)"finvorgid")) {
                name = "\u5e93\u5b58\u7ec4\u7ec7";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dim, (CharSequence)"fwarehouseid")) {
                name = "\u4ed3\u5e93";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dim, (CharSequence)"fcustid")) {
                name = "\u5ba2\u6237";
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dim, (CharSequence)"fmaterialid")) {
                name = "\u7269\u6599";
            }
            ci.setCaption(new LocaleString(name));
            ci.setValue(dim);
            dimSelectItems.add(ci);
            defaultSelect.add(dim);
        }
        dimSelect.setComboItems(dimSelectItems);
        this.getModel().setValue(COMBO_DIM_SELECTOR, (Object)String.format(",%s,", org.apache.commons.lang3.StringUtils.join(defaultSelect, (String)",")));
        this.getCache().put(CURRENT_SELECTED_DIMS, defaultSelect);
    }

    private JSONArray initMetricSelect(JSONArray findicators) {
        ComboEdit select = (ComboEdit)this.getControl(COMBO_METRIC_SELECTOR);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ArrayList<String> defaultSelect = new ArrayList<String>();
        JSONArray selectMetrics = new JSONArray();
        for (int i = 0; i < findicators.size(); ++i) {
            JSONObject item = findicators.getJSONObject(i);
            String name = item.getString("name");
            String id = item.getString("id");
            boolean canshow = item.getBooleanValue("canshow");
            if (!canshow || !RequirePlanConstants.REQUIRE_PLAN_DETAIL_SHOW_METRICS.contains(id)) continue;
            ComboItem ci = new ComboItem();
            ci.setCaption(new LocaleString(name));
            ci.setValue(id);
            items.add(ci);
            defaultSelect.add(id);
        }
        select.setComboItems(items);
        this.getModel().setValue(COMBO_METRIC_SELECTOR, (Object)String.format(",%s,", org.apache.commons.lang3.StringUtils.join(defaultSelect, (String)",")));
        this.getCache().put(CURRENT_SELECTED_METRIC, defaultSelect);
        this.getCache().put(DEFAULT_SHOW_METRIC, defaultSelect);
        return selectMetrics;
    }

    private List<String> getHisPeriods(JSONObject config) {
        JSONArray fhistoryperiods = config.getJSONArray("fhistoryperiods");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < fhistoryperiods.size(); ++i) {
            list.add(fhistoryperiods.getString(i));
        }
        return list;
    }

    private List<String> getFeaPeriods(JSONObject config) {
        JSONArray fpreperiods = config.getJSONArray("fpreperiods");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < fpreperiods.size(); ++i) {
            list.add(fpreperiods.getString(i));
        }
        return list;
    }

    private List<String> initHisSelect(int count) {
        ArrayList<String> res = new ArrayList<String>();
        List metrics = this.getCache().getAsList(CURRENT_SELECTED_METRIC, String.class);
        if (metrics != null && !metrics.isEmpty()) {
            for (String metric : metrics) {
                for (int i = 0; i < count; ++i) {
                    res.add(String.format("%s%s_%s", HISTORY_PRE_COL_FIX, metric, i + 1));
                }
            }
        }
        return res;
    }

    private List<String> initFeatureSelect(int count) {
        ArrayList<String> res = new ArrayList<String>();
        List metrics = this.getCache().getAsList(CURRENT_SELECTED_METRIC, String.class);
        if (metrics != null && !metrics.isEmpty()) {
            for (String metric : metrics) {
                for (int i = 0; i < count; ++i) {
                    res.add(String.format("%s%s_%s", FEATURE_PRE_COL_FIX, metric, i + 1));
                }
            }
        }
        return res;
    }

    private void hiddenGridColumn(List<String> showHisList, List<String> showFList) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            String key = fieldEdit.getFieldKey();
            if (!key.startsWith(HISTORY_PRE_COL_FIX) && !key.startsWith(FEATURE_PRE_COL_FIX) || showHisList.contains(key) || showFList.contains(key)) continue;
            fieldEdit.setVisible(key, Boolean.FALSE.booleanValue());
        }
        Optional.ofNullable(entryGrid).ifPresent(e -> {
            e.setColumnProperty("org", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("warehouse", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("customer", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("material_name", "isFixed", (Object)Boolean.TRUE);
            e.setColumnProperty("material_number", "isFixed", (Object)Boolean.TRUE);
        });
        this.changeHeaderNames(showHisList, HISTORY_PRE_COL_FIX);
        this.changeHeaderNames(showFList, FEATURE_PRE_COL_FIX);
        this.getCache().put(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, showHisList);
        this.getCache().put(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, showFList);
    }

    private void changeHeaderNames(List<String> list, String flag) {
        block3: {
            JSONObject config;
            EntryGrid entryGrid;
            block2: {
                entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
                config = this.getCache().getAsObject("config_tag");
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)HISTORY_PRE_COL_FIX)) break block2;
                List<String> hisPeriods = this.getHisPeriods(config);
                int hisCount = hisPeriods.size();
                for (String his : list) {
                    int t = Integer.parseInt(his.substring(his.lastIndexOf("_") + 1));
                    String period = hisPeriods.get(hisCount - t);
                    entryGrid.setColumnProperty(his, "header", (Object)new LocaleString(period));
                }
                break block3;
            }
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)FEATURE_PRE_COL_FIX)) break block3;
            List<String> feaPeriods = this.getFeaPeriods(config);
            for (String fea : list) {
                int t = Integer.parseInt(fea.substring(fea.lastIndexOf("_") + 1));
                String period = feaPeriods.get(t - 1);
                entryGrid.setColumnProperty(fea, "header", (Object)new LocaleString(period));
                if (t != 1) continue;
                entryGrid.setColumnProperty(fea, "tbc", (Object)"#C7E5FF");
                entryGrid.setColumnProperty(fea, "bc", (Object)"#C7E5FF");
            }
        }
    }

    private void setColEditable(boolean enable) {
        String rowcountStr = this.getCache().get(CURRENT_DISPLAY_METRIC_ROW_COUNT_KEY);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)rowcountStr)) {
            return;
        }
        int rowcount = Integer.parseInt(rowcountStr);
        List showHisList = this.getCache().getAsList(CURRENT_DISPLAY_COL_HIS_CACHE_KEY, String.class);
        List showFList = this.getCache().getAsList(CURRENT_DISPLAY_COL_FEA_CACHE_KEY, String.class);
        int hisCount = showHisList.size();
        int fCount = showFList.size();
        for (int i = 0; i < rowcount; ++i) {
            for (int j = 0; j < hisCount; ++j) {
                this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{String.format("%s%s", HISTORY_PRE_COL_FIX, j + 1)});
            }
            for (int m = 0; m < fCount; ++m) {
                this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{String.format("%s%s", FEATURE_PRE_COL_FIX, m + 1)});
            }
        }
    }

    private void showRequireSummaryData() {
        if (tree != null) {
            List dims = this.getCache().getAsList(CURRENT_SELECTED_DIMS, String.class);
            List metrics = this.getCache().getAsList(CURRENT_SELECTED_METRIC, String.class);
            if (dims != null && !dims.isEmpty()) {
                String summaryDim = this.getSummaryDim(dims);
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)summaryDim, (CharSequence)"fmaterialid")) {
                    this.initDimColumn();
                    this.hiddenOrShowMaterialDimColumn(Boolean.TRUE);
                    JSONObject data = this.getCache().getAsObject("require_plan_data_cache");
                    JSONObject summaryData = this.summaryMaterialData(data.getJSONObject("data"), metrics, dims);
                    this.showRequirePlanData(summaryData, metrics);
                    this.setColEditable(Boolean.FALSE);
                    String hasInit = this.getCache().get(KEY_HAS_INIT_SHOW_METRIC);
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hasInit) || org.apache.commons.lang3.StringUtils.equals((CharSequence)hasInit, (CharSequence)"0")) {
                        ArrayList<String> initShowMetrics = new ArrayList<String>();
                        List defaultMetrics = this.getCache().getAsList(DEFAULT_SHOW_METRIC, String.class);
                        if (defaultMetrics != null && !defaultMetrics.isEmpty()) {
                            initShowMetrics.add((String)defaultMetrics.get(0));
                        }
                        this.getModel().setValue(COMBO_METRIC_SELECTOR, (Object)String.format(",%s,", org.apache.commons.lang3.StringUtils.join(initShowMetrics, (String)",")));
                        this.handleMetricDisplay(initShowMetrics);
                        this.getCache().put(KEY_HAS_INIT_SHOW_METRIC, "1");
                    }
                } else {
                    this.initDimColumn();
                    this.hiddenOrShowMaterialDimColumn(Boolean.FALSE);
                    String nodeType = (String)RequirePlanConstants.DETAIL_SUMMARY_TYPE_MAPPING.get(summaryDim);
                    Boolean isSingleSummary = Boolean.FALSE;
                    if (dims.size() == 1) {
                        isSingleSummary = Boolean.TRUE;
                    }
                    JSONObject data = this.summaryDimData(nodeType, metrics, isSingleSummary, dims);
                    this.showRequirePlanData(data, metrics);
                    this.setColEditable(Boolean.FALSE);
                }
            } else {
                EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
                grid.getModel().setDataChanged(Boolean.FALSE.booleanValue());
                this.getModel().deleteEntryData(KEY_ENTRYENTITY);
                this.initDimColumn();
            }
        }
    }

    private void hiddenOrShowMaterialDimColumn(Boolean visible) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            String key = fieldEdit.getFieldKey();
            if (!key.equals("material_name") && !key.equals("material_number")) continue;
            fieldEdit.setVisible(key, visible.booleanValue());
        }
    }

    private String getSummaryDim(List<String> dims) {
        if (dims.contains("fmaterialid")) {
            return "fmaterialid";
        }
        if (dims.contains("fcustid")) {
            return "fcustid";
        }
        if (dims.contains("fwarehouseid")) {
            return "fwarehouseid";
        }
        if (dims.contains("finvorgid")) {
            return "finvorgid";
        }
        return "fmaterialid";
    }

    private void showRequirePlanData(JSONObject data, final List<String> metrics) {
        final JSONObject preData = data.getJSONObject("data");
        if (preData != null) {
            final JSONArray requirePlanRowData = new JSONArray();
            preData.keySet().stream().forEach(new Consumer<String>(){

                @Override
                public void accept(String rowKeyId) {
                    JSONObject materialData = preData.getJSONObject(rowKeyId);
                    JSONObject indicators = materialData.getJSONObject("indicator");
                    JSONObject materialRowData = new JSONObject();
                    materialRowData.put("org", (Object)materialData.getString("orgName"));
                    materialRowData.put("warehouse", (Object)materialData.getString("warehouseName"));
                    materialRowData.put("material_name", (Object)materialData.getString("name"));
                    materialRowData.put("material_number", (Object)materialData.getString("number"));
                    materialRowData.put("customer", (Object)materialData.getString("customerName"));
                    for (String metric : metrics) {
                        JSONObject metricData = indicators.getJSONObject(metric);
                        if (metricData != null) {
                            RequirePlanEntryDetailPlugin.this.genMaterialRowData(materialRowData, metricData, metric);
                            continue;
                        }
                        RequirePlanEntryDetailPlugin.this.genMaterialRowData(materialRowData, new JSONObject(), metric);
                    }
                    requirePlanRowData.add((Object)materialRowData);
                }
            });
            this.showMaterialMetricRow(requirePlanRowData);
        }
    }

    private void initDimColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        List fieldEdits = entryGrid.getFieldEdits();
        List preDimTypes = this.getCache().getAsList(CURRENT_SELECTED_DIMS, String.class);
        JSONObject fieldKeyRenameJo = this.getCache().getAsObject(KEY_FIELDKEY_RENAME_MAP);
        for (FieldEdit fieldEdit : fieldEdits) {
            String key = fieldEdit.getFieldKey();
            if (!RequirePlanConstants.DETAIL_PRE_DIM_TYPE_MAP.containsKey(key)) continue;
            String mappingName = (String)RequirePlanConstants.DETAIL_PRE_DIM_TYPE_MAP.get(key);
            if (!preDimTypes.contains(mappingName)) {
                fieldEdit.setVisible(key, Boolean.FALSE.booleanValue());
                continue;
            }
            fieldEdit.setVisible(key, Boolean.TRUE.booleanValue());
            String dimFieldKey = (String)RequirePlanConstants.DIM_TYPE_MAPPING.get(mappingName);
            if (fieldKeyRenameJo == null || !fieldKeyRenameJo.containsKey((Object)dimFieldKey)) continue;
            String renameName = fieldKeyRenameJo.getString(dimFieldKey);
            fieldEdit.setCaption(new LocaleString(renameName));
        }
    }

    private JSONObject genMaterialRowData(JSONObject materialRowData, JSONObject metricData, String metric) {
        BigDecimal data;
        int i;
        int fhistorytntype = Integer.parseInt(this.getCache().get("fhistorytntype"));
        int pretntype = Integer.parseInt(this.getCache().get("ftntype"));
        for (i = 0; i < pretntype; ++i) {
            data = metricData.getBigDecimal(String.format("%s%s", FEATURE_PRE_COL_VALUE_FIX, i + 1));
            materialRowData.put(String.format("%s%s_%s", FEATURE_PRE_COL_FIX, metric, i + 1), (Object)data);
        }
        for (i = fhistorytntype; i > 0; --i) {
            data = metricData.getBigDecimal(String.format("%s%s", HISTORY_PRE_COL_VALUE_FIX, i));
            materialRowData.put(String.format("%s%s_%s", HISTORY_PRE_COL_FIX, metric, i), (Object)data);
        }
        return materialRowData;
    }

    private void showMaterialMetricRow(JSONArray requirePlanRowData) {
        int i;
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        int fhistorytntype = Integer.parseInt(this.getCache().get("fhistorytntype"));
        int pretntype = Integer.parseInt(this.getCache().get("ftntype"));
        ArrayList<String> showFList = new ArrayList<String>(12);
        ArrayList<String> showHisList = new ArrayList<String>(12);
        List metrics = this.getCache().getAsList(CURRENT_SELECTED_METRIC, String.class);
        for (String metric : metrics) {
            for (i = 0; i < pretntype; ++i) {
                showFList.add(String.format("%s%s_%s", FEATURE_PRE_COL_FIX, metric, i + 1));
            }
            for (i = fhistorytntype; i > 0; --i) {
                showHisList.add(String.format("%s%s_%s", HISTORY_PRE_COL_FIX, metric, i));
            }
        }
        int count = requirePlanRowData.size();
        if (count == 0) {
            return;
        }
        this.getCache().put(CURRENT_DISPLAY_METRIC_ROW_COUNT_KEY, String.valueOf(count));
        int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, count);
        for (i = 0; i < count; ++i) {
            BigDecimal bd;
            JSONObject rowData = requirePlanRowData.getJSONObject(i);
            String export_invorg = rowData.getString("org");
            String export_warehouse = rowData.getString("warehouse");
            String export_material_name = rowData.getString("material_name");
            String export_material_number = rowData.getString("material_number");
            String export_customer = rowData.getString("customer");
            this.getModel().setValue("org", (Object)export_invorg, rowIndex[i]);
            this.getModel().setValue("warehouse", (Object)export_warehouse, rowIndex[i]);
            this.getModel().setValue("material_name", (Object)export_material_name, rowIndex[i]);
            this.getModel().setValue("material_number", (Object)export_material_number, rowIndex[i]);
            this.getModel().setValue("customer", (Object)export_customer, rowIndex[i]);
            for (String his : showHisList) {
                bd = rowData.getBigDecimal(String.format("%s", his));
                if (bd != null) {
                    if (bd.compareTo(BigDecimal.ZERO) == 0) {
                        this.getModel().setValue(his, null, rowIndex[i]);
                        continue;
                    }
                    this.getModel().setValue(his, (Object)bd.setScale(2, 4), rowIndex[i]);
                    continue;
                }
                this.getModel().setValue(his, null, rowIndex[i]);
            }
            for (String fea : showFList) {
                bd = rowData.getBigDecimal(String.format("%s", fea));
                if (bd != null) {
                    if (bd.compareTo(BigDecimal.ZERO) == 0) {
                        this.getModel().setValue(fea, null, rowIndex[i]);
                        continue;
                    }
                    this.getModel().setValue(fea, (Object)bd.setScale(2, 4), rowIndex[i]);
                    continue;
                }
                this.getModel().setValue(fea, null, rowIndex[i]);
            }
        }
    }

    private JSONObject summaryMaterialData(final JSONObject materials, final List<String> metrics, final List<String> dims) {
        JSONObject data = new JSONObject();
        final JSONObject preData = new JSONObject();
        data.put("data", (Object)preData);
        if (materials != null && !materials.isEmpty()) {
            materials.keySet().stream().forEach(new Consumer<String>(){

                @Override
                public void accept(String materialId) {
                    JSONObject indicators;
                    JSONObject materialData;
                    String rowKeyId;
                    JSONObject material = materials.getJSONObject(materialId);
                    String number = material.getString("number");
                    String name = material.getString("name");
                    String orgNumber = material.getString("orgNumber");
                    String warehouseNumber = material.getString("warehouseNumber");
                    String customerNumber = material.getString("customerNumber");
                    LinkedList<String> rowKeys = new LinkedList<String>();
                    if (dims.contains("finvorgid")) {
                        rowKeys.add(orgNumber);
                    }
                    if (dims.contains("fwarehouseid")) {
                        rowKeys.add(warehouseNumber);
                    }
                    if (dims.contains("fcustid")) {
                        rowKeys.add(customerNumber);
                    }
                    if (dims.contains("fmaterialid")) {
                        rowKeys.add(number);
                    }
                    if (!preData.containsKey((Object)(rowKeyId = String.format("%s", org.apache.commons.lang3.StringUtils.join(rowKeys, (String)"_"))))) {
                        materialData = new JSONObject();
                        indicators = new JSONObject();
                        materialData.put("indicator", (Object)indicators);
                        materialData.put("name", (Object)name);
                        materialData.put("number", (Object)number);
                        materialData.put("orgName", (Object)material.getString("orgName"));
                        materialData.put("warehouseName", (Object)material.getString("warehouseName"));
                        materialData.put("customerName", (Object)material.getString("customerName"));
                        preData.put(rowKeyId, (Object)materialData);
                    }
                    materialData = preData.getJSONObject(rowKeyId);
                    indicators = materialData.getJSONObject("indicator");
                    JSONObject indicatorData = material.getJSONObject("indicator");
                    for (String metric : metrics) {
                        if (!indicators.containsKey((Object)metric)) {
                            indicators.put(metric, (Object)new JSONObject());
                        }
                        JSONObject metricSum = indicators.getJSONObject(metric);
                        JSONObject metricData = indicatorData.getJSONObject(metric);
                        RequirePlanEntryDetailPlugin.this.algPreData(metricSum, metricData);
                    }
                }
            });
        }
        return data;
    }

    private JSONObject summaryDimData(String nodeType, List<String> metrics, Boolean isSingleSummary, List<String> dims) {
        JSONObject data = new JSONObject();
        JSONObject preData = new JSONObject();
        data.put("data", (Object)preData);
        if (tree != null) {
            List nodes = tree.getChildren();
            this.summaryDimNodes(nodes, nodeType, preData, metrics, isSingleSummary, dims);
        }
        return data;
    }

    private void summaryDimNodes(List<RequirePlanBase> nodes, String summaryNodeType, JSONObject preData, List<String> metrics, Boolean isSingleSummary, List<String> dims) {
        if (nodes != null && !nodes.isEmpty()) {
            RequirePlanBase firstNode = nodes.get(0);
            String _nodeType = firstNode.getNodeType();
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)_nodeType, (CharSequence)summaryNodeType)) {
                if (!isSingleSummary.booleanValue()) {
                    for (RequirePlanBase node : nodes) {
                        String _nodeId = node.getNodeId();
                        String nodeType = node.getNodeType();
                        String[] nodeIds = _nodeId.split("_");
                        LinkedList<String> rowKeys = new LinkedList<String>();
                        if (dims.contains("finvorgid")) {
                            rowKeys.add(nodeIds[0]);
                        }
                        if (dims.contains("fwarehouseid")) {
                            rowKeys.add(nodeIds[1]);
                        }
                        if (dims.contains("fcustid")) {
                            rowKeys.add(nodeIds[2]);
                        }
                        String rowKeyId = String.format("%s", org.apache.commons.lang3.StringUtils.join(rowKeys, (String)"_"));
                        JSONObject materialData = new JSONObject();
                        JSONObject indicators = new JSONObject();
                        for (String metric : metrics) {
                            JSONObject summaryData = this.genSummaryData(materialData, node, metric);
                            indicators.put(metric, (Object)summaryData);
                        }
                        materialData.put("indicator", (Object)indicators);
                        preData.put(rowKeyId, (Object)materialData);
                    }
                } else {
                    for (RequirePlanBase node : nodes) {
                        JSONObject indicators;
                        JSONObject materialData;
                        String nodeNumber;
                        String nodeType = node.getNodeType();
                        String rowKeyId = String.format("%s_%s", nodeType, nodeNumber = node.getNodeNumber());
                        if (!preData.containsKey((Object)rowKeyId)) {
                            materialData = new JSONObject();
                            indicators = new JSONObject();
                            materialData.put("indicator", (Object)indicators);
                            preData.put(rowKeyId, (Object)materialData);
                        }
                        materialData = preData.getJSONObject(rowKeyId);
                        indicators = materialData.getJSONObject("indicator");
                        for (String metric : metrics) {
                            if (!indicators.containsKey((Object)metric)) {
                                indicators.put(metric, (Object)new JSONObject());
                            }
                            JSONObject metricSum = indicators.getJSONObject(metric);
                            JSONObject summaryData = this.genSummaryData(materialData, node, metric);
                            this.algPreData(metricSum, summaryData);
                        }
                    }
                }
            } else {
                ArrayList<RequirePlanBase> subs = new ArrayList<RequirePlanBase>();
                for (RequirePlanBase node : nodes) {
                    List children = node.getChildren();
                    if (children == null || children.isEmpty()) continue;
                    subs.addAll(children);
                }
                this.summaryDimNodes(subs, summaryNodeType, preData, metrics, isSingleSummary, dims);
            }
        }
    }

    private JSONObject genSummaryData(final JSONObject materialData, RequirePlanBase node, final String metric) {
        List<RequirePlanBase> allMaterialNodes = this.findMaterialNodes(node.getChildren());
        final JSONObject summaryData = new JSONObject();
        if (allMaterialNodes != null && !allMaterialNodes.isEmpty()) {
            allMaterialNodes.stream().forEach(new Consumer<RequirePlanBase>(){

                @Override
                public void accept(RequirePlanBase requirePlanBase) {
                    String type = requirePlanBase.getNodeType();
                    if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"material")) {
                        RequirePlanMaterial material = (RequirePlanMaterial)requirePlanBase;
                        String materialId = material.getNodeId();
                        JSONObject data = RequirePlanEntryDetailPlugin.this.getCache().getAsObject(String.format("%s_%s", type, materialId));
                        JSONObject indicators = data.getJSONObject("indicator");
                        JSONObject predata = indicators.getJSONObject(metric);
                        if (predata != null) {
                            RequirePlanEntryDetailPlugin.this.algPreData(summaryData, predata);
                        }
                        materialData.put("orgName", (Object)data.getString("orgName"));
                        materialData.put("warehouseName", (Object)data.getString("warehouseName"));
                        materialData.put("customerName", (Object)data.getString("customerName"));
                    }
                }
            });
        }
        return summaryData;
    }

    private void algPreData(JSONObject sum, JSONObject predata) {
        BigDecimal temp;
        BigDecimal bd;
        int i;
        int fhistorytntype = Integer.parseInt(this.getCache().get("fhistorytntype"));
        int pretntype = Integer.parseInt(this.getCache().get("ftntype"));
        ArrayList<String> showFList = new ArrayList<String>(12);
        ArrayList<String> showHisList = new ArrayList<String>(12);
        for (i = 0; i < pretntype; ++i) {
            showFList.add(String.format("%s%s", FEATURE_PRE_COL_VALUE_FIX, i + 1));
        }
        for (i = fhistorytntype; i > 0; --i) {
            showHisList.add(String.format("%s%s", HISTORY_PRE_COL_VALUE_FIX, i));
        }
        for (String his : showHisList) {
            bd = predata.getBigDecimal(his);
            if (!sum.containsKey((Object)his)) {
                if (bd != null) {
                    sum.put(his, (Object)bd);
                    continue;
                }
                sum.put(his, (Object)new BigDecimal(0));
                continue;
            }
            temp = sum.getBigDecimal(his);
            if (temp != null) {
                sum.put(his, (Object)temp.add(bd == null ? new BigDecimal(0) : bd));
                continue;
            }
            sum.put(his, (Object)(bd == null ? new BigDecimal(0) : bd).add(new BigDecimal(0)));
        }
        for (String fea : showFList) {
            bd = predata.getBigDecimal(fea);
            if (!sum.containsKey((Object)fea)) {
                if (bd != null) {
                    sum.put(fea, (Object)bd);
                    continue;
                }
                sum.put(fea, (Object)new BigDecimal(0));
                continue;
            }
            temp = sum.getBigDecimal(fea);
            if (temp != null) {
                sum.put(fea, (Object)temp.add(bd == null ? new BigDecimal(0) : bd));
                continue;
            }
            sum.put(fea, (Object)(bd == null ? new BigDecimal(0) : bd).add(new BigDecimal(0)));
        }
    }

    private List<RequirePlanBase> findMaterialNodes(List<RequirePlanBase> nodes) {
        if (!nodes.isEmpty()) {
            RequirePlanBase first = nodes.get(0);
            String nodeType = first.getNodeType();
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)"material")) {
                ArrayList<RequirePlanBase> allNodes = new ArrayList<RequirePlanBase>();
                for (RequirePlanBase item : nodes) {
                    allNodes.addAll(item.getChildren());
                }
                return this.findMaterialNodes(allNodes);
            }
            return nodes;
        }
        return new ArrayList<RequirePlanBase>();
    }
}

