/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.card;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.ai.ids.core.enumtype.AppIdentifierEnum;
import kd.ai.ids.core.enumtype.AppStatusEnum;
import kd.ai.ids.core.enumtype.AppTypeEnum;
import kd.ai.ids.core.enumtype.DataappPvaEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.IdsPermissionEnum;
import kd.ai.ids.core.enumtype.IdsVersionEnum;
import kd.ai.ids.core.query.clientproxy.SubInitDashboardQuery;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.response.server.TenantModelInfoDTO;
import kd.ai.ids.core.service.IDashboardService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.PermUtils;
import kd.ai.ids.core.utils.TaskUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.card.BaseCardPlugin;
import kd.ai.ids.plugin.tool.CommonTools;
import kd.ai.ids.plugin.tool.FormTools;
import kd.ai.ids.plugin.tool.PopAppUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;

public class AppListCardPlugin
extends BaseCardPlugin {
    public static final String KEY_ENABLE = "enable";
    public static final String KEY_UNABLE = "unable";
    public static final String KEY_CONFIG = "config";
    public static final String KEY_PROCESS = "process";
    public static final String KEY_ENTER = "enter";
    public static final String KEY_PREF_LIST = "list_";
    public static final String KEY_PREF_ID = "id_";
    public static final String KEY_PREF_NAME = "name_";
    public static final String KEY_PREF_STATUS = "status_";
    public static final String KEY_PREF_TYPE = "type_";
    public static final String KEY_PREF_IDSVERSION = "idsversion_";
    public static final String KEY_PREF_PIC = "pic_";
    public static final String KEY_PREF_CANSUBSCRIBE = "cansubscribe_";
    public static final String KEY_PREF_SUBSERVICEID = "subserviceid_";
    public static final String KEY_PREF_SHOWHOMEPAGE = "showhomepage_";
    public static final String KEY_PREF_PRODUCT = "product_";
    public static final String KEY_PREF_BIZ_NAME = "biz_name_";
    public static final String KEY_PREF_DESCRIPE = "descripe_";
    public static final String KEY_STATUS = "status";
    public static final String KEY_PREF_FLEXPANELAP = "flexpanelap_";
    public static final String KEY_REFRESH = "refresh";
    private static final String KEY_TITLE_PANEL = "flexpanelap";
    private static final String[] KEY_CONTROL_PREF_KEY = new String[]{"enable", "unable", "config", "enter", "process"};

    public IDashboardService dashboardService() {
        return (IDashboardService)Services.get(IDashboardService.class);
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        super.refreshCard(allConfigMap);
        if (this.isDesignMode()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TITLE_PANEL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TITLE_PANEL});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().beginInit();
        try {
            TenantDTO tenantDTO;
            JSONObject dataJo = null;
            RequestContext rc = RequestContext.get();
            String clientFullContextPath = rc.getClientFullContextPath();
            if (!org.apache.commons.lang3.StringUtils.endsWith((CharSequence)clientFullContextPath, (CharSequence)"/")) {
                clientFullContextPath = clientFullContextPath + "/";
            }
            if ((tenantDTO = this.getTenantDTO()) != null) {
                dataJo = this.dataAppService().getSubAppList(Long.valueOf(rc.getOrgId()), rc.getTenantId(), tenantDTO.getTenantId());
            }
            for (AppTypeEnum appType : AppTypeEnum.values()) {
                JSONArray subAppArray;
                String targetKey = KEY_PREF_FLEXPANELAP + appType.getKey();
                if (this.getControl(targetKey) == null) continue;
                JSONArray jSONArray = subAppArray = dataJo == null ? null : dataJo.getJSONArray(appType.getKey());
                if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)appType.getKey(), (CharSequence)AppTypeEnum.FORECAST.getKey())) {
                    if (subAppArray == null) {
                        subAppArray = new JSONArray();
                    }
                    JSONObject gpeJo = JSONObject.parseObject((String)"{\"type\":1,\"descripe\":\"\u878d\u5408GPT\u5404\u79cd\u6280\u80fd\uff0c\u65e0\u4ee3\u7801\u667a\u80fd\u9884\u6d4b\u4ea7\u54c1\u3002\u652f\u6301\u4f01\u4e1a\u7528\u6237\u5feb\u901f\u5b9a\u5236\u4e0d\u540c\u6570\u636e\u6765\u6e90\uff0c\u9488\u5bf9\u4e0d\u540c\u4e1a\u52a1\u573a\u666f\uff0c\u6784\u5efa\u9884\u6d4b\u6a21\u578b\u65b9\u6848\u5e76\u5b9e\u65f6\u7ed9\u51fa\u9884\u6d4b\u7ed3\u679c\uff0c\u7ecf\u8fc7\u8bc4\u4f30\u7684\u9884\u6d4b\u7ed3\u679c\u53ef\u4ee5\u5f15\u7528\u5230\u4e1a\u52a1\u7cfb\u7edf\u4e2d\u3002\",\"productName\":\"\u5168\u90e8\",\"canSubscribe\":1,\"onLineTime\":\"2023-09-15 16:16:09\",\"appId\":\"1000\",\"dataCenterId\":\"\",\"customerId\":\"\",\"id\":0,\"applyTime\":\"2022-06-17 10:11:55\",\"subServiceId\":\"\",\"appVersionId\":\"\",\"clientId\":\"\",\"productId\":\"1001\",\"dataCenter\":\"\",\"appName\":\"GPT\u9884\u6d4b\u5f15\u64ce\",\"bussinessName\":\"\u5168\u90e8\",\"configure\":0,\"enterpriseType\":0,\"createTime\":\"2022-06-17 10:11:55\",\"modTime\":\"2023-09-15 16:16:09\",\"tenantId\":\"\",\"subServiceName\":\"\",\"status\":3}");
                    subAppArray.add((Object)gpeJo);
                }
                if (subAppArray == null || subAppArray.isEmpty()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{targetKey});
                    continue;
                }
                this.getModel().batchCreateNewEntryRow(KEY_PREF_LIST + appType.getKey(), subAppArray.size());
                for (int index = 0; index < subAppArray.size(); ++index) {
                    JSONObject subServiceJo;
                    JSONObject appJo = subAppArray.getJSONObject(index);
                    String appId = appJo.getString("appId");
                    String subServiceId = appJo.getString("subServiceId");
                    int showHomePage = 0;
                    if (this.dataAppService().appIsSalesForecast(appId) && (subServiceJo = this.dataAppService().getSubService(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), appId)) != null) {
                        showHomePage = subServiceJo.getIntValue("showHomePage");
                    }
                    this.getModel().setValue(KEY_PREF_ID + appType.getKey(), (Object)appId, index);
                    this.getModel().setValue(KEY_PREF_NAME + appType.getKey(), (Object)appJo.getString("appName"), index);
                    this.getModel().setValue(KEY_PREF_SUBSERVICEID + appType.getKey(), (Object)subServiceId, index);
                    this.getModel().setValue(KEY_PREF_SHOWHOMEPAGE + appType.getKey(), (Object)showHomePage, index);
                    this.getModel().setValue(KEY_PREF_PRODUCT + appType.getKey(), (Object)appJo.getString("productName"), index);
                    this.getModel().setValue(KEY_PREF_BIZ_NAME + appType.getKey(), (Object)appJo.getString("bussinessName"), index);
                    this.getModel().setValue(KEY_PREF_DESCRIPE + appType.getKey(), (Object)appJo.getString("descripe"), index);
                    Integer status = appJo.getInteger(KEY_STATUS);
                    if (status == null) {
                        status = AppStatusEnum.INIT.getKey();
                    }
                    this.getModel().setValue(KEY_PREF_STATUS + appType.getKey(), (Object)status, index);
                    this.getModel().setValue(KEY_PREF_TYPE + appType.getKey(), (Object)appJo.getIntValue("type"), index);
                    this.getModel().setValue(KEY_PREF_IDSVERSION + appType.getKey(), (Object)tenantDTO.getIdsVersion(), index);
                    this.getModel().setValue(KEY_PREF_CANSUBSCRIBE + appType.getKey(), (Object)appJo.getIntValue("canSubscribe"), index);
                    String logoUrl = this.getLogoUrl(clientFullContextPath, appId);
                    this.getModel().setValue(KEY_PREF_PIC + appType.getKey(), (Object)logoUrl, index);
                }
            }
        }
        finally {
            this.getModel().endInit();
        }
        FormTools.cachePageId(this.getView());
    }

    private String getLogoUrl(String clientFullContextPath, String appId) {
        String logo = AppIdentifierEnum.SSF.getLogo();
        if (this.dataAppService().appIsRfm(appId)) {
            logo = AppIdentifierEnum.RFM.getLogo();
        } else if (this.dataAppService().appIsPva(appId)) {
            logo = AppIdentifierEnum.PVA.getLogo();
        } else if (this.dataAppService().appIsGpe(appId)) {
            logo = AppIdentifierEnum.GPE.getLogo();
        }
        return String.format("%s%s", clientFullContextPath, logo);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (AppTypeEnum appType : AppTypeEnum.values()) {
            for (String prefKey : KEY_CONTROL_PREF_KEY) {
                Control c = this.getControl(prefKey + "_" + appType.getKey());
                if (!(c instanceof ISuportClick)) continue;
                ((ISuportClick)c).addClickListener((ClickListener)this);
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (KEY_REFRESH.equals(e.getName())) {
            this.getView().invokeOperation(KEY_REFRESH);
        }
    }

    public void click(EventObject e) {
        int expectKeyLen;
        String[] skey;
        super.click(e);
        String controlKey = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            controlKey = ((Control)source).getKey();
        }
        if ((skey = controlKey.split("_")).length == (expectKeyLen = 2)) {
            String type = skey[1];
            AppTypeEnum typeEnum = AppTypeEnum.fromKey((String)type);
            if (typeEnum == null) {
                return;
            }
            CardEntry cardEntry = (CardEntry)this.getControl(KEY_PREF_LIST + typeEnum.getKey());
            int focusRow = cardEntry.getEntryState().getFocusRow();
            String appId = (String)this.getModel().getValue(KEY_PREF_ID + typeEnum.getKey(), focusRow);
            String appName = (String)this.getModel().getValue(KEY_PREF_NAME + typeEnum.getKey(), focusRow);
            int status = Integer.parseInt((String)this.getModel().getValue(KEY_PREF_STATUS + typeEnum.getKey(), focusRow));
            String subServiceId = (String)this.getModel().getValue(KEY_PREF_SUBSERVICEID + typeEnum.getKey(), focusRow);
            if (!this.hasPermission(skey[0])) {
                String tip = "";
                if (KEY_ENABLE.equals(skey[0])) {
                    tip = "\u7533\u8bf7\u4e0a\u7ebf";
                } else if (KEY_UNABLE.equals(skey[0])) {
                    tip = "\u7533\u8bf7\u4e0b\u7ebf";
                }
                String message = String.format("\u65e0\"%s\"\u7684\"%s\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", appName, tip);
                this.getView().showErrorNotification(message);
                return;
            }
            if (KEY_ENABLE.equals(skey[0])) {
                this.appEnable(appId, appName, status, subServiceId, typeEnum, focusRow);
            } else if (KEY_UNABLE.equals(skey[0])) {
                this.appUnable(appId, appName, status, subServiceId, typeEnum, focusRow);
            } else if (KEY_CONFIG.equals(skey[0])) {
                this.appConfig(appId);
            } else if (KEY_ENTER.equals(skey[0])) {
                this.appEnter(appId);
            } else if (KEY_PROCESS.equals(skey[0])) {
                this.appProcess(appId);
            }
        }
    }

    private boolean hasPermission(String type) {
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        String appId = AppMetadataCache.getAppInfo((String)"ids").getAppId();
        if (KEY_ENABLE.equals(type)) {
            return PermUtils.hasPermission((Object)currentUserId, (Object)appId, (Object)"ids_apphome_applist", (Object)"APP_ONLINE");
        }
        if (KEY_UNABLE.equals(type)) {
            return PermUtils.hasPermission((Object)currentUserId, (Object)appId, (Object)"ids_apphome_applist", (Object)"APP_OFFLINE");
        }
        return true;
    }

    private void appEnable(String appId, String appName, int status, String subServiceId, AppTypeEnum typeEnum, int focusRow) {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.getTenantDTO();
        if (tenantDTO.getIdsPermission() == IdsPermissionEnum.NO.getKey()) {
            this.showUnAuthorizedConfirmDlg();
            return;
        }
        if (this.agreementService().hasGrantAgreement(rc, tenantDTO.getTenantId())) {
            BaseResult baseResult;
            TaskUtils.createCommonTask((TenantDTO)tenantDTO, (long)rc.getCurrUserId(), (long)rc.getOrgId());
            JSONObject paramsJo = new JSONObject();
            paramsJo.put("appId", (Object)appId);
            paramsJo.put("customerId", (Object)tenantDTO.getCustomerId());
            paramsJo.put("tenantId", (Object)tenantDTO.getTenantId());
            AppStatusEnum successTargetStatus = AppStatusEnum.INIT;
            if (status == AppStatusEnum.OFFLINE.getKey()) {
                paramsJo.put("subServiceId", (Object)subServiceId);
                baseResult = this.idsServer().getBaseResultByPost(Long.valueOf(rc.getOrgId()), "/ids/ids/app/customer/sub/online", paramsJo);
                successTargetStatus = AppStatusEnum.APPLY_ONLINE;
            } else {
                paramsJo.put("dataCenter", (Object)tenantDTO.getDataCenter());
                paramsJo.put("dataCenterId", (Object)tenantDTO.getDataCenterId());
                paramsJo.put("clientId", (Object)"");
                paramsJo.put("subChannel", (Object)"ids");
                baseResult = this.idsServer().getBaseResultByPost(Long.valueOf(rc.getOrgId()), "/ids/ids/app/customer/sub/add", paramsJo);
                successTargetStatus = AppStatusEnum.WAIT_ACTIVE;
            }
            if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
                this.dataAppService().removeSubserviceCache(Long.valueOf(rc.getOrgId()), rc.getTenantId(), appId);
                this.getView().showSuccessNotification(String.format("\u201c%s\u201d%s", appName, ResManager.loadKDString((String)"\u5df2\u7533\u8bf7\u4e0a\u7ebf\u3002", (String)"AppListCardPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0])));
                FormTools.notifyAppHomeMenuRefresh(this.getView());
                this.getModel().setValue(KEY_PREF_STATUS + typeEnum.getKey(), (Object)successTargetStatus.getKey(), focusRow);
                JSONObject subServiceJo = this.dataAppService().getSubService(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), appId);
                String newSubServiceId = subServiceJo.getString("subServiceId");
                if (typeEnum.getKey().equalsIgnoreCase(AppTypeEnum.STATISTICS.getKey())) {
                    ThreadUtils.execute(() -> this.subInit(rc, appId, newSubServiceId));
                }
                this.uploadTenantModelOnce(appId, rc, tenantDTO);
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u7533\u8bf7\u4e0a\u7ebf", (String)String.format("\u5e94\u7528:%s\uff0c\u7533\u8bf7\u4e0a\u7ebf-\u6210\u529f", appId));
            } else {
                this.getView().showErrorNotification(baseResult.getDescriptionCn());
                LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u7533\u8bf7\u4e0a\u7ebf", (String)String.format("\u5e94\u7528:%s\uff0c\u7533\u8bf7\u4e0a\u7ebf-\u5931\u8d25", appId));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4e0a\u7ebf\u5e94\u7528\u524d\u9700\u7b7e\u7f72\u300a\u667a\u80fd\u6570\u636e\u670d\u52a1\u534f\u8bae\u300b\u3002", (String)"AppListCardPlugin_1", (String)"ai-ids-plugin", (Object[])new Object[0]));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ids_service_agreement");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private void showUnAuthorizedConfirmDlg() {
        FormShowParameter fsp = new FormShowParameter();
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        fsp.setOpenStyle(style);
        fsp.setFormId(IdsFormIdEnum.IDS_CONFIRM_DLG.getId());
        this.getView().showForm(fsp);
    }

    private void subInit(RequestContext rc, String appId, String subServiceId) {
        SubInitDashboardQuery subInitDashboardQuery = new SubInitDashboardQuery();
        subInitDashboardQuery.setAppId(appId);
        subInitDashboardQuery.setSubServiceId(subServiceId);
        this.dashboardService().subInit(Long.valueOf(rc.getOrgId()), subInitDashboardQuery);
    }

    private void uploadTenantModelOnce(String appId, RequestContext rc, TenantDTO tenantDTO) {
        TenantModelInfoDTO tenantModelInfoDTO = this.tenantModelService().getTenantModelInfo(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId());
        if (tenantModelInfoDTO != null && tenantModelInfoDTO.getCount() <= 0) {
            String description = String.format("%s%s(%s)%s", rc.getUserName(), ResManager.loadKDString((String)"\u8ba2\u9605\u5e94\u7528", (String)"AppListCardPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]), appId, ResManager.loadKDString((String)"\u89e6\u53d1\u66f4\u65b0\u79df\u6237\u9886\u57df\u6a21\u578b", (String)"AppListCardPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]));
            ThreadPools.executeOnceIncludeRequestContext((String)description, () -> this.tenantModelService().syncTenantModel(Long.valueOf(rc.getOrgId()), description, tenantDTO.getTenantId(), CommonTools.getProductVersion()));
        }
    }

    private void appUnable(String appId, String appName, int status, String subServiceId, AppTypeEnum typeEnum, int focusRow) {
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.getTenantDTO();
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("appId", (Object)appId);
        paramsJo.put("subServiceId", (Object)subServiceId);
        paramsJo.put("customerId", (Object)tenantDTO.getCustomerId());
        paramsJo.put("tenantId", (Object)tenantDTO.getTenantId());
        BaseResult baseResult = this.idsServer().getBaseResultByPost(Long.valueOf(rc.getOrgId()), "/ids/ids/app/customer/sub/cancel", paramsJo);
        if (Objects.equals(baseResult.getErrcode(), BaseResult.SUCCESS)) {
            this.dataAppService().removeSubserviceCache(Long.valueOf(rc.getOrgId()), rc.getTenantId(), appId);
            this.getView().showSuccessNotification(String.format("\u201c%s\u201d%s", appName, ResManager.loadKDString((String)"\u5df2\u7533\u8bf7\u4e0b\u7ebf\u3002", (String)"AppListCardPlugin_4", (String)"ai-ids-plugin", (Object[])new Object[0])));
            FormTools.notifyAppHomeMenuRefresh(this.getView());
            this.getModel().setValue(KEY_PREF_STATUS + typeEnum.getKey(), (Object)AppStatusEnum.APPLY_OFFLINE.getKey(), focusRow);
            LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u7533\u8bf7\u4e0b\u7ebf", (String)String.format("\u7533\u8bf7\u4e0b\u7ebf-\u6210\u529f\uff0c\u5e94\u7528:%s", appId));
        } else {
            this.getView().showErrorNotification(baseResult.getDescriptionCn());
            LogServiceHelper.addLog((IFormView)this.getView(), (String)"\u7533\u8bf7\u4e0b\u7ebf", (String)String.format("\u7533\u8bf7\u4e0b\u7ebf-\u5931\u8d25\uff0c\u5e94\u7528:%s", appId));
        }
    }

    private void appConfig(String appId) {
        if (this.dataAppService().appIsSalesForecast(appId)) {
            TenantDTO tenantDTO = this.getTenantDTO();
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)tenantDTO.getIdsVersion(), (CharSequence)IdsVersionEnum.BIC.getKey())) {
                String idsAppId = AppMetadataCache.getAppInfo((String)"ids").getAppId();
                boolean hasPemission = PermUtils.hasPermission((Object)RequestContext.get().getCurrUserId(), (Object)idsAppId, (Object)"ids_application_config", (Object)"CONFIG-PREDICT-TARGET");
                if (hasPemission) {
                    String caption = ResManager.loadKDString((String)"\u5e94\u7528\u914d\u7f6e", (String)"AppListCardPlugin_5", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    PopAppUtils.showFormOnlyOnce(this.getView(), "ids_application_config", caption, null);
                } else {
                    String tip = "\u914d\u7f6e\u9884\u6d4b\u5bf9\u8c61\u8303\u56f4";
                    String message = String.format("\u65e0\"%s\"\u7684\"%s\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", AppIdentifierEnum.SSF.getKey(), tip);
                    this.getView().showErrorNotification(message);
                }
            } else {
                String caption = "\u5e94\u7528\u914d\u7f6e-\u9884\u6d4b\u65b9\u6848\u5217\u8868";
                PopAppUtils.showFormOnlyOnce(this.getView(), IdsFormIdEnum.IDS_SF_STD_APP_CONFIG.getId(), caption, null);
            }
        }
    }

    private void appProcess(String appId) {
        if (this.dataAppService().appIsSalesForecast(appId)) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("appId", appId);
            PopAppUtils.showFormOnlyOnce(this.getView(), IdsFormIdEnum.IDS_SF_STD_EXEC_PROCESS.getId(), null, customParams);
        }
    }

    private void appEnter(String dataappId) {
        if (this.dataAppService().appIsSalesForecast(dataappId)) {
            PopAppUtils.showFormOnlyOnce(this.getView(), "ids_sale_forecast_home", null, null);
        } else if (this.dataAppService().appIsPva(dataappId)) {
            String appName = DataappPvaEnum.getIdAppById((String)dataappId).getName();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("appIdentifier", AppIdentifierEnum.PVA.getKey());
            PopAppUtils.showFormOnlyOnce(this.getView(), IdsFormIdEnum.IDS_DASHBOARD_ANA.getId(), String.format("%s-\u4e3b\u9898\u5206\u6790", appName), customParams);
        } else if (this.dataAppService().appIsGpe(dataappId)) {
            PopAppUtils.showFormOnlyOnce(this.getView(), IdsFormIdEnum.IDS_GPE_HOMEPAGE.getId(), null, null);
        }
    }
}

