/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.card;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.ai.ids.core.enumtype.AppStatusEnum;
import kd.ai.ids.core.enumtype.AppTypeEnum;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.plugin.card.BaseCardPlugin;
import kd.ai.ids.plugin.tool.FormTools;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClientCallBackEvent;

public class MyServiceCardPlugin
extends BaseCardPlugin {
    private static final String KEY_APPLY_COUNT = "applycount";
    private static final String KEY_ONLINE_COUNT = "onlinecount";
    private static final String KEY_BTN_AGREEMENT_GET = "btnagreementget";
    private static final String KEY_FLEXPANELAP_GRANT = "flexpanelapgrant";
    private static final String KEY_BTN_AGREEMENT_SHOW = "btnagreementshow";
    private static final String KEY_FLEXPANELAP_GRANTED = "flexpanelapgranted";
    private static final String KEY_FORMID_IDS_SERVICE_AGREEMENT = "ids_service_agreement";
    public static final String KEY_REFRESH = "refresh";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_AGREEMENT_GET, KEY_BTN_AGREEMENT_SHOW});
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnagreementget": 
            case "btnagreementshow": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(KEY_FORMID_IDS_SERVICE_AGREEMENT);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (KEY_REFRESH.equals(e.getName())) {
            this.getView().invokeOperation(KEY_REFRESH);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateUI();
        FormTools.cachePageId(this.getView());
    }

    private void updateUI() {
        int applyCount = 0;
        int onlineCount = 0;
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
        if (tenantDTO != null) {
            boolean hasGrantAgreement = this.agreementService().hasGrantAgreement(rc, tenantDTO.getTenantId());
            this.judgeGrantAgreement(hasGrantAgreement);
            this.setControlVisible(hasGrantAgreement);
            JSONObject dataJo = this.dataAppService().getSubAppList(Long.valueOf(rc.getOrgId()), rc.getTenantId(), tenantDTO.getTenantId());
            for (AppTypeEnum appType : AppTypeEnum.values()) {
                JSONArray dataappJa;
                JSONArray jSONArray = dataappJa = dataJo == null ? null : dataJo.getJSONArray(appType.getKey());
                if (dataappJa == null || dataappJa.isEmpty()) continue;
                for (Object appObj : dataappJa) {
                    JSONObject appJo = JsonUtils.parseObj(appObj);
                    Integer appStatus = appJo.getInteger("status");
                    if (appStatus == null) {
                        appStatus = AppStatusEnum.INIT.getKey();
                    }
                    if (appStatus.intValue() == AppStatusEnum.ONLINE.getKey()) {
                        ++onlineCount;
                    }
                    if (appStatus.intValue() == AppStatusEnum.INIT.getKey() || appStatus.intValue() == AppStatusEnum.OFFLINE.getKey()) continue;
                    ++applyCount;
                }
            }
        }
        IFormView view = this.getView();
        Label applyCountLabel = (Label)view.getControl(KEY_APPLY_COUNT);
        Label onlineCountLabel = (Label)view.getControl(KEY_ONLINE_COUNT);
        applyCountLabel.setText(String.valueOf(applyCount));
        onlineCountLabel.setText(String.valueOf(onlineCount));
    }

    private void judgeGrantAgreement(boolean hasGrantAgreement) {
        String expect = "false";
        String needShowAgreement = this.getCache().get("NeedShowAgreement");
        if (!expect.equals(needShowAgreement)) {
            if (!hasGrantAgreement) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(KEY_FORMID_IDS_SERVICE_AGREEMENT);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
            this.getCache().put("NeedShowAgreement", expect);
        }
    }

    private void setControlVisible(boolean hasGrantAgreement) {
        IFormView view = this.getView();
        if (hasGrantAgreement) {
            view.setVisible(Boolean.FALSE, new String[]{KEY_FLEXPANELAP_GRANT});
            view.setVisible(Boolean.TRUE, new String[]{KEY_FLEXPANELAP_GRANTED});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{KEY_FLEXPANELAP_GRANT});
            view.setVisible(Boolean.FALSE, new String[]{KEY_FLEXPANELAP_GRANTED});
        }
    }
}

