/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.cache.SessionCache;
import kd.ai.ids.core.enumtype.FilterItemBizTypeEnum;
import kd.ai.ids.core.query.data.FilterItemValuesDTO;
import kd.ai.ids.core.query.label.LabelItem;
import kd.ai.ids.core.service.IAnaResultService;
import kd.ai.ids.core.service.IMaterialSaleAnaService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.plugin.tool.VirtualEntityTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.list.QueryResult;

public class FilterItemProvider {
    private final EntityType entityType;
    private final IdsPageCache pageCache;
    private LabelItem label;
    private String subServiceId;
    private String modelTypeId;
    private List<String> prevLabelId;
    private List<String> allLabelId;
    private JSONObject listDataCache = null;
    private String bizType;
    private String fschemeNumber;
    private String fdimtype;
    private List<String> fdim1levelList;

    public FilterItemProvider(EntityType entityType, IdsPageCache pageCache) {
        this.entityType = entityType;
        this.pageCache = pageCache;
    }

    public static String toJsonString(FilterItemProvider provider) {
        JSONObject json = new JSONObject();
        json.put("label", (Object)provider.label);
        json.put("subServiceId", (Object)provider.subServiceId);
        json.put("modelTypeId", (Object)provider.modelTypeId);
        json.put("prevLabelId", provider.prevLabelId);
        json.put("allLabelId", provider.allLabelId);
        json.put("pageCacheId", (Object)provider.pageCache.getPageId());
        json.put("bizType", (Object)provider.bizType);
        json.put("fschemeNumber", (Object)provider.fschemeNumber);
        json.put("fdimtype", (Object)provider.fdimtype);
        json.put("fdim1levelList", provider.fdim1levelList);
        return json.toJSONString();
    }

    public static FilterItemProvider fromJsonString(String str) {
        JSONArray allLabelId;
        JSONArray prevLabelId;
        JSONObject json = JSON.parseObject((String)str);
        if (json == null) {
            return null;
        }
        String pageCacheId = json.getString("pageCacheId");
        if (kd.bos.util.StringUtils.isEmpty((String)pageCacheId)) {
            return null;
        }
        IdsPageCache pageCache = new IdsPageCache(pageCacheId);
        FilterItemProvider provider = new FilterItemProvider((EntityType)VirtualEntityTools.createEntityType(), pageCache);
        provider.label = (LabelItem)json.getObject("label", LabelItem.class);
        provider.subServiceId = json.getString("subServiceId");
        provider.modelTypeId = json.getString("modelTypeId");
        provider.bizType = json.getString("bizType");
        provider.fschemeNumber = json.getString("fschemeNumber");
        provider.fdimtype = json.getString("fdimtype");
        JSONArray fdim1levelList = json.getJSONArray("fdim1levelList");
        if (fdim1levelList != null) {
            provider.fdim1levelList = fdim1levelList.toJavaList(String.class);
        }
        if ((prevLabelId = json.getJSONArray("prevLabelId")) != null) {
            provider.prevLabelId = prevLabelId.toJavaList(String.class);
        }
        if ((allLabelId = json.getJSONArray("allLabelId")) != null) {
            provider.allLabelId = allLabelId.toJavaList(String.class);
        }
        return provider;
    }

    public LabelItem getLabel() {
        return this.label;
    }

    public void setLabel(LabelItem label) {
        this.label = label;
    }

    public void setSubServiceId(String subServiceId) {
        this.subServiceId = subServiceId;
    }

    public void setModelTypeId(String modelTypeId) {
        this.modelTypeId = modelTypeId;
    }

    public void setPrevLabelId(List<String> prevLabelId) {
        this.prevLabelId = prevLabelId;
    }

    public List<String> getAllLabelId() {
        return this.allLabelId;
    }

    public void setAllLabelId(List<String> allLabelId) {
        this.allLabelId = allLabelId;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public void setFschemeNumber(String fschemeNumber) {
        this.fschemeNumber = fschemeNumber;
    }

    public void setFdimtype(String fdimtype) {
        this.fdimtype = fdimtype;
    }

    public void setFdim1levelList(List<String> fdim1levelList) {
        this.fdim1levelList = fdim1levelList;
    }

    private JSONObject getListDataCache() {
        this.listDataCache = SessionCache.get().getAsObject("ListData_" + this.label.getId());
        if (this.listDataCache == null) {
            this.listDataCache = new JSONObject();
        }
        return this.listDataCache;
    }

    private JSONObject getListDataCache(String labelId) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)labelId)) {
            this.listDataCache = SessionCache.get().getAsObject("ListData_" + labelId);
            if (this.listDataCache == null) {
                this.listDataCache = new JSONObject();
            }
        }
        return this.listDataCache;
    }

    private void updateListDataCache(JSONObject data) {
        SessionCache.get().put("ListData_" + this.label.getId(), data.toJSONString());
    }

    public List<String> getSelectedIdList() {
        return this.pageCache.getAsList("SelectedList_" + this.label.getId(), String.class);
    }

    public void setSelectedIdList(List<String> idList) {
        this.pageCache.put("SelectedList_" + this.label.getId(), JSON.toJSONString(idList));
    }

    public List<String> getSelectedNumberList(String labelId) {
        List idList = this.pageCache.getAsList("SelectedList_" + labelId, String.class);
        ArrayList<String> rtn = new ArrayList<String>(idList.size());
        JSONObject cache = this.getListDataCache(labelId);
        for (String id : idList) {
            JSONObject record = cache.getJSONObject("data_" + id);
            if (record == null) continue;
            rtn.add(record.getString("id"));
        }
        return rtn;
    }

    private List<FilterItemValuesDTO> buildPrevFilterItemValues(String currLabelId) {
        ArrayList<FilterItemValuesDTO> rtn = new ArrayList<FilterItemValuesDTO>();
        if (this.prevLabelId != null && !this.prevLabelId.isEmpty()) {
            int currLabelIndex = this.prevLabelId.indexOf(currLabelId);
            for (String labelId : this.prevLabelId) {
                List<String> numberList;
                int index = this.prevLabelId.indexOf(labelId);
                if (StringUtils.equalsIgnoreCase((CharSequence)labelId, (CharSequence)currLabelId) || currLabelIndex >= 0 && index > currLabelIndex || (numberList = this.getSelectedNumberList(labelId)).isEmpty()) continue;
                FilterItemValuesDTO item = new FilterItemValuesDTO();
                item.setLabelId(labelId);
                item.setValues(String.join((CharSequence)",", numberList));
                rtn.add(item);
            }
        }
        return rtn;
    }

    public void saveChanges() {
        this.pageCache.saveChanges();
    }

    public DynamicObject getDataById(Object id) {
        String recordId;
        JSONObject cache = this.getListDataCache();
        JSONObject record = cache.getJSONObject("data_" + id);
        if (record == null && kd.bos.util.StringUtils.isNotEmpty((String)(recordId = cache.getString("id_map_" + id)))) {
            id = recordId;
            record = cache.getJSONObject("data_" + recordId);
        }
        if (record == null) {
            return null;
        }
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)this.entityType);
        dynamicObject.set("id", id);
        dynamicObject.set("name", (Object)record.getString("name"));
        dynamicObject.set("number", (Object)record.getString("number"));
        return dynamicObject;
    }

    public DynamicObjectCollection getDataByIdList(List<Object> idList) {
        DynamicObjectCollection data = new DynamicObjectCollection((DynamicObjectType)this.entityType, null);
        JSONObject cache = this.getListDataCache();
        for (Object id : idList) {
            String recordId;
            JSONObject record = cache.getJSONObject("data_" + id);
            if (record == null && kd.bos.util.StringUtils.isNotEmpty((String)(recordId = cache.getString("id_map_" + id)))) {
                id = recordId;
                record = cache.getJSONObject("data_" + recordId);
            }
            if (record == null) continue;
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)this.entityType);
            dynamicObject.set("id", id);
            dynamicObject.set("name", (Object)record.getString("name"));
            dynamicObject.set("number", (Object)record.getString("number"));
            data.add((Object)dynamicObject);
        }
        return data;
    }

    private DynamicObject buildDynamicObject(JSONObject record, AtomicLong maxIdVal, JSONObject listDataCache) {
        String recordNumber = record.getString("number");
        String id = record.getString("id");
        if (kd.bos.util.StringUtils.isEmpty((String)recordNumber)) {
            recordNumber = record.getString("id");
            record.put("number", (Object)recordNumber);
        }
        if (id == null) {
            id = String.valueOf(maxIdVal.getAndIncrement());
            listDataCache.put("id_map_" + recordNumber, (Object)id);
            listDataCache.put("data_" + id, (Object)record);
        } else {
            listDataCache.put("id_map_" + recordNumber, (Object)id);
            listDataCache.put("data_" + id, (Object)record);
        }
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)this.entityType);
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("name", (Object)record.getString("name"));
        dynamicObject.set("number", (Object)recordNumber);
        return dynamicObject;
    }

    public QueryResult getData(int start, int limit, String search) {
        int total;
        DynamicObjectCollection data = new DynamicObjectCollection((DynamicObjectType)this.entityType, null);
        QueryResult queryResult = new QueryResult();
        int current = start == 0 ? 1 : start / limit + 1;
        RequestContext rc = RequestContext.get();
        List<FilterItemValuesDTO> filterItemValuesDTOList = this.buildPrevFilterItemValues(this.label.getId());
        JSONObject dataJo = null;
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.bizType, (CharSequence)FilterItemBizTypeEnum.MATERIAL_SALE.getId())) {
            dataJo = ((IMaterialSaleAnaService)Services.get(IMaterialSaleAnaService.class)).getFilterItemValueLevel(Long.valueOf(rc.getOrgId()), this.subServiceId, this.fschemeNumber, current, limit, this.fdimtype, search, this.fdim1levelList);
        } else {
            boolean fisOutlier = org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)this.bizType, (CharSequence)FilterItemBizTypeEnum.MODEL_ANA_OUTLIER.getId());
            dataJo = ((IAnaResultService)Services.get(IAnaResultService.class)).getFilterItemValueLevel(Long.valueOf(rc.getOrgId()), this.subServiceId, this.modelTypeId, current, limit, this.label.getId(), search, filterItemValuesDTOList, fisOutlier);
        }
        JSONArray recordsJa = dataJo == null ? null : dataJo.getJSONArray("records");
        int n = total = dataJo == null ? 0 : dataJo.getIntValue("total");
        if (recordsJa != null) {
            JSONObject cache = this.getListDataCache();
            AtomicLong maxIdVal = new AtomicLong(cache.getLongValue("maxIdVal"));
            int len = recordsJa.size();
            for (int i = 0; i < len; ++i) {
                JSONObject record = recordsJa.getJSONObject(i);
                DynamicObject dynamicObject = this.buildDynamicObject(record, maxIdVal, cache);
                data.add((Object)dynamicObject);
            }
            cache.put("maxIdVal", (Object)maxIdVal.get());
            this.updateListDataCache(cache);
        }
        queryResult.setCollection(data);
        queryResult.setDataCount(total);
        return queryResult;
    }
}

