/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.ai.ids.core.cache.IdsPageCache;
import kd.ai.ids.core.query.label.LabelItem;
import kd.ai.ids.plugin.control.FilterItemProvider;
import kd.ai.ids.plugin.tool.VirtualEntityTools;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.param.ShowColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;

public class IdsFilterItemEdit
extends MulBasedataEdit {
    private final EntityType entityType = VirtualEntityTools.createEntityType();
    private LabelItem label;
    private String subServiceId;
    private String modelTypeId;
    private boolean multiSelect;
    private IdsPageCache pageCache;
    private List<String> prevLabelId;
    private List<String> allLabelId;
    private String bizType;
    private String fschemeNumber;
    private String fdimtype;
    private List<String> fdim1levelList;
    private FilterItemProvider filterItemProvider = null;

    public void setLabel(LabelItem label) {
        this.label = label;
    }

    public void setSubServiceId(String subServiceId) {
        this.subServiceId = subServiceId;
    }

    public void setModelTypeId(String modelTypeId) {
        this.modelTypeId = modelTypeId;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void setPrevLabelId(List<String> prevLabelId) {
        this.prevLabelId = prevLabelId;
    }

    public List<String> getAllLabelId() {
        return this.allLabelId;
    }

    public void setAllLabelId(List<String> allLabelId) {
        this.allLabelId = allLabelId;
    }

    public void setPageCache(IdsPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public void setFschemeNumber(String fschemeNumber) {
        this.fschemeNumber = fschemeNumber;
    }

    public void setFdimtype(String fdimtype) {
        this.fdimtype = fdimtype;
    }

    public void setFdim1levelList(List<String> fdim1levelList) {
        this.fdim1levelList = fdim1levelList;
    }

    private FilterItemProvider getFilterItemProvider() {
        if (this.filterItemProvider == null) {
            this.filterItemProvider = new FilterItemProvider(this.entityType, this.pageCache);
            this.filterItemProvider.setLabel(this.label);
            this.filterItemProvider.setSubServiceId(this.subServiceId);
            this.filterItemProvider.setModelTypeId(this.modelTypeId);
            this.filterItemProvider.setPrevLabelId(this.prevLabelId);
            this.filterItemProvider.setAllLabelId(this.allLabelId);
            this.filterItemProvider.setBizType(this.bizType);
            this.filterItemProvider.setFschemeNumber(this.fschemeNumber);
            this.filterItemProvider.setFdimtype(this.fdimtype);
            this.filterItemProvider.setFdim1levelList(this.fdim1levelList);
        }
        return this.filterItemProvider;
    }

    public void click() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ids_listf7");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        fsp.getOpenStyle().setInlineStyleCss(css);
        fsp.setShowTitle(false);
        fsp.setHasRight(true);
        fsp.setCustomParam("multiSelect", (Object)String.valueOf(this.multiSelect));
        fsp.setCustomParam("provider", (Object)FilterItemProvider.toJsonString(this.getFilterItemProvider()));
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(this.getKey());
        fsp.setCloseCallBack(closeCallBack);
        this.getView().showForm(fsp);
    }

    public List<String> getSelectedNumberList() {
        return this.getFilterItemProvider().getSelectedNumberList(this.label.getId());
    }

    public void getLookUpList(List<Object> args) {
        String searchKey = (String)args.get(1);
        QueryResult queryResult = this.getFilterItemProvider().getData(0, 10, searchKey);
        ArrayList<Object[]> queryData = new ArrayList<Object[]>();
        for (DynamicObject record : queryResult.getCollection()) {
            queryData.add(new Object[]{record.getString("id"), record.getString("number"), record.getString("name")});
        }
        ArrayList<ShowColumn> showColumns = new ArrayList<ShowColumn>();
        showColumns.add(new ShowColumn("id", "id", false));
        showColumns.add(new ShowColumn("number", "\u7f16\u7801", 156.0f, true));
        showColumns.add(new ShowColumn("name", "\u540d\u79f0", 156.0f, true));
        HashMap<String, Object> data = new HashMap<String, Object>(7);
        data.put("columns", showColumns);
        data.put("data", queryData);
        data.put("next", Boolean.FALSE);
        data.put("k", this.key);
        data.put("size", queryResult.getDataCount());
        data.put("args", args);
        data.put("r", 0);
        this.clientViewProxy.invokeControlMethod(this.key, "setLookUpListValue", new Object[]{data});
    }

    public void setItemByIdFromClient(List<Object> args) {
        if (args != null && StringUtils.isNotBlank((Object)args.get(0))) {
            String id = String.valueOf(args.get(0));
            DynamicObject record = this.getFilterItemProvider().getDataById(id);
            if (record == null) {
                return;
            }
            if (this.multiSelect) {
                ArrayList<Object[]> returnValues = new ArrayList<Object[]>();
                returnValues.add(new Object[]{id, record.getString("name"), record.getString("name")});
                this.clientViewProxy.setFieldProperty(this.getKey(), "v", returnValues);
            } else {
                Object[] returnValue = new Object[]{id, record.getString("name"), record.getString("name")};
                this.clientViewProxy.setFieldProperty(this.getKey(), "v", (Object)returnValue);
            }
            this.getFilterItemProvider().setSelectedIdList(Collections.singletonList(id));
        }
    }

    public void setItemByNumber(String number, int rowKey) {
        if (number == null) {
            return;
        }
        String[] numberArr = number.split("[,;\uff1b]");
        ArrayList<Object> numberList = new ArrayList<Object>();
        Collections.addAll(numberList, numberArr);
        ArrayList<Object[]> returnValues = new ArrayList<Object[]>();
        ArrayList<String> selectedIdList = new ArrayList<String>();
        DynamicObjectCollection recordList = this.getFilterItemProvider().getDataByIdList(numberList);
        for (DynamicObject record : recordList) {
            String pkId = String.valueOf(record.getPkValue());
            if (selectedIdList.contains(pkId)) continue;
            selectedIdList.add(pkId);
            returnValues.add(new Object[]{pkId, record.getString("name"), record.getString("name")});
        }
        if (this.multiSelect) {
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", returnValues);
        } else {
            Object[] returnValue = returnValues.isEmpty() ? new Object[]{} : (Object[])returnValues.get(0);
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", (Object)returnValue);
        }
        this.getFilterItemProvider().setSelectedIdList(selectedIdList);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows == null || rows.isEmpty() && !rows.isClearFlag()) {
            return;
        }
        ArrayList<String> selectedIdList = new ArrayList<String>();
        if (this.multiSelect) {
            ArrayList<Object[]> returnValues = new ArrayList<Object[]>();
            for (ListSelectedRow lsr : rows) {
                selectedIdList.add(lsr.getBillNo());
                returnValues.add(new Object[]{lsr.getBillNo(), lsr.getName(), lsr.getName()});
            }
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", returnValues);
        } else if (rows.isEmpty()) {
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", new ArrayList());
        } else {
            ListSelectedRow lsr = rows.get(0);
            selectedIdList.add(lsr.getBillNo());
            Object[] returnValue = new Object[]{lsr.getBillNo(), lsr.getName(), lsr.getName()};
            this.clientViewProxy.setFieldProperty(this.getKey(), "v", (Object)returnValue);
        }
        this.getFilterItemProvider().setSelectedIdList(selectedIdList);
        this.getFilterItemProvider().saveChanges();
    }
}

