/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.controller;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.ai.ids.core.entity.model.gpe.AttachmentDTO;
import kd.ai.ids.core.enumtype.BillStatusEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.enumtype.gpe.ErrorCodeEnum;
import kd.ai.ids.core.query.gpe.AttachmentInfo;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.AwsS3Utils;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

@ApiController(value="ids", desc="\u4fdd\u5b58\u6587\u4ef6\u5355\u636e")
@ApiMapping(value="gpe")
public class GpeAttachmentController
implements Serializable {
    protected Log log = LogFactory.getLog(this.getClass());
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";

    private IIdsParameterService idsParameterService() {
        return (IIdsParameterService)Services.get(IIdsParameterService.class);
    }

    @ApiPostMapping(value="/attachment/save")
    public CustomApiResult<@ApiResponseBody AttachmentDTO> save(@ApiParam(value="\u9644\u4ef6\u5bf9\u8c61", required=true) @ApiParam(value="\u9644\u4ef6\u5bf9\u8c61", required=true) AttachmentInfo attachmentInfo) {
        String fileName = attachmentInfo.getFileName();
        if (!StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".csv")) {
            fileName = String.format("%s.csv", fileName);
        }
        long orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
        IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(orgId));
        String gpeServerUrl = idsParameter.getGpeServerUrl();
        String downloadUrl = String.format("%s%s?fileId=%s", gpeServerUrl, "/gpes/algorithm/attachment/download", attachmentInfo.getFileId());
        DynamicObject attachmentDo = BusinessDataServiceHelper.newDynamicObject((String)IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId());
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)attachmentDo.getDataEntityType().getName(), (DynamicObject)attachmentDo, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)attachmentDo);
        long id = ID.genLongId();
        attachmentDo.set("id", (Object)id);
        attachmentDo.set("number", (Object)number);
        attachmentDo.set("name", (Object)fileName);
        attachmentDo.set("status", (Object)BillStatusEnum.AUDITED.getId());
        attachmentDo.set("enable", (Object)YesNoEnum.YES.getKeyStr());
        attachmentDo.set("masterid", (Object)id);
        attachmentDo.set("source", (Object)attachmentInfo.getSource());
        attachmentDo.set("sourceid", (Object)attachmentInfo.getSourceId());
        String content = AwsS3Utils.readS3File((String)downloadUrl);
        InputStream in = IOUtils.toInputStream((String)content, (Charset)Charset.forName("utf-8"));
        int fileSize = 0;
        try {
            fileSize = in.available();
            attachmentDo.set("filesize", (Object)fileSize);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachmentDo});
            boolean uploadSuccess = this.upload(attachmentDo, in, fileName);
            if (uploadSuccess) {
                DynamicObject sourceDo = BusinessDataServiceHelper.loadSingle((Object)attachmentInfo.getSourceId(), (String)attachmentInfo.getSource());
                sourceDo.set("attachmentid", (Object)attachmentDo);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceDo});
                AttachmentDTO attachmentDTO = new AttachmentDTO();
                attachmentDTO.setNumber(number);
                attachmentDTO.setName(fileName);
                attachmentDTO.setFileSize(Integer.valueOf(fileSize));
                attachmentDTO.setId(Long.valueOf(id));
                return CustomApiResult.success((Object)attachmentDTO);
            }
            return CustomApiResult.fail((String)ErrorCodeEnum.FAIL.getId(), (String)"\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        catch (Exception e) {
            this.log.error("error:" + e.getMessage(), (Throwable)e);
            return CustomApiResult.fail((String)ErrorCodeEnum.FAIL.getId(), (String)"\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38");
        }
    }

    private boolean upload(DynamicObject attachmentDo, InputStream inputStream, String fileName) {
        RequestContext rc = RequestContext.get();
        boolean uploadSuccess = false;
        try {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".csv")) {
                fileName = String.format("%s.csv", fileName);
            }
            String today = DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMMdd");
            String uploadPath = String.format("%s/%s/%s/%s/%s/%s", rc.getTenantId(), rc.getAccountId(), today, IdsFormIdEnum.IDS_GPE_ATTACHMENT.getId(), attachmentDo.getPkValue(), fileName);
            FileService fs = FileServiceFactory.getAttachmentFileService();
            FileItem fi = new FileItem(fileName, uploadPath, inputStream);
            int size = inputStream.available();
            String path = fs.upload(fi);
            HashMap<String, Object> uploadFileMap = new HashMap<String, Object>();
            uploadFileMap.put("entityNum", attachmentDo.getDynamicObjectType().getName());
            uploadFileMap.put("billPkId", attachmentDo.get("id"));
            uploadFileMap.put("lastModified", KDDateUtils.now().getTime());
            uploadFileMap.put("name", fileName);
            uploadFileMap.put("url", uploadPath);
            uploadFileMap.put("size", size);
            uploadFileMap.put("status", "success");
            ArrayList<HashMap<String, Object>> attachments = new ArrayList<HashMap<String, Object>>();
            attachments.add(uploadFileMap);
            AttachmentServiceHelper.upload((String)attachmentDo.getDynamicObjectType().getName(), (Object)attachmentDo.getPkValue(), (String)KEY_ATTACHMENTPANELAP, attachments);
            uploadSuccess = true;
            this.log.info("\u4e0a\u4f20\u6210\u529f\uff1a" + path);
        }
        catch (Exception e) {
            uploadSuccess = false;
            this.log.error("error:" + e.getMessage(), (Throwable)e);
        }
        return uploadSuccess;
    }
}

