/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.ai.ids.core.entity.model.gpe.LogDTO;
import kd.ai.ids.core.query.gpe.LogQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

@ApiController(value="ids", desc="\u6253\u5370GPT\u9884\u6d4b\u5f15\u64ce\u670d\u52a1\u7aef\u65e5\u5fd7")
@ApiMapping(value="gpe")
public class GpeLogController
implements Serializable {
    public static final String DEBUG = "DEBUG";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";
    public static final String GPESLOG_PREFIX = "[GPESLog] level:{} requestId:{} \n {}";
    public static final int LOG_MAX_LENGTH = 5000;
    protected Log log = LogFactory.getLog(this.getClass());

    @ApiPostMapping(value="/monitor/log/add")
    public CustomApiResult<@ApiResponseBody LogDTO> logAdd(@ApiParam(value="\u65e5\u5fd7\u5bf9\u8c61", required=true) @ApiParam(value="\u65e5\u5fd7\u5bf9\u8c61", required=true) LogQuery logQuery) {
        String msg = logQuery.getMsg();
        List<String> msgList = this.getMsgList(msg);
        switch (logQuery.getLevel()) {
            case "DEBUG": {
                for (String msgItem : msgList) {
                    this.log.debug(GPESLOG_PREFIX, new Object[]{logQuery.getLevel(), logQuery.getRequestId(), msgItem});
                }
                break;
            }
            case "WARN": {
                for (String msgItem : msgList) {
                    this.log.warn(GPESLOG_PREFIX, new Object[]{logQuery.getLevel(), logQuery.getRequestId(), msgItem});
                }
                break;
            }
            case "ERROR": {
                for (String msgItem : msgList) {
                    this.log.error(GPESLOG_PREFIX, new Object[]{logQuery.getLevel(), logQuery.getRequestId(), msgItem});
                }
                break;
            }
            default: {
                for (String msgItem : msgList) {
                    this.log.info(GPESLOG_PREFIX, new Object[]{logQuery.getLevel(), logQuery.getRequestId(), msgItem});
                }
            }
        }
        LogDTO logDTO = new LogDTO();
        logDTO.setRequestId(logQuery.getRequestId());
        logDTO.setCreateTime(KDDateFormatUtils.getDateTimeFormat().format(KDDateUtils.now()));
        return CustomApiResult.success((Object)logDTO);
    }

    private List<String> getMsgList(String msg) {
        ArrayList<String> msgList = new ArrayList<String>();
        if (msg != null) {
            if (msg.length() <= 5000) {
                msgList.add(msg);
            } else {
                String number = RandomStringUtils.randomNumeric((int)3);
                int index = 1;
                do {
                    if (msg != null && msg.length() > 5000) {
                        String item = msg.substring(0, 5000);
                        item = String.format("[\u7f16\u53f7%s-%s]%s", number, index, item);
                        msg = msg.substring(5000);
                        msgList.add(item);
                    } else {
                        msg = String.format("[\u7f16\u53f7%s-%s]%s", number, index, msg);
                        msgList.add(msg);
                        msg = null;
                    }
                    ++index;
                } while (StringUtils.isNotEmpty((CharSequence)msg));
            }
        }
        return msgList;
    }
}

