/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.ids.core.cache.AppCache;
import kd.ai.ids.core.cache.SessionCache;
import kd.ai.ids.core.enumtype.AppConfigParameterEnum;
import kd.ai.ids.core.enumtype.AppStatusEnum;
import kd.ai.ids.core.enumtype.AppTypeEnum;
import kd.ai.ids.core.enumtype.IdsFormIdEnum;
import kd.ai.ids.core.enumtype.IdsPermissionEnum;
import kd.ai.ids.core.enumtype.IdsVersionEnum;
import kd.ai.ids.core.enumtype.ShowHomePageEnum;
import kd.ai.ids.core.enumtype.SubParameterScopeEnum;
import kd.ai.ids.core.enumtype.gpe.ErrorCodeEnum;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.JsonUtils;
import kd.ai.ids.core.utils.PermUtils;
import kd.ai.ids.core.utils.ThreadUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.CommonTools;
import kd.ai.ids.plugin.tool.FormTools;
import kd.ai.ids.plugin.tool.PopAppUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeMenuNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeMenu;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeMenuClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.portal.plugin.BizAppHomePlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AppHomeFormPlugin
extends BaseFormPlugin
implements TreeMenuClickListener,
TabSelectListener {
    private static final String KEY_REFRESH_MENU = "refreshMenu";
    private static final String KEY_APPMIANTAB = "appmiantab";
    private static final String KEY_APPID = "appid";
    private static final String CONS_NAVIGATIONBAR = "navigationbar";
    private static final String KEY_SUB_COUNT = "subcount";
    private static final String KEY_SALE_FORECAST_SHOW_HOME_PAGE = "saleForecastShowHomePage";
    private static final String KEY_TAB = "_submaintab_";
    private static final JSONArray KEY_IDS_VERSION_BIC_TREE_MENU_ARRAY = JSONArray.parseArray((String)"[{\"id\":\"1372341349340203008\",\"text\":\"\u5e94\u7528\u7ba1\u7406\"},{\"id\":\"1372405781785266176\",\"text\":\"\u667a\u80fd\u9500\u552e\u9884\u6d4b\"},{\"id\":\"1705728749221195776\",\"text\":\"\u5546\u54c1\u5206\u6790\"},{\"id\":\"1421714198320172032\",\"text\":\"\u4e1a\u52a1\u5173\u8054\u65b9\u6848\"},{\"id\":\"1545660613508791296\",\"text\":\"\u57fa\u7840\u8d44\u6599\"},{\"id\":\"1677610996102859776\",\"text\":\"\u9500\u552e\u8ba1\u5212\"},{\"id\":\"1681342993614784512\",\"text\":\"\u9700\u6c42\u8ba1\u5212\"},{\"id\":\"1791941979488181248\",\"text\":\"GPT\u9884\u6d4b\u5f15\u64ce\"},{\"id\":\"1ZY6YB43XFE#hpce\",\"text\":\"\u5e2e\u52a9\u4e2d\u5fc3\"}]");
    private static final JSONArray KEY_IDS_VERSION_STANDARD_TREE_MENU_ARRAY = JSONArray.parseArray((String)"[{\"id\":\"1372341349340203008\",\"text\":\"\u5e94\u7528\u7ba1\u7406\"},{\"id\":\"1754263965904455680\",\"text\":\"\u667a\u80fd\u9500\u552e\u9884\u6d4b\"},{\"id\":\"1705728749221195776\",\"text\":\"\u5546\u54c1\u5206\u6790\"},{\"id\":\"1421714198320172032\",\"text\":\"\u4e1a\u52a1\u5173\u8054\u65b9\u6848\"},{\"id\":\"1791941979488181248\",\"text\":\"GPT\u9884\u6d4b\u5f15\u64ce\"},{\"id\":\"1ZY6YB43XFE#hpce\",\"text\":\"\u5e2e\u52a9\u4e2d\u5fc3\"}]");
    private static final String KEY_OP_EVALUATION = "evaluation";
    private static final String CACHE_KEY_THIRD_APP_EXISTED = "thirdAppExisted";

    private int getSubCount() {
        String s = this.getCache().get(KEY_SUB_COUNT);
        return s != null ? Integer.parseInt(s) : 0;
    }

    private int getSaleForecastShowHomePage() {
        String s = this.getCache().get(KEY_SALE_FORECAST_SHOW_HOME_PAGE);
        return s != null ? Integer.parseInt(s) : 0;
    }

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private boolean enableNewProductForecast() {
        String s = SessionCache.get().get(AppConfigParameterEnum.ENABLE_NEW_PRODUCT_FORECAST.getId());
        return Boolean.parseBoolean(s);
    }

    private boolean enableNsRealtimePredict() {
        String s = SessionCache.get().get(AppConfigParameterEnum.ENABLE_NS_REALTIME_PREDICT.getId());
        return Boolean.parseBoolean(s);
    }

    private boolean enableSalesPlan() {
        String s = SessionCache.get().get(AppConfigParameterEnum.ENABLE_SALESPLAN.getId());
        return Boolean.parseBoolean(s);
    }

    private boolean enableRequirePlan() {
        String s = SessionCache.get().get(AppConfigParameterEnum.ENABLE_REQUIREPLAN.getId());
        return Boolean.parseBoolean(s);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeMenu navigationBar = (TreeMenu)this.getView().getControl(CONS_NAVIGATIONBAR);
        if (navigationBar != null) {
            navigationBar.addTreeMenuClickListener((TreeMenuClickListener)this);
            this.addClickListeners(new String[]{CONS_NAVIGATIONBAR});
        }
        Tab tab = (Tab)this.getView().getControl(KEY_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        boolean showAllMenu = false;
        if (!showAllMenu) {
            this.initTreeMenuDataListener();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormTools.cachePageId(this.getView());
        if (this.getSaleForecastShowHomePage() == ShowHomePageEnum.SHOW_AND_OPEN.getId().intValue()) {
            PopAppUtils.showFormOnlyOnce(this.getView(), "ids_sale_forecast_home", null, null);
        }
    }

    private void initTreeMenuDataListener() {
        TreeMenu treeMenu = (TreeMenu)this.getControl(CONS_NAVIGATIONBAR);
        if (treeMenu != null) {
            TenantDTO tenantDTO = this.getTenantDTO();
            if (StringUtils.equalsIgnoreCase((CharSequence)tenantDTO.getIdsVersion(), (CharSequence)IdsVersionEnum.BIC.getKey())) {
                Set<String> showTreeNodeIdList;
                Set<String> finalShowTreeNodeIdList = showTreeNodeIdList = this.getShowTreeNodeIdList(KEY_IDS_VERSION_BIC_TREE_MENU_ARRAY);
                treeMenu.addTreeMenuAddNodesListener(treeMenuAddNodesEvent -> {
                    List treeMenuNodeList = treeMenuAddNodesEvent.getNodes();
                    HashSet<TreeMenuNode> needRemove = new HashSet<TreeMenuNode>();
                    Set<String> unSubServiceTreeMenuNodeIdList = this.getUnSubServiceTreeMenuNodeIdList();
                    for (TreeMenuNode menuNode : treeMenuNodeList) {
                        if (!finalShowTreeNodeIdList.contains(menuNode.getId())) {
                            needRemove.add(menuNode);
                        }
                        if (unSubServiceTreeMenuNodeIdList.contains(menuNode.getId())) {
                            needRemove.add(menuNode);
                        }
                        if (this.getSubCount() <= 0 && StringUtils.equalsIgnoreCase((CharSequence)menuNode.getId(), (CharSequence)"1399091351399713792")) {
                            needRemove.add(menuNode);
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)menuNode.getId(), (CharSequence)"1372405781785266176")) {
                            List sfTreeMenuNodeList = menuNode.getChildren();
                            ArrayList<TreeMenuNode> needRemoveSfTreeMenuNodeList = new ArrayList<TreeMenuNode>();
                            for (TreeMenuNode treeMenuNode : sfTreeMenuNodeList) {
                                if (StringUtils.equalsIgnoreCase((CharSequence)treeMenuNode.getId(), (CharSequence)"1510043386243974144")) {
                                    List sfLevel3TreeMenuNodeList = treeMenuNode.getChildren();
                                    ArrayList<TreeMenuNode> needRemoveTreeMenuNodeList = new ArrayList<TreeMenuNode>();
                                    for (TreeMenuNode sfLevel3TreeMenuNode : sfLevel3TreeMenuNodeList) {
                                        if (this.getSaleForecastShowHomePage() != ShowHomePageEnum.HIDE.getId().intValue() || !StringUtils.equalsIgnoreCase((CharSequence)sfLevel3TreeMenuNode.getId(), (CharSequence)"1509488229718473728")) continue;
                                        needRemoveTreeMenuNodeList.add(sfLevel3TreeMenuNode);
                                    }
                                    if (needRemoveTreeMenuNodeList.isEmpty()) continue;
                                    sfLevel3TreeMenuNodeList.removeAll(needRemoveTreeMenuNodeList);
                                    String menuText = ResManager.loadKDString((String)"\u5e94\u7528\u914d\u7f6e", (String)"AppHomeFormPlugin_4", (String)"ai-ids-plugin", (Object[])new Object[0]);
                                    treeMenuNode.setText(menuText);
                                    continue;
                                }
                                if (!StringUtils.equalsIgnoreCase((CharSequence)treeMenuNode.getId(), (CharSequence)"1615961939677036544") || this.enableNsRealtimePredict()) continue;
                                needRemoveSfTreeMenuNodeList.add(treeMenuNode);
                            }
                            if (needRemoveSfTreeMenuNodeList.isEmpty()) continue;
                            sfTreeMenuNodeList.removeAll(needRemoveSfTreeMenuNodeList);
                            continue;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)menuNode.getId(), (CharSequence)"1545660613508791296")) continue;
                        List basedataTreeMenuNodeList = menuNode.getChildren();
                        ArrayList<TreeMenuNode> needRemoveBasedataTreeMenuNodeList = new ArrayList<TreeMenuNode>();
                        for (TreeMenuNode treeMenuNode : basedataTreeMenuNodeList) {
                            if (!this.enableSalesPlan() && StringUtils.equalsIgnoreCase((CharSequence)treeMenuNode.getId(), (CharSequence)"1677415194004823040")) {
                                needRemoveBasedataTreeMenuNodeList.add(treeMenuNode);
                            }
                            if (this.enableNewProductForecast() || !StringUtils.equalsIgnoreCase((CharSequence)treeMenuNode.getId(), (CharSequence)"1615962277746328576")) continue;
                            needRemoveBasedataTreeMenuNodeList.add(treeMenuNode);
                        }
                        if (needRemoveBasedataTreeMenuNodeList.isEmpty()) continue;
                        basedataTreeMenuNodeList.removeAll(needRemoveBasedataTreeMenuNodeList);
                    }
                    treeMenuNodeList.removeAll(needRemove);
                });
            } else {
                Set<String> showTreeNodeIdList;
                Set<String> finalShowTreeNodeIdList = showTreeNodeIdList = this.getShowTreeNodeIdList(KEY_IDS_VERSION_STANDARD_TREE_MENU_ARRAY);
                treeMenu.addTreeMenuAddNodesListener(treeMenuAddNodesEvent -> {
                    List treeMenuNodeList = treeMenuAddNodesEvent.getNodes();
                    HashSet<TreeMenuNode> needRemove = new HashSet<TreeMenuNode>();
                    Set<String> unSubServiceTreeMenuNodeIdList = this.getUnSubServiceTreeMenuNodeIdList();
                    for (TreeMenuNode menuNode : treeMenuNodeList) {
                        if (!finalShowTreeNodeIdList.contains(menuNode.getId())) {
                            needRemove.add(menuNode);
                        }
                        if (!unSubServiceTreeMenuNodeIdList.contains(menuNode.getId())) continue;
                        needRemove.add(menuNode);
                    }
                    treeMenuNodeList.removeAll(needRemove);
                });
            }
        }
    }

    private Set<String> getShowTreeNodeIdList(JSONArray ja) {
        HashSet<String> nodeIdList = new HashSet<String>();
        if (ja != null) {
            for (Object o : ja) {
                JSONObject jo = (JSONObject)o;
                nodeIdList.add(jo.getString("id"));
            }
        }
        return nodeIdList;
    }

    private Set<String> getUnSubServiceTreeMenuNodeIdList() {
        HashSet<String> unSubServiceTreeMenuNodeIdList = new HashSet<String>();
        unSubServiceTreeMenuNodeIdList.add("1372405781785266176");
        unSubServiceTreeMenuNodeIdList.add("1705728749221195776");
        int subCount = 0;
        RequestContext rc = RequestContext.get();
        TenantDTO tenantDTO = this.getTenantDTO();
        if (tenantDTO != null) {
            JSONObject dataJo = this.dataAppService().getSubAppList(Long.valueOf(rc.getOrgId()), rc.getTenantId(), tenantDTO.getTenantId());
            unSubServiceTreeMenuNodeIdList.clear();
            for (AppTypeEnum appType : AppTypeEnum.values()) {
                JSONArray subAppArray;
                JSONArray jSONArray = subAppArray = dataJo == null ? null : dataJo.getJSONArray(appType.getKey());
                if (subAppArray == null || subAppArray.isEmpty()) continue;
                for (int index = 0; index < subAppArray.size(); ++index) {
                    boolean isUnSubscribe;
                    JSONObject appJo = subAppArray.getJSONObject(index);
                    String appId = appJo.getString("appId");
                    Integer status = appJo.getInteger("status");
                    boolean bl = isUnSubscribe = status == null || status.intValue() == AppStatusEnum.INIT.getKey() || status.intValue() == AppStatusEnum.OFFLINE.getKey();
                    if (this.dataAppService().appIsSalesForecast(appId)) {
                        JSONObject subServiceJo;
                        if (isUnSubscribe) {
                            unSubServiceTreeMenuNodeIdList.add("1372405781785266176");
                            unSubServiceTreeMenuNodeIdList.add("1754263965904455680");
                        }
                        if ((subServiceJo = this.dataAppService().getSubService(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), appId)) != null) {
                            int showHomePage = subServiceJo.getIntValue("showHomePage");
                            String subServiceId = subServiceJo.getString("subServiceId");
                            this.getCache().put(KEY_SALE_FORECAST_SHOW_HOME_PAGE, String.valueOf(showHomePage));
                            boolean enableNewProductForecast = this.commonService().getBooleanValue(Long.valueOf(rc.getOrgId()), subServiceId, SubParameterScopeEnum.MODEL_RESULT_PARAMETER.getKey(), AppConfigParameterEnum.ENABLE_NEW_PRODUCT_FORECAST.getId());
                            SessionCache.get().put(AppConfigParameterEnum.ENABLE_NEW_PRODUCT_FORECAST.getId(), String.valueOf(enableNewProductForecast));
                            boolean enableNsRealtimePredict = this.commonService().getBooleanValue(Long.valueOf(rc.getOrgId()), subServiceId, SubParameterScopeEnum.MODEL_RESULT_PARAMETER.getKey(), AppConfigParameterEnum.ENABLE_NS_REALTIME_PREDICT.getId());
                            SessionCache.get().put(AppConfigParameterEnum.ENABLE_NS_REALTIME_PREDICT.getId(), String.valueOf(enableNsRealtimePredict));
                            boolean enableSalesplan = this.commonService().getBooleanValue(Long.valueOf(rc.getOrgId()), subServiceId, SubParameterScopeEnum.MODEL_RESULT_PARAMETER.getKey(), AppConfigParameterEnum.ENABLE_SALESPLAN.getId());
                            SessionCache.get().put(AppConfigParameterEnum.ENABLE_SALESPLAN.getId(), String.valueOf(enableSalesplan));
                            boolean enableRequireplan = this.commonService().getBooleanValue(Long.valueOf(rc.getOrgId()), subServiceId, SubParameterScopeEnum.MODEL_RESULT_PARAMETER.getKey(), AppConfigParameterEnum.ENABLE_REQUIREPLAN.getId());
                            SessionCache.get().put(AppConfigParameterEnum.ENABLE_REQUIREPLAN.getId(), String.valueOf(enableRequireplan));
                        }
                    } else if (this.dataAppService().appIsPva(appId) && isUnSubscribe) {
                        unSubServiceTreeMenuNodeIdList.add("1705728749221195776");
                    }
                    if (isUnSubscribe) continue;
                    ++subCount;
                }
            }
        }
        if (!this.enableSalesPlan()) {
            unSubServiceTreeMenuNodeIdList.add("1677610996102859776");
        }
        if (!this.enableRequirePlan()) {
            unSubServiceTreeMenuNodeIdList.add("1681342993614784512");
        }
        this.getCache().put(KEY_SUB_COUNT, String.valueOf(subCount));
        return unSubServiceTreeMenuNodeIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Object source = e.getSource();
        if (!(source instanceof FormShowParameter)) {
            e.setCancel(true);
            return;
        }
        FormShowParameter fsp = (FormShowParameter)source;
        String rootPageId = fsp.getRootPageId();
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            e.setCancel(true);
            return;
        }
        AtomicInteger showLoadingStatus = new AtomicInteger(0);
        Object lock = new Object();
        ThreadUtils.schedule(() -> {
            Object object = lock;
            synchronized (object) {
                int status = showLoadingStatus.getAndSet(2);
                if (status == 0) {
                    FormTools.showLoadingAsync(rootPageId);
                }
            }
        }, (long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            SessionCache.get().clear();
            RequestContext rc = RequestContext.get();
            String platformCode = this.labelService().getPlatformCode();
            String productVersion = CommonTools.getProductVersion();
            this.log.info("{} platformCode: {} productVesion:{}", new Object[]{rc.getClientFullContextPath(), platformCode, productVersion});
            TenantDTO tenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            boolean cancel = false;
            if (tenantDTO == null) {
                String cacheKey = "tenant/create/flag";
                String expect = "true";
                String flag = AppCache.get().get(cacheKey);
                if (!expect.equals(flag)) {
                    AppCache.get().put(cacheKey, expect, 20);
                    TenantDTO tmpTenantDTO = this.tenantService().getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
                    if (tmpTenantDTO == null) {
                        this.tenantService().createTenant(rc, productVersion);
                    }
                }
                cancel = true;
            } else if (tenantDTO.getIdsPermission() == IdsPermissionEnum.NO.getKey() || tenantDTO.getIdsPermission() == IdsPermissionEnum.UNAVAILABLE.getKey()) {
                cancel = true;
            }
            if (cancel) {
                // empty if block
            }
        }
        finally {
            Object object = lock;
            synchronized (object) {
                int status = showLoadingStatus.getAndSet(1);
                if (status == 2) {
                    FormTools.hideLoadingAsync(rootPageId);
                }
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (KEY_REFRESH_MENU.equals(e.getName())) {
            FormTools.notifyMyServiceCardRefresh(this.getView());
            SessionCache.get().clear();
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            for (IFormPlugin formPlugin : pluginProxy.getPlugIns()) {
                if (!(formPlugin instanceof BizAppHomePlugin)) continue;
                String appId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_APPID);
                if (StringUtils.isEmpty((CharSequence)appId)) {
                    this.getView().getFormShowParameter().setCustomParam(KEY_APPID, (Object)"1ZY6U=RCHA6Y");
                }
                this.initTreeMenuDataListener();
                BizAppHomePlugin bizAppHomePlugin = (BizAppHomePlugin)formPlugin;
                JSONArray menus = bizAppHomePlugin.getMenuArray();
                JSONArray qingMenus = bizAppHomePlugin.getQingMenuArray();
                qingMenus = CommonUtil.nullIfEmpty((JSONArray)qingMenus);
                bizAppHomePlugin.renderNavigation(menus, qingMenus);
                break;
            }
            FormTools.cachePageId(this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        RequestContext rc = RequestContext.get();
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_OP_EVALUATION) && returnData != null && (dataJo = JsonUtils.parseObj((Object)returnData)) != null) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(IdsFormIdEnum.IDS_GPE_RESULT_ANALYSIS.getId());
            fsp.setCaption(String.format("\u9884\u6d4b\u8bc4\u4f30-%s", dataJo.getString("number")));
            fsp.setCustomParam("recordId", (Object)dataJo.getLongValue("recordId"));
            fsp.setCustomParam("evaluationDatasetCacheId", (Object)dataJo.getString("evaluationDatasetCacheId"));
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(fsp);
        }
    }

    public void treeMenuClick(TreeNodeEvent treeNodeEvent) {
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)"ids", (String)treeNodeEvent.getNodeId().toString());
        if (menu != null) {
            String formId = menu.getFormId();
            this.judgeSaveThirdAppPerm(formId);
            if (this.getView().getEntityId().equals(formId)) {
                Tab mainTab = (Tab)this.getView().getControl(KEY_TAB);
                if (mainTab != null) {
                    mainTab.activeTab(KEY_APPMIANTAB);
                }
            } else {
                if (IdsFormIdEnum.IDS_GPE_PRE_EVALUATION.getId().equals(formId)) {
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setFormId(IdsFormIdEnum.IDS_GPE_PRE_EVALUATION.getId());
                    fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_OP_EVALUATION));
                    StyleCss css = new StyleCss();
                    css.setWidth("780px");
                    css.setHeight("380px");
                    fsp.getOpenStyle().setInlineStyleCss(css);
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(fsp);
                    return;
                }
                this.getCache().restore();
                String checkOnlineKey = "is_online_" + formId;
                String checkSchemeOnlineKey = "is_scheme_online_" + formId;
                String expect = "false";
                boolean showConfirm = false;
                String msg = "";
                String detail = "";
                if (expect.equals(this.getCache().get(checkOnlineKey))) {
                    showConfirm = true;
                    msg = ResManager.loadKDString((String)"\u5e94\u7528\u672a\u4e0a\u7ebf\uff0c\u8bf7\u7b49\u5f85\u4e0a\u7ebf\u540e\u518d\u67e5\u770b\uff01", (String)"AppHomeFormPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    detail = ResManager.loadKDString((String)"\u60a8\u53ef\u4ee5\u7535\u8bdd\u8054\u7cfb\u6211\u4eec\u5feb\u901f\u4e0a\u7ebf\uff010755-84371244", (String)"AppHomeFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
                } else if (expect.equals(this.getCache().get(checkSchemeOnlineKey))) {
                    showConfirm = true;
                    msg = ResManager.loadKDString((String)"\u6682\u65e0\u4e0a\u7ebf\u9884\u6d4b\u65b9\u6848\uff0c\u8bf7\u7b49\u5f85\u4e0a\u7ebf\u540e\u518d\u67e5\u770b\uff01", (String)"AppHomeFormPlugin_2", (String)"ai-ids-plugin", (Object[])new Object[0]);
                    detail = ResManager.loadKDString((String)"\u60a8\u53ef\u4ee5\u7535\u8bdd\u8054\u7cfb\u6211\u4eec\u5feb\u901f\u4e0a\u7ebf\uff010755-84371244", (String)"AppHomeFormPlugin_3", (String)"ai-ids-plugin", (Object[])new Object[0]);
                }
                if (showConfirm) {
                    this.getView().showConfirm(msg, detail, MessageBoxOptions.OK, ConfirmTypes.Wait, null);
                    this.getCache().remove(checkOnlineKey);
                    this.getCache().remove(checkSchemeOnlineKey);
                }
            }
        }
    }

    private void judgeSaveThirdAppPerm(String formId) {
        String thirdAppExisted = SessionCache.get().get(CACHE_KEY_THIRD_APP_EXISTED);
        if (!Boolean.parseBoolean(thirdAppExisted) && StringUtils.contains((CharSequence)formId, (CharSequence)"ids_gpe")) {
            IdsParameter idsParameter = this.idsParameterService().getIdsParameter(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
            String appId = idsParameter.getThirdAppId();
            long existedThirdAppId = this.openAPIService().findThirdApp(appId);
            boolean hasPermission = PermUtils.hasPermission((Object)RequestContext.get().getCurrUserId(), (Object)"open", (Object)"third_app", (Object)"QXX0009");
            if (existedThirdAppId <= 0L) {
                if (!hasPermission) {
                    this.log.info("\u7b2c\u4e09\u65b9\u5e94\u7528{}\u4e0d\u5b58\u5728\u4e14\u65e0\u6743\u9650", (Object)appId);
                    throw new KDBizException(new ErrorCode(ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getId(), ErrorCodeEnum.NO_SAVE_THIRD_APP_PERMISSION.getName()), new Object[0]);
                }
                this.log.info("\u7b2c\u4e09\u65b9\u5e94\u7528{}\u4e0d\u5b58\u5728...\u5f00\u59cb\u521b\u5efa", (Object)appId);
                boolean flag = this.openAPIService().initOpenAPIThirdApp(idsParameter);
                if (flag) {
                    SessionCache.get().put(CACHE_KEY_THIRD_APP_EXISTED, Boolean.TRUE.toString());
                }
            } else {
                this.log.info("\u7b2c\u4e09\u65b9\u5e94\u7528{}\u5df2\u5b58\u5728", (Object)appId);
                SessionCache.get().put(CACHE_KEY_THIRD_APP_EXISTED, Boolean.TRUE.toString());
            }
        }
    }

    public void treeMenuDoubleClick(TreeNodeEvent treeNodeEvent) {
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }
}

