/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.DataScore;
import kd.ai.ids.core.entity.model.DataScoreCheckItem;
import kd.ai.ids.core.entity.model.Dataapp;
import kd.ai.ids.core.entity.model.Entity;
import kd.ai.ids.core.entity.model.EntityCatalog;
import kd.ai.ids.core.entity.model.EntityTable;
import kd.ai.ids.core.entity.model.Field;
import kd.ai.ids.core.enumtype.IncrementFieldEnum;
import kd.ai.ids.core.enumtype.YesNoEnum;
import kd.ai.ids.core.response.BaseResult;
import kd.ai.ids.core.response.server.TenantDTO;
import kd.ai.ids.core.service.IDataQualityService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.CommonUtil;
import kd.ai.ids.core.utils.EntityUtils;
import kd.ai.ids.plugin.form.BaseFormPlugin;
import kd.ai.ids.plugin.tool.FormTools;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.StepEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.control.events.WizardStepsListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ApplicationConfigPlugin
extends BaseFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
BeforeBindDataListener,
WizardStepsListener {
    private static final String KEY_CUSTOMCONTROLAP = "customcontrolap";
    private static final String KEY_ID = "id";
    private static final String KEY_FIELDTYPE = "fieldtype";
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_FIELDNAME = "fieldname";
    private static final String KEY_FIELDCOMMENT = "fieldcomment";
    private static final String KEY_INCREMENTFIELD = "incrementfield";
    private static final String KEY_CURRENT_STEP = "currentStep";
    private static final String KEY_CURRENT_STATUS = "currentStatus";
    private static final String PREDICT_TARGET_SCHEME = "predictTargetScheme";
    private static final String STEP_INFO = "stepInfo";
    private static final String KEY_SCORE = "Score";
    private static final String KEY_CHECK_LIST = "checkList";
    private static final String KEY_FORMID_IDS_ENTITY_FIELD = "ids_entity_field";
    private static final String KEY_WIZARDAP = "wizardap";
    private static final String KEY_BTN_PREV = "btnprev";
    private static final String KEY_BTN_NEXT = "btnnext";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_TAB_GUIDECONTENT = "guidecontent";
    private static final String KEY_TAB_PAGE_AP_1 = "tabpageap1";
    private static final String KEY_LABELAP_ENTITY_BASE_INFO = "labelapentitybaseinfo";
    private static final String KEY_LABELAP_TABLE_BASE_INFO = "labelaptablebaseinfo";
    private static final String KEY_TREEVIEWAP_MODEL = "treeviewapmodel";
    private static final String KEY_LABELAP_DATA_CENTNER = "labelapdatacenter";
    private static final String KEY_LABELAP_BIZ_ORG_COUNT = "labelapbizorgcount";
    private static final String KEY_LABELAP_MATERIAL_GROUP_COUNT = "labelapmaterialgroupcount";
    private static final String KEY_LABELAP_MATERIAL_COUNT = "labelapmaterialcount";
    private static final String KEY_LABELAP_CUSTOMER_COUNT = "labelapcustomercount";
    private static final String KEY_LABELAP_ORDER_COUNT = "labelapordercount";
    private static final String KEY_LABELAP_APP_NAME = "labelapappname";
    private static final String KEY_LABELAP_BIZ_MODULE = "labelapbizmodule";
    private static final String KEY_HTML_APP_DESCRIBE = "htmlapappdescribe";
    private static final String KEY_HTML_BIZOBJ = "htmlapbizobj";
    private static final String KEY_TF_APP_DESCRIBE = "tfappdescribe";
    private static final String KEY_TF_BIZOBJ = "tfbizobj";
    private static final String KEY_ENTITY_NAME_BIZ_ORG = "bos_org";
    private static final String KEY_ENTITY_NAME_MATERIAL_GROUP = "bd_materialgroup";
    private static final String KEY_ENTITY_NAME_MATERIAL = "bd_material";
    private static final String KEY_ENTITY_NAME_CUSTOMER = "bd_customer";
    private static final String KEY_ENTITY_NAME_ORDER = "sm_salorder";
    private static final String KEY_BILLLISTAP_ENTITY_FIELD = "billlistapenityfield";
    private static final String KEY_FLEX_CONFIG = "flexconfig";
    private static final String KEY_FLEX_CONFIG_RESULT = "flexconfigresult";
    private static final String KEY_BTN_RE_CONFIG = "btnreconfig";
    private static final String KEY_IMAGEAP = "imageap";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_FMODELTYPEID_FNAME = "fmodeltypeidfname";
    private static final String KEY_FPREDIMENTYPE_ORG_FNAME = "fpredimentypeOrgFname";
    private static final String KEY_FPREDIMENTYPE_PRODUCT_FNAME = "fpredimentypeProductFname";
    private static final String KEY_FPRETIMETYPE_FNAME = "fpretimetypeFname";
    private static final String KEY_FTN = "ftn";
    private static final String KEY_FPREVALUETYPE_FNAME = "fprevaluetypeFname";
    private static final String KEY_VECTORAP_CONFIG = "vectorapconfig";
    private static final String KEY_APP_IS_ONLINE = "appisonline";

    public TenantDTO getTenantDTO() {
        String s = this.getCache().get("tenantDTO");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            TenantDTO tenantDTO = ((ITenantService)Services.get(ITenantService.class)).getTenantDTO(Long.valueOf(rc.getOrgId()), rc.getTenantId(), rc.getAccountId());
            if (tenantDTO != null) {
                this.getCache().put("tenantDTO", JSON.toJSONString((Object)tenantDTO));
            }
            return tenantDTO;
        }
        return (TenantDTO)JSON.parseObject((String)s, TenantDTO.class);
    }

    private String getSubServiceId() {
        String s = this.getCache().get("subServiceId");
        if (StringUtils.isEmpty((CharSequence)s)) {
            RequestContext rc = RequestContext.get();
            String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
            TenantDTO tenantDTO = this.getTenantDTO();
            if (tenantDTO != null) {
                s = this.dataAppService().getSubServiceId(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), salesForecastAppId);
                this.setSubServiceId(s);
            }
        }
        return s;
    }

    public void setSubServiceId(String subServiceId) {
        this.getCache().put("subServiceId", subServiceId);
    }

    private JSONObject getStepInfo() {
        String s = this.getCache().get(STEP_INFO);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return new JSONObject();
        }
        return JSON.parseObject((String)s);
    }

    public void setStepInfo(JSONObject stepInfo) {
        this.getCache().put(STEP_INFO, stepInfo.toJSONString());
    }

    @Override
    public void initialize() {
        super.initialize();
        DeleteServiceHelper.delete((String)KEY_FORMID_IDS_ENTITY_FIELD, null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEWAP_MODEL);
        tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{KEY_BTN_PREV, KEY_BTN_NEXT, KEY_BTN_OK, KEY_BTN_RE_CONFIG, KEY_VECTORAP_CONFIG});
        Wizard wizard = (Wizard)this.getControl(KEY_WIZARDAP);
        wizard.addWizardStepsListener((WizardStepsListener)this);
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnprev": {
                this.setControlVisible(this.getTenantDTO(), -1);
                break;
            }
            case "btnnext": {
                this.setControlVisible(this.getTenantDTO(), 1);
                break;
            }
            case "btnok": {
                this.forwardToApplicationConfigPage();
                break;
            }
            case "btnreconfig": {
                this.setControlVisible(this.getTenantDTO(), -2);
                Tab tab = (Tab)this.getControl(KEY_TAB_GUIDECONTENT);
                tab.activeTab(KEY_TAB_PAGE_AP_1);
                break;
            }
            case "vectorapconfig": {
                this.openPredictObjConfig();
                break;
            }
        }
    }

    private void openPredictObjConfig() {
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY_ENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        String fmodeltypeid = (String)this.getModel().getValue("fmodeltypeid", focusRow);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("fmodeltypeid", fmodeltypeid);
        String caption = ResManager.loadKDString((String)"\u914d\u7f6e\u9884\u6d4b\u5bf9\u8c61\u8303\u56f4", (String)"PredictObjConfigFormPlugin_0", (String)"ai-ids-plugin", (Object[])new Object[0]);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ids_predict_obj_config");
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    private void forwardToApplicationConfigPage() {
        Image meImage = (Image)this.getControl(KEY_IMAGEAP);
        meImage.setUrl("kingdee/ai-ids/modelanalysic/img/config_result.gif");
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_CONFIG});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_CONFIG_RESULT});
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    private void setControlVisible(TenantDTO tenantDTO, int stepIndexOffset) {
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_CONFIG});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_CONFIG_RESULT});
        JSONObject stepInfo = this.getStepInfo();
        int stepIndex = stepInfo.getIntValue("stepIndex") + stepIndexOffset;
        stepInfo.put("stepIndex", (Object)stepIndex);
        if (stepIndex == 0) {
            if (!stepInfo.getBooleanValue("loadedStepIndex0")) {
                this.loadSelectDataSource(tenantDTO);
                stepInfo.put("loadedStepIndex0", (Object)Boolean.TRUE);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_OK});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_NEXT});
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTN_PREV});
        } else if (stepIndex == 1) {
            if (!stepInfo.getBooleanValue("loadedStepIndex1")) {
                this.loadDataAssessData(tenantDTO);
                stepInfo.put("loadedStepIndex1", (Object)Boolean.TRUE);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_OK});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_NEXT});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BTN_PREV});
        } else if (stepIndex == 2) {
            if (!stepInfo.getBooleanValue("loadedStepIndex2")) {
                // empty if block
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_NEXT});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_PREV, KEY_BTN_OK});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_BTN_PREV});
        }
        this.setStepInfo(stepInfo);
    }

    public void createNewData(BizDataEventArgs e) {
        RequestContext rc = RequestContext.get();
        JSONObject stepInfo = new JSONObject();
        stepInfo.put("stepIndex", (Object)0);
        TenantDTO tenantDTO = this.getTenantDTO();
        this.setStepInfo(stepInfo);
        this.setControlVisible(tenantDTO, 0);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadSchemeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchemeList() {
        this.getModel().beginInit();
        RequestContext rc = RequestContext.get();
        try {
            JSONArray dataJa = null;
            String salesForecastAppId = this.dataAppService().getSalesForecastAppIdByPlatformCode();
            boolean appIsOnline = this.dataAppService().appIsOnline(Long.valueOf(rc.getOrgId()), this.getTenantDTO().getTenantId(), salesForecastAppId);
            dataJa = appIsOnline ? this.anaResultService().getOnlineSchemeList(Long.valueOf(rc.getOrgId()), this.getSubServiceId()) : this.anaResultService().getAllSchemeList(Long.valueOf(rc.getOrgId()), this.getSubServiceId());
            if (dataJa != null) {
                int modelCount = dataJa.size();
                this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY, modelCount);
                for (int index = 0; index < dataJa.size(); ++index) {
                    JSONObject jo = (JSONObject)dataJa.get(index);
                    String fmodeltypeid = jo.getString("fmodeltypeid");
                    String fmodeltypeidFname = jo.getString("fmodeltypeidFname");
                    String fpredimentypeOrgFname = jo.getString(KEY_FPREDIMENTYPE_ORG_FNAME);
                    String fpredimentypeProductFname = jo.getString(KEY_FPREDIMENTYPE_PRODUCT_FNAME);
                    String fpretimetypeFname = jo.getString(KEY_FPRETIMETYPE_FNAME);
                    String ftn = jo.getString(KEY_FTN);
                    String fprevaluetypeFname = jo.getString(KEY_FPREVALUETYPE_FNAME);
                    this.getModel().setValue("fmodeltypeid", (Object)fmodeltypeid, index);
                    this.getModel().setValue(KEY_FMODELTYPEID_FNAME, (Object)fmodeltypeidFname, index);
                    this.getModel().setValue(KEY_FPREDIMENTYPE_ORG_FNAME, (Object)fpredimentypeOrgFname, index);
                    this.getModel().setValue(KEY_FPREDIMENTYPE_PRODUCT_FNAME, (Object)fpredimentypeProductFname, index);
                    this.getModel().setValue(KEY_FPRETIMETYPE_FNAME, (Object)fpretimetypeFname, index);
                    this.getModel().setValue(KEY_FTN, (Object)ftn, index);
                    this.getModel().setValue(KEY_FPREVALUETYPE_FNAME, (Object)fprevaluetypeFname, index);
                    this.getModel().setValue(KEY_APP_IS_ONLINE, (Object)(appIsOnline ? YesNoEnum.YES.getKey() : YesNoEnum.NO.getKey()), index);
                }
            }
        }
        finally {
            this.getModel().endInit();
        }
        FormTools.cachePageId(this.getView());
    }

    private void loadDataAssessData(TenantDTO tenantDTO) {
        RequestContext rc = RequestContext.get();
        IFormView view = this.getView();
        IDataQualityService dataQualityService = this.dataQualityService();
        int bizOrgCount = dataQualityService.count(KEY_ENTITY_NAME_BIZ_ORG);
        int materialGroupCount = dataQualityService.count(KEY_ENTITY_NAME_MATERIAL_GROUP);
        int materialCount = dataQualityService.count(KEY_ENTITY_NAME_MATERIAL);
        int customerCount = dataQualityService.count(KEY_ENTITY_NAME_CUSTOMER);
        int orderCount = dataQualityService.count(KEY_ENTITY_NAME_ORDER);
        Account account = AccountUtils.getAccountById((String)rc.getAccountId());
        this.setLabelText(KEY_LABELAP_DATA_CENTNER, account.getAccountName());
        this.setLabelText(KEY_LABELAP_BIZ_ORG_COUNT, String.valueOf(bizOrgCount));
        this.setLabelText(KEY_LABELAP_MATERIAL_GROUP_COUNT, String.valueOf(materialGroupCount));
        this.setLabelText(KEY_LABELAP_MATERIAL_COUNT, String.valueOf(materialCount));
        this.setLabelText(KEY_LABELAP_CUSTOMER_COUNT, String.valueOf(customerCount));
        this.setLabelText(KEY_LABELAP_ORDER_COUNT, String.valueOf(orderCount));
        JSONObject paramsJo = new JSONObject();
        paramsJo.put("appId", (Object)this.dataAppService().getSalesForecastAppIdByPlatformCode());
        BaseResult baseResult = this.idsServer().getBaseResultByPost(Long.valueOf(rc.getOrgId()), "/ids/clientproxy/dataapp/get", paramsJo);
        Dataapp dataapp = new Dataapp();
        if (baseResult.getData() != null) {
            JSONObject jsonObject = baseResult.getDataAsJSONObject();
            dataapp = (Dataapp)jsonObject.toJavaObject(Dataapp.class);
        }
        EntityCatalog entityCatalog = this.dataAppService().getModelData(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), this.dataAppService().getSalesForecastAppIdByPlatformCode());
        List entityTableList = EntityUtils.getHeadEntityTableList((EntityCatalog)entityCatalog);
        List entityNameList = entityTableList.stream().map(EntityTable::getName).collect(Collectors.toList());
        String entityNames = org.apache.commons.lang3.StringUtils.join(entityNameList, (String)"\u3001");
        Label appNameLabel = (Label)view.getControl(KEY_LABELAP_APP_NAME);
        appNameLabel.setText(dataapp.getAppName());
        Label bizModuleLabel = (Label)view.getControl(KEY_LABELAP_BIZ_MODULE);
        bizModuleLabel.setText(dataapp.getBussinessName());
        this.getModel().setValue(KEY_TF_APP_DESCRIBE, (Object)dataapp.getDescripe());
        this.getModel().setValue(KEY_TF_BIZOBJ, (Object)entityNames);
        CustomControl ctl = (CustomControl)this.getControl(KEY_CUSTOMCONTROLAP);
        if (ctl != null) {
            DataScore dataScore = this.dataQualityService().calcScore(KEY_ENTITY_NAME_ORDER);
            HashMap<String, Serializable> model = new HashMap<String, Serializable>();
            Double percent = 100.0;
            DataScoreCheckItem checkItem = new DataScoreCheckItem("aiy_sjlsdjc_20_20", ResManager.loadKDString((String)"\u6570\u636e\u79bb\u6563\u5ea6\u68c0\u6d4b", (String)"ApplicationConfigPlugin_7", (String)"ai-ids-plugin", (Object[])new Object[0]), Integer.valueOf(dataScore.getDispersionScore()), percent);
            DataScoreCheckItem checkItem1 = new DataScoreCheckItem("aiy_sjycjc_20_20", ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\u68c0\u6d4b", (String)"ApplicationConfigPlugin_8", (String)"ai-ids-plugin", (Object[])new Object[0]), Integer.valueOf(dataScore.getOutlierScore()), percent);
            DataScoreCheckItem checkItem2 = new DataScoreCheckItem("aiy_sjqsjc_20_20", ResManager.loadKDString((String)"\u6570\u636e\u7f3a\u5931\u5ea6\u68c0\u6d4b", (String)"ApplicationConfigPlugin_9", (String)"ai-ids-plugin", (Object[])new Object[0]), Integer.valueOf(dataScore.getMissingScore()), percent);
            DataScoreCheckItem checkItem3 = new DataScoreCheckItem("aiy_sjljc_20_20", ResManager.loadKDString((String)"\u6570\u636e\u91cf\u68c0\u6d4b", (String)"ApplicationConfigPlugin_10", (String)"ai-ids-plugin", (Object[])new Object[0]), Integer.valueOf(dataScore.getSizeScore()), percent);
            ArrayList<DataScoreCheckItem> list = new ArrayList<DataScoreCheckItem>();
            list.add(checkItem);
            list.add(checkItem1);
            list.add(checkItem2);
            list.add(checkItem3);
            model.put(KEY_SCORE, Integer.valueOf(dataScore.getScore()));
            model.put(KEY_CHECK_LIST, list);
            ctl.setData(model);
        }
    }

    private void loadSelectDataSource(TenantDTO tenantDTO) {
        RequestContext rc = RequestContext.get();
        EntityCatalog entityCatalog = this.dataAppService().getModelData(Long.valueOf(rc.getOrgId()), tenantDTO.getTenantId(), this.dataAppService().getSalesForecastAppIdByPlatformCode());
        if (entityCatalog == null) {
            return;
        }
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEWAP_MODEL);
        String rootId = entityCatalog.getId();
        TreeNode rootNode = new TreeNode(null, rootId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ApplicationConfigPlugin_11", (String)"ai-ids-plugin", (Object[])new Object[0]), (Object)Boolean.TRUE);
        rootNode.setIsOpened(true);
        Entity initEntity = null;
        TreeNode initTreeNode = null;
        List bizCloudList = entityCatalog.getChildren();
        HashMap<String, String> cache = new HashMap<String, String>();
        for (EntityCatalog bizCloudEntityCatalog : bizCloudList) {
            TreeNode tn1 = new TreeNode(bizCloudEntityCatalog.getParentid(), bizCloudEntityCatalog.getKey(), bizCloudEntityCatalog.getText(), (Object)Boolean.TRUE);
            tn1.setIcon("folder");
            tn1.setIsOpened(true);
            List appList = bizCloudEntityCatalog.getChildren();
            for (EntityCatalog appEntityCatalog : appList) {
                TreeNode tn2 = new TreeNode(appEntityCatalog.getParentid(), appEntityCatalog.getKey(), appEntityCatalog.getText(), (Object)Boolean.TRUE);
                tn2.setIsOpened(true);
                List entityList = appEntityCatalog.getChildren();
                for (EntityCatalog entityEntityCatalog : entityList) {
                    Entity entity = entityEntityCatalog.getEntity();
                    if (entity == null) continue;
                    String entityKey = entity.getKey();
                    TreeNode tn3 = new TreeNode(entityEntityCatalog.getParentid(), entityKey, entityEntityCatalog.getText(), (Object)Boolean.TRUE);
                    tn2.addChild(tn3);
                    tn3.setIsOpened(true);
                    if (initEntity == null) {
                        initEntity = entity;
                        initTreeNode = tn3;
                        this.initEntityFieldData(initEntity);
                    }
                    entity.setEntityId(entity.getId());
                    this.putEntityToCache(cache, entity);
                    List entityChildrenList = entity.getChildren();
                    if (CollectionUtils.isEmpty((Collection)entityChildrenList)) continue;
                    for (Entity childrenEntity : entityChildrenList) {
                        childrenEntity.setEntityId(entity.getId());
                        this.putEntityToCache(cache, childrenEntity);
                        List subEntityChildrenList = childrenEntity.getChildren();
                        boolean isParent = !CollectionUtils.isEmpty((Collection)childrenEntity.getChildren());
                        TreeNode tn4 = new TreeNode(entity.getKey(), childrenEntity.getKey(), childrenEntity.getName(), isParent);
                        tn3.addChild(tn4);
                        tn4.setIsOpened(true);
                        if (CollectionUtils.isEmpty((Collection)subEntityChildrenList)) continue;
                        for (Entity subChildrenEntity : subEntityChildrenList) {
                            subChildrenEntity.setEntityId(entity.getId());
                            this.putEntityToCache(cache, subChildrenEntity);
                            List subSubEntityChildrenList = subChildrenEntity.getChildren();
                            boolean subEntityIsParent = !CollectionUtils.isEmpty((Collection)subSubEntityChildrenList);
                            TreeNode tn5 = new TreeNode(entity.getKey(), subChildrenEntity.getKey(), subChildrenEntity.getName(), subEntityIsParent);
                            tn4.addChild(tn5);
                            tn5.setIsOpened(true);
                        }
                    }
                }
                tn1.addChild(tn2);
            }
            rootNode.addChild(tn1);
        }
        tv.addNode(rootNode);
        tv.setRootVisible(false);
        if (initTreeNode != null) {
            tv.focusNode(initTreeNode);
        }
        this.getCache().put(cache);
    }

    private void putEntityToCache(Map<String, String> data, Entity entity) {
        JSONObject o = (JSONObject)JSON.toJSON((Object)entity);
        o.remove((Object)"children");
        data.put("EntityCache_" + entity.getKey(), o.toJSONString());
    }

    private Entity getEntityFromCache(String entityKey) {
        String s = this.getCache().get("EntityCache_" + entityKey);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return (Entity)JSON.parseObject((String)s, Entity.class);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String entityKey = (String)treeNodeEvent.getNodeId();
        this.log.info("#####treeNodeClick entityKey : {}" + entityKey);
        Entity entity = this.getEntityFromCache(entityKey);
        if (entity != null) {
            this.log.info("##### entity:{}", (Object)JSONObject.toJSONString((Object)entity));
            this.initEntityFieldData(entity);
        }
    }

    private void initEntityFieldData(Entity entity) {
        if (entity == null) {
            return;
        }
        Label entityBaseInfoLabel = (Label)this.getView().getControl(KEY_LABELAP_ENTITY_BASE_INFO);
        entityBaseInfoLabel.setText(String.format("%s\uff1a%s(%s)", ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"ApplicationConfigPlugin_12", (String)"ai-ids-plugin", (Object[])new Object[0]), entity.getName(), entity.getId()));
        Label tableBaseInfoLabel = (Label)this.getView().getControl(KEY_LABELAP_TABLE_BASE_INFO);
        tableBaseInfoLabel.setText(String.format("%s\uff1a%s", ResManager.loadKDString((String)"\u8868\u540d", (String)"ApplicationConfigPlugin_13", (String)"ai-ids-plugin", (Object[])new Object[0]), entity.getTableName()));
        List fieldList = CommonUtil.emptyIfNull((List)entity.getFields());
        DynamicObject[] dynamicObjects = new DynamicObject[fieldList.size()];
        int dynamicObjectsIndex = 0;
        for (Field field : fieldList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)KEY_FORMID_IDS_ENTITY_FIELD);
            dynamicObject.set(KEY_ID, (Object)ID.genLongId());
            dynamicObject.set(KEY_FIELDTYPE, (Object)field.getFieldType());
            dynamicObject.set(KEY_FIELDKEY, (Object)field.getFieldName());
            dynamicObject.set(KEY_FIELDNAME, (Object)field.getKey());
            dynamicObject.set(KEY_FIELDCOMMENT, (Object)field.getName());
            dynamicObject.set(KEY_INCREMENTFIELD, (Object)(StringUtils.equalsIgnoreCase((CharSequence)entity.getIncrementField(), (CharSequence)field.getKey()) ? String.valueOf(IncrementFieldEnum.YES.getKey()) : String.valueOf(IncrementFieldEnum.NO.getKey())));
            dynamicObjects[dynamicObjectsIndex] = dynamicObject;
            ++dynamicObjectsIndex;
        }
        DeleteServiceHelper.delete((String)KEY_FORMID_IDS_ENTITY_FIELD, null);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP_ENTITY_FIELD);
        if (billList != null) {
            billList.refreshData();
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
    }

    public void update(StepEvent e) {
        Wizard wizard = (Wizard)this.getControl(KEY_WIZARDAP);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put(KEY_CURRENT_STEP, 1);
        currentStepMap.put(KEY_CURRENT_STATUS, "error");
        wizard.setWizardCurrentStep(currentStepMap);
    }
}

